/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.CanvasManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.SpriteDescriptor;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class MovableSprite {
    public Sprite[] mySprites;
    private short[][] mySpriteDescriptionParams;
    private short[][] mySpriteDescriptionBoundingBoxes;
    public boolean isOnSide = false;
    private int[] myLastFrameSequence;
    private Sprite[] normalSprites;
    public short[][] normalSpriteDescriptionParams;
    public short[][] normalSpriteDescriptionBoundingBoxes;
    private Sprite[] sideSprites;
    public short[][] sideSpriteDescriptionParams;
    public short[][] sideSpriteDescriptionBoundingBoxes;
    private int[] myRelativePos;
    private short[][] myBoundingBoxes;
    private int myPositionX;
    private int myPositionY;
    private int myWidth;
    private int myHeight;
    private int myLogicalWidth;
    private int myLogicalHeight;

    public MovableSprite(short[] sArray, short[] sArray2, short[] sArray3, short[] sArray4) {
        this.normalSprites = new Sprite[]{SpriteDescriptor.loadSprite(sArray)};
        this.normalSpriteDescriptionParams = new short[][]{sArray};
        this.normalSpriteDescriptionBoundingBoxes = new short[][]{sArray2};
        if (sArray3 != null) {
            this.sideSprites = new Sprite[]{SpriteDescriptor.loadSprite(sArray3)};
            this.sideSpriteDescriptionParams = new short[][]{sArray3};
            this.sideSpriteDescriptionBoundingBoxes = new short[][]{sArray4};
        }
        this.myPositionX = 0;
        this.myPositionY = 0;
        this.isOnSide = false;
        this.replaceSprite(this.normalSprites, this.normalSpriteDescriptionParams, this.normalSpriteDescriptionBoundingBoxes);
    }

    public MovableSprite(short[][] sArray, short[][] sArray2, short[][] sArray3, short[][] sArray4) {
        int n;
        this.normalSprites = new Sprite[sArray.length];
        for (n = 0; n < sArray.length; ++n) {
            this.normalSprites[n] = SpriteDescriptor.loadSprite(sArray[n]);
        }
        this.normalSpriteDescriptionParams = sArray;
        this.normalSpriteDescriptionBoundingBoxes = sArray2;
        if (sArray3 != null) {
            this.sideSprites = new Sprite[sArray3.length];
            for (n = 0; n < sArray3.length; ++n) {
                this.sideSprites[n] = SpriteDescriptor.loadSprite(sArray3[n]);
            }
            this.sideSpriteDescriptionParams = sArray3;
            this.sideSpriteDescriptionBoundingBoxes = sArray4;
        }
        this.myPositionX = 0;
        this.myPositionY = 0;
        this.isOnSide = false;
        this.replaceSprite(this.normalSprites, this.normalSpriteDescriptionParams, this.normalSpriteDescriptionBoundingBoxes);
    }

    protected void setPosition(int n, int n2) {
        this.myPositionX = n;
        this.myPositionY = n2;
        for (int i = 0; i < this.mySprites.length; ++i) {
            this.mySprites[i].setPosition(n + this.myRelativePos[i * 2], n2 + this.myRelativePos[i * 2 + 1]);
        }
    }

    public int getX() {
        return this.myPositionX;
    }

    public int getY() {
        return this.myPositionY;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getLogicalWidth() {
        return this.myLogicalWidth;
    }

    public int getLogicalHeight() {
        return this.myLogicalHeight;
    }

    private void defineReferencePixel(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException("This hasn't been fully checked and tested yet, and therefore must not be used");
        }
        for (int i = 0; i < this.mySprites.length; ++i) {
            this.mySprites[i].defineReferencePixel(n, n2);
        }
    }

    private void initRelativePositions() {
        int n;
        int n2 = this.mySprites.length;
        if (this.myRelativePos == null || this.myRelativePos.length != n2 * 2) {
            this.myRelativePos = new int[n2 * 2];
        }
        for (n = 0; n < n2; ++n) {
            this.myRelativePos[n * 2] = this.mySpriteDescriptionParams[n][7];
            this.myRelativePos[n * 2 + 1] = this.mySpriteDescriptionParams[n][8];
        }
        if (this.mySpriteDescriptionBoundingBoxes[0] == null) {
            this.myBoundingBoxes = null;
        } else {
            if (this.myBoundingBoxes == null || this.myBoundingBoxes.length != n2) {
                this.myBoundingBoxes = new short[n2][];
                for (n = 0; n < n2; ++n) {
                    if (this.myBoundingBoxes[n] != null && this.myBoundingBoxes[n].length == this.mySpriteDescriptionBoundingBoxes[n].length) continue;
                    this.myBoundingBoxes[n] = new short[this.mySpriteDescriptionBoundingBoxes[n].length];
                }
            }
            for (n = 0; n < n2; ++n) {
                short[] sArray = this.mySpriteDescriptionBoundingBoxes[n];
                System.arraycopy(sArray, 0, this.myBoundingBoxes[n], 0, sArray.length);
            }
        }
    }

    public void setTransform(int n) {
        int n2 = this.getFrame();
        if (n == 5 || n == 7 || n == 6 || n == 4) {
            if (!this.isOnSide) {
                this.isOnSide = true;
                if (this.sideSpriteDescriptionParams == null) {
                    throw new RuntimeException("Error: no side sprite!");
                }
                this.replaceSprite(this.sideSprites, this.sideSpriteDescriptionParams, this.sideSpriteDescriptionBoundingBoxes);
            }
            switch (n) {
                case 5: {
                    n = 0;
                    break;
                }
                case 7: {
                    n = 1;
                    break;
                }
                case 6: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 2;
                }
            }
        } else if (this.isOnSide && (n == 0 || n == 2 || n == 3 || n == 1)) {
            this.isOnSide = false;
            if (this.normalSpriteDescriptionParams == null) {
                throw new RuntimeException("Error: no side sprite!");
            }
            this.replaceSprite(this.normalSprites, this.normalSpriteDescriptionParams, this.normalSpriteDescriptionBoundingBoxes);
        }
        for (int i = 0; i < this.mySprites.length; ++i) {
            Object[] objectArray;
            int n3 = this.mySprites[i].getX();
            int n4 = this.mySprites[i].getY();
            short[] sArray = this.mySpriteDescriptionParams[i];
            short[] sArray2 = i < this.mySpriteDescriptionBoundingBoxes.length ? this.mySpriteDescriptionBoundingBoxes[i] : null;
            Sprite sprite = this.mySprites[i];
            if (sArray[7] != 0 || sArray[8] != 0 || sprite.getWidth() != this.getWidth() || sprite.getHeight() != this.getHeight()) {
                objectArray = new int[]{0, sArray[7] * 2, sArray[8] * 2, sprite.getWidth() * 2, sprite.getHeight() * 2};
                CanvasManager.transformShape(objectArray, n, this.getWidth(), this.getHeight(), null);
                this.myRelativePos[i * 2] = objectArray[1] / 2;
                this.myRelativePos[i * 2 + 1] = objectArray[2] / 2;
            }
            this.mySprites[i].setTransform(n);
            this.mySprites[i].setPosition(n3, n4);
            objectArray = sArray2;
            if (objectArray == null) continue;
            for (int j = 0; j < objectArray.length / 4; ++j) {
                int[] nArray = new int[]{0, objectArray[j * 4] * 2, objectArray[j * 4 + 1] * 2, objectArray[j * 4 + 2] * 2, objectArray[j * 4 + 3] * 2};
                CanvasManager.transformShape(nArray, n, this.mySprites[i].getWidth(), this.mySprites[i].getHeight(), null);
                this.myBoundingBoxes[i][j * 4] = (short)(nArray[1] / 2);
                this.myBoundingBoxes[i][j * 4 + 1] = (short)(nArray[2] / 2);
            }
        }
        this.setPosition(this.getX(), this.getY());
        this.defineReferencePixel(0, 0);
        this.setFrameSequence(this.myLastFrameSequence);
        this.setFrame(n2);
    }

    public void setFrameSequence(int[] nArray) {
        this.myLastFrameSequence = new int[nArray.length];
        System.arraycopy(nArray, 0, this.myLastFrameSequence, 0, nArray.length);
        this.mySprites[0].setFrameSequence(nArray);
    }

    public int getFrameSequenceLength() {
        return this.mySprites[0].getFrameSequenceLength();
    }

    public int getFrame() {
        return this.mySprites[0].getFrame();
    }

    public void setFrame(int n) {
        if (this.myBoundingBoxes != null && this.myBoundingBoxes[0] != null) {
            int n2;
            int n3;
            if (n == 0) {
                n3 = this.mySprites.length;
                n2 = 0;
            } else {
                n3 = 1;
                n2 = this.myLastFrameSequence[n];
            }
            for (int i = 0; i < n3; ++i) {
                this.mySprites[i].defineCollisionRectangle((int)this.myBoundingBoxes[i][4 * n2], (int)this.myBoundingBoxes[i][4 * n2 + 1], (int)this.myBoundingBoxes[i][4 * n2 + 2], (int)this.myBoundingBoxes[i][4 * n2 + 3]);
            }
        }
        this.mySprites[0].setFrame(n);
    }

    public boolean collidesWith(MovableSprite movableSprite, boolean bl) {
        for (int i = 0; i < this.mySprites.length; ++i) {
            for (int j = 0; j < movableSprite.mySprites.length; ++j) {
                if (!this.mySprites[i].collidesWith(movableSprite.mySprites[j], bl)) continue;
                return true;
            }
        }
        return false;
    }

    private void replaceSprite(Sprite[] spriteArray, short[][] sArray, short[][] sArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.mySprites = spriteArray;
        this.mySpriteDescriptionParams = sArray;
        this.mySpriteDescriptionBoundingBoxes = sArray2;
        this.initRelativePositions();
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MAX_VALUE;
        int n9 = Integer.MIN_VALUE;
        for (n5 = 0; n5 < spriteArray.length; ++n5) {
            n4 = spriteArray[n5].getX();
            n3 = spriteArray[n5].getY();
            n2 = spriteArray[n5].getWidth();
            n = spriteArray[n5].getHeight();
            if (n4 < n6) {
                n6 = n4;
            }
            if (n4 + n2 > n7) {
                n7 = n4 + n2;
            }
            if (n3 < n8) {
                n8 = n3;
            }
            if (n3 + n <= n9) continue;
            n9 = n3 + n;
        }
        this.myWidth = n7 - n6;
        this.myHeight = n9 - n8;
        n6 = Integer.MAX_VALUE;
        n7 = Integer.MIN_VALUE;
        n8 = Integer.MAX_VALUE;
        n9 = Integer.MIN_VALUE;
        for (n5 = 0; n5 < sArray.length; ++n5) {
            n4 = sArray[n5][7] * Defines.PRECISION;
            n3 = sArray[n5][8] * Defines.PRECISION;
            n2 = sArray[n5][5] * Defines.PRECISION;
            n = sArray[n5][6] * Defines.PRECISION;
            if (n4 < n6) {
                n6 = n4;
            }
            if (n4 + n2 > n7) {
                n7 = n4 + n2;
            }
            if (n3 < n8) {
                n8 = n3;
            }
            if (n3 + n <= n9) continue;
            n9 = n3 + n;
        }
        this.myLogicalWidth = n7 - n6;
        this.myLogicalHeight = n9 - n8;
        this.defineReferencePixel(0, 0);
        this.setFrame(0);
    }

    public void dispose() {
        int n;
        if (this.sideSpriteDescriptionParams != null) {
            for (n = 0; n < this.sideSpriteDescriptionParams.length; ++n) {
                if (this.sideSpriteDescriptionParams == null) continue;
                SpriteDescriptor.addSpriteToPool(this.sideSpriteDescriptionParams[n], this.sideSprites[n]);
                SpriteDescriptor.decreaseImageRefCount(this.sideSpriteDescriptionParams[n][0]);
            }
        }
        if (this.normalSpriteDescriptionParams != null) {
            for (n = 0; n < this.normalSpriteDescriptionParams.length; ++n) {
                if (this.normalSpriteDescriptionParams[n] == null) continue;
                SpriteDescriptor.addSpriteToPool(this.normalSpriteDescriptionParams[n], this.normalSprites[n]);
                SpriteDescriptor.decreaseImageRefCount(this.normalSpriteDescriptionParams[n][0]);
            }
        }
    }

    public void paint(Graphics graphics) {
        for (int i = this.mySprites.length - 1; i >= 0; --i) {
            this.mySprites[i].paint(graphics);
        }
    }
}

