/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tools.AnimationManager;
import Snakedelia.tools.CanvasManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.MovableObject;
import Snakedelia.tools.MovableSprite;
import javax.microedition.lcdui.Graphics;

public final class PhysicalSprite
extends MovableObject {
    boolean myDisableSnapToGrid = false;
    private int myScreenX = 0;
    private int myScreenY = 0;
    private int defaultScreenWidth;
    private int defaultScreenHeight;
    private AnimationManager myAnimationManager;
    private MovableSprite myMovableSprite;
    private CanvasManager myCanvasManager;
    private boolean myIsVisible = true;
    private boolean layerUpdated = false;
    private int myTransformation;
    public int myWorldState = 0;

    public PhysicalSprite(AnimationManager animationManager, MovableSprite movableSprite, CanvasManager canvasManager, boolean bl) {
        super(bl);
        this.myAnimationManager = animationManager;
        this.myMovableSprite = movableSprite;
        this.myCanvasManager = canvasManager;
        this.initWidthHeight(this.myMovableSprite.getLogicalWidth(), this.myMovableSprite.getLogicalHeight());
    }

    public PhysicalSprite(int n, int n2, CanvasManager canvasManager, boolean bl) {
        super(bl);
        this.myAnimationManager = null;
        this.myMovableSprite = null;
        this.myCanvasManager = canvasManager;
        this.initWidthHeight(n, n2);
        this.initDefaultScreenWidth();
    }

    private void initDefaultScreenWidth() {
        int n = this.getLogicalWidth();
        BasicCanvas.getInstance().getClass();
        int n2 = n * 240;
        BasicCanvas.getInstance().getClass();
        int n3 = n2 / 691200;
        BasicCanvas.getInstance().getClass();
        this.defaultScreenWidth = n3 + (n2 % 691200 != 0 ? 1 : 0);
        int n4 = this.getLogicalHeight();
        BasicCanvas.getInstance().getClass();
        n2 = n4 * 320;
        BasicCanvas.getInstance().getClass();
        int n5 = n2 / 921600;
        BasicCanvas.getInstance().getClass();
        this.defaultScreenHeight = n5 + (n2 % 921600 != 0 ? 1 : 0);
    }

    public final int getHeight() {
        if (this.hasSprite()) {
            return this.myMovableSprite.getHeight();
        }
        return this.defaultScreenHeight;
    }

    public final int getWidth() {
        if (this.hasSprite()) {
            return this.myMovableSprite.getWidth();
        }
        return this.defaultScreenWidth;
    }

    public final int getX() {
        return this.myScreenX;
    }

    public final int getY() {
        return this.myScreenY;
    }

    public final boolean isVisible() {
        return this.myIsVisible;
    }

    public final void setVisibility(boolean bl) {
        this.myIsVisible = bl;
    }

    protected void setLogicalZ(int n) {
        if (n != this.getLogicalZ()) {
            super.setLogicalZ(n);
        }
    }

    public final void movePrecise(int n, int n2, boolean bl, boolean bl2) {
        this.setLogicalX(this.getLogicalX() + n);
        this.setLogicalY(this.getLogicalY() + n2);
        long l = this.getLogicalXOnScreen();
        BasicCanvas.getInstance().getClass();
        long l2 = l * 240L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        int n3 = Defines.unPrecise(l2 / 691200L);
        long l3 = this.getLogicalYOnScreen();
        BasicCanvas.getInstance().getClass();
        long l4 = l3 * 320L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        int n4 = Defines.unPrecise(l4 / 921600L);
        this.myScreenX = n3;
        this.myScreenY = n4;
        if (this.hasSprite()) {
            this.myMovableSprite.setPosition(n3, n4);
        }
        this.layerUpdated = false;
        this.myWorldState = GameManager.WorldStateNumber;
    }

    public final void movePrecise(int n, int n2) {
        this.movePrecise(n, n2, true, true);
    }

    public final void setPositionPrecise(int n, int n2) {
        boolean bl = n == this.getLogicalX() && n2 == this.getLogicalY();
        this.setLogicalX(n);
        this.setLogicalY(n2);
        long l = this.getLogicalXOnScreen();
        BasicCanvas.getInstance().getClass();
        long l2 = l * 240L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        int n3 = Defines.unPrecise(l2 / 691200L);
        long l3 = this.getLogicalYOnScreen();
        BasicCanvas.getInstance().getClass();
        long l4 = l3 * 320L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        int n4 = Defines.unPrecise(l4 / 921600L);
        if (this.hasSprite()) {
            this.myMovableSprite.setPosition(n3, n4);
        }
        this.myScreenX = n3;
        this.myScreenY = n4;
        this.layerUpdated = false;
        this.myWorldState = GameManager.WorldStateNumber;
        if (!this.myDisableSnapToGrid && !bl) {
            this.snapToPhysicalGrid();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            this.myDisableSnapToGrid = true;
            int n = this.getLogicalX();
            int n2 = this.getLogicalY();
            this.setPositionPrecise(n + this.myGlitchCorrectionX, n2 + this.myGlitchCorrectionY);
            if (this.hasSprite()) {
                this.myMovableSprite.paint(graphics);
            }
            if (this.hasCanvas()) {
                this.myCanvasManager.drawCanvas(graphics);
            }
            this.setPositionPrecise(n, n2);
            this.myDisableSnapToGrid = false;
        }
    }

    public final boolean collidesWith(PhysicalSprite physicalSprite, boolean bl) {
        if (!this.myIsVisible || !physicalSprite.myIsVisible) {
            return false;
        }
        return this.myMovableSprite.collidesWith(physicalSprite.myMovableSprite, bl);
    }

    public final void setTransform(int n) {
        if (this.hasSprite()) {
            this.myMovableSprite.setTransform(n);
        }
        if (this.hasCanvas()) {
            this.myCanvasManager.setTransform(n);
        }
        if (CanvasManager.isOnSide(n) != CanvasManager.isOnSide(this.myTransformation)) {
            this.initWidthHeight(this.getLogicalHeight(), this.getLogicalWidth());
            this.initDefaultScreenWidth();
        }
        this.myTransformation = n;
    }

    public static final int rotateClockwise(int n) {
        int n2;
        switch (n) {
            case 2: {
                n2 = 7;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 6: {
                n2 = 0;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static final int mirror(int n) {
        int n2;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            case 7: {
                n2 = 5;
                break;
            }
            case 0: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 7;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public int getTransformation() {
        return this.myTransformation;
    }

    public final boolean hasSprite() {
        return this.myMovableSprite != null;
    }

    public final MovableSprite getWrappedSprite() {
        if (!this.hasSprite()) {
            throw new RuntimeException("No wrapped sprite for this BasicSprite");
        }
        return this.myMovableSprite;
    }

    public final boolean hasCanvas() {
        return this.myCanvasManager != null;
    }

    public final CanvasManager getCanvasManager() {
        return this.myCanvasManager;
    }

    public final boolean isAnimatable() {
        return this.myAnimationManager != null;
    }

    public final AnimationManager getAnimationManager() {
        return this.myAnimationManager;
    }

    public final boolean logicalCollidesWith(PhysicalSprite physicalSprite) {
        int n = physicalSprite.getLogicalX();
        int n2 = physicalSprite.getLogicalY();
        int n3 = physicalSprite.getLogicalWidth();
        int n4 = physicalSprite.getLogicalHeight();
        int n5 = this.getLogicalX();
        int n6 = this.getLogicalY();
        int n7 = this.getLogicalWidth();
        int n8 = this.getLogicalHeight();
        if (!this.myIsVisible || !physicalSprite.myIsVisible) {
            return false;
        }
        int n9 = n5;
        int n10 = n9 + n7;
        int n11 = n6;
        int n12 = n6 + n8;
        return n12 > n2 && n11 < n2 + n4 && n10 > n && n9 < n + n3;
    }

    public void dispose() {
        if (this.myMovableSprite != null) {
            this.myMovableSprite.dispose();
        }
    }
}

