/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.GameManager;
import Snakedelia.tools.BasicSprite;

public final class SpriteCollection {
    private GameManager mManager;
    private int mPosition;
    private int mNumItems;
    private int[] mArray;
    private int mLockDepth = 0;
    private boolean mCompactingRequired;
    private final int CONST_INITIAL_SIZE;

    public SpriteCollection(GameManager gameManager) {
        this.CONST_INITIAL_SIZE = 4;
        this.mManager = gameManager;
        this.initArray();
    }

    private void initArray() {
        this.mArray = new int[8];
        this.mPosition = 0;
        this.mNumItems = 0;
        this.mCompactingRequired = false;
    }

    public void lockCompacting() {
        ++this.mLockDepth;
    }

    public void unlockCompacting() {
        if (this.mLockDepth == 0) {
            throw new RuntimeException("Error: Trying to unlock an unlocked array");
        }
        --this.mLockDepth;
        if (this.mLockDepth == 0 && this.mCompactingRequired) {
            this.compact();
        }
    }

    public int retrieveFirstSprite() {
        for (int i = 0; i < this.mNumItems * 2; i += 2) {
            if (this.mArray[i] == -1) continue;
            if (this.mManager.spriteExists(this.mArray[i], this.mArray[i + 1])) {
                if (this.mManager.getSprite((int)this.mArray[i]).isDying) continue;
                return this.mArray[i];
            }
            this.mArray[i] = -1;
        }
        return -1;
    }

    public int getLength() {
        return this.mNumItems;
    }

    public boolean isValid(int n) {
        return this.mArray[n *= 2] != -1 && this.mManager.spriteExists(this.mArray[n], this.mArray[n + 1]) && !this.mManager.getSprite((int)this.mArray[n]).isDying;
    }

    public int getSprite(int n) {
        return this.mArray[n * 2];
    }

    public int remove(int n) {
        for (int i = 0; i < this.mNumItems * 2; i += 2) {
            if (this.mArray[i] != n) continue;
            this.mArray[i] = -1;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.initArray();
    }

    private void compactExpand() {
        int n = this.countValidSprites();
        if (n < this.mNumItems) {
            this.mCompactingRequired = true;
            if (this.mLockDepth == 0) {
                this.compact();
                if (this.mArray.length > this.mPosition) {
                    return;
                }
            }
        }
        int[] nArray = new int[this.mNumItems * 2 * 2];
        for (int i = 0; i < this.mNumItems * 2; ++i) {
            nArray[i] = this.mArray[i];
        }
        this.mArray = nArray;
    }

    private void compact() {
        int n = 0;
        for (int i = 0; i < this.mNumItems * 2; i += 2) {
            if (this.mArray[i] == -1 || !this.mManager.spriteExists(this.mArray[i], this.mArray[i + 1])) continue;
            if (n != i) {
                this.mArray[n] = this.mArray[i];
                this.mArray[n + 1] = this.mArray[i + 1];
            }
            n += 2;
        }
        this.mCompactingRequired = false;
        this.mPosition = n;
        this.mNumItems = n / 2;
    }

    public int countValidSprites() {
        int n = 0;
        for (int i = 0; i < this.mNumItems * 2; i += 2) {
            if (this.mArray[i] == -1 || !this.mManager.spriteExists(this.mArray[i], this.mArray[i + 1]) || this.mManager.getSprite((int)this.mArray[i]).isDying) continue;
            ++n;
        }
        return n;
    }

    private int addSpriteUnsafe(int n, int n2) {
        if (this.mArray.length == this.mPosition) {
            this.compactExpand();
        }
        this.mArray[this.mPosition] = n;
        this.mArray[this.mPosition + 1] = n2;
        this.mPosition += 2;
        ++this.mNumItems;
        return this.mPosition - 2;
    }

    private int addSprite(int n, int n2) {
        for (int i = 0; i < this.mNumItems * 2; i += 2) {
            if (this.mArray[i] != n) continue;
            if (this.mArray[i + 1] == n2) {
                return i;
            }
            this.mArray[i] = -1;
        }
        return this.addSpriteUnsafe(n, n2);
    }

    public int addSprite(int n) {
        BasicSprite basicSprite = this.mManager.getSprite(n);
        if (basicSprite == null) {
            return -1;
        }
        return this.addSprite(n, basicSprite.getUID());
    }
}

