/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.IUpdatable;
import Snakedelia.tools.MovableObject;
import Snakedelia.tools.SpriteDescriptor;
import javax.microedition.lcdui.game.TiledLayer;

public abstract class TiledBackground
extends MovableObject
implements IUpdatable {
    private int myFilenameId;
    private TiledLayer myTiledLayer;
    private int logicalCellWidth;
    private int logicalCellHeight;
    protected int currentTileColumn = -1;
    protected int currentTileRow = -1;
    private boolean isStatic;
    private int originX;
    private int originY;
    private boolean myHasEmptyTiles;
    private int myLastWorldPositionX = 0;
    private int myLastWorldPositionY = 0;

    protected TiledBackground(int n, int n2, short s, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
        super(false);
        this.myFilenameId = s;
        this.myTiledLayer = new TiledLayer(n, n2, SpriteDescriptor.loadImage(s), n7, n8);
        BasicCanvas.getInstance().getClass();
        BasicCanvas.getInstance().getClass();
        int n9 = n * n7 * 691200 / 240;
        BasicCanvas.getInstance().getClass();
        BasicCanvas.getInstance().getClass();
        this.initWidthHeight(n9, n2 * n8 * 921600 / 320);
        this.setVelocityX(-n5);
        this.setVelocityY(-n6);
        int n10 = this.getCellWidth();
        BasicCanvas.getInstance().getClass();
        int n11 = n10 * 691200;
        BasicCanvas.getInstance().getClass();
        this.setLogicalCellWidth(n11 / 240);
        int n12 = this.getCellHeight();
        BasicCanvas.getInstance().getClass();
        int n13 = n12 * 921600;
        BasicCanvas.getInstance().getClass();
        this.setLogicalCellHeight(n13 / 320);
        this.isStatic = bl;
        this.setLogicalX(-this.getLogicalCellWidth() + n3);
        this.setLogicalY(-this.getLogicalCellHeight() + n4);
        this.snapToPhysicalGrid();
        this.originX = -this.getCellWidth();
        this.originY = -this.getCellHeight();
        this.myHasEmptyTiles = bl2;
    }

    protected void initCells() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                this.setCell(j, i, this.getNewCell(this.currentTileColumn + j, this.currentTileRow + i));
            }
        }
    }

    public final void movePrecise(int n, int n2) {
        int n3;
        int n4;
        int n5 = (this.getLogicalX() + this.myLastWorldPositionX) / this.getLogicalCellWidth();
        int n6 = (this.getLogicalY() + this.myLastWorldPositionY) / this.getLogicalCellHeight();
        if (!this.isStatic) {
            this.myLastWorldPositionX = GameManager.WorldPositionX;
            this.myLastWorldPositionY = GameManager.WorldPositionY;
            n4 = this.getLogicalX() + GameManager.WorldPositionX;
            n3 = this.getLogicalY() + GameManager.WorldPositionY;
        } else {
            n4 = this.getLogicalX();
            n3 = this.getLogicalY();
        }
        int n7 = n4 / this.getLogicalCellWidth() - n5;
        int n8 = n3 / this.getLogicalCellHeight() - n6;
        int n9 = n4 % this.getLogicalCellWidth();
        int n10 = n3 % this.getLogicalCellHeight();
        this.setPositionPrecise(n9, n10);
        if (n7 != 0 || n8 != 0) {
            this.moveBG(n7, n8);
        }
    }

    public final void setPositionPrecise(int n, int n2) {
        long l = n;
        BasicCanvas.getInstance().getClass();
        long l2 = l * 240L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        int n3 = this.originX - Defines.unPrecise(l2 / 691200L);
        long l3 = n2;
        BasicCanvas.getInstance().getClass();
        long l4 = l3 * 320L * (long)Defines.PRECISION;
        BasicCanvas.getInstance().getClass();
        this.setPosition(n3, this.originY - Defines.unPrecise(l4 / 921600L));
    }

    public void setPositionEx(int n, int n2) {
        if (!this.isStatic) {
            n += GameManager.WorldPositionX;
            n2 += GameManager.WorldPositionY;
            this.myLastWorldPositionX = GameManager.WorldPositionX;
            this.myLastWorldPositionY = GameManager.WorldPositionY;
        }
        this.currentTileColumn = n / this.getLogicalCellWidth();
        this.currentTileRow = n2 / this.getLogicalCellHeight();
        this.setPositionPrecise(n % this.getLogicalCellWidth(), n2 % this.getLogicalCellHeight());
        this.initCells();
    }

    public void moveBG(int n, int n2) {
        this.currentTileColumn += n;
        this.currentTileRow += n2;
        if (n >= 0 && n2 >= 0) {
            for (int i = 0; i < this.getRows() - n2; ++i) {
                for (int j = 0; j < this.getColumns() - n; ++j) {
                    this.setCell(j, i, this.getCell(j + n, i + n2));
                }
            }
        } else if (n >= 0 && n2 < 0) {
            for (int i = this.getRows() - 1; i >= -n2; --i) {
                for (int j = 0; j < this.getColumns() - n; ++j) {
                    this.setCell(j, i, this.getCell(j + n, i + n2));
                }
            }
        } else if (n < 0 && n2 >= 0) {
            for (int i = 0; i < this.getRows() - n2; ++i) {
                for (int j = this.getColumns() - 1; j >= -n; --j) {
                    this.setCell(j, i, this.getCell(j + n, i + n2));
                }
            }
        } else {
            for (int i = this.getRows() - 1; i >= -n2; --i) {
                for (int j = this.getColumns() - 1; j >= -n; --j) {
                    this.setCell(j, i, this.getCell(j + n, i + n2));
                }
            }
        }
        this.generateTiles(n, n2);
    }

    public void generateTiles(int n, int n2) {
        block12: {
            int n3;
            int n4;
            block11: {
                this.updateGrid(n %= this.getColumns(), n2 %= this.getRows());
                if (n > 0) {
                    for (n4 = 0; n4 < this.getRows(); ++n4) {
                        for (n3 = this.getColumns() - 1; n3 > this.getColumns() - 1 - n; --n3) {
                            this.setCell(n3, n4, this.getNewCell(this.currentTileColumn + n3, this.currentTileRow + n4));
                        }
                    }
                } else if (n < 0) {
                    for (n4 = 0; n4 < this.getRows(); ++n4) {
                        for (n3 = 0; n3 < -n; ++n3) {
                            this.setCell(n3, n4, this.getNewCell(this.currentTileColumn + n3, this.currentTileRow + n4));
                        }
                    }
                }
                if (n2 <= 0) break block11;
                for (n4 = 0; n4 < this.getColumns(); ++n4) {
                    for (n3 = this.getRows() - 1; n3 > this.getRows() - 1 - n2; --n3) {
                        this.setCell(n4, n3, this.getNewCell(this.currentTileColumn + n4, this.currentTileRow + n3));
                    }
                }
                break block12;
            }
            if (n2 >= 0) break block12;
            for (n4 = 0; n4 < this.getColumns(); ++n4) {
                for (n3 = 0; n3 < -n2; ++n3) {
                    this.setCell(n4, n3, this.getNewCell(this.currentTileColumn + n4, this.currentTileRow + n3));
                }
            }
        }
    }

    public abstract void updateGrid(int var1, int var2);

    public abstract int getNewCell(int var1, int var2);

    private void setLogicalCellWidth(int n) {
        this.logicalCellWidth = n;
    }

    public int getLogicalCellWidth() {
        return this.logicalCellWidth;
    }

    private void setLogicalCellHeight(int n) {
        this.logicalCellHeight = n;
    }

    public int getLogicalCellHeight() {
        return this.logicalCellHeight;
    }

    public int getCellHeight() {
        return this.myTiledLayer.getCellHeight();
    }

    public int getCellWidth() {
        return this.myTiledLayer.getCellWidth();
    }

    public int getRows() {
        return this.myTiledLayer.getRows();
    }

    public int getColumns() {
        return this.myTiledLayer.getColumns();
    }

    public int getCell(int n, int n2) {
        return this.myTiledLayer.getCell(n, n2);
    }

    public void setCell(int n, int n2, int n3) {
        this.myTiledLayer.setCell(n, n2, n3);
    }

    protected void setPosition(int n, int n2) {
        this.myTiledLayer.setPosition(n, n2);
    }

    public int getX() {
        return this.myTiledLayer.getX();
    }

    public int getY() {
        return this.myTiledLayer.getY();
    }

    public int getWidth() {
        return this.myTiledLayer.getWidth();
    }

    public int getHeight() {
        return this.myTiledLayer.getHeight();
    }

    public boolean isVisible() {
        return this.myTiledLayer.isVisible();
    }

    public boolean hasEmptyTiles() {
        return this.myHasEmptyTiles;
    }

    public TiledLayer getTiledLayer() {
        return this.myTiledLayer;
    }

    public void dispose() {
        SpriteDescriptor.decreaseImageRefCount(this.myFilenameId);
    }
}

