/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia;

import Snakedelia.KeyPressEventHandler;
import Snakedelia.Snakedelia;
import Snakedelia.menus.BasicScreen;
import Snakedelia.tasks.MyTimerTask;
import Snakedelia.tools.Configuration;
import Snakedelia.tools.Defines;
import Snakedelia.tools.GraphicFont;
import Snakedelia.tools.IUpdatable;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class AbstractCanvas
extends GameCanvas
implements Runnable {
    public static final int KEY_NUM0_PRESSED = 65536;
    public static final int KEY_NUM1_PRESSED = 131072;
    public static final int KEY_NUM2_PRESSED = 262144;
    public static final int KEY_NUM3_PRESSED = 524288;
    public static final int KEY_NUM4_PRESSED = 0x100000;
    public static final int KEY_NUM5_PRESSED = 0x200000;
    public static final int KEY_NUM6_PRESSED = 0x400000;
    public static final int KEY_NUM7_PRESSED = 0x800000;
    public static final int KEY_NUM8_PRESSED = 0x1000000;
    public static final int KEY_NUM9_PRESSED = 0x2000000;
    public static final int KEY_STAR_PRESSED = 0x4000000;
    public static final int KEY_POUND_PRESSED = 0x8000000;
    public static final int KEY_SOFTKEYL_PRESSED = 0x10000000;
    public static final int KEY_SOFTKEYR_PRESSED = 0x20000000;
    private Image fpsImage;
    private int myNumOfUpdates;
    private int myTotalTime;
    private int myAverageUpdateTime = 2147483;
    private int myLongestUpdate = 0;
    private boolean firstTimePaint = true;
    private Vector myTextBubbles = new Vector();
    private int myNumKeysStates = 0;
    private int myNewKeys = 0;
    private int myNewKeysTime = 0;
    private int myInternalGetKeyStates = 0;
    public final int InternalWidth;
    public final int InternalHeight;
    public final int LogicalWidth;
    public final int LogicalHeight;
    protected Graphics backBuffer = null;
    protected long lastUpdateTime = 0L;
    private boolean shouldStop = false;
    private Thread myGameThread = null;
    protected Vector myUpdatables = new Vector();
    private int numFlushed;
    private int accumTimeFPS;
    private int currentFPS;
    private int lastFPS = -1;
    private String lastFPSString;
    private static int myScore;
    private static int myLives;
    private int lastHighScore = -1;
    private String lastHighscoreString;
    private int lastScore = -1;
    private String lastScoreString;
    private int myTotalTimeElapsed = 0;
    private static Object syncObject;
    public static int MINIMAL_LOGIC_TIME;
    private BasicScreen myCurrentScreen = null;
    protected boolean myIsPaused = false;
    private Stack myBasicScreens = new Stack();
    private final int SOFTKEY_LEFT;
    private final int SOFTKEY_RIGHT;
    protected boolean myIsGainVisibility = true;

    protected AbstractCanvas() {
        super(false);
        this.InternalWidth = 240;
        this.InternalHeight = 320;
        this.LogicalWidth = 691200;
        this.LogicalHeight = 921600;
        this.SOFTKEY_LEFT = 13;
        this.SOFTKEY_RIGHT = 14;
    }

    protected void resetTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    protected void updateFPS(long l) {
        this.accumTimeFPS += (int)l;
        ++this.numFlushed;
        if (this.accumTimeFPS > 1000) {
            this.currentFPS = this.numFlushed * 10000 / this.accumTimeFPS;
            this.numFlushed = 0;
            this.accumTimeFPS = 0;
        }
    }

    protected void drawFPS() {
        if (this.lastFPS != this.currentFPS) {
            this.lastFPSString = Integer.toString(this.currentFPS);
            this.lastFPS = this.currentFPS;
            this.fpsImage = Image.createImage((int)GraphicFont.Comic_32_Sans_32_MS12GoldRegular.stringWidth(this.lastFPSString), (int)GraphicFont.Comic_32_Sans_32_MS12GoldRegular.getHeight());
            Graphics graphics = this.fpsImage.getGraphics();
            GraphicFont.Comic_32_Sans_32_MS12GoldRegular.draw(graphics, this.lastFPSString, 0, 0);
        }
        this.backBuffer.drawImage(this.fpsImage, 0, 0, 20);
    }

    protected void drawHighscore() {
        if (this.lastHighScore != Configuration.getHighScore()) {
            this.lastHighScore = Configuration.getHighScore();
            this.lastHighscoreString = "Highscore: " + Defines.unPrecise(this.lastHighScore);
        }
        GraphicFont.Comic_32_Sans_32_MS12GoldRegular.draw(this.backBuffer, this.lastHighscoreString, 0, GraphicFont.Comic_32_Sans_32_MS12GoldRegular.getHeight());
    }

    protected void drawScore() {
        if (this.lastScore != myScore) {
            this.lastScore = myScore;
            this.lastScoreString = "Score: " + Defines.unPrecise(myScore);
        }
        this.backBuffer.setColor(-252645121);
        GraphicFont.Comic_32_Sans_32_MS12GoldRegular.draw(this.backBuffer, this.lastScoreString, 0, GraphicFont.Comic_32_Sans_32_MS12GoldRegular.getHeight());
    }

    protected void addUpdatable(IUpdatable iUpdatable) {
        this.myUpdatables.addElement(iUpdatable);
    }

    protected boolean removeUpdatable(IUpdatable iUpdatable) {
        return this.myUpdatables.removeElement(iUpdatable);
    }

    protected void clearUpdatables() {
        this.myUpdatables.removeAllElements();
    }

    public void returnFromPause() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private long calculateElapsedTime(long l) {
        if (this.myCurrentScreen != null) {
            this.myCurrentScreen.handleKeyPress(l, this.getCustomKeyStates());
            this.myCurrentScreen.doLogic(l);
            if (this.myCurrentScreen.isBlocking()) {
                l = 0L;
            }
        }
        if (this.myIsPaused) {
            l = 0L;
        }
        return l;
    }

    protected void updateObjects() {
        int n;
        long l;
        long l2;
        long l3 = System.currentTimeMillis();
        long l4 = l3 - this.lastUpdateTime;
        this.updateFPS(l4);
        this.lastUpdateTime = l3;
        l4 = l4 * (long)Configuration.getSpeed() / 5L;
        l4 = this.calculateElapsedTime(l4);
        if (l4 != 0L) {
            ++this.myNumOfUpdates;
        }
        this.myTotalTime = (int)((long)this.myTotalTime + l4);
        if (l4 > (long)this.myLongestUpdate) {
            this.myLongestUpdate = (int)l4;
        }
        if (l4 > (long)(this.myAverageUpdateTime * 4)) {
            l4 = this.myAverageUpdateTime;
        }
        if (this.myNumOfUpdates > 10) {
            this.myAverageUpdateTime = (this.myTotalTime - this.myLongestUpdate) / (this.myNumOfUpdates - 1);
            this.myTotalTime = 0;
            this.myNumOfUpdates = 0;
            this.myLongestUpdate = 0;
        }
        if ((l2 = l4 < (long)MINIMAL_LOGIC_TIME ? l4 : (long)MINIMAL_LOGIC_TIME) > (l = MyTimerTask.getInstance().getNextTime())) {
            l2 = l;
        }
        l4 -= l2;
        boolean bl = true;
        long l5 = System.currentTimeMillis();
        while (l2 > 0L || bl) {
            bl = false;
            this.seTotalTimeElapsed(this.getTotalTimeElapsed() + (int)l2);
            this.internalUpdate(l2);
            int n2 = this.myUpdatables.size();
            for (n = 0; n < n2; ++n) {
                ((IUpdatable)this.myUpdatables.elementAt(n)).update(l2);
            }
            this.afterLogicRun();
            l4 = this.calculateElapsedTime(l4);
            l2 = l4 < (long)MINIMAL_LOGIC_TIME ? l4 : (long)MINIMAL_LOGIC_TIME;
            l = MyTimerTask.getInstance().getNextTime();
            if (l4 > l) {
                l2 = l;
            }
            l4 -= l2;
            if (this.myNewKeys != 0) {
                this.myNewKeys = 0;
            }
            if (System.currentTimeMillis() - l5 <= 150L) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l5 = System.currentTimeMillis();
        }
        if (this.myIsGainVisibility) {
            Graphics graphics = this.backBuffer;
            n = graphics.getClipX();
            int n3 = graphics.getClipY();
            int n4 = graphics.getClipHeight();
            int n5 = graphics.getClipWidth();
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setClip(n, n3, n5, n4);
        }
        this.paintOnBuffer(this.backBuffer);
        if (null != this.myCurrentScreen) {
            this.myCurrentScreen.paint(this.backBuffer);
        }
    }

    public abstract void paintOnBuffer(Graphics var1);

    protected abstract void internalUpdate(long var1);

    protected abstract void afterLogicRun();

    public void start() {
        if (this.myGameThread == null) {
            this.myGameThread = new Thread(this);
            this.myGameThread.start();
        }
    }

    public void paint(Graphics graphics) {
        this.setFullScreenMode(true);
        super.paint(graphics);
    }

    public void run() {
        this.shouldStop = false;
        this.resetTime();
        long l = System.currentTimeMillis();
        long l2 = 1000L;
        while (!this.shouldStop) {
            l2 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            if (this.myIsPaused) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            this.updateObjects();
            if (this.myIsGainVisibility) {
                this.flushGraphics();
                this.myIsGainVisibility = false;
            } else {
                this.flushGraphics(0, 0, 240, 320);
            }
            if (l2 <= 100L) continue;
            Thread.yield();
            l2 = 0L;
        }
        try {
            Snakedelia.midlet.destroyApp(true);
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            mIDletStateChangeException.printStackTrace();
        }
        this.myGameThread = null;
    }

    public static final void setScore(int n) {
        myScore = n;
        if (myScore > Configuration.getHighScore()) {
            Configuration.setHighScore(myScore);
        }
    }

    public static final void setLives(int n) {
        myLives = n;
    }

    public static final int getScore() {
        return myScore;
    }

    public int getUnprecisedScore() {
        return Defines.unPrecise(myScore);
    }

    public static final int getLives() {
        return myLives;
    }

    public static void setSyncObject(Object object) {
        syncObject = object;
    }

    public static Object getSyncObject() {
        return syncObject;
    }

    public void seTotalTimeElapsed(int n) {
        this.myTotalTimeElapsed = n;
    }

    public int getTotalTimeElapsed() {
        return this.myTotalTimeElapsed;
    }

    public BasicScreen getBasicScreen() {
        return this.myCurrentScreen;
    }

    public final void clearKeyPresses() {
        this.myNumKeysStates = 0;
        this.myNewKeys = 0;
    }

    public final void keyPressed(int n) {
        int n2 = this.keyToPressed(n);
        this.myNumKeysStates |= n2;
        this.myNewKeys |= n2;
    }

    public final void keyReleased(int n) {
        this.myNumKeysStates &= ~this.keyToPressed(n);
    }

    public final int keyToPressed(int n) {
        int n2 = 0;
        int n3 = this.getGameAction(n);
        if (-6 == n) {
            n3 = 13;
        } else if (-7 == n) {
            n3 = 14;
        } else if (-10 == n) {
            n3 = 9;
        }
        switch (n3) {
            case 9: {
                n2 |= 0x200;
                break;
            }
            case 10: {
                n2 |= 0x400;
                break;
            }
            case 11: {
                n2 |= 0x800;
                break;
            }
            case 12: {
                n2 |= 0x1000;
                break;
            }
            case 8: {
                n2 |= 0x100;
                break;
            }
            case 2: {
                n2 |= 4;
                break;
            }
            case 5: {
                n2 |= 0x20;
                break;
            }
            case 1: {
                n2 |= 2;
                break;
            }
            case 6: {
                n2 |= 0x40;
                break;
            }
            case 13: {
                n2 |= 0x10000000;
                break;
            }
            case 14: {
                n2 |= 0x20000000;
            }
        }
        switch (n) {
            case 48: {
                n2 |= 0x10000;
                break;
            }
            case 49: {
                n2 |= 0x20000;
                break;
            }
            case 50: {
                n2 |= 0x40000;
                break;
            }
            case 51: {
                n2 |= 0x80000;
                break;
            }
            case 52: {
                n2 |= 0x100000;
                break;
            }
            case 53: {
                n2 |= 0x200000;
                break;
            }
            case 54: {
                n2 |= 0x400000;
                break;
            }
            case 55: {
                n2 |= 0x800000;
                break;
            }
            case 56: {
                n2 |= 0x1000000;
                break;
            }
            case 57: {
                n2 |= 0x2000000;
                break;
            }
            case 42: {
                n2 |= 0x4000000;
                break;
            }
            case 35: {
                n2 |= 0x8000000;
            }
        }
        return n2;
    }

    public int getCustomKeyStates() {
        return this.myNumKeysStates | this.myNewKeys | this.myInternalGetKeyStates;
    }

    public void pushScreen(BasicScreen basicScreen) {
        if (basicScreen != null) {
            this.myBasicScreens.push(basicScreen);
        }
        this.myCurrentScreen = basicScreen;
        this.clearKeyPresses();
    }

    public void popScreen() {
        if (this.myBasicScreens.empty()) {
            return;
        }
        this.myBasicScreens.pop();
        BasicScreen basicScreen = null;
        if (!this.myBasicScreens.empty()) {
            basicScreen = (BasicScreen)this.myBasicScreens.peek();
        }
        this.myCurrentScreen = basicScreen;
        if (KeyPressEventHandler.getInstance() != null) {
            KeyPressEventHandler.getInstance().clearState();
        }
    }

    public void clearScreens() {
        this.myBasicScreens.removeAllElements();
        this.myCurrentScreen = null;
        this.clearKeyPresses();
    }

    protected void stopLogic() {
        this.shouldStop = true;
    }

    static {
        syncObject = new Object();
        MINIMAL_LOGIC_TIME = 80;
    }
}

