/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia;

import Snakedelia.BasicCanvas;
import Snakedelia.CollisionEventHandler;
import Snakedelia.LevelInitData;
import Snakedelia.tasks.MyTimerTask;
import Snakedelia.tools.BasicSprite;
import Snakedelia.tools.CanvasManager;
import Snakedelia.tools.IUpdatable;
import Snakedelia.tools.IntVector;
import Snakedelia.tools.PhysicalSprite;
import Snakedelia.tools.TiledBackground;
import Snakedelia.tools.Variables;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public final class GameManager
extends LayerManager
implements IUpdatable {
    public boolean flushingDestroyedEventQueue = false;
    IntVector emptyVector = new IntVector(16);
    private Vector mySprites = new Vector();
    private IntVector animVector = new IntVector();
    private Vector updateVector = new Vector();
    private IntVector updateVectorEmptySlots = new IntVector(256);
    private IntVector mySpritesToRemoveQueue = new IntVector(128);
    private IntVector mySpritesToRemoveWithEvent = new IntVector(128);
    public static IntVector[] groupsArray = new IntVector[40];
    static final int[] groupsFlags = Variables.__arraydataInt[41];
    static final int CONST_FLAG_CONTAINS_PROPERTIES = 1;
    static final int CONST_FLAG_TARGET = 2;
    static final int CONST_FLAG_HAS_CREATE = 4;
    static final int CONST_FLAG_HAS_DESTROY = 8;
    static final int CONST_FLAG_HAS_COLLISION = 16;
    static final int CONST_FLAG_HAS_CONDITION = 32;
    static final int CONST_FLAG_HAS_POSITION = 64;
    static final int CONST_FLAG_HAS_DISTANCE = 128;
    private int vwX = 0;
    private int vwY = 0;
    private int vwWidth;
    private int vwHeight;
    private int myWorldVelocityX = 0;
    private int myWorldVelocityY = 0;
    public static int WorldPositionX = 0;
    public static int WorldPositionY = 0;
    public static int WorldStateNumber = 0;
    public int trackedInstancePositionX = 0;
    public int trackedInstancePositionY = 0;
    public int trackedInstancePositionWidth = 0;
    public int trackedInstancePositionHeight = 0;
    private BasicSprite myRelativeSprite = null;
    private boolean myTrackInfinite = true;
    private Timer myTimer;
    private TiledBackground myBackground = null;
    private GameManager myManager = this;

    public GameManager(int n, int n2) {
        this.vwWidth = n;
        this.vwHeight = n2;
        this.setViewWindow(this.vwX, this.vwY, this.vwWidth, this.vwHeight);
        this.setTimer(new Timer());
        this.removeAll();
    }

    public void classicPaint(Graphics graphics, int n) {
        BasicCanvas basicCanvas = BasicCanvas.getInstance();
        basicCanvas.getClass();
        basicCanvas.getClass();
        graphics.setClip(0, 0, 240, 320);
        if (this.myBackground == null || this.myBackground.hasEmptyTiles()) {
            graphics.setColor(n);
            basicCanvas.getClass();
            basicCanvas.getClass();
            graphics.fillRect(0, 0, 240, 320);
        }
        if (this.myBackground != null) {
            this.myBackground.getTiledLayer().paint(graphics);
        }
        int n2 = this.mySprites.size();
        for (int i = 0; i < n2; ++i) {
            BasicSprite basicSprite = (BasicSprite)this.mySprites.elementAt(i);
            PhysicalSprite physicalSprite = basicSprite.myPhysicalSprite;
            physicalSprite.paint(graphics);
        }
    }

    public static void printMemory(String string) {
    }

    public void replaceSpriteInSortedList(BasicSprite basicSprite) {
        this.mySprites.removeElement(basicSprite);
        this.addSpriteToSortedList(basicSprite);
    }

    private void addSpriteToSortedList(BasicSprite basicSprite) {
        if (this.mySprites.size() == 0 || basicSprite.myPhysicalSprite.getLogicalZ() == Integer.MAX_VALUE) {
            this.mySprites.addElement(basicSprite);
            return;
        }
        int n = 0;
        int n2 = this.mySprites.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = basicSprite.myPhysicalSprite.getLogicalZ();
        if (n5 < ((BasicSprite)this.mySprites.elementAt((int)0)).myPhysicalSprite.getLogicalZ()) {
            this.mySprites.insertElementAt(basicSprite, 0);
        } else if (n5 >= ((BasicSprite)this.mySprites.elementAt((int)(this.mySprites.size() - 1))).myPhysicalSprite.getLogicalZ()) {
            this.mySprites.addElement(basicSprite);
        } else {
            while (n < n2) {
                n3 = (n + n2) / 2;
                n4 = ((BasicSprite)this.mySprites.elementAt((int)n3)).myPhysicalSprite.getLogicalZ();
                if (n5 < n4) {
                    n2 = n3;
                    continue;
                }
                if (n5 <= n4) break;
                n = n3 + 1;
            }
            if (n5 > n4) {
                ++n3;
            }
            this.mySprites.insertElementAt(basicSprite, n3);
        }
    }

    public int append(BasicSprite basicSprite) {
        int n;
        if (this.updateVectorEmptySlots.ItemCount == 0) {
            this.updateVector.addElement(basicSprite);
            n = this.updateVector.size() - 1;
        } else {
            n = this.updateVectorEmptySlots.Array[this.updateVectorEmptySlots.Size - 1];
            this.updateVectorEmptySlots.removeElementAt(this.updateVectorEmptySlots.Size - 1);
            this.updateVector.setElementAt(basicSprite, n);
        }
        if (basicSprite.isPhysical()) {
            this.addSpriteToSortedList(basicSprite);
            if (basicSprite.isAnimatable()) {
                this.appendAnimatable(n);
            }
        }
        for (int i = basicSprite.myGroups.length - 1; i >= 0; --i) {
            short s = basicSprite.myGroups[i];
            if ((groupsFlags[s] & 2) != 0) {
                if (groupsArray[s] == null) {
                    GameManager.groupsArray[s] = new IntVector(32);
                }
                groupsArray[s].addElement(n);
            }
            if ((groupsFlags[s] & 1) == 0) continue;
            LevelInitData.initializeSpriteVariables(s, n, basicSprite);
        }
        return n;
    }

    private void appendAnimatable(int n) {
        this.animVector.addElement(n);
    }

    public boolean spriteExists(int n, int n2) {
        BasicSprite basicSprite = (BasicSprite)this.updateVector.elementAt(n);
        if (basicSprite == null) {
            return false;
        }
        return basicSprite.getUID() == n2;
    }

    public void removeAll() {
        if (this.myBackground != null) {
            this.myBackground.dispose();
            super.remove((Layer)this.myBackground.getTiledLayer());
            this.myBackground = null;
        }
        for (int i = 1; i < this.updateVector.size(); ++i) {
            if (this.updateVector.elementAt(i) == null) continue;
            this.remove(i);
        }
        this.updateVector.removeAllElements();
        this.updateVectorEmptySlots.removeAllElements();
        this.animVector.removeAllElements();
        this.mySpritesToRemoveQueue.removeAllElements();
        this.updateVector.addElement(null);
    }

    public void addToRemoveQueue(int n) {
        if (this.mySpritesToRemoveQueue.ItemCount == 0 || this.mySpritesToRemoveQueue.Array[0] != Integer.MAX_VALUE && !this.mySpritesToRemoveQueue.contains(n)) {
            this.mySpritesToRemoveQueue.addElement(n);
        }
        this.getSprite((int)n).isDying = true;
    }

    public void addToDestroyedEventQueue(int n) {
        if (!this.mySpritesToRemoveWithEvent.contains(n)) {
            this.mySpritesToRemoveWithEvent.addElement(n);
        }
    }

    public void addAllToRemoveQueue() {
        if (this.mySpritesToRemoveQueue.ItemCount > 0) {
            this.mySpritesToRemoveQueue.Array[0] = Integer.MAX_VALUE;
        } else {
            this.mySpritesToRemoveQueue.addElement(Integer.MAX_VALUE);
        }
    }

    public void flushRemovalQueue() {
        if (this.mySpritesToRemoveQueue.ItemCount > 0) {
            if (this.mySpritesToRemoveQueue.Array[0] != Integer.MAX_VALUE) {
                for (int i = 0; i < this.mySpritesToRemoveQueue.Size; ++i) {
                    if (this.mySpritesToRemoveQueue.Array[i] == -1) continue;
                    this.remove(this.mySpritesToRemoveQueue.Array[i]);
                }
            } else {
                this.removeAll();
            }
        }
        this.mySpritesToRemoveQueue.removeAllElements();
    }

    public void flushDestroyedEventQueue() {
        int n;
        int n2;
        this.flushingDestroyedEventQueue = true;
        for (n2 = 0; n2 < this.mySpritesToRemoveWithEvent.Size; ++n2) {
            n = this.mySpritesToRemoveWithEvent.Array[n2];
            if (n == -1) continue;
            BasicSprite basicSprite = this.getSprite(n);
            basicSprite.isDying = true;
        }
        n2 = Variables.firstSprite;
        for (n = 0; n < this.mySpritesToRemoveWithEvent.Size; ++n) {
            short s;
            int n3;
            if (this.mySpritesToRemoveWithEvent.Array[n] == -1) continue;
            int n4 = this.mySpritesToRemoveWithEvent.Array[n];
            BasicSprite basicSprite = this.getSprite(n4);
            block6: for (n3 = basicSprite.myGroups.length - 1; n3 >= 0; --n3) {
                Variables.firstSprite = n4;
                s = basicSprite.myGroups[n3];
                switch (s) {
                    case 13: {
                        CollisionEventHandler.handleCollision_worm_hole_811909175_head2_770529099();
                        continue block6;
                    }
                    case 4: {
                        CollisionEventHandler.handleCollision_worm_hole_811909175_head_431746797();
                    }
                }
            }
            for (n3 = basicSprite.myGroups.length - 1; n3 >= 0; --n3) {
                Variables.firstSprite = n4;
                s = basicSprite.myGroups[n3];
                if ((groupsFlags[s] & 8) == 0) continue;
            }
        }
        Variables.firstSprite = n2;
        this.mySpritesToRemoveWithEvent.removeAllElements();
        this.flushingDestroyedEventQueue = false;
    }

    public void clearDestoryedEventQueue() {
        this.mySpritesToRemoveWithEvent.removeAllElements();
    }

    public void remove(int n) {
        BasicSprite basicSprite = this.getSprite(n);
        this.mySprites.removeElement(basicSprite);
        if (basicSprite == null) {
            throw new IllegalArgumentException("element does not exist in sprite vector");
        }
        if (basicSprite.isAnimatable()) {
            this.removeAnimatable(n);
        }
        if (this.myRelativeSprite == basicSprite) {
            this.setRelativeSprite(null, false);
        }
        this.updateVector.setElementAt(null, n);
        this.updateVectorEmptySlots.addElement(n);
        MyTimerTask.getInstance().removeTasksWithSpriteId(n);
        short[] sArray = basicSprite.getGroups();
        if (sArray != null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = sArray.length - 1; i >= 0; --i) {
                short s = sArray[i];
                if ((groupsFlags[s] & 2) != 0) {
                    if (groupsArray[sArray[i]] == null) {
                        throw new RuntimeException("Group " + sArray[i] + " doesn't exist although it should!");
                    }
                    groupsArray[sArray[i]].removeElement(n);
                }
                if ((groupsFlags[s] & 1) != 0) {
                    LevelInitData.disposeOfSpriteVariables(s, n, basicSprite);
                }
                if (!bl3 && (groupsFlags[s] & 0x10) != 0) {
                    CollisionEventHandler.getInstance().removeSprite(n);
                    bl3 = true;
                }
                if ((groupsFlags[s] & 0x20) == 0) continue;
            }
        }
        basicSprite.dispose();
    }

    public BasicSprite getSprite(int n) {
        if (this.updateVector.size() <= n) {
            return null;
        }
        return (BasicSprite)this.updateVector.elementAt(n);
    }

    private void removeAnimatable(int n) {
        this.animVector.removeElement(n);
    }

    public void animateAll(long l) {
        int n = this.animVector.Size;
        for (int i = 0; i < n; ++i) {
            if (this.animVector.Array[i] == -1) continue;
            BasicSprite basicSprite = null;
            int n2 = 0;
            basicSprite = this.getSprite(this.animVector.Array[i]);
            if (basicSprite == null) continue;
            PhysicalSprite physicalSprite = basicSprite.myPhysicalSprite;
            n2 = physicalSprite.getWrappedSprite().getFrame();
            physicalSprite.getAnimationManager().animate(l);
            int n3 = physicalSprite.getWrappedSprite().getFrame();
        }
    }

    public void updateAll(long l) {
        boolean bl = false;
        if (this.myRelativeSprite != null) {
            BasicCanvas basicCanvas = BasicCanvas.getInstance();
            this.myRelativeSprite.update(l);
            PhysicalSprite physicalSprite = this.myRelativeSprite.myPhysicalSprite;
            int n = physicalSprite.getLogicalX();
            int n2 = physicalSprite.getLogicalX() + physicalSprite.getLogicalWidth();
            int n3 = physicalSprite.getLogicalY();
            int n4 = physicalSprite.getLogicalY() + physicalSprite.getLogicalHeight();
            int n5 = WorldPositionX + this.trackedInstancePositionX;
            int n6 = WorldPositionX + this.trackedInstancePositionX + this.trackedInstancePositionWidth;
            int n7 = WorldPositionY + this.trackedInstancePositionY;
            int n8 = WorldPositionY + this.trackedInstancePositionY + this.trackedInstancePositionHeight;
            int n9 = WorldPositionX;
            basicCanvas.getClass();
            int n10 = WorldPositionX + 691200;
            int n11 = WorldPositionY;
            basicCanvas.getClass();
            int n12 = WorldPositionY + 921600;
            int n13 = WorldPositionX;
            int n14 = WorldPositionY;
            if (n < n5) {
                n13 = n - this.trackedInstancePositionX;
            } else if (n2 > n6) {
                n13 = n2 - this.trackedInstancePositionX - this.trackedInstancePositionWidth;
            }
            if (n3 < n7) {
                n14 = n3 - this.trackedInstancePositionY;
            } else if (n4 > n8) {
                n14 = n4 - this.trackedInstancePositionY - this.trackedInstancePositionHeight;
            }
            if (!this.myTrackInfinite) {
                int n15 = basicCanvas.getCurrentRoomLogicalWidth();
                basicCanvas.getClass();
                if (n15 >= 691200) {
                    basicCanvas.getClass();
                    if (n13 + 691200 > basicCanvas.getCurrentRoomLogicalWidth()) {
                        int n16 = basicCanvas.getCurrentRoomLogicalWidth();
                        basicCanvas.getClass();
                        n13 = n16 - 691200;
                    }
                    if (n13 < 0) {
                        n13 = 0;
                    }
                }
                int n17 = basicCanvas.getCurrentRoomLogicalHeight();
                basicCanvas.getClass();
                if (n17 >= 921600) {
                    basicCanvas.getClass();
                    if (n14 + 921600 > basicCanvas.getCurrentRoomLogicalHeight()) {
                        int n18 = basicCanvas.getCurrentRoomLogicalHeight();
                        basicCanvas.getClass();
                        n14 = n18 - 921600;
                    }
                    if (n14 < 0) {
                        n14 = 0;
                    }
                }
            }
            if (WorldPositionX != n13 || WorldPositionY != n14) {
                this.setWorldPosition(n13, n14);
            }
            this.myRelativeSprite.myPhysicalSprite.movePrecise(0, 0);
        } else {
            this.setWorldVelocityX(0);
            this.setWorldVelocityY(0);
        }
        this.internalUpdateAll(l);
    }

    private void internalUpdateAll(long l) {
        int n = this.updateVector.size();
        for (int i = 0; i < n; ++i) {
            IUpdatable iUpdatable = (IUpdatable)this.updateVector.elementAt(i);
            if (iUpdatable == null || iUpdatable == this.myRelativeSprite) continue;
            iUpdatable.update(l);
        }
    }

    private void syncObjectsWithWorld() {
        int n = this.updateVector.size();
        if (this.myBackground != null) {
            this.myBackground.movePrecise(0, 0);
        }
        for (int i = 0; i < n; ++i) {
            BasicSprite basicSprite;
            IUpdatable iUpdatable = (IUpdatable)this.updateVector.elementAt(i);
            if (iUpdatable == null || iUpdatable == this.myRelativeSprite || this.myRelativeSprite == null || !(iUpdatable instanceof BasicSprite) || !(basicSprite = (BasicSprite)iUpdatable).isPhysical()) continue;
            PhysicalSprite physicalSprite = ((BasicSprite)iUpdatable).myPhysicalSprite;
            if (physicalSprite.isStatic()) {
                physicalSprite.movePrecise(0, 0, true, false);
                continue;
            }
            if (!physicalSprite.hasSprite() && basicSprite.myCanvasManager == null) continue;
            physicalSprite.movePrecise(0, 0, false, false);
        }
    }

    public void setWorldPosition(int n, int n2) {
        if (this.setWorldPositionX(n, false) || this.setWorldPositionY(n2, false)) {
            // empty if block
        }
        this.syncObjectsWithWorld();
    }

    public void setWorldPositionX(int n) {
        this.setWorldPositionX(n, true);
    }

    public void setWorldPositionY(int n) {
        this.setWorldPositionY(n, true);
    }

    private boolean setWorldPositionX(int n, boolean bl) {
        if (WorldPositionX != n) {
            WorldPositionX = n;
            ++WorldStateNumber;
            BasicCanvas basicCanvas = BasicCanvas.getInstance();
            this.syncObjectsWithWorld();
        }
        return false;
    }

    private boolean setWorldPositionY(int n, boolean bl) {
        if (WorldPositionY != n) {
            WorldPositionY = n;
            ++WorldStateNumber;
            this.syncObjectsWithWorld();
        }
        return false;
    }

    public void update(long l) {
        this.updateAll(l);
        this.animateAll(l);
        this.updateVectorEmptySlots.compactArray();
        this.updateVectorEmptySlots.shrinkCapacity();
        this.animVector.compactArray();
        this.animVector.shrinkCapacity();
        int n = groupsArray.length;
        for (int i = 0; i < n; ++i) {
            if (groupsArray[i] == null) continue;
            groupsArray[i].compactArray();
            groupsArray[i].shrinkCapacity();
        }
    }

    private void setTimer(Timer timer) {
        this.myTimer = timer;
    }

    public Timer getTimer() {
        return this.myTimer;
    }

    public int getSpriteIndex(BasicSprite basicSprite) {
        return this.updateVector.indexOf(basicSprite);
    }

    public IntVector getGroupElements(int n) {
        IntVector intVector = groupsArray[n];
        if (intVector == null) {
            return this.emptyVector;
        }
        return intVector;
    }

    public void setBackground(TiledBackground tiledBackground) {
        if (this.myBackground != null) {
            this.myBackground.dispose();
            super.remove((Layer)this.myBackground.getTiledLayer());
        }
        this.myBackground = tiledBackground;
        if (this.myBackground != null) {
            super.append((Layer)this.myBackground.getTiledLayer());
        }
        this.updateVector.setElementAt(this.myBackground, 0);
    }

    public TiledBackground getBackground() {
        return this.myBackground;
    }

    public void setWorldVelocityX(int n) {
        this.myWorldVelocityX = n;
    }

    public void setWorldVelocityY(int n) {
        this.myWorldVelocityY = n;
    }

    public int getWorldVelocityX() {
        return this.myWorldVelocityX;
    }

    public int getWorldVelocityY() {
        return this.myWorldVelocityY;
    }

    public void setRelativeSprite(BasicSprite basicSprite, boolean bl) {
        this.myRelativeSprite = basicSprite;
        this.myTrackInfinite = bl;
    }

    public void setTrackingInfinite(boolean bl) {
        this.myTrackInfinite = bl;
    }

    public boolean isTrackingInfinite() {
        return this.myTrackInfinite;
    }

    public final CanvasManager getSpriteCanvas(int n) {
        return this.getSprite((int)n).myCanvasManager;
    }

    public void paint(Graphics graphics, int n, int n2) {
        super.paint(graphics, n, n2);
    }
}

