/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.AbstractCanvas;
import Snakedelia.tools.GraphicFont;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Graphics;

public abstract class BasicScreen {
    private static final int KEY_PRESS_TIME_INTERVAL = 300;
    long timeElapsedFromLastKeypress = 0L;
    long lastTimeLogic;
    private CommandListener myCommandListener;
    private Command cmdLeft;
    private Command cmdRight;
    private int myX;
    private int myY;
    private int myWidth;
    private int myHeight;
    private boolean myIsBlocking;
    private AbstractCanvas myCanvas;
    private boolean myIsVisible = true;
    private boolean isSuppressKeys = true;
    private boolean myShouldFillScreen = false;
    private int myFillColor = 0;
    protected GraphicFont myFont;

    public BasicScreen(int n, int n2, int n3, int n4, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont) {
        this.setBlocking(bl);
        this.myX = n;
        this.myY = n2;
        this.myHeight = n4;
        this.myWidth = n3;
        this.myCanvas = abstractCanvas;
        this.myFont = graphicFont;
    }

    public final void handleKeyPress(long l, int n) {
        this.timeElapsedFromLastKeypress += l;
        if (this.timeElapsedFromLastKeypress > 300L && n != 0) {
            this.handleKeyState(n);
            if ((n & 0x20000000) != 0) {
                this.invokeCommand(this.cmdRight);
            } else if ((n & 0x10000000) != 0) {
                this.invokeCommand(this.cmdLeft);
            }
            this.timeElapsedFromLastKeypress = 0L;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (!this.isVisible()) {
            return;
        }
        if (this.myShouldFillScreen) {
            n2 = graphics.getColor();
            graphics.setColor(this.myFillColor);
            graphics.fillRect(this.myX + 0, this.myY + 0, this.getWidth(), this.getHeight());
            graphics.setColor(n2);
        }
        if (this.cmdLeft != null) {
            n2 = this.myX + 3;
            n = this.myY + this.getHeight() - this.myFont.getHeight();
            this.myFont.draw(graphics, this.cmdLeft.getLabel(), n2, n);
        }
        if (this.cmdRight != null) {
            n2 = this.myX + this.getWidth() - this.myFont.stringWidth(this.cmdRight.getLabel()) - 3;
            n = this.myY + this.getHeight() - this.myFont.getHeight();
            this.myFont.draw(graphics, this.cmdRight.getLabel(), n2, n);
        }
    }

    protected int getYForChild() {
        return this.myY;
    }

    protected int getHeightForChild() {
        return this.getHeight() - this.myFont.getHeight();
    }

    public abstract void doLogic(long var1);

    public void setCommandListener(CommandListener commandListener) {
        this.myCommandListener = commandListener;
    }

    protected void handleKeyState(int n) {
    }

    public void setLeftCommand(Command command) {
        this.cmdLeft = command;
    }

    public void setRightCommand(Command command) {
        this.cmdRight = command;
    }

    public int getX() {
        return this.myX;
    }

    public int getY() {
        return this.myY;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public void setBlocking(boolean bl) {
        this.myIsBlocking = bl;
    }

    public boolean isBlocking() {
        return this.myIsBlocking;
    }

    protected AbstractCanvas getCanvas() {
        return this.myCanvas;
    }

    public void setVisible(boolean bl) {
        this.myIsVisible = bl;
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    public void setSuppressKeys(boolean bl) {
        this.isSuppressKeys = bl;
    }

    public boolean isSuppressKeys() {
        return this.isSuppressKeys;
    }

    protected void setFillColor(int n) {
        this.myFillColor = n;
    }

    protected int getFillColor() {
        return this.myFillColor;
    }

    protected void setShouldFillScreen(boolean bl) {
        this.myShouldFillScreen = bl;
    }

    protected boolean shouldFillScreen() {
        return this.myShouldFillScreen;
    }

    private void invokeCommand(Command command) {
        if (this.myCommandListener != null && command != null) {
            this.myCommandListener.commandAction(command, null);
        }
    }
}

