/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.AbstractCanvas;
import Snakedelia.BasicCanvas;
import Snakedelia.menus.BasicScreen;
import Snakedelia.tools.GraphicFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Highscores
extends BasicScreen
implements CommandListener {
    private static final String MARKER_CHAR = "_";
    private static final int FLICKERING_VISIBLE_TIME = 1000;
    private static final int FLICKERING_INVISIBLE_TIME = 200;
    static final String HIGHSCORE_RECORDSTORE_NAME = "HighscoresRecord";
    static final String HIGHTSCORE_TITLE = "Highscores";
    final int LINES_GAP;
    final int LINE_HEIGHT;
    final int NAME_POSITION;
    static final int NUM_SCORES = 10;
    static final int NUM_CHARACTERS_IN_NAME = 3;
    final int BORDER_WIDTH;
    final int BORDER_HEIGHT;
    String[] myNames;
    String[] myScores;
    boolean[] myIsCheat;
    int editedLineIndex;
    int editedCharacterIndex;
    char currentChar;
    boolean isInvisible;
    long totalTime;
    private Command cmdBack;
    private String newScoreString;
    private final int CONST_DELAY_AT_EDGES;
    private final int CONST_RATE_OF_SCROLL;
    private final int CONST_MOVEMENT_AT_TOP;
    private final int CONST_MOVEMENT_GOING_DOWN;
    private final int CONST_MOVEMENT_GOING_UP;
    private final int CONST_MOVEMENT_AT_BOTTOM;
    private int scrollingTimeElapsed;
    private int myHighScoreY;
    private int myScrollingAmount;
    private int myCurrentScroll;
    private int myMovementType;

    public Highscores(int n, int n2, int n3, int n4, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont) {
        super(n, n2, n3, n4, bl, abstractCanvas, graphicFont);
        this.LINES_GAP = this.myFont.getHeight() / 12;
        this.LINE_HEIGHT = this.myFont.getHeight();
        this.NAME_POSITION = this.myFont.stringWidth("99.");
        this.BORDER_WIDTH = this.getWidth() / 10;
        this.BORDER_HEIGHT = this.getHeight() / 30;
        this.myNames = new String[10];
        this.myScores = new String[10];
        this.myIsCheat = new boolean[10];
        this.editedLineIndex = -1;
        this.editedCharacterIndex = -1;
        this.isInvisible = false;
        this.cmdBack = new Command("Back", 2, 1);
        this.CONST_DELAY_AT_EDGES = 1500;
        this.CONST_RATE_OF_SCROLL = 100;
        this.CONST_MOVEMENT_AT_TOP = 0;
        this.CONST_MOVEMENT_GOING_DOWN = 1;
        this.CONST_MOVEMENT_GOING_UP = 2;
        this.CONST_MOVEMENT_AT_BOTTOM = 3;
        this.scrollingTimeElapsed = 0;
        this.myHighScoreY = 0;
        this.myScrollingAmount = 0;
        this.myCurrentScroll = 0;
        this.myMovementType = 0;
        Highscores.getHighscores(this.myNames, this.myScores, this.myIsCheat);
        this.setLeftCommand(this.cmdBack);
        this.setCommandListener(this);
        this.updatePositions();
    }

    public void doLogic(long l) {
        if (this.isEditing()) {
            this.totalTime += l;
            if (!this.isInvisible && this.totalTime > 1000L || this.isInvisible && this.totalTime > 200L) {
                this.isInvisible = !this.isInvisible;
                this.totalTime = 0L;
            }
        } else {
            this.scrollingTimeElapsed = (int)((long)this.scrollingTimeElapsed + l);
            switch (this.myMovementType) {
                case 0: {
                    if (this.scrollingTimeElapsed < 1500) break;
                    this.myMovementType = 1;
                    this.scrollingTimeElapsed -= 1500;
                    this.doLogic(0L);
                    break;
                }
                case 3: {
                    if (this.scrollingTimeElapsed < 1500) break;
                    this.myMovementType = 2;
                    this.scrollingTimeElapsed -= 1500;
                    this.doLogic(0L);
                    break;
                }
                case 1: {
                    this.myCurrentScroll += this.scrollingTimeElapsed / 100;
                    this.scrollingTimeElapsed %= 100;
                    if (this.myCurrentScroll < this.myScrollingAmount) break;
                    this.myMovementType = 3;
                    this.scrollingTimeElapsed += (this.myCurrentScroll - this.myScrollingAmount) * 100;
                    this.myCurrentScroll = this.myScrollingAmount;
                    this.doLogic(0L);
                    break;
                }
                case 2: {
                    this.myCurrentScroll -= this.scrollingTimeElapsed / 100;
                    this.scrollingTimeElapsed %= 100;
                    if (this.myCurrentScroll > 0) break;
                    this.myMovementType = 0;
                    this.scrollingTimeElapsed += -this.myCurrentScroll * 100;
                    this.myCurrentScroll = 0;
                    this.doLogic(0L);
                }
            }
        }
    }

    private void updatePositions() {
        if (this.getHeightForHighscore() < this.LINE_HEIGHT * 10) {
            this.myScrollingAmount = this.LINE_HEIGHT * 10 - this.getHeightForHighscore();
            this.myHighScoreY = this.getYForHighscore();
        } else {
            this.myHighScoreY = this.getYForHighscore() + (this.getHeightForHighscore() - this.LINE_HEIGHT * 10) / 2;
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEditing()) {
            super.paint(graphics);
            this.myFont.draw(graphics, HIGHTSCORE_TITLE, this.getX() + this.getWidth() / 2, this.getYForChild() + this.BORDER_HEIGHT, 17);
            int n = graphics.getClipX();
            int n2 = graphics.getClipY();
            int n3 = graphics.getClipWidth();
            int n4 = graphics.getClipHeight();
            graphics.clipRect(this.getX() + 0, this.getYForHighscore() + 0, this.getWidth(), this.getHeightForHighscore());
            int n5 = this.myHighScoreY - this.myCurrentScroll;
            for (int i = 0; i < 10; ++i) {
                this.drawScore(graphics, i, n5, this.myNames[i], this.myScores[i], this.myIsCheat[i]);
                if ((n5 += this.LINE_HEIGHT) > this.getYForHighscore() + this.getHeightForHighscore()) break;
            }
            graphics.setClip(n, n2, n3, n4);
        } else {
            String string = this.myNames[this.editedLineIndex];
            int n = this.myFont.getHeight() * 2 + this.BORDER_HEIGHT;
            int n6 = this.getY() + (this.getHeight() - n) / 2;
            this.myFont.draw(graphics, this.newScoreString, this.getX(), n6, this.getWidth(), this.myFont.getHeight() * 2, 1, true);
            String string2 = MARKER_CHAR;
            if (this.editedCharacterIndex > 0) {
                String string3 = string.substring(0, this.editedCharacterIndex);
                string2 = string3 + string2;
            }
            int n7 = this.getX() + (this.getWidth() - this.myFont.stringWidth(string)) / 2;
            this.myFont.draw(graphics, string2, n7, n6 += this.BORDER_HEIGHT + this.myFont.getHeight() * 2, 20);
            this.myFont.draw(graphics, string, n7, n6, 20);
        }
    }

    public int getYForHighscore() {
        return super.getYForChild() + this.BORDER_HEIGHT + this.myFont.getHeight();
    }

    public int getHeightForHighscore() {
        return this.getHeightForChild() - (this.getYForHighscore() - this.getYForChild());
    }

    private void drawScore(Graphics graphics, int n, int n2, String string, String string2, boolean bl) {
        this.myFont.draw(graphics, Integer.toString(n + 1) + ".", this.getX() + this.BORDER_WIDTH, n2, 20);
        int n3 = this.getX() + this.BORDER_WIDTH + this.NAME_POSITION;
        if (bl) {
            this.myFont.draw(graphics, string + "*", n3, n2, 20);
        } else {
            this.myFont.draw(graphics, string, n3, n2, 20);
        }
        this.myFont.draw(graphics, string2, this.getX() + this.getWidth() - this.BORDER_WIDTH, n2, 24);
    }

    public void addNewScore(int n) {
        int n2;
        int n3;
        int n4 = -1;
        String string = Integer.toString(n);
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = Integer.parseInt(this.myScores[n3]);
            if (n <= n2) continue;
            n4 = n3;
            break;
        }
        if (n4 != -1) {
            for (n3 = 9; n3 > n4; --n3) {
                if (n3 <= 0) continue;
                this.myNames[n3] = this.myNames[n3 - 1];
                this.myScores[n3] = this.myScores[n3 - 1];
                this.myIsCheat[n3] = this.myIsCheat[n3 - 1];
            }
            n3 = Math.max(this.myScores[0].length(), string.length());
            this.myScores[n4] = this.padString(string, n3, '0');
            this.myIsCheat[n4] = BasicCanvas.getInstance().getHasRestarted();
            for (n2 = 0; n2 < 10; ++n2) {
                this.myScores[n2] = this.padString(this.myScores[n2], n3, '0');
            }
            this.startEditing(n4);
        }
        this.updatePositions();
    }

    private String padString(String string, int n, char c) {
        if (string.length() < n) {
            for (int i = 0; i < n - string.length(); ++i) {
                string = c + string;
            }
        }
        return string;
    }

    protected void handleKeyState(int n) {
        if (!this.isEditing()) {
            return;
        }
        if ((n & 6) != 0) {
            this.advanceCharacter(-1);
        } else if ((n & 0x60) != 0) {
            this.advanceCharacter(1);
        }
        if ((n & 0x100) != 0) {
            this.editNextCharacterInName();
        }
    }

    private void editNextCharacterInName() {
        if (this.editedCharacterIndex < 2) {
            ++this.editedCharacterIndex;
            this.myNames[this.editedLineIndex] = Highscores.insertAtPos(this.myNames[this.editedLineIndex], this.editedCharacterIndex, this.currentChar);
        } else {
            this.stopEditing();
        }
    }

    private void stopEditing() {
        Highscores.updateHighscores(this.myNames, this.myScores, this.myIsCheat);
        this.editedCharacterIndex = -1;
        this.editedLineIndex = -1;
    }

    private void startEditing(int n) {
        this.newScoreString = "New Highscore - " + this.myScores[n];
        this.myNames[n] = "AAA";
        this.editedLineIndex = n;
        this.editedCharacterIndex = 0;
        this.totalTime = 0L;
        this.isInvisible = false;
        this.currentChar = (char)65;
        this.myCurrentScroll = 0;
    }

    private boolean isEditing() {
        return this.editedLineIndex != -1;
    }

    private void advanceCharacter(int n) {
        boolean bl = false;
        if (this.currentChar == ' ') {
            bl = true;
        }
        this.currentChar = (char)(this.currentChar + n);
        if (bl) {
            this.currentChar = this.currentChar < ' ' ? (char)90 : (char)65;
        }
        if (this.currentChar < 'A') {
            this.currentChar = (char)32;
        } else if (this.currentChar > 'Z') {
            this.currentChar = (char)32;
        }
        this.myNames[this.editedLineIndex] = Highscores.insertAtPos(this.myNames[this.editedLineIndex], this.editedCharacterIndex, this.currentChar);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.isEditing()) {
            return;
        }
        if (command == this.cmdBack) {
            this.getCanvas().popScreen();
        }
    }

    private static String insertAtPos(String string, int n, char c) {
        char[] cArray = string.toCharArray();
        cArray[n] = c;
        return new String(cArray);
    }

    private static void updateHighscores(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < 10; ++i) {
            object = stringArray[i].getBytes();
            byteArrayOutputStream.write(((byte[])object).length);
            byteArrayOutputStream.write((byte[])object, 0, ((byte[])object).length);
            byte[] byArray = stringArray2[i].getBytes();
            byteArrayOutputStream.write(byArray.length);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[]{blArray[i] ? (byte)1 : 0};
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            object = RecordStore.openRecordStore((String)HIGHSCORE_RECORDSTORE_NAME, (boolean)true);
            int n = object.getNumRecords();
            if (object.getNumRecords() == 0) {
                object.addRecord(byArray, 0, byArray.length);
            } else {
                object.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println("Could not save high score");
        }
    }

    private static void getHighscores(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)HIGHSCORE_RECORDSTORE_NAME, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            for (int i = 0; i < 10; ++i) {
                int n = byteArrayInputStream.read();
                byte[] byArray2 = new byte[n];
                if (Highscores.readStream(byteArrayInputStream, byArray2, 0, n) != n) {
                    throw new Exception("Record corrupted");
                }
                stringArray[i] = new String(byArray2);
                int n2 = byteArrayInputStream.read();
                byte[] byArray3 = new byte[n2];
                if (Highscores.readStream(byteArrayInputStream, byArray3, 0, n2) != n2) {
                    throw new Exception("Record corrupted");
                }
                stringArray2[i] = new String(byArray3);
                byte[] byArray4 = new byte[1];
                if (Highscores.readStream(byteArrayInputStream, byArray4, 0, 1) != 1) {
                    throw new Exception("Record corrupted");
                }
                blArray[i] = byArray4[0] == 1;
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("RecordStore not found");
            System.out.println(recordStoreException.toString());
            Highscores.getDefaultScoreTable(stringArray, stringArray2, blArray);
        }
        catch (Exception exception) {
            System.out.println("RecordStore corrupted");
            System.out.println(exception.toString());
            Highscores.getDefaultScoreTable(stringArray, stringArray2, blArray);
        }
    }

    private static int readStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4;
        while ((n4 = inputStream.read(byArray, n + n3, n2 - n3)) != -1 && n3 < n2) {
            n3 += n4;
        }
        return n3;
    }

    private static void getDefaultScoreTable(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        stringArray[0] = "TH";
        stringArray[1] = "ZR";
        stringArray[2] = "ER";
        stringArray[3] = "AR";
        stringArray[4] = "EB";
        stringArray[5] = "NO";
        stringArray[6] = "OV";
        stringArray[7] = "HHH";
        stringArray[8] = "III";
        stringArray[9] = "JJJ";
        stringArray2[9] = "0010";
        stringArray2[8] = "0020";
        stringArray2[7] = "0030";
        stringArray2[6] = "0050";
        stringArray2[5] = "0060";
        stringArray2[4] = "0070";
        stringArray2[3] = "0080";
        stringArray2[2] = "0090";
        stringArray2[1] = "0100";
        stringArray2[0] = "0200";
        for (int i = 0; i < 10; ++i) {
            blArray[i] = false;
        }
    }
}

