/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.menus.IMenuItemListener;
import Snakedelia.tools.GraphicFont;
import javax.microedition.lcdui.Graphics;

public class MenuItem {
    private String myLabel;
    private int myLayout;
    private boolean isHovered = false;
    public static final int LAYOUT_LEFT = 0;
    public static final int LAYOUT_RIGHT = 1;
    public static final int LAYOUT_CENTER = 2;
    IMenuItemListener myListener;
    private boolean myIsSelectable;
    private GraphicFont myFont;
    protected GraphicFont myFontInverse;
    private boolean myUseFontInversing;
    private int myWidth;
    private int myHeight;

    public MenuItem(String string, int n, GraphicFont graphicFont, GraphicFont graphicFont2) {
        this(string, n, true, graphicFont, graphicFont2);
    }

    public MenuItem(String string, int n, boolean bl, GraphicFont graphicFont) {
        this(string, n, bl, graphicFont, null);
    }

    public MenuItem(String string, int n, boolean bl, GraphicFont graphicFont, GraphicFont graphicFont2) {
        if (n != 2 && n != 0 && n != 1) {
            throw new IllegalArgumentException("ilegal layout value!!!");
        }
        this.setLabel(string);
        this.setLayout(n);
        this.myIsSelectable = bl;
        this.myFont = graphicFont;
        this.myFontInverse = graphicFont2;
        this.myUseFontInversing = graphicFont2 != null;
    }

    public void setUseFontInversing(boolean bl) {
        this.myUseFontInversing = bl && this.myFontInverse != null;
    }

    private void setLabel(String string) {
        this.myLabel = string;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public void setLayout(int n) {
        this.myLayout = n;
    }

    public int getLayout() {
        return this.myLayout;
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        GraphicFont graphicFont = this.isSelectable() && this.myUseFontInversing && this.isHovered() ? this.myFontInverse : this.myFont;
        int n6 = graphics.getColor();
        int n7 = graphicFont.getHeight() / 2;
        int n8 = graphicFont.getHeight() / 4;
        int n9 = graphicFont.getHeight() / 8;
        if (this.isSelectable()) {
            n5 = n3 - (n7 + n9 * 2) * 2;
            n4 = (n3 - n5) / 2;
        } else {
            n5 = n3;
            n4 = 0;
        }
        int n10 = graphicFont.stringWidth(this.getDisplayedLabel(), 0, n5);
        int n11 = this.getHeight(n5);
        if (this.isHovered && this.myUseFontInversing) {
            graphics.setColor(-10496);
            graphics.fillRect(n + 0 + n3 / 40, n2 + 0, n3 - n3 / 20, n11);
        }
        switch (this.getLayout()) {
            case 2: {
                int n12 = 1;
                graphicFont.draw(graphics, this.getDisplayedLabel(), n + n4, n2, n5, 1000, n12, true);
                n += (n3 - n10) / 2;
                break;
            }
            case 0: {
                int n13 = 0;
                graphicFont.draw(graphics, this.getDisplayedLabel(), n += n4, n2, n5, 1000, n13, true);
                break;
            }
            case 1: {
                int n14 = 2;
                graphicFont.draw(graphics, this.getDisplayedLabel(), n + n4, n2, n5, 1000, n14, true);
                n = n + n3 - n10 - n4;
            }
        }
        if (this.isHovered && !this.myUseFontInversing) {
            graphics.setColor(-10496);
            graphics.fillRect(n - n7 - n9 + 0, n2 + (n11 - n8) / 2 + 0, n7, n8);
            graphics.fillRect(n + n10 + n9 + 0, n2 + (n11 - n8) / 2 + 0, n7, n8);
        }
        graphics.setColor(n6);
    }

    public void onHover() {
        this.isHovered = true;
    }

    public void onHoverEnded() {
        this.isHovered = false;
    }

    protected String getDisplayedLabel() {
        return this.getLabel();
    }

    public void handleClick(int n) {
        if (((n & 0x100) != 0 || (n & 4) != 0 || (n & 0x20) != 0) && this.myListener != null) {
            this.myListener.handleStateChange(this);
        }
    }

    public int getHeight(int n) {
        return this.myFont.stringHeight(this.getDisplayedLabel(), 0, n);
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void setButtonListener(IMenuItemListener iMenuItemListener) {
        this.myListener = iMenuItemListener;
    }

    public boolean isSelectable() {
        return this.myIsSelectable;
    }
}

