/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.AbstractCanvas;
import Snakedelia.menus.BasicScreen;
import Snakedelia.tools.GraphicFont;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class TitlesScreen
extends BasicScreen
implements CommandListener {
    private static final int fillColor = 0;
    private static final int ADVANCEMENT_RATE = 20;
    final int LINES_GAP;
    final int LINE_HEIGHT;
    final int TITLES_BORDER;
    String[] myStrings;
    int myCurrentIndex;
    int myImageY;
    long advReminder;
    Command cmdBack;
    int myTextHeight;
    boolean myAutoScroll;
    final int myScreenSize;
    int[] myCursorPoints;
    int myCurrentPage;
    final int myNumberOfPages;

    public TitlesScreen(int n, int n2, int n3, int n4, String[] stringArray, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont, boolean bl2) {
        super(n, n2, n3, n4, bl, abstractCanvas, graphicFont);
        int n5;
        this.LINES_GAP = this.myFont.getHeight() / 4;
        this.LINE_HEIGHT = this.myFont.getHeight();
        this.TITLES_BORDER = this.LINE_HEIGHT + this.LINES_GAP;
        this.cmdBack = new Command("Back", 2, 1);
        this.myStrings = stringArray;
        this.myAutoScroll = bl2;
        this.setLeftCommand(this.cmdBack);
        this.initRuntime();
        this.setCommandListener(this);
        this.setFillColor(0);
        this.setShouldFillScreen(true);
        int n6 = this.getHeight() - (this.TITLES_BORDER << 1);
        this.myScreenSize = n6 - n6 % this.myFont.getHeight();
        if (!bl2) {
            int n7 = n5 = this.TITLES_BORDER * 2 / 5;
            int n8 = this.getWidth() / 2;
            int n9 = (this.TITLES_BORDER - n5) / 2;
            this.myCursorPoints = new int[]{n8, n9, n8 - n7 / 2, n9 + n5, n8 + n7 / 2, n9 + n5};
        }
        this.myTextHeight = 0;
        for (n5 = 0; n5 < this.myStrings.length; ++n5) {
            this.myTextHeight += this.myFont.stringHeight(this.myStrings[n5], 0, this.getWidth());
        }
        this.myNumberOfPages = this.myTextHeight / this.myScreenSize + (this.myTextHeight % this.myScreenSize != 0 ? 1 : 0);
        this.myCurrentPage = 1;
    }

    public final boolean isEmpty() {
        return this.myStrings == null || this.myStrings.length == 0 || this.myStrings.length == 1 && this.myStrings[0].length() == 0;
    }

    public void initRuntime() {
        this.myImageY = this.myAutoScroll ? this.getHeight() / 3 : this.TITLES_BORDER;
        this.myCurrentIndex = 0;
        this.advReminder = 0L;
    }

    public void doLogic(long l) {
        if (this.myAutoScroll) {
            if (l > 100L) {
                l = 100L;
            }
            long l2 = l * 20L + this.advReminder;
            this.advReminder = l2 % 1000L;
            this.scrollText(l2 / 1000L);
        }
    }

    protected void handleKeyState(int n) {
        if (!this.myAutoScroll) {
            if ((n & 0x140) != 0) {
                this.scrollText(this.myScreenSize);
            } else if ((n & 2) != 0) {
                this.scrollText(-this.myScreenSize);
            }
        }
    }

    private void scrollText(long l) {
        this.myImageY = (int)((long)this.myImageY - l);
        if (-this.myImageY + this.TITLES_BORDER >= this.myTextHeight) {
            this.myImageY = this.myAutoScroll ? this.getHeight() - this.TITLES_BORDER : (int)((long)this.myImageY + l);
        } else if (this.myImageY > this.TITLES_BORDER && !this.myAutoScroll) {
            this.myImageY = (int)((long)this.myImageY + l);
        }
        this.myCurrentPage = (this.TITLES_BORDER - this.myImageY) / this.myScreenSize + 1;
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        super.paint(graphics);
        if (!this.myAutoScroll) {
            if (this.myImageY < this.TITLES_BORDER) {
                graphics.setColor(-10496);
                graphics.fillTriangle(this.myCursorPoints[0] + 0, this.myCursorPoints[1] + 0, this.myCursorPoints[2] + 0, this.myCursorPoints[3] + 0, this.myCursorPoints[4] + 0, this.myCursorPoints[5] + 0);
            }
            if (-this.myImageY + this.TITLES_BORDER + this.myScreenSize <= this.myTextHeight) {
                graphics.setColor(-10496);
                graphics.fillTriangle(this.myCursorPoints[0] + 0, this.getHeight() - this.myCursorPoints[1] + 0, this.myCursorPoints[2] + 0, this.getHeight() - this.myCursorPoints[3] + 0, this.myCursorPoints[4] + 0, this.getHeight() - this.myCursorPoints[5] + 0);
            }
            this.myFont.draw(graphics, this.myCurrentPage + "/" + this.myNumberOfPages, 0, 0, this.getWidth(), this.getHeight(), 2, true);
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        int n5 = this.getHeight() - (this.TITLES_BORDER << 1);
        n5 -= n5 % this.myFont.getHeight();
        graphics.setClip(this.getX() + 0, this.getY() + this.TITLES_BORDER + 0, this.getWidth(), n5);
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0xFFFFFF);
        int n6 = 0;
        boolean bl = false;
        for (int i = 0; i < this.myStrings.length; ++i) {
            String string = this.myStrings[i];
            this.myFont.draw(graphics, string, 0, this.myImageY + n6, this.getWidth(), this.getHeight(), 1, true);
            n6 += this.LINE_HEIGHT;
        }
        graphics.setClip(n, n2, n3, n4);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.getCanvas().popScreen();
        }
    }
}

