/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tasks.TimerTaskDescription;
import Snakedelia.tools.BasicSprite;
import Snakedelia.tools.Defines;
import Snakedelia.tools.PhysicalSprite;

public final class Actions {
    private Actions() {
    }

    public static void setRoomSizeAction(int n, int n2) {
        BasicCanvas.getInstance().setCurrentRoomLogicalWidth(n * Defines.PRECISION);
        BasicCanvas.getInstance().setCurrentRoomLogicalHeight(n2 * Defines.PRECISION);
    }

    public static void setScoreAction(int n) {
        BasicCanvas.setScore(n);
    }

    public static void setLivesAction(int n) {
        BasicCanvas.setLives(n);
    }

    public static void addTimedTask(int n, int n2, int n3, int n4) {
        BasicCanvas.getInstance().addTimedTask(new TimerTaskDescription(n, n2, n3, n4));
    }

    public static void setLevelAction(int n) {
        BasicCanvas basicCanvas = null;
        basicCanvas = BasicCanvas.getInstance();
        int n2 = basicCanvas.getCurrentLevel();
        basicCanvas.setCurrentLevel(n);
        basicCanvas.levelChanged(n, n2);
    }

    public static void setWorldPositionX(GameManager gameManager, int n) {
        gameManager.setWorldPositionX(n);
    }

    public static void setWorldPositionY(GameManager gameManager, int n) {
        gameManager.setWorldPositionY(n);
    }

    public static void setRelativeSprite(GameManager gameManager, BasicSprite basicSprite, boolean bl, int n, int n2, int n3, int n4) {
        gameManager.trackedInstancePositionX = n;
        gameManager.trackedInstancePositionY = n2;
        gameManager.trackedInstancePositionWidth = n3;
        gameManager.trackedInstancePositionHeight = n4;
        gameManager.setRelativeSprite(basicSprite, bl);
    }

    public static void setAccelerationX(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setAccelerationX(n);
    }

    public static void setAccelerationY(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setAccelerationY(n);
    }

    public static void setBackgroundColor(int n) {
        BasicCanvas.getInstance().setCurrentBackgroundColor(n);
    }

    public static void setVisibility(BasicSprite basicSprite, boolean bl) {
        basicSprite.myPhysicalSprite.setVisibility(bl);
    }

    public static void setPositionZ(GameManager gameManager, BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setLogicalZ(n);
        gameManager.replaceSpriteInSortedList(basicSprite);
    }

    public static void setPositionY(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setPositionPrecise(basicSprite.myPhysicalSprite.getLogicalX(), n);
    }

    public static void setPositionX(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setPositionPrecise(n, basicSprite.myPhysicalSprite.getLogicalY());
    }

    public static void increaseSpeed(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.increaseSpeed(n);
    }

    public static void move(BasicSprite basicSprite, int n, int n2) {
        basicSprite.myPhysicalSprite.movePrecise(n, n2);
    }

    public static void setPosition(BasicSprite basicSprite, int n, int n2) {
        basicSprite.myPhysicalSprite.setPositionPrecise(n, n2);
    }

    public static void transformSprite(BasicSprite basicSprite, int n, boolean bl) {
        if (bl) {
            boolean bl2 = n == 2 || n == 7 || n == 1 || n == 4;
            if (bl2) {
                n = PhysicalSprite.mirror(n);
            }
            int n2 = n == 0 || n == 2 ? 0 : (n == 5 || n == 7 ? 1 : (n == 3 || n == 1 ? 2 : 3));
            for (int i = 0; i < n2; ++i) {
                n = PhysicalSprite.rotateClockwise(n);
            }
        }
        basicSprite.myPhysicalSprite.setTransform(n);
    }

    public static void setVelocityY(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setVelocityY(n);
    }

    public static void setVelocityX(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.setVelocityX(n);
    }

    public static void setBackgroundVelocityX(GameManager gameManager, int n) {
        if (gameManager.getBackground() != null) {
            gameManager.getBackground().setVelocityX(n);
        }
    }

    public static void setBackgroundVelocityY(GameManager gameManager, int n) {
        if (gameManager.getBackground() != null) {
            gameManager.getBackground().setVelocityY(n);
        }
    }

    public static void setWorldVelocityX(GameManager gameManager, int n) {
        gameManager.setWorldVelocityX(n);
    }

    public static void setWorldVelocityY(GameManager gameManager, int n) {
        gameManager.setWorldVelocityY(n);
    }

    public static void setKeysEnabled(boolean bl) {
        Defines.keysEnabled = bl;
    }

    public static void enableSpriteDrawing(GameManager gameManager, int n) {
        throw new RuntimeException("Unsupported");
    }

    public static void disableSpriteDrawing(GameManager gameManager, int n) {
        throw new RuntimeException("Unsupported");
    }

    public static void destroySpriteDrawing(GameManager gameManager, int n, boolean bl) {
        BasicCanvas basicCanvas = BasicCanvas.getInstance();
        gameManager.addToRemoveQueue(n);
        if (bl) {
            gameManager.addToDestroyedEventQueue(n);
        }
    }

    public static void setAnimationSequenceRunOnce(BasicSprite basicSprite, int n, boolean bl) {
        basicSprite.myPhysicalSprite.getAnimationManager().setFrameSequenceRunOnce(n, bl);
    }

    public static void setAnimationSequence(BasicSprite basicSprite, int n) {
        basicSprite.myPhysicalSprite.getAnimationManager().setFrameSequence(n);
    }

    public static void showAbout() {
        BasicCanvas.getInstance().showAbout();
    }

    public static void enterHighScore(int n) {
        if (Defines.showHighScores) {
            BasicCanvas.getInstance().enterHighScore(n);
        }
    }
}

