/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.tools.BasicSprite;
import Snakedelia.tools.MovableSprite;
import java.util.Stack;

public final class AnimationManager {
    private MovableSprite mySprite;
    private BasicSprite myFather;
    private boolean myIsAnimatable;
    private long myAnimationTimeElapsed;
    private int myCurrentFrameSequence;
    private int[][] myFrameSequences;
    private int[] myAnimationRates;
    private boolean myRunningOnce = false;
    private boolean myInterruptable = true;
    private Stack myPreviousSequenceStack;

    public AnimationManager(int[][] nArray, int[] nArray2, BasicSprite basicSprite, MovableSprite movableSprite) {
        this.myFather = basicSprite;
        this.mySprite = movableSprite;
        this.myFrameSequences = nArray;
        this.myAnimationRates = nArray2;
        this.myCurrentFrameSequence = 0;
        this.mySprite.setFrameSequence(nArray[1]);
    }

    public void animate(long l) {
        this.myAnimationTimeElapsed += l;
        int n = this.myAnimationRates[this.myCurrentFrameSequence];
        if ((long)n <= this.myAnimationTimeElapsed) {
            int n2;
            int n3 = (int)this.myAnimationTimeElapsed / n;
            this.myAnimationTimeElapsed = 0L;
            if (this.myRunningOnce && this.myPreviousSequenceStack != null && this.mySprite.getFrame() + n3 >= this.myFrameSequences[this.myCurrentFrameSequence + 1].length) {
                this.myInterruptable = true;
                n2 = this.getFrameSequence();
                this.setFrameSequenceInternal((Integer)this.myPreviousSequenceStack.pop());
                if (this.myPreviousSequenceStack.size() == 0) {
                    this.myRunningOnce = false;
                }
                n3 = 0;
                this.mySprite.setFrame(0);
                BasicCanvas.spriteAnimationEnded(n2, this.myFather);
            }
            n2 = (this.mySprite.getFrame() + n3) % this.mySprite.getFrameSequenceLength();
            this.mySprite.setFrame(n2);
        }
    }

    public void setFrameSequence(int n) {
        int n2 = -1;
        for (int i = 0; i < this.myFrameSequences[0].length; ++i) {
            if (n != this.myFrameSequences[0][i]) continue;
            n2 = i;
            break;
        }
        this.setFrameSequenceInternal(n2);
    }

    private void setFrameSequenceInternal(int n) {
        if (!this.myInterruptable) {
            return;
        }
        BasicCanvas.spriteAnimationStarted(this.myFrameSequences[0][n], this.myFather);
        this.myAnimationTimeElapsed = 0L;
        this.myRunningOnce = false;
        if (this.myPreviousSequenceStack != null) {
            this.myPreviousSequenceStack.removeAllElements();
        }
        this.mySprite.setFrameSequence(this.myFrameSequences[n + 1]);
        this.myCurrentFrameSequence = n;
    }

    public void setFrameSequenceRunOnce(int n, boolean bl) {
        int n2 = -1;
        for (int i = 0; i < this.myFrameSequences[0].length; ++i) {
            if (n != this.myFrameSequences[0][i]) continue;
            n2 = i;
            break;
        }
        this.setFrameSequenceRunOnceInternal(n2, bl);
    }

    private void setFrameSequenceRunOnceInternal(int n, boolean bl) {
        if (!this.myInterruptable) {
            return;
        }
        if (this.myPreviousSequenceStack == null) {
            this.myPreviousSequenceStack = new Stack();
        }
        BasicCanvas.getInstance();
        BasicCanvas.spriteAnimationStarted(this.myFrameSequences[0][n], this.myFather);
        int n2 = this.myCurrentFrameSequence;
        if (this.myRunningOnce) {
            n2 = (Integer)this.myPreviousSequenceStack.elementAt(0);
        }
        this.setFrameSequenceInternal(n);
        this.mySprite.setFrame(0);
        this.myPreviousSequenceStack.push(new Integer(n2));
        this.myRunningOnce = true;
        this.myInterruptable = bl;
        this.myCurrentFrameSequence = n;
    }

    public int getFrameSequence() {
        return this.myFrameSequences[0][this.myCurrentFrameSequence];
    }
}

