/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.IntHashtableEntry;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IntHashtable {
    private IntHashtableEntry[] table;
    private int count;
    private int threshold;
    private int loadFactor;

    public IntHashtable(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = n2;
        this.table = new IntHashtableEntry[n];
        this.threshold = n * n2 / 100;
    }

    public IntHashtable(int n) {
        this(n, 75);
    }

    public IntHashtable() {
        this(101, 75);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public IntHashtableEnumerator keys() {
        return new IntHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new IntHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n = intHashtableEntryArray.length;
        while (n-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.value.equals(object)) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return false;
    }

    public Object get(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return intHashtableEntry.value;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n2];
        this.threshold = n2 * this.loadFactor / 100;
        this.table = intHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.next;
                int n4 = (intHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                intHashtableEntry2.next = intHashtableEntryArray2[n4];
                intHashtableEntryArray2[n4] = intHashtableEntry2;
            }
        }
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                Object object2 = intHashtableEntry.value;
                intHashtableEntry.value = object;
                return object2;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.hash = n2;
        intHashtableEntry.key = n;
        intHashtableEntry.value = object;
        intHashtableEntry.next = intHashtableEntryArray[n3];
        intHashtableEntryArray[n3] = intHashtableEntry;
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.next = intHashtableEntry.next;
                } else {
                    intHashtableEntryArray[n3] = intHashtableEntry.next;
                }
                --this.count;
                return intHashtableEntry.value;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n = intHashtableEntryArray.length;
        while (--n >= 0) {
            intHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        IntHashtableEnumerator intHashtableEnumerator = this.keys();
        Enumeration enumeration = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = intHashtableEnumerator.nextElement().toString();
            String string2 = enumeration.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public class IntHashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        IntHashtableEntry[] table;
        IntHashtableEntry entry;

        IntHashtableEnumerator(IntHashtableEntry[] intHashtableEntryArray, boolean bl) {
            this.table = intHashtableEntryArray;
            this.keys = bl;
            this.index = intHashtableEntryArray.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntHashtableEntry intHashtableEntry = this.entry;
                this.entry = intHashtableEntry.next;
                return this.keys ? new Integer(intHashtableEntry.key) : intHashtableEntry.value;
            }
            throw new NoSuchElementException("IntHashtableEnumerator");
        }

        public int nextElementInt() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntHashtableEntry intHashtableEntry = this.entry;
                this.entry = intHashtableEntry.next;
                return intHashtableEntry.key;
            }
            throw new NoSuchElementException("IntHashtableEnumerator");
        }
    }
}

