/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

public final class IntVector {
    public int[] Array;
    public int Size;
    public int ItemCount;
    private int myCapacity;
    public static final int DEFAULT_CAPACITY = 512;

    public IntVector() {
        this(512);
    }

    public IntVector(int[] nArray) {
        this.Array = nArray.length > 1024 ? new int[nArray.length] : new int[512];
        System.arraycopy(nArray, 0, this.Array, 0, nArray.length);
        this.ItemCount = this.Size = nArray.length;
        this.myCapacity = 512;
    }

    public IntVector(int n) {
        this.Array = new int[n];
        this.Size = 0;
        this.ItemCount = 0;
        this.myCapacity = n;
    }

    public final boolean contains(int n) {
        for (int i = 0; i < this.Size; ++i) {
            if (this.Array[i] != n) continue;
            return true;
        }
        return false;
    }

    public final int addElement(int n) {
        int n2 = this.Array.length;
        if (this.Size >= n2) {
            int[] nArray = new int[n2 * 3 / 2];
            System.arraycopy(this.Array, 0, nArray, 0, n2);
            this.Array = nArray;
        }
        this.Array[this.Size] = n;
        ++this.ItemCount;
        return ++this.Size;
    }

    public final void removeElement(int n) {
        for (int i = 0; i < this.Size; ++i) {
            if (this.Array[i] != n) continue;
            --this.ItemCount;
            this.Array[i] = -1;
            while (this.Size > 0 && i == this.Size - 1 && this.Array[i] == -1) {
                --this.Size;
                --i;
            }
            return;
        }
    }

    public final void removeElementAt(int n) {
        this.Array[n] = -1;
        --this.ItemCount;
        while (this.Size > 0 && n == this.Size - 1 && this.Array[n] == -1) {
            --this.Size;
            --n;
        }
    }

    public final void removeAllElements() {
        this.Size = 0;
        this.ItemCount = 0;
        if (this.Array.length > this.myCapacity) {
            this.Array = new int[this.myCapacity];
        }
    }

    public final void compactArray() {
        if (this.Size < this.Array.length * 9 / 10 || this.ItemCount < this.Size / 2) {
            int n = 0;
            for (int i = 0; i < this.Size; ++i) {
                if (this.Array[i] == -1) {
                    ++n;
                    continue;
                }
                if (n == 0) continue;
                this.Array[i - n] = this.Array[i];
                this.Array[i] = -1;
            }
            this.Size -= n;
        }
    }

    public final void shrinkCapacity() {
        int n = this.Array.length;
        if (this.Size > this.myCapacity && this.Size < this.Array.length / 2) {
            int[] nArray = new int[this.Size * 3 / 2];
            System.arraycopy(this.Array, 0, nArray, 0, this.Size);
            this.Array = nArray;
        }
    }
}

