/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.IntHashtable;
import Snakedelia.tools.IntVector;
import java.util.Stack;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class SpriteDescriptor {
    static int removeUnreferencedCounter = 0;
    public static final IntHashtable imagesHash = new IntHashtable();
    private short[] mData;
    private short[] myBoundingBoxes;
    public static final int CONST_IMAGE_LOCATION_OFFSET = 0;
    public static final int CONST_FRAME_WIDTH_OFFSET = 1;
    public static final int CONST_FRAME_HEIGHT_OFFSET = 2;
    public static final int CONST_REFERNCE_PIXEL_X_OFFSET = 3;
    public static final int CONST_REFERNCE_PIXEL_Y_OFFSET = 4;
    public static final int CONST_LOGICAL_UNPRECISED_WIDTH_OFFSET = 5;
    public static final int CONST_LOGICAL_UNPRECISED_HEIGHT_OFFSET = 6;
    public static final int CONST_RELATIVE_POSITION_X_OFFSET = 7;
    public static final int CONST_RELATIVE_POSITION_Y_OFFSET = 8;

    public SpriteDescriptor(short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        this.init(s, s2, s3, s4, s5, s6, s7);
    }

    public SpriteDescriptor(short[] sArray) {
        if (sArray.length != 9) {
            throw new RuntimeException("Invalid sprite params size");
        }
        this.mData = sArray;
    }

    public SpriteDescriptor(short[] sArray, short[] sArray2) {
        if (sArray.length != 9) {
            throw new RuntimeException("Invalid sprite params size");
        }
        this.mData = sArray;
        this.myBoundingBoxes = sArray2;
    }

    private void init(short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        this.mData = new short[9];
        this.mData[0] = s;
        this.mData[1] = -1;
        this.mData[2] = -1;
        this.mData[3] = s2;
        this.mData[4] = s3;
        this.mData[5] = s4;
        this.mData[6] = s5;
        this.mData[7] = s6;
        this.mData[8] = s7;
    }

    public SpriteDescriptor(short s, short s2, short s3, short s4, short s5, short s6, short s7, short[] sArray, short s8, short s9) {
        this.init(s, s2, s3, s4, s5, s6, s7, sArray, s8, s9);
    }

    private void init(short s, short s2, short s3, short s4, short s5, short s6, short s7, short[] sArray, short s8, short s9) {
        this.mData = new short[9];
        this.mData[0] = s;
        this.mData[1] = s2;
        this.mData[2] = s3;
        this.mData[3] = s4;
        this.mData[4] = s5;
        this.mData[5] = s6;
        this.mData[6] = s7;
        this.mData[7] = s8;
        this.mData[8] = s9;
        this.myBoundingBoxes = sArray;
    }

    public static final Sprite loadSprite(short[] sArray) {
        int n;
        int n2;
        ImageDescriptor imageDescriptor = (ImageDescriptor)imagesHash.get(sArray[0]);
        if (imageDescriptor != null && imageDescriptor.UnusedSpritePool.size() > 0) {
            return (Sprite)imageDescriptor.UnusedSpritePool.pop();
        }
        Image image = SpriteDescriptor.loadImage(sArray[0]);
        if (sArray[1] == -1) {
            n2 = image.getWidth();
            n = image.getHeight();
        } else {
            n2 = sArray[1];
            n = sArray[2];
        }
        return new Sprite(image, n2, n);
    }

    public static final void addSpriteToPool(short[] sArray, Sprite sprite) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)imagesHash.get(sArray[0]);
        if (imageDescriptor == null) {
            return;
        }
        sprite.setTransform(0);
        sprite.setVisible(true);
        imageDescriptor.UnusedSpritePool.push(sprite);
    }

    private static final String getImageLocation(int n) {
        switch (n) {
            case 0: {
                return "/images/life.png";
            }
            case 1: {
                return "/images/life_star.png";
            }
            case 2: {
                return "/images/orange.png";
            }
            case 3: {
                return "/images/flower.png";
            }
            case 4: {
                return "/images/head.png";
            }
            case 5: {
                return "/images/head_side.png";
            }
            case 6: {
                return "/images/head_hit.png";
            }
            case 7: {
                return "/images/boom.png";
            }
            case 8: {
                return "/images/head2.png";
            }
            case 9: {
                return "/images/n_level.png";
            }
            case 10: {
                return "/images/MoMinisLogo.png";
            }
            case 11: {
                return "/images/-1226900487.png";
            }
            case 12: {
                return "/images/ap.png";
            }
            case 13: {
                return "/images/-1819927376.png";
            }
            case 14: {
                return "/images/sa.png";
            }
            case 15: {
                return "/images/sa_side.png";
            }
            case 16: {
                return "/images/sq.png";
            }
            case 17: {
                return "/images/sq_side.png";
            }
            case 18: {
                return "/images/pe.png";
            }
            case 19: {
                return "/images/monster.png";
            }
            case 20: {
                return "/images/game_complete.png";
            }
        }
        throw new RuntimeException("Invalid image id exception");
    }

    public static final Image loadImage(short s) {
        SpriteDescriptor.preLoadImage(s, true, true);
        ImageDescriptor imageDescriptor = (ImageDescriptor)imagesHash.get(s);
        if (imageDescriptor == null || imageDescriptor.Image == null) {
            throw new RuntimeException("Error: Failed loading image, insufficient device resources");
        }
        return imageDescriptor.Image;
    }

    public static final void increaseImageRefCount(int n) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)imagesHash.get(n);
        if (imageDescriptor == null) {
            return;
        }
        ++imageDescriptor.ReferenceCount;
    }

    public static final void decreaseImageRefCount(int n) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)imagesHash.get(n);
        if (imageDescriptor == null) {
            return;
        }
        --imageDescriptor.ReferenceCount;
    }

    public static final void removeUnreferencedImages() {
        ++removeUnreferencedCounter;
        IntVector intVector = new IntVector();
        IntHashtable.IntHashtableEnumerator intHashtableEnumerator = imagesHash.keys();
        while (intHashtableEnumerator.hasMoreElements()) {
            int n = intHashtableEnumerator.nextElementInt();
            if (((ImageDescriptor)SpriteDescriptor.imagesHash.get((int)n)).ReferenceCount >= 1) continue;
            intVector.addElement(n);
        }
        for (int i = 0; i < intVector.Size; ++i) {
            imagesHash.remove(intVector.Array[i]);
        }
    }

    public static final void preLoadImages(short[] sArray, boolean bl, boolean bl2) {
        for (int i = 0; i < sArray.length; ++i) {
            SpriteDescriptor.preLoadImage(sArray[i], bl, bl2);
        }
    }

    public static final void preLoadImage(short s, boolean bl, boolean bl2) {
        if (!imagesHash.containsKey(s)) {
            String string = SpriteDescriptor.getImageLocation(s);
            Image image = null;
            try {
                image = Image.createImage((String)string);
            }
            catch (Error error) {
                if (bl) {
                    SpriteDescriptor.removeUnreferencedImages();
                    SpriteDescriptor.preLoadImage(s, false, bl2);
                    return;
                }
                System.out.println("Error: Could not load image " + string);
                error.printStackTrace();
                int n = 0;
                IntHashtable.IntHashtableEnumerator intHashtableEnumerator = imagesHash.keys();
                while (intHashtableEnumerator.hasMoreElements()) {
                    int n2 = intHashtableEnumerator.nextElementInt();
                    Image image2 = ((ImageDescriptor)SpriteDescriptor.imagesHash.get((int)n2)).Image;
                    n += image2.getWidth() * image2.getHeight();
                }
                throw new Error(error.toString() + " totalMemory - " + Runtime.getRuntime().totalMemory() + " freeMemory - " + Runtime.getRuntime().freeMemory() + " Num images - " + imagesHash.size() + " Total image size - " + n + " Num Unreferenced Clear - " + removeUnreferencedCounter + " Location - " + string);
            }
            catch (Exception exception) {
                if (bl) {
                    SpriteDescriptor.removeUnreferencedImages();
                    SpriteDescriptor.preLoadImage(s, false, bl2);
                    return;
                }
                System.out.println("Error: Could not load image " + string);
                exception.printStackTrace();
                throw new RuntimeException(exception.toString());
            }
            if (bl2) {
                imagesHash.put(s, new ImageDescriptor(image, 1));
            } else {
                imagesHash.put(s, new ImageDescriptor(image, 0));
            }
        } else if (bl2) {
            SpriteDescriptor.increaseImageRefCount(s);
        }
    }

    private static final class ImageDescriptor {
        public Image Image;
        public Stack UnusedSpritePool;
        public int ReferenceCount;

        public ImageDescriptor(Image image, int n) {
            this.Image = image;
            this.ReferenceCount = n;
            this.UnusedSpritePool = new Stack();
        }
    }
}

