/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.Defines;
import Snakedelia.tools.Variables;

public final class SuperMath {
    private static final short[] sinTable = Variables.__arraydataShort[88];
    private static final int PI_TIMES_10000 = 31415;

    public static final long lsqrt(long l) {
        long l2 = 1L;
        long l3 = SuperMath.lsqrtNext(l2, l);
        while (Math.abs(l3 - l2) > 1L) {
            l2 = l3;
            l3 = SuperMath.lsqrtNext(l2, l);
        }
        while (l3 * l3 > l) {
            --l3;
        }
        return l3;
    }

    private static final long lsqrtNext(long l, long l2) {
        return l + l2 / l >> 1;
    }

    public static final long precisedPower(long l, long l2) {
        if (l2 == 0L) {
            return Defines.PRECISION;
        }
        long l3 = l;
        int n = 0;
        while ((long)n < l2 - 1L) {
            l3 = Defines.unPrecise(l3 * l);
            ++n;
        }
        return l3;
    }

    public static final int sinTimesThousand(int n) {
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        return sinTable[n];
    }

    public static final int cosTimesThousand(int n) {
        n += 90;
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        return sinTable[n];
    }

    public static final int tanTimesThousand(int n) {
        return SuperMath.sinTimesThousand(n) * 1000 / SuperMath.cosTimesThousand(n);
    }

    public static final int cotTimesHundred(int n) {
        return SuperMath.cosTimesThousand(n) * 1000 / SuperMath.sinTimesThousand(n);
    }

    public static final int getVectorX(int n, int n2) {
        int n3 = Defines.unPrecise(n2);
        if ((n3 %= 360) < 0) {
            n3 += 360;
        }
        long l = SuperMath.cosTimesThousand(n3);
        int n4 = (int)(l * (long)n / 1000L);
        return n4;
    }

    public static final int getVectorY(int n, int n2) {
        int n3 = Defines.unPrecise(n2);
        if ((n3 %= 360) < 0) {
            n3 += 360;
        }
        long l = SuperMath.sinTimesThousand(n3);
        int n4 = (int)(l * (long)n / 1000L);
        return n4;
    }

    public static final int rotateAndGetX(int n, int n2, int n3) {
        long l = (long)n * (long)SuperMath.cosTimesThousand(n3) - (long)(n2 * SuperMath.sinTimesThousand(n3));
        if (l % 1000L >= 500L) {
            return (int)(l / 1000L + 1L);
        }
        return (int)(l / 1000L);
    }

    public static final int rotateAndGetY(int n, int n2, int n3) {
        long l = (long)n * (long)SuperMath.sinTimesThousand(n3) + (long)(n2 * SuperMath.cosTimesThousand(n3));
        if (l % 1000L >= 500L) {
            return (int)(l / 1000L + 1L);
        }
        return (int)(l / 1000L);
    }
}

