/*
 * Decompiled with CFR 0.152.
 */
package SonicGolf;

import Coral.crlCanvas;
import SonicGolf.cCanvas;
import SonicGolf.cCourse;
import SonicGolf.cFP;
import SonicGolf.cObjects;
import SonicGolf.cSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class cBall {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final byte BASE_SHOT_POWER = 30;
    public static final byte SONIC_MIN_POWER = 18;
    public static final byte SONIC_POWER = 18;
    public static final byte SONIC_CONTROL = 13;
    public static final byte SONIC_SPIN = 6;
    public static final byte TAILS_MIN_POWER = 13;
    public static final byte TAILS_POWER = 13;
    public static final byte TAILS_CONTROL = 15;
    public static final byte TAILS_SPIN = 5;
    public static final byte KNUCKLES_MIN_POWER = 22;
    public static final byte KNUCKLES_POWER = 22;
    public static final byte KNUCKLES_CONTROL = 11;
    public static final byte KNUCKLES_SPIN = 4;
    private static final byte CROSSHAIR_OFFSET = -8;
    public static final byte COLL_RADIUS = 1;
    public static final byte DRAW_RADIUS = 2;
    public static final byte MAX_SPIN_INCS = 10;
    public static final byte SPIN_REDUCER = 2;
    public static final int INIT_ANGLE_FP = cFP.toFP(50);
    public static final int MIN_ANGLE_FP = cFP.toFP(20);
    public static final int MAX_ANGLE_FP = cFP.toFP(85);
    public static final int BOUNCE_FP = cFP.toFP("0.5");
    public static final int ROLL_FP = cFP.toFP("0.9");
    private static final int GRAVITY_FP = cFP.toFP(10);
    private static final int VISCOSITY_FP = cFP.toFP(5);
    private static final int SLOPE_ROLL_INC_FP = cFP.toFP(15);
    private static final int SLOPE_BOUNCE_FP = cFP.toFP("0.5");
    private static final int BALL_STOP_FP = cFP.toFP("0.1");
    private static final int BALL_PUTT_FP = cFP.toFP(70);
    private static final byte BALL_TRACE_LENGTH = 12;
    private static final int WIND_FACTOR_FP = cFP.toFP("0.06");
    public static final byte NO_ROLL = 0;
    public static final byte SLOW_ROLL = 1;
    public static final byte FAST_ROLL = 2;
    private static final byte COLL_UP = 0;
    private static final byte COLL_DOWN = 1;
    private static final byte COLL_LEFT = 2;
    private static final byte COLL_RIGHT = 3;
    private static final byte COLL_TOP_RIGHT = 5;
    private static final byte COLL_TOP_LEFT = 6;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private static cCanvas _mCanvas;
    public static byte mShotDirection;
    public static int mFPX;
    public static int mFPY;
    public static int mFPDX;
    public static int mFPDY;
    public static int mFPAngle;
    public static int mAppliedSpin;
    public static int mNaturalSpin;
    public static byte mRoll;
    private static int _mRow;
    private static int _mCol;
    private static int _mCrossHairFPX;
    private static int _mCrossHairFPY;
    private static int _mCrossHairX;
    private static int _mCrossHairY;
    private static byte _mStopTimer;
    public static int mNextFPX;
    public static int mNextFPY;
    public static int mDropFPX;
    public static int mDropFPY;
    public static boolean mPutting;
    private static int[] _mTraceX;
    private static int[] _mTraceY;
    private static int _mTracePrevX;
    private static int _mTracePrevY;
    private static int _mTraceCnt;
    public static boolean mTraceDebug;
    public static int mFPSpeedCoeff;
    public static boolean mHoled;
    public static boolean mStopped;
    public static boolean mLost;
    public static boolean mDrowned;
    public static boolean mExploded;
    public static boolean mCollided;
    private static boolean _mBunkered;
    public static boolean mFairwayHit;
    private static byte M;
    private static byte N;
    private static byte S;
    private static byte E;
    private static byte W;
    private static byte NE;
    private static byte NW;
    private static byte SE;
    private static byte SW;
    public static boolean mApplyWind;
    public static int mWind;
    public static int mFPWind;
    public static int mReplayFPX;
    public static int mReplayFPY;
    public static int mReplayFPAngle;
    public static boolean mNotMarkerDrop;
    public static boolean mCheckFishSpikeDrop;
    public static byte mReplayPower;
    public static int mReplaySpin;
    private static boolean _mReplayPutting;
    private static boolean _mReplayPowerShot;
    private static boolean _mReplayFLeft;
    private static byte _mReplayShotDir;
    private static Image _mImgBall;
    private static Image _mImgBallPower;
    private static Image _mImgCrosshair;
    private static Image _mImgBallGlow;
    private static cSprite _mSprBallGlow;

    cBall() {
    }

    public static void open(cCanvas cCanvas2) {
        _mCanvas = cCanvas2;
        mFPAngle = INIT_ANGLE_FP;
        _mTraceX = new int[12];
        _mTraceY = new int[12];
        _mTraceCnt = 0;
        mTraceDebug = false;
        _mSprBallGlow = new cSprite(_mCanvas.getWidth(), _mCanvas.getHeight(), 0, 0, 9, 9, 1);
    }

    public static void init(int n, int n2, boolean bl) {
        block7: {
            block6: {
                if (bl) break block6;
                if (!cCanvas.mLoadingGame) break block7;
            }
            cBall.loadGraphics();
            _mSprBallGlow.setAnimProps(0, cObjects.mFrm0to3, cObjects.mFrm0to3.length, 50);
            _mSprBallGlow.playAnim(0, true, true);
            if (!cCanvas.mLoadingGame) {
                mFPAngle = INIT_ANGLE_FP;
            }
            mAppliedSpin = 0;
            mShotDirection = 0;
        }
        mFPX = n;
        mFPY = n2;
        _mRow = cFP.toInt(mFPY) >> 4;
        _mCol = cFP.toInt(mFPX) >> 4;
        mPutting = false;
        if (cCourse.mCollisionInfo[_mRow + 1][_mCol] == 7 || cCourse.mCollisionInfo[_mRow + 1][_mCol] == 6) {
            mPutting = true;
        }
        if (_mRow >= cCourse.mTotRows - 1 || !mPutting) {
            mFPAngle = mFPAngle <= 368640 ? INIT_ANGLE_FP : 737280 - INIT_ANGLE_FP;
            mPutting = false;
        }
        cBall.setCrossHairPos();
    }

    public static void loadGraphics() {
        _mImgBall = crlCanvas.gResourceManager.getImageByID(76357241960537L);
        _mImgBallPower = crlCanvas.gResourceManager.getImageByID(78210387184649L);
        _mImgBallGlow = crlCanvas.gResourceManager.getImageByID(77272976461136L);
        _mImgCrosshair = crlCanvas.gResourceManager.getImageByID(79540634720195L);
    }

    public static void replayReset() {
        cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber - 1);
        mFPX = mReplayFPX;
        mFPY = mReplayFPY;
        cBall.initShot(0);
        mAppliedSpin = mReplaySpin;
        mShotDirection = _mReplayShotDir;
        mPutting = _mReplayPutting;
        cCanvas.mPowerShot = _mReplayPowerShot;
        cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFacingLeft = _mReplayFLeft;
        cCanvas.mShotPower = mReplayPower;
        mFPAngle = mReplayFPAngle;
    }

    public static void renderCrosshair(Graphics graphics) {
        int n = cFP.toInt(mFPX + cCourse.mFPX);
        int n2 = cFP.toInt(mFPY + cCourse.mFPY);
        if (mPutting) {
            cCanvas.renderImage(graphics, _mImgCrosshair, (_mImgCrosshair.getWidth() >> 1) + 1, 0, _mImgCrosshair.getWidth() >> 1, _mImgCrosshair.getHeight(), _mCrossHairX + n + -8 - 1, _mCrossHairY + n2 + -8 - 5);
        } else {
            cCanvas.renderImage(graphics, _mImgCrosshair, 0, 0, 15, _mImgCrosshair.getHeight(), _mCrossHairX + n + -8 + 1, _mCrossHairY + n2 + -8 + 4);
            int n3 = _mCrossHairX * (cCanvas.mFrameCount % 10 + 1) / 10 + 5;
            int n4 = (4 + _mCrossHairY) * (cCanvas.mFrameCount % 10 + 1) / 10 + 5;
            int n5 = mFPAngle > 368640 ? 1 : 0;
            cCanvas.renderImage(graphics, _mImgBall, 0, 0, 5, 5, n3 + n + -8 + 1 + n5, n4 + n2 + -8 + 1);
        }
    }

    public static boolean initShot(int n) {
        mAppliedSpin = 0;
        mNaturalSpin = 0;
        mFPDY = 0;
        mFPDX = 0;
        mRoll = 0;
        mHoled = false;
        mStopped = false;
        mLost = false;
        mDrowned = false;
        mExploded = false;
        _mBunkered = false;
        cCanvas.mPowerShot = false;
        mFairwayHit = true;
        cObjects.mShotDropped = -1;
        return cBall.aim(n == 1);
    }

    public static void aim() {
        if (mShotDirection != 0) {
            if (cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFacingLeft != cBall.aim(mShotDirection == 1)) {
                if (mPutting) {
                    cCourse.centreViewPoint(mFPX, mFPY, -1, (byte)1, (byte)0);
                } else {
                    cCanvas.mGameLoopState = (byte)4;
                }
            }
        }
    }

    private static boolean aim(boolean bl) {
        if (mPutting) {
            mFPAngle = bl ? 0 : 737280;
        } else if (!bl && mFPAngle < 737280 - MIN_ANGLE_FP) {
            mFPAngle += 10240;
        } else if (bl && mFPAngle > MIN_ANGLE_FP) {
            mFPAngle -= 10240;
        }
        if (!bl && mFPAngle > MAX_ANGLE_FP && mFPAngle < 368640) {
            mFPAngle = 737280 - MAX_ANGLE_FP;
        } else if (bl && mFPAngle < 737280 - MAX_ANGLE_FP && mFPAngle > 368640) {
            mFPAngle = MAX_ANGLE_FP;
        }
        cBall.setCrossHairPos();
        return mFPAngle > 368640;
    }

    public static void setCrossHairPos() {
        int n = mFPAngle > 368640 ? 368640 - (mFPAngle - 368640) : mFPAngle;
        _mCrossHairFPX = cFP.getX(30, n);
        _mCrossHairFPY = cFP.getY(30, n);
        if (n != mFPAngle) {
            _mCrossHairFPX = -_mCrossHairFPX;
        }
        _mCrossHairX = cFP.toInt(_mCrossHairFPX);
        _mCrossHairY = cFP.toInt(_mCrossHairFPY);
    }

    public static void shoot(int n) {
        int n2 = mFPAngle > 368640 ? 368640 - (mFPAngle - 368640) : mFPAngle;
        mFPDX = cFP.getX(n, n2);
        mFPDY = cFP.getY(n, n2);
        mFPSpeedCoeff = cFP.mul(mFPDX, mFPDX) + cFP.mul(mFPDY, mFPDY);
        mFPDX = n2 == mFPAngle ? mFPDX : -mFPDX;
        mAppliedSpin = cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFacingLeft ? -mAppliedSpin : mAppliedSpin;
        mStopped = false;
        mReplayFPAngle = mFPAngle;
        mReplayFPX = mFPX;
        mReplayFPY = mFPY;
        _mReplayPutting = mPutting;
        _mReplayPowerShot = cCanvas.mPowerShot;
        _mReplayFLeft = cCanvas.mPlayer[cCanvas.mCurrPlayerID].mFacingLeft;
        _mReplayShotDir = mShotDirection;
        mReplaySpin = mAppliedSpin;
        cBall.clearTrace();
        cBall.setTrace();
        cCanvas.actionSFX(cCanvas.mPowerShot ? 12 : 7);
        if (cCanvas.mPowerShot) {
            cCanvas.actionVibrate(15);
        }
    }

    private static void clearTrace() {
        int n = 12;
        while (--n >= 0) {
            cBall._mTraceY[n] = 0;
            cBall._mTraceX[n] = 0;
        }
        cBall._mTraceX[0] = mFPX;
        cBall._mTraceY[0] = mFPY;
    }

    public static void update() {
        if (!mStopped) {
            cBall.move();
            _mSprBallGlow.updateAnim();
        }
        if (mStopped) {
            if (mHoled) {
                cCanvas.mPlayer[cCanvas.mCurrPlayerID].initHoleComplete(cCanvas.mCurrHoleID - 1, cCourse.mPar[cCanvas.mCurrHoleID - 1]);
                cCanvas.mGameLoopState = (byte)9;
            } else {
                cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber + 1);
                if (!_mCanvas.isTooManyShots()) {
                    if (mDrowned || mExploded || mLost) {
                        if (cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls <= 0) {
                            cCanvas.mPlayer[cCanvas.mCurrPlayerID].mGameOver = true;
                            _mCanvas.playBadHoleEnding();
                        } else {
                            cCanvas.mGameLoopState = (byte)6;
                        }
                        cCanvas.mDelay = System.currentTimeMillis();
                        mFairwayHit = false;
                        cCanvas.mPlayer[cCanvas.mCurrPlayerID].setShotCompleteStats();
                    } else {
                        mFairwayHit = !_mBunkered && !mLost;
                        cCanvas.mPlayer[cCanvas.mCurrPlayerID].setShotCompleteStats();
                        if (!mLost) {
                            cCanvas.mPlayer[cCanvas.mCurrPlayerID].initShot(mFPX, mFPY + cFP.toFP(4));
                        }
                        _mCanvas.nextShot();
                    }
                }
            }
        }
    }

    private static void checkTerminalVelocity() {
        int n = cFP.getX(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mMaxShotPower, MIN_ANGLE_FP);
        int n2 = -cFP.getY(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mMaxShotPower, MAX_ANGLE_FP);
        if (Math.abs(mFPDY) > n2) {
            int n3 = mFPDY = mFPDY > 0 ? n2 : -n2;
        }
        if (Math.abs(mFPDX) > n) {
            mFPDX = mFPDX > 0 ? n : -n;
        }
    }

    private static boolean fishCheck() {
        int n;
        boolean bl = false;
        for (n = 0; n < cObjects.mSprEnemies.length; ++n) {
            if (cFP.toInt(mFPX) < cObjects.mSprEnemies[n].mX || cFP.toInt(mFPX) > cObjects.mSprEnemies[n].mX + 32) continue;
            bl = true;
        }
        if (bl) {
            bl = false;
            for (int i = 0; i < cObjects.mWaterMarker.length; ++i) {
                n = cFP.toInt(mFPY);
                if (cObjects.mWaterMarker[i].mY - 4 > n || cObjects.mWaterMarker[i].mY + 1 + 2 < n) continue;
                bl = true;
            }
        }
        if (bl) {
            for (n = 0; n < cObjects.mSprEnemies.length; ++n) {
                if (cObjects.mFishSpikesDone[n]) continue;
                return false;
            }
            for (n = 0; n < cObjects.mSprEnemies.length; ++n) {
                cObjects.mFishSpikesDone[n] = false;
            }
        }
        return true;
    }

    private static boolean spikesDropCheck() {
        int n;
        boolean bl = false;
        for (n = 0; n < cObjects.mBlockSpikeX.length; ++n) {
            if (cFP.toInt(mFPX) < cObjects.mBlockSpikeX[n] + 2 || cFP.toInt(mFPX) > cObjects.mBlockSpikeX[n] + 30) continue;
            bl = true;
        }
        if (bl) {
            bl = false;
            for (int i = 0; i < cObjects.mSpikeMarker.length; ++i) {
                n = cFP.toInt(mFPY);
                if (cObjects.mSpikeMarker[i].mY - 4 > n || cObjects.mSpikeMarker[i].mY + 1 + 2 < n) continue;
                bl = true;
            }
        }
        if (bl) {
            for (n = 0; n < cObjects.mBlockSpikeX.length; ++n) {
                if (cObjects.mFishSpikesDone[n]) continue;
                return false;
            }
            for (n = 0; n < cObjects.mBlockSpikeX.length; ++n) {
                cObjects.mFishSpikesDone[n] = false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static void move() {
        block24: {
            block21: {
                block22: {
                    block23: {
                        cBall.mCollided = false;
                        cBall.applyGravity();
                        cBall.applyFrictionWind();
                        cBall.checkTerminalVelocity();
                        var0 = cFP.getX(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mMaxShotPower, cBall.MIN_ANGLE_FP);
                        var1_1 = -cFP.getY(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mMaxShotPower, cBall.MAX_ANGLE_FP);
                        var2_2 = cFP.div(cFP.mul(cBall.mFPDX, cFP.toFP(14) - 410), var0);
                        var3_3 = cFP.div(cFP.mul(cBall.mFPDY, cFP.toFP(14) - 410), var1_1);
                        cObjects.checkCollisions(cBall.mFPX, cBall.mFPY, var2_2, var3_3);
                        cBall.checkTerminalVelocity();
                        cBall.checkCollisions(var2_2, var3_3);
                        cBall.checkTerminalVelocity();
                        if (cBall.mCollided) {
                            cBall.mAppliedSpin /= 2;
                            if (cBall.mRoll != 0 && !cBall.mHoled && !cBall._mBunkered || cBall.mDrowned) {
                                var2_2 = cFP.div(cFP.mul(cBall.mFPDX, cFP.toFP(14)), var0);
                                var3_3 = cFP.div(cFP.mul(cBall.mFPDY, cFP.toFP(14)), var1_1);
                                if (cBall.mRoll == 1) {
                                    cBall.mFPX += cFP.mul(var2_2, cBall.ROLL_FP);
                                } else {
                                    cBall.mFPX += var2_2;
                                    cBall.mFPY += var3_3;
                                }
                            }
                            cBall.setTrace();
                            if (cBall.mRoll != 1) {
                                cBall._mCanvas.triggerPaint();
                            }
                        } else if (!cBall.mLost && !cBall._mBunkered) {
                            cBall.mFPX += var2_2;
                            cBall.mFPY += var3_3;
                            cBall.setTrace();
                        }
                        cCourse.centreViewPoint(cBall.mFPX, cBall.mFPY, -1, (byte)0, (byte)0);
                        if (cBall.mLost || cBall.mFPY > cFP.toFP(cCourse.mHeight)) {
                            cBall.mStopped = true;
                            cBall.mLost = true;
                            if (!cBall.mDrowned) {
                                cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls - 1);
                            }
                        }
                        cBall._mRow = cFP.toInt(cBall.mFPY) >> 4;
                        cBall._mCol = cFP.toInt(cBall.mFPX) >> 4;
                        if (!cBall._mBunkered && !cBall.mHoled && (Math.abs(var3_3) >= cBall.BALL_STOP_FP || Math.abs(var2_2) >= cBall.BALL_STOP_FP)) break block21;
                        if (Math.abs(var3_3) < cBall.BALL_STOP_FP && Math.abs(var2_2) < cBall.BALL_STOP_FP) {
                            cBall.mFPDY = 0;
                        }
                        cBall._mStopTimer = (byte)(cBall._mStopTimer + 1);
                        if ((!cBall.mHoled || cBall._mStopTimer < 4) && cBall._mStopTimer <= 16) break block22;
                        cBall.mCheckFishSpikeDrop = true;
                        if (cCanvas.mCurrCourseID != 1) break block23;
                        if (cCanvas.mDifficulty == 0) break block23;
                        if (cCanvas.mCurrHoleID == 9) break block23;
                        if (cBall.spikesDropCheck()) {
                            cBall.mStopped = true;
                            cBall._mStopTimer = 0;
                            cBall.mNaturalSpin = 0;
                        }
                        break block24;
                    }
                    if (cCanvas.mCurrCourseID != 0) ** GOTO lbl-1000
                    if (cCanvas.mDifficulty != 0) {
                        if (cBall.fishCheck()) {
                            cBall.mStopped = true;
                            cBall._mStopTimer = 0;
                            cBall.mNaturalSpin = 0;
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        cBall.mStopped = true;
                        cBall._mStopTimer = 0;
                        cBall.mNaturalSpin = 0;
                    }
                    break block24;
                }
                cBall.mCheckFishSpikeDrop = false;
                break block24;
            }
            if (cCanvas.mCurrCourseID == 1) {
                if (cCanvas.mDifficulty != 0) {
                    if (cCanvas.mCurrHoleID != 9) {
                        for (var4_4 = 0; var4_4 < cObjects.mFishSpikesDone.length; ++var4_4) {
                            cObjects.mFishSpikesDone[var4_4] = false;
                        }
                    }
                }
            }
            cBall._mStopTimer = 0;
            cBall.mCheckFishSpikeDrop = false;
        }
        if (cBall.mStopped && cBall.mDrowned) {
            cBall.replaceBall(8, cObjects.mWaterMarker);
        } else if (cBall.mStopped && (cBall.mExploded || cBall.mLost)) {
            cBall.replaceBall(8, cObjects.mSpikeMarker);
        }
    }

    public static void setTrace() {
        if (_mTracePrevX != mFPX || _mTracePrevY != mFPY) {
            cBall._mTraceX[cBall._mTraceCnt] = mFPX;
            cBall._mTraceY[cBall._mTraceCnt] = mFPY;
            _mTraceCnt = (_mTraceCnt + 1) % _mTraceX.length;
        }
        _mTracePrevX = mFPX;
        _mTracePrevY = mFPY;
    }

    private static void replaceBall(int n, cObjects.cMarker[] cMarkerArray) {
        int n2 = -1;
        int n3 = 200000;
        if (mNotMarkerDrop) {
            mDropFPX = mReplayFPX;
            mDropFPY = mReplayFPY + cFP.toFP(4);
            mNotMarkerDrop = false;
        } else {
            if (mExploded) {
                mFPX = cFP.toFP(cObjects.mSprBallExplosion.mX);
            }
            for (int i = 0; i < n; ++i) {
                if (!cMarkerArray[i].mActive || Math.abs(cMarkerArray[i].mX - cFP.toInt(mFPX)) >= n3 || (mFPX <= mReplayFPX || cMarkerArray[i].mX >= cFP.toInt(mFPX)) && (mFPX >= mReplayFPX || cMarkerArray[i].mX <= cFP.toInt(mFPX))) continue;
                n2 = i;
                n3 = Math.abs(cMarkerArray[i].mX - cFP.toInt(mFPX));
            }
            mDropFPX = n2 < 0 ? mReplayFPX : cFP.toFP(cMarkerArray[n2].mX);
            mDropFPY = n2 < 0 ? mReplayFPY + cFP.toFP(4) : cFP.toFP(cMarkerArray[n2].mY + 1 + 2);
        }
    }

    private static void applyGravity() {
        mFPDY = mRoll == 1 ? 0 : (mFPDY += mDrowned ? VISCOSITY_FP : GRAVITY_FP);
    }

    private static void applyFrictionWind() {
        if (mPutting || mRoll == 1) {
            if (mRoll == 1) {
                mNaturalSpin /= 2;
            }
            mFPDX = cFP.mul(mFPDX, ROLL_FP);
            mFPWind = 0;
        } else if (mRoll == 0) {
            if (cCanvas.mDifficulty == 2 && mApplyWind) {
                if (cCanvas.mFrameCount % 2 == 0) {
                    mFPWind = cFP.mul(cFP.toFP(mWind), WIND_FACTOR_FP);
                    mFPDX += mFPWind;
                }
            }
        }
        if (_mBunkered || Math.abs(mFPDX) < BALL_STOP_FP || mDrowned) {
            mFPDX = 0;
            mApplyWind = false;
        } else if (cCanvas.mDifficulty == 2) {
            mApplyWind = true;
        }
    }

    public static void setWind() {
        mWind = ((Math.abs(cCanvas.mRand.nextInt()) % 2 == 0 ? -1 : 1) * Math.abs(cCanvas.mRand.nextInt() % 3) + 1) * 15;
        mApplyWind = true;
        mFPWind = 0;
    }

    public static void adjustWind() {
        int n = 0;
        do {
        } while ((n = cCanvas.mRand.nextInt() % 2) == 0);
        if ((mWind += n * 15) == 0) {
            mWind += n * 15;
        } else if (mWind > 45) {
            mWind = 30;
        } else if (mWind < -45) {
            mWind = -30;
        }
    }

    private static void collidedSlope(int n, byte by) {
        int n2 = mFPDY + (GRAVITY_FP >> 1);
        int n3 = SLOPE_BOUNCE_FP;
        int n4 = SLOPE_BOUNCE_FP;
        byte by2 = cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin;
        switch (n) {
            case 3: {
                mFPDY = cFP.mul(-mFPDX + mNaturalSpin, n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 8192);
                mFPDX = cFP.mul(-n2 - mNaturalSpin, n4) + cFP.div(cFP.toFP(mAppliedSpin * by2), 8192);
                break;
            }
            case 8: 
            case 9: {
                mFPDY = cFP.mul(-cFP.mul(mFPDX, 3277) - cFP.mul(n2, 2518) + cFP.div(mNaturalSpin, 8192), n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 12288);
                mFPDX = cFP.mul(cFP.mul(mFPDX, 2518) - cFP.mul(n2, 3277) - mNaturalSpin, n4) + cFP.mul(cFP.div(cFP.toFP(mAppliedSpin * by2), 12288), 8192);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                mFPDY = cFP.mul(-cFP.mul(mFPDX, 2518) - cFP.mul(n2, 3277) + cFP.div(mNaturalSpin, 12288), n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 16384);
                mFPDX = cFP.mul(cFP.mul(mFPDX, 3277) - cFP.mul(n2, 2518) - mNaturalSpin, n4) + cFP.mul(cFP.toFP(mAppliedSpin * by2), 3072);
                break;
            }
            case 2: {
                mFPDY = cFP.mul(mFPDX + mNaturalSpin, n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 8192);
                mFPDX = cFP.mul(n2 + mNaturalSpin, n4) + cFP.div(cFP.toFP(mAppliedSpin * by2), 8192);
                break;
            }
            case 10: 
            case 11: {
                mFPDY = cFP.mul(cFP.mul(mFPDX, 3277) - cFP.mul(n2, 2518) + cFP.div(mNaturalSpin, 8192), n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 12288);
                mFPDX = cFP.mul(cFP.mul(mFPDX, 2518) + cFP.mul(n2, 3277) + mNaturalSpin, n4) + cFP.mul(cFP.div(cFP.toFP(mAppliedSpin * by2), 12288), 8192);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                mFPDY = cFP.mul(cFP.mul(mFPDX, 2518) - cFP.mul(n2, 3277) + cFP.div(mNaturalSpin, 12288), n3) - cFP.div(cFP.toFP(mAppliedSpin * by2), 16384);
                mFPDX = cFP.mul(cFP.mul(mFPDX, 3277) + cFP.mul(n2, 2518) + mNaturalSpin, n4) + cFP.mul(cFP.toFP(mAppliedSpin * by2), 3072);
                break;
            }
            case 20: 
            case 21: {
                mFPDY = cFP.mul(-cFP.mul(mFPDX, 3277) + cFP.mul(n2, 2518) + mNaturalSpin, n3) - cFP.mul(cFP.div(cFP.toFP(mAppliedSpin * by2), 16384), 12288);
                mFPDX = cFP.mul(cFP.mul(-Math.abs(mFPDX), 2518) - cFP.mul(n2, 3277) - mNaturalSpin, n4) + cFP.div(cFP.toFP(mAppliedSpin * by2), 16384);
                break;
            }
            case 22: 
            case 23: {
                mFPDY = cFP.mul(cFP.mul(mFPDX, 3277) + cFP.mul(n2, 2518) + mNaturalSpin, n3) - cFP.mul(cFP.div(cFP.toFP(mAppliedSpin * by2), 16384), 12288);
                mFPDX = cFP.mul(cFP.mul(Math.abs(mFPDX), 2518) + cFP.mul(n2, 3277) + mNaturalSpin, n4) + cFP.div(cFP.toFP(mAppliedSpin * by2), 16384);
            }
        }
        mNaturalSpin = mFPDX < 0 && by == 1 || mFPDX > 0 && by == 0 ? (mNaturalSpin += SLOPE_ROLL_INC_FP) : (mNaturalSpin /= 8192);
        mRoll = (byte)2;
        mCollided = true;
        if (Math.abs(mFPDY) > cFP.toFP(5)) {
            cCanvas.actionSFX(10);
        }
    }

    public static void explode() {
        mExploded = true;
        mStopped = true;
        cObjects.playEffect(cObjects.mSprBallExplosion, cFP.toInt(mFPX) - 7, cFP.toInt(mFPY) - 6);
        if (!mDrowned) {
            cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls - 1);
        }
        if (cCanvas.mCurrCourseID == 0) {
            mDrowned = true;
        }
        cCanvas.actionVibrate(10);
        cCanvas.actionSFX(12);
    }

    private static void collidedBunker(int n) {
        if (!_mBunkered && n != 0) {
            cBall.setTrace();
            cObjects.playEffect(cObjects.mSprSandEffect, 1 + cFP.toInt(mFPX) - 8, cFP.toInt(mFPY) - 5);
            cCanvas.actionSFX(11);
        }
        mCollided = true;
        mNaturalSpin = 0;
        mAppliedSpin = 0;
        mRoll = 0;
        _mBunkered = true;
        mFPDX = 0;
        mFPDY = 0;
    }

    private static void collidedWaterLava() {
        if (cCanvas.mCurrCourseID == 0) {
            cObjects.playEffect(cObjects.mSprSplashEffect, cFP.toInt(mFPX) - 8 + 1, cFP.toInt(mFPY) - 4);
            mDrowned = true;
            mFPDY = 0;
            mFPDX = 0;
            cCanvas.actionSFX(11);
            cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls = (byte)(cCanvas.mPlayer[cCanvas.mCurrPlayerID].mBalls - 1);
        } else {
            cBall.explode();
            mDrowned = true;
        }
    }

    private static void collidedUp(int n) {
        int n2 = mFPY;
        mFPY = cFP.toFP(0 + (n + 1) * 16);
        mFPX = mNextFPX - cFP.mul(mFPDX, cFP.div(mNextFPY - (mNextFPY - mFPY > 0 ? n2 : mFPY), mFPDY));
        mFPDY = -cFP.mul(mFPDY, BOUNCE_FP);
        mFPDX = cFP.mul(mFPDX, BOUNCE_FP) + cFP.toFP(mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin);
    }

    private static void collidedDown(int n, int n2, int n3, int n4) {
        int n5 = mFPDX;
        int n6 = mFPDY;
        mFPY = cFP.toFP(n2 * 16 - 1 - 2);
        if (cObjects.checkSpringCollision(mFPX, mFPY, mNextFPY - mFPY, mNextFPX - mFPX, cObjects.mSprSprings, 32, 6, 3)) {
            mFPY -= cFP.toFP(16);
        } else {
            if (n == 5 && S == 5) {
                cBall.collidedBunker(n6);
                return;
            }
            if (n == 4) {
                mFPX = mNextFPX - (n6 != 0 && mRoll != 1 ? cFP.mul(n5, cFP.div(mNextFPY - mFPY, n6)) : 0);
                cBall.collidedWaterLava();
            } else {
                int n7 = mFPDY = mLost || mDrowned ? 0 : cFP.mul(-mFPDY, BOUNCE_FP);
                if (!mPutting) {
                    mFPDX = cFP.mul(n5, ROLL_FP) + cFP.toFP(mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin);
                }
            }
            if (Math.abs(mFPDY) <= GRAVITY_FP && !mDrowned) {
                mRoll = 1;
                mFPDY = 0;
            }
            if (mRoll == 2 || mDrowned) {
                mRoll = 0;
            }
            mFPX = mNextFPX - (n6 != 0 && mRoll != 1 ? cFP.mul(mNextFPY - mFPY, cFP.div(n5, n6)) : 0);
        }
        cBall.extraHoleCheck(n3, n4);
        mNaturalSpin /= 2;
    }

    private static void extraHoleCheck(int n, int n2) {
        int n3 = cFP.toInt(cCourse.mFPHoleX) >> 4;
        int n4 = cFP.toInt(cCourse.mFPHoleY) >> 4;
        n = cFP.toInt(mFPX) - n3 * 16;
        n2 = cFP.toInt(mFPY) - (n4 - 1) * 16;
        if (n - 8 + 4 + 2 > 0 && n - 8 - 4 + 1 < 0 && n2 >= 0 && n2 <= 16) {
            cBall.collidedHole();
        }
    }

    private static void collidedRightLeft(int n, byte by) {
        mFPX = by == 1 ? cFP.toFP(n * 16 - 4) : cFP.toFP((n + 1) * 16);
        mFPY = by == 1 && mNextFPX - mFPX - mFPWind > 0 || by == 0 && mNextFPX - mFPX - mFPWind < 0 ? mNextFPY - cFP.mul(mNextFPX - mFPX - mFPWind, cFP.div(mFPDY, mFPDX)) : mNextFPY;
        mFPDX = (by == 1 ? -1 : 1) * Math.abs(cFP.mul(mNaturalSpin - mFPDX, 1229));
        if (mRoll == 0 && !mPutting) {
            mFPDY += (by == 1 ? -1 : 1) * cFP.toFP(mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin);
        }
    }

    private static void collidedTopRightLeft(byte by) {
        int n = mFPDY - (GRAVITY_FP >> 1);
        mFPDY = cFP.mul(by == 1 ? mFPDX : -mFPDX, BOUNCE_FP) - cFP.div(cFP.toFP(mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin), 8192);
        mFPDX = cFP.mul(by == 1 ? n : -n, BOUNCE_FP) + cFP.div(cFP.toFP(mAppliedSpin * cCanvas.mPlayer[cCanvas.mCurrPlayerID].mSpin), 8192);
    }

    private static void collidedHole() {
        mFPDX = 0;
        mFPDY = 0;
        mFPY = cCourse.mFPHoleY + 4;
        mFPX = cCourse.mFPHoleX - 4;
        cBall.setTrace();
        mCollided = true;
        mHoled = true;
        mStopped = true;
        cCanvas.actionVibrate(20);
    }

    private static void collided(int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n2) {
            case 24: {
                if (n6 > 8 || cCourse.mCollisionInfo[n3 - 1][n4] == 24) {
                    cBall.explode();
                    break;
                }
                mRoll = 0;
                mCollided = false;
                return;
            }
            case 25: {
                if (!cCanvas.mPowerShot) break;
                int n7 = n3;
                while (cCourse.mCollisionInfo[n7][n4] == 25) {
                    cCourse.mCollisionInfo[n7][n4] = 0;
                    cCourse.mTiles[n7][n4] = 102;
                    ++n7;
                }
                n7 = n3 - 1;
                while (cCourse.mCollisionInfo[n7][n4] == 25) {
                    cCourse.mCollisionInfo[n7][n4] = 0;
                    cCourse.mTiles[n7][n4] = 102;
                    --n7;
                }
                mCollided = false;
                cCanvas.actionSFX(12);
                return;
            }
            case 26: {
                if (n != 1) {
                    mCollided = false;
                    return;
                }
                if (Math.abs(mFPDY) <= cFP.toFP(5)) break;
                cCanvas.actionSFX(10);
            }
        }
        switch (n) {
            case 0: {
                cBall.collidedUp(n3);
                break;
            }
            case 1: {
                if (mDrowned) break;
                cBall.collidedDown(n2, n3, n5, n6);
                break;
            }
            case 2: {
                cBall.collidedRightLeft(n4, (byte)0);
                break;
            }
            case 3: {
                cBall.collidedRightLeft(n4, (byte)1);
                break;
            }
            case 5: {
                cBall.collidedTopRightLeft((byte)1);
                break;
            }
            case 6: {
                cBall.collidedTopRightLeft((byte)0);
            }
        }
        cBall.setTrace();
        mCollided = true;
        if (Math.abs(mFPDY) > cFP.toFP(5) && !mDrowned) {
            cCanvas.actionSFX(10);
        }
    }

    private static void checkSlopeCollision(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 3 && cObjects.checkSpringCollision(mFPX, mFPY, mNextFPY - mFPY, mNextFPX - mFPX, cObjects.mSprSprings45L, 37, 6, 5) || n == 2 && cObjects.checkSpringCollision(mFPX, mFPY, mNextFPY - mFPY, mNextFPX - mFPX, cObjects.mSprSprings45R, 37, 6, 4)) {
            mRoll = (byte)2;
            return;
        }
        switch (n) {
            default: {
                bl = true;
            }
            case 3: {
                n8 = 1;
                n7 = 1;
                break;
            }
            case 10: {
                bl = true;
            }
            case 8: {
                n8 = 1;
                n7 = 2;
                break;
            }
            case 11: {
                bl = true;
            }
            case 9: {
                n8 = 2;
                n7 = 2;
                break;
            }
            case 15: {
                bl = true;
            }
            case 12: {
                n8 = 1;
                n7 = 3;
                break;
            }
            case 16: {
                bl = true;
            }
            case 13: {
                n8 = 2;
                n7 = 3;
                break;
            }
            case 17: {
                bl = true;
            }
            case 14: {
                n8 = 3;
                n7 = 3;
                break;
            }
            case 22: {
                bl = true;
            }
            case 20: {
                bl2 = true;
                n8 = 1;
                n7 = 2;
                break;
            }
            case 23: {
                bl = true;
            }
            case 21: {
                bl2 = true;
                n8 = 2;
                n7 = 2;
            }
        }
        if (mFPDY != 0 && !bl2 && Math.abs(mFPDX) > Math.abs(mFPDY) && (bl && mFPDX > 0 || !bl && mFPDX < 0) && cFP.toInt(cFP.div(Math.abs(mFPDX), Math.abs(mFPDY))) > n7) {
            return;
        }
        int n9 = n5 + 1 + 1;
        int n10 = n6 = bl ? n4 - 1 : n4 + 1 + 1;
        if (!bl2 && (bl && n6 < 16 && n9 > (n7 - n8) * 16 / n7 && n6 - n9 * n7 + (n7 - n8) * 16 < 0 || !bl && n6 >= 0 && n9 >= 0 && n9 * n7 + n6 - 16 * (n7 - (n8 - 1)) >= 0) || bl2 && (bl && n9 >= 0 && n6 <= 16 / n8 && n9 - n7 * n6 + (2 - n8) * 16 > 0 || !bl && n9 >= 0 && n6 >= (n8 - 1) * 16 / n7 && n9 + n7 * n6 - n8 * 16 >= 0)) {
            int n11 = bl ? 1 : -1;
            int n12 = -1;
            if (Math.abs(mFPDX) > Math.abs(mFPDY) && (bl2 || !bl2 && bl && mFPDX < 0 || !bl2 && !bl && mFPDX > 0)) {
                int n13 = cFP.mul(cFP.toFP(n6), cFP.div(mFPDY, mFPDX));
                int n14 = cFP.toFP(n9) - n13;
                while ((bl2 || (!bl || (n6 += n11) - n9 * n7 + (n7 - n8) * 16 < 0 && n6 < 16) && (bl || n9 * n7 + n6 - 16 * (n7 - (n8 - 1)) >= 0 && n6 >= 0)) && (!bl2 || (!bl || n6 <= 16 / n8 && n9 - n7 * n6 + (2 - n8) * 16 > 0) && (bl || n9 + n7 * n6 - n8 * 16 >= 0 && n6 >= (n8 - 1) * 16 / n7))) {
                    n13 = cFP.mul(cFP.toFP(n6), cFP.div(mFPDY, mFPDX));
                    n9 = cFP.toInt(n13 + n14);
                    if (!bl2 && (bl && n6 < 16 && n9 >= (n7 - n8) * 16 / n7 && n6 - n9 * n7 + (n7 - n8) * 16 < 0 || !bl && n6 >= 0 && n9 >= 0 && n9 * n7 + n6 - 16 * (n7 - (n8 - 1)) >= 0) || bl2 && (bl && n9 >= 0 && n6 <= 16 / n8 && n9 - n7 * n6 + (2 - n8) * 16 > 0 || !bl && n9 >= 0 && n6 >= (n8 - 1) * 16 / n7 && n9 + n7 * n6 - n8 * 16 >= 0)) continue;
                    break;
                }
            } else if (mFPDY != 0) {
                int n15 = cFP.mul(cFP.toFP(n9), cFP.div(mFPDX, mFPDY));
                int n16 = cFP.toFP(n6) - n15;
                while ((bl2 || (!bl || (n9 += n12) >= (n7 - n8) * 16 / n7 && n6 - n9 * n7 + (n7 - n8) * 16 < 0) && (bl || n9 * n7 + n6 - 16 * (n7 - (n8 - 1)) >= 0 && n9 >= 0)) && (!bl2 || (!bl || n9 - n7 * n6 + (2 - n8) * 16 > 0 && n9 >= 0) && (bl || n9 + n7 * n6 - n8 * 16 >= 0 && n9 >= 0))) {
                    n15 = cFP.mul(cFP.toFP(n9), cFP.div(mFPDX, mFPDY));
                    n6 = cFP.toInt(n15 + n16);
                    if (!bl2 && (bl && n6 < 16 && n9 >= (n7 - n8) * 16 / n7 && n6 - n9 * n7 + (n7 - n8) * 16 < 0 || !bl && n6 >= 0 && n9 >= 0 && n9 * n7 + n6 - 16 * (n7 - (n8 - 1)) >= 0) || bl2 && (bl && n9 >= 0 && n6 <= 16 / n8 && n9 - n7 * n6 + (2 - n8) * 16 > 0 || !bl && n9 >= 0 && n6 >= (n8 - 1) * 16 / n7 && n9 + n7 * n6 - n8 * 16 >= 0)) continue;
                }
            }
            mFPX = bl ? cFP.toFP(n6 + 1 + n3 * 16) : cFP.toFP(n6 - 1 - 1 + n3 * 16);
            mFPY = cFP.toFP(n9 - 1 - 1 + n2 * 16);
            cBall.setTrace();
            cBall.collidedSlope(n, !bl ? (byte)1 : 0);
        } else {
            mRoll = 0;
        }
    }

    private static void checkCeilingSlopeCollision(int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl = true;
        if (n == 18) {
            bl = false;
        }
        int n7 = bl ? n5 - 1 : n5;
        int n8 = n6 = bl ? n4 + 1 + 1 : n4;
        if (bl && n7 < 16 && n6 >= 0 && n6 - n7 - 2 >= 0 || !bl && n6 < 16 && n7 < 16 && n7 + n6 - 16 <= 0) {
            int n9 = mFPDX;
            int n10 = mFPDY;
            if (Math.abs(mFPDX) > Math.abs(mFPDY)) {
                int n11 = cFP.mul(cFP.toFP(n6), cFP.div(mFPDY, mFPDX));
                int n12 = cFP.toFP(n7) - n11;
                n9 = bl ? -1 : 1;
                while ((!bl || (n6 += n9) - n7 - 2 >= 0 && n6 >= 0) && (bl || n7 + n6 - 16 <= 0 && n6 < 16)) {
                    n11 = cFP.mul(cFP.toFP(n6), cFP.div(mFPDY, mFPDX));
                    n7 = cFP.toInt(n11 + n12);
                    if (bl && n7 < 16 && n6 >= 0 && n6 - n7 - 2 >= 0 || !bl && n6 < 16 && n7 < 16 && n7 + n6 - 16 <= 0) continue;
                    break;
                }
            } else if (mFPDY != 0) {
                int n13 = cFP.mul(cFP.toFP(n7), cFP.div(mFPDX, mFPDY));
                int n14 = cFP.toFP(n6) - n13;
                n10 = 1;
                while ((!bl || n6 - (n7 += n10) - 1 >= 0 && n7 < 16) && (bl || n7 + n6 - 16 <= 0 && n7 < 16)) {
                    n13 = cFP.mul(cFP.toFP(n7), cFP.div(mFPDX, mFPDY));
                    n6 = cFP.toInt(n13 + n14);
                    if (bl && n7 < 16 && n6 >= 0 && n6 - n7 - 2 >= 0 || n6 < 16 && n7 < 16 && n7 + n6 - 16 <= 0) continue;
                }
            }
            mFPX = bl ? cFP.toFP(n6 - 1 - 1 + n3 * 16) : cFP.toFP(n6 + n3 * 16);
            mFPY = bl ? cFP.toFP(n7 + 1 + n2 * 16) : cFP.toFP(n7 + n2 * 16);
            cBall.setTrace();
            if (bl) {
                cBall.collided(5, 19, n2, n3, n4, n5);
            } else {
                cBall.collided(6, 18, n2, n3, n4, n5);
            }
        } else {
            mRoll = 0;
        }
    }

    private static void checkHoleCollision(int n, int n2, int n3, int n4, int n5, int n6) {
        if (mHoled) {
            cBall.collidedHole();
        }
        if (n3 != 0 && !mPutting && mRoll != 1) {
            int n7;
            int n8 = cFP.div(n4, n3);
            int n9 = n7 = n8 >= 0 ? n5 - 8 - 4 : -(n5 - 8 + 4);
            if (n7 != 0 && cFP.div(cFP.toFP(n6), cFP.toFP(n7)) > n8) {
                if (n6 + 1 + 1 >= 0) {
                    cBall.collided(1, 6, n, n2, n5, n6);
                }
                return;
            }
        }
        if (n5 - 8 + 4 + 1 + 1 >= 0 && n5 - 8 - 4 - 1 <= 0 && (n6 + 1 + 1 >= 0 || mPutting || mRoll != 0) && mFPDY >= 0) {
            if (Math.abs(mFPDX) < BALL_PUTT_FP || !mPutting && mRoll == 1) {
                cBall.collidedHole();
            }
        } else if (n6 + 1 + 1 >= 0) {
            cBall.collided(1, 6, n, n2, n5, n6);
        }
    }

    private static void checkCollisionsMiddle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        block0 : switch (n) {
            case 24: {
                cBall.collided(1, n, n4, n5, n6, n7);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 25: {
                int n8;
                int n9 = n6;
                int n10 = n7;
                int n11 = 0;
                if (Math.abs(n2) > Math.abs(n3)) {
                    int n12;
                    int n13 = cFP.mul(cFP.toFP(n6), cFP.div(n3, n2));
                    int n14 = cFP.toFP(n7) - n13;
                    int n15 = n12 = n2 < 0 ? 1 : -1;
                    if (n6 < 0 && n2 > -16384) {
                        cBall.collided(3, n, n4, n5, n9 + 2, n10);
                        break;
                    }
                    if (n6 >= 16 && n2 < 16384) {
                        cBall.collided(2, n, n4, n5, n9, n10);
                        break;
                    }
                    do {
                        if ((n6 += n12) < 0 && n2 > 0) {
                            cBall.collided(3, n, n4, n5, n9 + 2, n10);
                            break block0;
                        }
                        if (n6 >= 16 && n2 < 0) {
                            cBall.collided(2, n, n4, n5, n9, n10);
                            break block0;
                        }
                        n13 = cFP.mul(cFP.toFP(n6), cFP.div(n3, n2));
                        n7 = cFP.toInt(n13 + n14);
                        if (n7 < 0 && n3 > 0) {
                            cBall.collided(1, n, n4, n5, n6, n7);
                            break block0;
                        }
                        if (n7 < 16 || n3 >= 0) continue;
                        cBall.collided(0, n, n4, n5, n9, n10);
                        break block0;
                    } while (n11++ <= 25);
                    break;
                }
                if (n3 == 0) break;
                int n16 = cFP.mul(cFP.toFP(n7), cFP.div(n2, n3));
                int n17 = cFP.toFP(n6) - n16;
                int n18 = n8 = n3 < 0 ? 1 : -1;
                if (n7 < 0 && n3 > -16384) {
                    cBall.collided(1, n, n4, n5, n6, n7);
                    break;
                }
                if (n7 >= 16 && n3 < 16384) {
                    cBall.collided(0, n, n4, n5, n9, n10);
                    break;
                }
                do {
                    if ((n7 += n8) < 0 && n3 > 0) {
                        cBall.collided(1, n, n4, n5, n6, n7);
                        break block0;
                    }
                    if (n7 >= 16 && n3 < 0) {
                        cBall.collided(0, n, n4, n5, n9, n10);
                        break block0;
                    }
                    n16 = cFP.mul(cFP.toFP(n7), cFP.div(n2, n3));
                    n6 = cFP.toInt(n16 + n17);
                    if (n6 < 0 && n2 > 0) {
                        cBall.collided(3, n, n4, n5, n9 + 2, n10);
                        break block0;
                    }
                    if (n6 < 16 || n2 <= 0) continue;
                    cBall.collided(2, n, n4, n5, n9, n10);
                    break block0;
                } while (n11++ <= 25);
                break;
            }
            case 6: {
                cBall.checkHoleCollision(n4, n5, n2, n3, n6, n7);
                break;
            }
            case 18: 
            case 19: {
                cBall.checkCeilingSlopeCollision(n, n4, n5, n6, n7);
                break;
            }
            default: {
                cBall.checkSlopeCollision(n, n4, n5, n6, n7);
            }
            case 0: 
            case 4: 
            case 26: 
        }
    }

    private static void checkCollisionsWest(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 18: {
                cBall.checkCeilingSlopeCollision(n, n2, n3 - 1, n4 + 16, n5);
            }
            case 0: 
            case 4: 
            case 24: 
            case 26: {
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 21: 
            case 25: {
                cBall.collided(2, n, n2, n3 - 1, n4 + 16, n5);
                break;
            }
            default: {
                cBall.checkSlopeCollision(n, n2, n3 - 1, n4 + 16, n5);
            }
        }
    }

    private static void checkCollisionsEast(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 19: {
                cBall.checkCeilingSlopeCollision(n, n2, n3 + 1, n4 - 16, n5);
            }
            case 0: 
            case 4: 
            case 24: 
            case 26: {
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 22: 
            case 23: 
            case 25: {
                cBall.collided(3, n, n2, n3 + 1, n4 - 16, n5);
                break;
            }
            default: {
                cBall.checkSlopeCollision(n, n2, n3 + 1, n4 - 16, n5);
            }
        }
    }

    private static void checkCollisionsNorth(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 18: 
            case 19: {
                cBall.checkCeilingSlopeCollision(n, n2 - 1, n3, n4, n5 + 16);
            }
            case 0: {
                break;
            }
            case 21: 
            case 23: {
                cBall.checkSlopeCollision(n, n2 - 1, n3, n4, n5 + 16);
                break;
            }
            default: {
                cBall.collided(0, n, n2 - 1, n3, n4, n5 + 16);
            }
        }
    }

    private static void checkCollisionsSouth(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n) {
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 24: 
            case 25: 
            case 26: {
                cBall.collided(1, n, n2 + 1, n3, n6, n7 - 16);
            }
            case 0: {
                break;
            }
            case 6: {
                cBall.checkHoleCollision(n2 + 1, n3, n4, n5, n6, n7 - 16);
                break;
            }
            default: {
                cBall.checkSlopeCollision(n, n2 + 1, n3, n6, n7 - 16);
            }
        }
    }

    private static void checkCollisionsNorthWest(int n, int n2, int n3, int n4, int n5, byte by) {
        switch (n) {
            case 2: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                cBall.checkSlopeCollision(n, n2 - 1, n3 - 1, n4 + 16, n5 + 16);
            }
            case 0: {
                break;
            }
            case 18: 
            case 19: {
                cBall.checkCeilingSlopeCollision(n, n2 - 1, n3 - 1, n4 + 16, n5 + 16);
                break;
            }
            default: {
                if (cCourse.mCollisionInfo[n2 - 1][n3] == 1 || cCourse.mCollisionInfo[n2 - 1][n3] == 18) break;
                if (by == 1) {
                    cBall.collided(2, n, n2 - 1, n3 - 1, n4 + 16, n5 + 16);
                    break;
                }
                cBall.collided(0, n, n2 - 1, n3 - 1, n4 + 16, n5 + 16);
            }
        }
    }

    private static void checkCollisionsNorthEast(int n, int n2, int n3, int n4, int n5, byte by) {
        switch (n) {
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                cBall.checkSlopeCollision(n, n2 - 1, n3 + 1, n4 - 16, n5 + 16);
            }
            case 0: {
                break;
            }
            case 18: 
            case 19: {
                cBall.checkCeilingSlopeCollision(n, n2 - 1, n3 + 1, n4 - 16, n5 + 16);
                break;
            }
            default: {
                if (cCourse.mCollisionInfo[n2 - 1][n3] == 1 || cCourse.mCollisionInfo[n2 - 1][n3] == 19) break;
                if (by == 1) {
                    cBall.collided(3, n, n2 - 1, n3 + 1, n4 - 16, n5 + 16);
                    break;
                }
                cBall.collided(0, n, n2 - 1, n3 + 1, n4 - 16, n5 + 16);
            }
        }
    }

    private static void checkCollisionsSouthEW(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte by, byte by2) {
        int n8 = n3 + (by2 == 1 ? 1 : -1);
        int n9 = n6 + (by2 == 1 ? -16 : 16);
        switch (n) {
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                if (by == 1) {
                    if (by2 == 1 && n == 19 || by2 == 0 && n == 18) {
                        cBall.checkCeilingSlopeCollision(n, n2 + 1, n8, n9, n7 - 16);
                        break;
                    }
                    if (n == 4) break;
                    if (by2 == 1) {
                        cBall.collided(3, n, n2 + 1, n8, n9, n7 - 16);
                        break;
                    }
                    cBall.collided(2, n, n2 + 1, n8, n9, n7 - 16);
                    break;
                }
                cBall.collided(1, n, n2 + 1, n8, n9, n7 - 16);
                break;
            }
            default: {
                cBall.checkSlopeCollision(n, n2 + 1, n8, n9, n7 - 16);
            }
            case 0: {
                break;
            }
            case 6: {
                cBall.checkHoleCollision(n2 + 1, n8, n4, n5, n9, n7 - 16);
            }
        }
    }

    private static void initCollisionData(int n, int n2) {
        SE = 0;
        SW = 0;
        NE = 0;
        NW = 0;
        W = 0;
        E = 0;
        S = 0;
        N = 0;
        M = 0;
        if (n <= 0) {
            return;
        }
        M = cCourse.mCollisionInfo[n][n2];
        N = n2 >= 0 && n2 + 1 - cCourse.mTotCols < 0 ? cCourse.mCollisionInfo[n - 1][n2] : (byte)1;
        NW = n2 > 0 && n2 - cCourse.mTotCols < 0 ? cCourse.mCollisionInfo[n - 1][n2 - 1] : (byte)1;
        NE = n2 + 1 >= 0 && n2 + 2 - cCourse.mTotCols < 0 ? cCourse.mCollisionInfo[n - 1][n2 + 1] : (byte)1;
        W = n2 <= 0 ? (byte)1 : cCourse.mCollisionInfo[n][n2 - 1];
        E = n2 >= cCourse.mTotCols - 1 ? (byte)1 : cCourse.mCollisionInfo[n][n2 + 1];
        if (n < cCourse.mTotRows - 1) {
            if (n2 >= 0 && n2 + 1 - cCourse.mTotCols < 0) {
                S = cCourse.mCollisionInfo[n + 1][n2];
            }
            if (n2 > 0 && n2 - cCourse.mTotCols < 0) {
                SW = cCourse.mCollisionInfo[n + 1][n2 - 1];
            }
            if (n2 + 1 >= 0 && n2 + 2 - cCourse.mTotCols < 0) {
                SE = cCourse.mCollisionInfo[n + 1][n2 + 1];
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkCollisions(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        block46: {
            int n7;
            int n8;
            int n9;
            block48: {
                block47: {
                    block45: {
                        n6 = cFP.toInt(mFPY) >> 4;
                        n5 = cFP.toInt(mFPX) >> 4;
                        if (n6 >= cCourse.mTotRows || n5 >= cCourse.mTotCols || n5 < 0) {
                            mLost = true;
                            return;
                        }
                        cBall.initCollisionData(n6, n5);
                        mNextFPX = mFPX + n;
                        mNextFPY = mFPY + n2;
                        n4 = cFP.toInt(mNextFPX) - n5 * 16;
                        n3 = cFP.toInt(mNextFPY) - n6 * 16;
                        cBall.checkCollisionsMiddle(M, n, n2, n6, n5, n4, n3);
                        if (mCollided) {
                            return;
                        }
                        if (n4 <= 0 && n3 + 1 + 1 >= 0 && n3 - 1 - 16 <= 0 && M != 2 && n < 0) {
                            cBall.checkCollisionsWest(W, n6, n5, n4, n3);
                            if (mCollided) {
                                return;
                            }
                        } else if (n4 + 1 - 16 + 2 >= 0 && n3 + 1 + 1 >= 0 && n3 - 1 - 16 <= 0 && M != 3 && n > 0) {
                            cBall.checkCollisionsEast(E, n6, n5, n4, n3);
                            if (mCollided) {
                                return;
                            }
                        }
                        if (n3 < 0 && n4 + 1 + 1 >= 0 && n4 - 1 - 16 <= 0 && n2 < 0) {
                            cBall.checkCollisionsNorth(N, n6, n5, n4, n3);
                            if (mCollided) {
                                return;
                            }
                        } else if (M == 0 && n3 + 1 + 2 - 16 >= 0 && n4 + 1 + 1 >= 0 && n4 - 1 - 16 <= 0 && n2 >= 0) {
                            cBall.checkCollisionsSouth(S, n6, n5, n, n2, n4, n3);
                            if (mCollided) {
                                return;
                            }
                        }
                        if (n4 + 1 - 16 + 1 < 0 || n3 >= 0 || n2 >= 0 || n <= 0) break block45;
                        n9 = mNextFPY - cFP.toFP(n6 * 16 + 1);
                        n8 = mNextFPX - cFP.toFP((n5 + 1) * 16 - 1 - 1);
                        if (n8 != 0) {
                            n7 = -Math.abs(cFP.div(n9, n8));
                            if (cFP.div(n2, n) <= n7) {
                                cBall.checkCollisionsEast(E, n6, n5, n4, n3);
                                if (!mCollided) {
                                    cBall.checkCollisionsNorthEast(NE, n6, n5, n4, n3, (byte)0);
                                }
                            } else {
                                cBall.checkCollisionsNorth(N, n6, n5, n4, n3);
                                if (!mCollided) {
                                    cBall.checkCollisionsNorthEast(NE, n6, n5, n4, n3, (byte)1);
                                }
                            }
                            if (mCollided) {
                                return;
                            }
                        }
                        break block46;
                    }
                    if (n4 > 0 || n3 >= 0 || n2 >= 0 || n >= 0) break block47;
                    n9 = mNextFPY - cFP.toFP(n6 * 16 + 1);
                    n8 = mNextFPX - cFP.toFP(n5 * 16 + 1);
                    if (n8 != 0) {
                        n7 = Math.abs(cFP.div(n9, n8));
                        if (cFP.div(n2, n) >= n7) {
                            cBall.checkCollisionsWest(W, n6, n5, n4, n3);
                            if (!mCollided) {
                                cBall.checkCollisionsNorthWest(NW, n6, n5, n4, n3, (byte)0);
                            }
                        } else {
                            cBall.checkCollisionsNorth(N, n6, n5, n4, n3);
                            if (!mCollided) {
                                cBall.checkCollisionsNorthWest(NW, n6, n5, n4, n3, (byte)1);
                            }
                        }
                        if (mCollided) {
                            return;
                        }
                    }
                    break block46;
                }
                if (n4 > 0 || n3 + 1 + 1 - 16 < 0 || n2 <= 0 || n >= 0) break block48;
                n9 = mNextFPY - cFP.toFP((n6 + 1) * 16 - 1 - 1);
                n8 = mNextFPX - cFP.toFP(n5 * 16 + 1);
                if (n8 != 0) {
                    n7 = -Math.abs(cFP.div(n9, n8));
                    if (cFP.div(n2, n) >= n7) {
                        cBall.checkCollisionsSouth(S, n6, n5, n, n2, n4, n3);
                        if (!mCollided) {
                            cBall.checkCollisionsSouthEW(SW, n6, n5, n, n2, n4, n3, (byte)1, (byte)0);
                        }
                    } else {
                        cBall.checkCollisionsWest(W, n6, n5, n4, n3);
                        if (!mCollided) {
                            cBall.checkCollisionsSouthEW(SW, n6, n5, n, n2, n4, n3, (byte)0, (byte)0);
                        }
                    }
                    if (mCollided) {
                        return;
                    }
                }
                break block46;
            }
            if (n4 + 1 + 1 - 16 >= 0 && n3 + 1 + 1 - 16 >= 0 && n2 > 0 && n > 0) {
                n9 = mNextFPY - cFP.toFP((n6 + 1) * 16 - 1 - 1);
                n8 = mNextFPX - cFP.toFP((n5 + 1) * 16 - 1 - 1);
                if (n8 != 0) {
                    n7 = Math.abs(cFP.div(n9, n8));
                    if (cFP.div(n2, n) <= n7) {
                        cBall.checkCollisionsSouth(S, n6, n5, n, n2, n4, n3);
                        if (!mCollided) {
                            cBall.checkCollisionsSouthEW(SE, n6, n5, n, n2, n4, n3, (byte)1, (byte)1);
                        }
                    } else {
                        cBall.checkCollisionsEast(E, n6, n5, n4, n3);
                        if (!mCollided) {
                            cBall.checkCollisionsSouthEW(SE, n6, n5, n, n2, n4, n3, (byte)0, (byte)1);
                        }
                    }
                    if (mCollided) {
                        return;
                    }
                }
            }
        }
        if (cObjects.checkSpringCollision(mFPX, mFPY, n2, n, cObjects.mSprSprings, 32, 6, 3) || cObjects.checkSpringCollision(mFPX, mFPY, mNextFPY - mFPY, mNextFPX - mFPX, cObjects.mSprSprings45L, 37, 6, 5) || cObjects.checkSpringCollision(mFPX, mFPY, mNextFPY - mFPY, mNextFPX - mFPX, cObjects.mSprSprings45R, 37, 6, 4)) {
            mRoll = (byte)2;
            return;
        }
        if ((S == 0 || S == 4 || S == 24 || S == 3 || S == 8 || S == 9 || S == 12 || S == 13 || S == 14 || S == 2 || S == 10 || S == 11 || S == 15 || S == 16 || S == 17 || S == 21 || S == 20 || S == 23 || S == 22) && mRoll != 0) {
            mRoll = 0;
            return;
        }
        if (S == 6) {
            cBall.checkHoleCollision(n6 + 1, n5, n, n2, n4, n3 - 16);
            return;
        }
        if (S == 5 && mRoll == 1) {
            cBall.collidedBunker(mFPDY);
            return;
        }
        if (S == 25 && mRoll == 1) {
            if (cCanvas.mPowerShot) {
                int n10 = n6 + 1;
                while (cCourse.mCollisionInfo[n10][n5] == 25) {
                    cCourse.mCollisionInfo[n10][n5] = 0;
                    cCourse.mTiles[n10++][n5] = 102;
                }
                n10 = n6 - 1;
                while (cCourse.mCollisionInfo[n10][n5] == 25) {
                    cCourse.mCollisionInfo[n10][n5] = 0;
                    cCourse.mTiles[n10--][n5] = 102;
                }
                return;
            }
        }
        if (S != 1) return;
        if (mRoll != 1) return;
        cObjects.checkSpringCollision(mFPX, mFPY, n2, n, cObjects.mSprSprings, 32, 6, 3);
    }

    public static byte setAimDirection() {
        int n = 1;
        int n2 = -1;
        int n3 = 200000;
        boolean bl = false;
        if (cCourse.mBallStartFPY > cCourse.mFPHoleY) {
            bl = true;
        }
        for (int i = 0; i < 2; ++i) {
            if (!cObjects.mAimMarker[i].mActive || Math.abs(cObjects.mAimMarker[i].mY - cFP.toInt(mFPY)) >= n3 || (!bl || cObjects.mAimMarker[i].mY >= cFP.toInt(mFPY)) && (bl || cObjects.mAimMarker[i].mY <= cFP.toInt(mFPY))) continue;
            n2 = i;
            n3 = Math.abs(cObjects.mAimMarker[i].mY - cFP.toInt(mFPY));
        }
        if (n2 < 0) {
            if (mFPX > cCourse.mFPHoleX) {
                n = -1;
            }
        } else if (mFPX > cFP.toFP(cObjects.mAimMarker[n2].mX)) {
            n = -1;
        }
        return (byte)n;
    }

    public static void render(Graphics graphics) {
        if (cCanvas.mGameLoopState != 9 && cCanvas.mGameLoopState != 10) {
            Image image = _mImgBall;
            if (!(cCanvas.mGameLoopState != 5 || mDrowned || _mBunkered || mExploded)) {
                int n;
                int n2 = 12;
                for (int i = n = _mTraceCnt % 12; i < n + 12; ++i) {
                    int n3 = i % 12;
                    if (_mTraceX[n3] != 0 && _mTraceY[n3] != 0) {
                        if (cCanvas.mPowerShot) {
                            cCanvas.renderImage(graphics, _mImgBallPower, (n2 - 1) * 7, 0, 7, 7, cFP.toInt(_mTraceX[n3] + cCourse.mFPX) - 2 - 1, cFP.toInt(_mTraceY[n3] + cCourse.mFPY) - 2 - 1);
                        } else {
                            cCanvas.renderImage(graphics, image, (n2 - 1) * 5, 0, 5, 5, cFP.toInt(_mTraceX[n3] + cCourse.mFPX) - 2, cFP.toInt(_mTraceY[n3] + cCourse.mFPY) - 2);
                        }
                    }
                    --n2;
                }
                if (cCanvas.mPowerShot) {
                    _mSprBallGlow.render(graphics, _mImgBallGlow, cFP.toInt(mFPX + cCourse.mFPX) - 4, cFP.toInt(mFPY + cCourse.mFPY) - 4);
                }
            } else if (!mHoled && !mExploded) {
                cCanvas.renderImage(graphics, image, 0, 0, 5, 5, cFP.toInt(mFPX + cCourse.mFPX) - 2, cFP.toInt(mFPY + cCourse.mFPY) - 2);
            }
        }
    }

    public static void close() {
        _mCanvas = null;
        _mImgBall = null;
        _mImgBallPower = null;
        _mImgBallGlow = null;
        _mImgCrosshair = null;
    }
}

