/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.models;

import bbs.framework.helper.BBSKeys;
import bbs.framework.helper.BBSSound;
import bbs.framework.helper.BBSThreading;
import bbs.framework.interfaces.BBSIGame;
import bbs.framework.library.BBSFonts;
import bbs.framework.library.BBSTile;
import bbs.framework.models.BBSLoader;
import bbs.framework.models.BBSMenu;
import bbs.framework.models.BBSStory;
import bbs.framework.starter.BBSStarter;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public abstract class BBSGame
extends GameCanvas
implements BBSIGame {
    public boolean vibration = false;
    public boolean music = false;
    public boolean soundfx = false;
    public boolean released = true;
    private boolean clicked = false;
    private boolean dragged = false;
    private boolean isTouch = false;
    public int stage = 1;
    public int dState = 0;
    public int w;
    public int h;
    public int gameState = 0;
    public int pauseState = 0;
    private int keyState = 0;
    private int poix = 0;
    private int poiy = 0;
    public long currentTimeMillis = System.currentTimeMillis();
    private long lastTouch = 0L;
    private long lastFire = 0L;
    public String[] fontNames;
    public Hashtable cache = new Hashtable();
    private BBSKeys kcol = new BBSKeys();
    public BBSTile tileSet;
    protected BBSMenu menu;
    protected BBSLoader loader;
    protected BBSStory story;
    private Graphics offScreen;
    public BBSStarter instance;
    private Vector threads = new Vector();
    public int goToMenu = 1;

    public BBSGame(BBSStarter inst) {
        super(true);
        this.instance = inst;
    }

    public final void start() {
        this.fontNames = this.getGameFonts();
        this.sizeChanged(this.getWidth(), this.getHeight());
        this.threads.addElement(new BBSThreading(this, BBSThreading.tAnim));
        this.threads.addElement(new BBSThreading(this, BBSThreading.tDraw));
        this.threads.addElement(new BBSThreading(this, BBSThreading.tPlay));
        this.gameState = 1;
    }

    protected final void sizeChanged(int wn, int hn) {
        if (this.w != wn || this.h != hn) {
            this.w = wn;
            this.h = hn;
            if (this.tileSet != null) {
                this.tileSet.calcTile(this);
            }
            if (this.offScreen == null) {
                this.offScreen = this.getGraphics();
            }
        }
    }

    public final void loadSound(String file) {
        if (this.soundfx) {
            BBSSound.loadSound(this, file, false);
        }
    }

    public final void loadMusic(String file) {
        if (this.music) {
            BBSSound.loadSound(this, file, true);
        }
    }

    public final void playMusic(String file) {
        if (this.music) {
            BBSSound.playSound(this, file);
        }
    }

    public final void playSound(String file) {
        if (this.soundfx) {
            BBSSound.playSound(this, file);
        }
    }

    public final void stopMusic(String file) {
        BBSSound.stopSound(this, file);
    }

    public final Image loadImage(String address) {
        Image tempImage = null;
        if (this.cache.containsKey(address)) {
            tempImage = (Image)this.cache.get(address);
        }
        if (tempImage == null) {
            try {
                tempImage = Image.createImage((String)("/res/" + address));
                this.cache.put(address, tempImage);
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tempImage;
    }

    public final Object addCache(String key, Object data) {
        this.cache.put(key, data);
        return data;
    }

    public final Object getCache(String key) {
        Object ret = null;
        if (this.cache.containsKey(key)) {
            ret = this.cache.get(key);
        }
        return ret;
    }

    public final void removeCache(String address) {
        if (this.cache.containsKey(address)) {
            this.cache.remove(address);
            System.gc();
        }
    }

    public void clearCache() {
        BBSSound.removeSounds(this);
        if (this.tileSet != null) {
            this.tileSet.freeResources();
            this.tileSet = null;
        }
        this.cache.clear();
        System.gc();
    }

    public BBSFonts loadFont(int font) {
        if (!this.cache.containsKey(this.fontNames[font - 1])) {
            this.cache.put(this.fontNames[font - 1], new BBSFonts(this, this.fontNames[font - 1]));
        }
        return (BBSFonts)this.cache.get(this.fontNames[font - 1]);
    }

    public final void drawText(Graphics g, int x, int y, String s, char[] sc, int font, int align) {
        BBSFonts fonts = this.loadFont(font);
        if (fonts.fontSet != null) {
            int len = 0;
            char c = '\u0000';
            if (s != null) {
                len = s.length();
            }
            if (sc != null) {
                len = sc.length;
            }
            if (len > 0) {
                int index;
                int txtWidth = 0;
                for (int cnt = 1; cnt <= len; ++cnt) {
                    if (s != null) {
                        c = s.charAt(cnt - 1);
                    }
                    if (sc != null) {
                        c = sc[cnt - 1];
                    }
                    if ((index = fonts.letters.indexOf(c)) == -1) continue;
                    txtWidth += 7 * fonts.map[index][2] / 10;
                }
                switch (align) {
                    case 8: {
                        x -= txtWidth;
                        break;
                    }
                    case 1: {
                        x -= txtWidth / 2;
                    }
                }
                for (int cnt = 1; cnt <= len; ++cnt) {
                    if (s != null) {
                        c = s.charAt(cnt - 1);
                    }
                    if (sc != null) {
                        c = sc[cnt - 1];
                    }
                    if ((index = fonts.letters.indexOf(c)) == -1) continue;
                    int[] map = fonts.map[index];
                    if (x > -map[2] && x < this.w + map[2] && y > -map[3] && y < this.h + map[3]) {
                        g.drawRegion(fonts.fontSet, map[0], map[1], map[2], map[3], 0, x, y, 0);
                    }
                    x += 7 * map[2] / 10;
                }
                Object map = null;
            }
            fonts = null;
        }
    }

    public final void callMenu(int toDirectory) {
        this.goToMenu = toDirectory;
        this.gameState = 1;
    }

    public final void vibrate(int duration) {
        if (this.vibration) {
            try {
                Display.getDisplay((MIDlet)this.instance).vibrate(duration);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean onceInMs(long time, int duration) {
        return time % (long)duration == 0L;
    }

    private static int getTouchCode(int w, int h, int poix, int poiy, boolean dragged) {
        int size = Math.min(w / 6, h / 6);
        int retCode = 0;
        if (poix >= w - 3 * size / 2 && poiy > h - 7 * size / 2) {
            retCode += 32;
        }
        if (poix <= w - 5 * size / 2 && poix > w - size * 4 && poiy > h - 7 * size / 2) {
            retCode += 4;
        }
        if (poix > w - size * 4 && poiy >= h - size) {
            retCode += 64;
        }
        if (poix > w - size * 4 && poiy <= h - size * 2 && poiy > h - 7 * size / 2) {
            retCode += 2;
        }
        if (!dragged && poix > w - 5 * size / 2 && poix < w - 3 * size / 2 && poiy > h - size * 2 && poiy < h - size) {
            retCode += 256;
        }
        if (!dragged && poix > size && poix < size * 2 && poiy > h - size * 2 && poiy < h - size) {
            retCode += 512;
        }
        if (retCode > 0) {
            dragged = true;
        }
        return retCode;
    }

    private static BBSKeys getAction(BBSKeys kcol, int key) {
        kcol.clear();
        if ((key & 4) != 0) {
            kcol.left = true;
        }
        if ((key & 0x20) != 0) {
            kcol.right = true;
        }
        if ((key & 2) != 0) {
            kcol.up = true;
        }
        if ((key & 0x40) != 0) {
            kcol.down = true;
        }
        if ((key & 0x100) != 0) {
            kcol.fire = true;
        }
        if ((key & 0x200) != 0) {
            kcol.game_a = true;
        }
        if ((key & 0x400) != 0) {
            kcol.game_b = true;
        }
        if ((key & 0x800) != 0) {
            kcol.game_c = true;
        }
        if ((key & 0x1000) != 0) {
            kcol.game_d = true;
        }
        return kcol;
    }

    private void drawTouchPad(Graphics g) {
        if (this.isTouch && this.currentTimeMillis - this.lastTouch < 5000L) {
            int size = Math.min(this.w / 6, this.h / 6);
            g.setColor(200, 200, 100);
            g.drawRect(size, this.h - size * 2, size, size);
            g.drawRect(size + 2, this.h - size * 2 + 2, size - 4, size - 4);
            g.fillTriangle(this.w - 5 * size / 2, this.h - size * 2, this.w - 3 * size / 2, this.h - size * 2, this.w - size * 2, this.h - size * 2 - size / 4);
            g.fillTriangle(this.w - 5 * size / 2, this.h - size * 2, this.w - 5 * size / 2, this.h - size, this.w - 5 * size / 2 - size / 4, this.h - 3 * size / 2);
            g.fillTriangle(this.w - 5 * size / 2, this.h - size, this.w - 3 * size / 2, this.h - size, this.w - size * 2, this.h - size + size / 4);
            g.fillTriangle(this.w - 3 * size / 2, this.h - size * 2, this.w - 3 * size / 2, this.h - size, this.w - 3 * size / 2 + size / 4, this.h - 3 * size / 2);
        }
    }

    public final void hideNotify() {
        this.pauseApp();
    }

    public final void showNotify() {
        this.resumeApp();
    }

    public void pauseApp() {
        if (this.gameState == 5) {
            this.pauseState = this.gameState;
            this.gameState = 6;
        }
    }

    public final void resumeApp() {
        if (this.gameState == 6) {
            this.gameState = this.pauseState;
        }
    }

    public void quitApp() {
        this.instance.quitApp();
    }

    public void freeResources() {
        BBSSound.removeSounds(this);
        this.gameState = 10;
        BBSGame.sleepDelay(300L);
        this.instance = null;
    }

    public static void sleepDelay(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void pointerPressed(int x, int y) {
        this.poix = x;
        this.poiy = y;
        this.clicked = true;
        if (!this.isTouch) {
            this.touchpadActivated();
        }
        this.isTouch = true;
        this.lastTouch = this.currentTimeMillis;
    }

    protected final void pointerReleased(int x, int y) {
        this.clicked = false;
        this.lastTouch = this.currentTimeMillis;
    }

    protected final void pointerDragged(int x, int y) {
        this.poix = x;
        this.poiy = y;
        this.lastTouch = this.currentTimeMillis;
    }

    protected void touchpadActivated() {
    }

    public final void doDraw() {
        while (this.gameState != 10) {
            if (this.dState == 1) {
                this.drawScreen(this.offScreen);
                this.drawTouchPad(this.offScreen);
                this.flushGraphics();
                this.dState = 0;
            }
            this.currentTimeMillis = System.currentTimeMillis();
            BBSGame.sleepDelay(5L);
        }
    }

    public final void doPlay() {
        while (this.gameState != 10) {
            BBSSound.playSounds(this);
            BBSGame.sleepDelay(30L);
        }
    }

    public final void doAnim() {
        int delayTime = 30;
        long ts = this.currentTimeMillis;
        int time = 0;
        while (this.gameState != 10) {
            this.keyState = this.getKeyStates();
            if (this.clicked) {
                this.keyState = BBSGame.getTouchCode(this.w, this.h, this.poix, this.poiy, this.dragged);
            } else {
                this.dragged = false;
            }
            if (this.keyState != 0) {
                BBSGame.getAction(this.kcol, this.keyState);
                if (this.kcol.fire) {
                    if (this.released && this.currentTimeMillis - this.lastFire < 240L) {
                        this.kcol.lfire = true;
                        this.kcol.fire = false;
                    }
                    this.lastFire = this.currentTimeMillis;
                }
                this.keyAction(this.kcol, time);
            }
            this.doAnimation(time);
            this.dState = 1;
            this.released = this.keyState == 0;
            if ((time += delayTime) > 120000) {
                time = 0;
            }
            this.currentTimeMillis = System.currentTimeMillis();
            long wMs = Math.max((long)delayTime - (this.currentTimeMillis - ts), 0L);
            ts = this.currentTimeMillis;
            if (wMs <= 0L) continue;
            BBSGame.sleepDelay(wMs);
        }
    }

    public void drawSpriteLayerSprites(Graphics g, int tx, int ty) {
    }

    public void drawLayerSprites(Graphics g, int zorder) {
    }

    protected void keyPress(int keyCode) {
    }

    protected void keyPressed(int keyCode) {
        String name = this.getKeyName(keyCode).toLowerCase();
        if (name.startsWith("soft")) {
            this.keyPress(name.charAt(name.length() - 1) - 48);
        } else {
            switch (keyCode) {
                case -202: 
                case -21: 
                case -11: 
                case -6: 
                case 21: 
                case 105: {
                    this.keyPress(1);
                    break;
                }
                case -203: 
                case -22: 
                case -12: 
                case -7: 
                case 22: 
                case 106: {
                    this.keyPress(2);
                }
            }
        }
        name = null;
    }

    protected void doAnimation(int time) {
        if (this.gameState != 0) {
            if (this.gameState == 1) {
                if (this.menu != null) {
                    this.menu.doAnimation(this, time);
                } else {
                    this.clearCache();
                    this.menu = this.getGameMenu();
                    this.menu.directory = this.goToMenu;
                    this.goToMenu = 1;
                }
            } else if (this.gameState == 2) {
                if (this.story != null) {
                    this.story.doAnimation(this, time);
                } else {
                    this.menu = null;
                    this.clearCache();
                    this.story = this.getGameStory();
                }
            } else if (this.gameState == 3 || this.gameState == 4) {
                if (this.loader != null) {
                    this.loader.doAnimation(this, time);
                } else {
                    this.menu = null;
                    this.story = null;
                    this.clearCache();
                    this.loader = this.getGameLoader();
                    this.stageLoading();
                }
            } else {
                if (this.loader != null) {
                    this.menu = null;
                    this.story = null;
                    this.loader = null;
                }
                this.classAnimation(time);
                this.stageAnimation(time);
            }
        }
    }

    protected void drawScreen(Graphics g) {
        if (this.gameState != 0) {
            if (this.gameState == 1) {
                if (this.menu != null) {
                    this.menu.drawScreen(this, g);
                }
            } else if (this.gameState == 2) {
                if (this.story != null) {
                    this.story.drawScreen(this, g);
                }
            } else if (this.gameState == 3 || this.gameState == 4) {
                if (this.loader != null) {
                    this.loader.drawScreen(this, g, this.stage);
                }
            } else {
                this.stageDraw(g);
            }
        }
    }

    public void keyAction(BBSKeys kcol, int time) {
        if (this.gameState != 0) {
            if (this.gameState == 1) {
                if (this.menu != null && this.released) {
                    this.menu.keyPress(this, kcol, time);
                }
            } else if (this.gameState == 2) {
                if (this.story != null && this.released) {
                    this.story.keyPress(this, kcol, time);
                }
            } else if (this.gameState == 3 || this.gameState == 4) {
                if (this.loader != null && this.released) {
                    this.loader.keyPress(this, kcol, time);
                }
            } else {
                this.keyPress(kcol, time);
            }
        }
    }

    public abstract String[] getGameFonts();

    public abstract BBSMenu getGameMenu();

    public abstract BBSLoader getGameLoader();

    public abstract BBSStory getGameStory();

    public abstract void stageLoading();

    public abstract void stageStart();

    public abstract void stageEnd();

    public abstract void stageDraw(Graphics var1);

    public abstract void classAnimation(int var1);

    public abstract void stageAnimation(int var1);

    public abstract void keyPress(BBSKeys var1, int var2);
}

