/*
 * Decompiled with CFR 0.152.
 */
package game;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.library.BBSSprite;
import bbs.framework.library.BBSTile;
import bbs.framework.models.BBSObjectFactory;
import game.SpaceKidGame;
import res.smarts.Card;
import res.smarts.Elevator;
import res.smarts.Energy;
import res.smarts.Gear;
import res.smarts.Generator;
import res.smarts.Gun;
import res.smarts.Marty;
import res.smarts.Mum;
import res.smarts.Passage;
import res.smarts.PowerCell;
import res.smarts.Robot1;
import res.smarts.Robot2;
import res.smarts.Robot3;
import res.smarts.SpaceShip;

public class SpaceKidObjects
extends BBSObjectFactory {
    public static final int oMarty = 1;
    public static final int oEnergy = 2;
    public static final int oGun = 3;
    public static final int oPower = 4;
    public static final int oRobot1 = 5;
    public static final int oRobot2 = 6;
    public static final int oRobot3 = 7;
    public static final int oShip = 8;
    public static final int oCard = 9;
    public static final int oGear = 10;
    public static final int oElevator = 11;
    public static final int oPassage = 12;
    public static final int oMum = 13;
    public static final int oGenerator = 14;
    public static final int sRoboBullet = 1;
    public static final int sMartyBullet = 2;
    public static final int sTakeGun = 3;
    public static final int sTakePower = 4;
    public static final int sSpaceShip = 5;
    public static final int sTakeCard = 6;
    public static final int sTakeGear = 7;
    public static final int sTakeElevator = 8;
    public static final int sPassage = 9;
    public static final int sMum = 10;
    public static final int sZap = 11;
    public static final int tPush = 1;
    public static final int tObstacle = 2;
    public static final int tObstacleBoth = 3;
    public static final int tObstacleTop = 4;
    public static final int tHung = 5;
    public static final int tStep = 6;
    public static final int tObstacleBottom = 7;
    public static final int aMoveUp = 1;
    public static final int aMoveDown = 2;

    public void objectFactory(BBSSmartGame game, String[] params, int id) {
        String type = params[0];
        if (type.equals("Marty")) {
            ((SpaceKidGame)game).marty = Marty.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 1, id, game.getSmart(Integer.parseInt(params[3])));
            game.addSmart(((SpaceKidGame)game).marty);
        } else if (type.equals("Energy")) {
            game.addSmart(Energy.create(game, Integer.parseInt(params[1]), 2, id, Integer.parseInt(params[2])));
        } else if (type.equals("Gun")) {
            game.addSmart(Gun.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 3, id));
        } else if (type.equals("Power")) {
            game.addSmart(PowerCell.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 4, id));
        } else if (type.equals("Robot1")) {
            game.addSmart(Robot1.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 5, id));
        } else if (type.equals("Robot2")) {
            game.addSmart(Robot2.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 6, id));
        } else if (type.equals("Robot3")) {
            game.addSmart(Robot3.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 7, id));
        } else if (type.equals("SpaceShip")) {
            game.addSmart(SpaceShip.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 8, id));
        } else if (type.equals("Card")) {
            game.addSmart(Card.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 9, id));
        } else if (type.equals("Gear")) {
            game.addSmart(Gear.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 10, id));
        } else if (type.equals("Elevator")) {
            game.addSmart(Elevator.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 11, id, params[3], Integer.parseInt(params[4]), Integer.parseInt(params[5]), Integer.parseInt(params[6])));
        } else if (type.equals("Passage")) {
            game.addSmart(Passage.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 12, id));
        } else if (type.equals("Mum")) {
            game.addSmart(Mum.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 13, id));
        } else if (type.equals("Generator")) {
            game.addSmart(Generator.create(game, Integer.parseInt(params[1]), Integer.parseInt(params[2]), 14, id));
        }
    }

    public int checkTileInteraction(BBSSprite bbss, BBSTile bbst, int mode) {
        int ret = 0;
        switch (mode) {
            case 1: {
                ret = bbst.checkCollision(bbss.x, bbss.y + 2);
                if (ret == 206) {
                    ret = 204;
                }
                if (ret != 188) break;
                ret = 204;
                break;
            }
            case 2: {
                ret = bbst.checkCollision(bbss.x, bbss.y - bbst.tileHeight / 4);
                if (ret == 206) {
                    ret = 204;
                }
                if (ret != 188) break;
                ret = 204;
                break;
            }
            case 3: {
                ret = bbst.checkCollision(bbss.x, bbss.y - bbst.tileHeight / 4);
                if (ret == 0) {
                    ret = bbst.checkCollision(bbss.x, bbss.y - 5 * bbst.tileHeight / 4);
                }
                if (ret == 206) {
                    ret = 204;
                }
                if (ret != 188) break;
                ret = 204;
                break;
            }
            case 4: {
                ret = bbst.checkCollision(bbss.x, bbss.y - 5 * bbst.tileHeight / 4);
                if (ret == 206) {
                    ret = 204;
                }
                if (ret != 188) break;
                ret = 204;
                break;
            }
            case 7: {
                ret = bbst.checkCollision(bbss.x, bbss.y + 5 * bbst.tileHeight / 4);
                if (ret == 206) {
                    ret = 204;
                }
                if (ret != 188) break;
                ret = 204;
                break;
            }
            case 5: {
                ret = bbst.checkCollision(bbss.x, bbss.y / 32 * 32 - bbss.getFrameHeight());
                if (ret != 207) break;
                ret = 205;
                break;
            }
            case 6: {
                if (bbss.faceTo == 1) {
                    ret = bbst.checkCollision(bbss.x + bbss.getFrameHeight() / 6, bbss.y);
                }
                if (bbss.faceTo != -1) break;
                ret = bbst.checkCollision(bbss.x - bbss.getFrameHeight() / 6, bbss.y);
            }
        }
        return ret;
    }

    public boolean checkSpriteInteraction(BBSSprite source, BBSSprite destination, int mode) {
        switch (mode) {
            case 8: {
                return Math.abs(destination.x - source.x) < 48 && Math.abs(destination.y - source.y) < 10;
            }
            case 6: {
                return Math.abs(destination.x - source.x) < 10 && Math.abs(destination.y - source.y) < 10;
            }
            case 7: {
                return Math.abs(destination.x - source.x) < 10 && Math.abs(destination.y - source.y) < 10;
            }
            case 4: {
                return Math.abs(destination.x - source.x) < 10 && Math.abs(destination.y - source.y) < 10;
            }
            case 3: {
                return Math.abs(destination.x - source.x) < 10 && Math.abs(destination.y - source.y) < 10;
            }
            case 2: {
                return Math.abs(destination.x - source.x) < source.getFrameWidth() * 2 && Math.abs(destination.y - source.y) < destination.getFrameHeight() && destination.y > source.y;
            }
            case 1: {
                return Math.abs(destination.x - source.x) < source.getFrameWidth() * 2 && Math.abs(destination.y - source.y) < destination.getFrameHeight() && destination.y > source.y;
            }
            case 5: {
                return Math.abs(destination.x - source.x) < source.getFrameWidth() / 2 && Math.abs(destination.y - source.y) < 10;
            }
            case 9: {
                return Math.abs(destination.x - source.x) < source.getFrameWidth() && Math.abs(destination.y - source.y) < source.getFrameHeight();
            }
            case 10: {
                return Math.abs(destination.x - source.x) < source.getFrameWidth() / 2 && Math.abs(destination.y - source.y) < 10;
            }
            case 11: {
                return Math.abs(destination.x - source.x) < 48 && Math.abs(destination.y - source.y) < 20;
            }
        }
        return false;
    }
}

