/*
 * Decompiled with CFR 0.152.
 */
package framework.math;

import framework.math.FP;
import framework.math.Vector2D;

public class MathUtils {
    public static final Vector2D tmp1 = new Vector2D();
    public static final Vector2D tmp2 = new Vector2D();
    public static int sqrtPrecision = 10;
    public static final int[] sin8 = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 128, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 128, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0};
    public static final int[] tan8 = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 45, 49, 54, 59, 63, 68, 73, 78, 83, 88, 93, 98, 103, 108, 113, 119, 124, 130, 136, 141, 147, 153, 159, 166, 172, 179, 185, 192, 200, 207, 214, 222, 230, 238, 247, 256, 265, 274, 284, 294, 305, 316, 327, 339, 352, 365, 379, 394, 409, 426, 443, 461, 481, 502, 524, 548, 574, 603, 633, 666, 703, 743, 787, 837, 892, 955, 1026, 1108, 1204, 1317, 1451, 1616, 1821, 2084, 2435, 2926, 3660, 4884, 7330, 14666, Integer.MAX_VALUE};
    public static final short[] atan2Table = MathUtils.buildAtan2Table();
    public static int fp_DIST_APPROX_CONST1 = (41 << FP.SHIFT << FP.SHIFT) / FP.HUNDRED;
    public static int fp_DIST_APPROX_CONST2 = (94 << FP.SHIFT << FP.SHIFT) / FP.HUNDRED;
    private static final Vector2D internalTmp1 = new Vector2D();
    private static final Vector2D internalTmp2 = new Vector2D();

    public static final int powIntInt(int a, int b) {
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        int tmp = MathUtils.powIntInt(a, b >> 1);
        if (b % 2 == 0) {
            return tmp * tmp;
        }
        return tmp * tmp * a;
    }

    public static final int powFixedInt(int fp_x, int n) {
        if (n == 0) {
            return 1 << FP.SHIFT;
        }
        if (n == 1) {
            return fp_x;
        }
        int fp_tmp = MathUtils.powFixedInt(fp_x, n >> 1);
        if (n % 2 == 0) {
            return fp_tmp * fp_tmp >> FP.SHIFT;
        }
        return (fp_tmp * fp_tmp >> FP.SHIFT) * fp_x >> FP.SHIFT;
    }

    public static final int sqrt(int fp_x) {
        if (fp_x == FP.ZERO) {
            return FP.ZERO;
        }
        int fp_result = fp_x;
        for (int k = 0; k < sqrtPrecision; ++k) {
            fp_result = fp_result + (fp_x << FP.SHIFT) / fp_result >> 1;
        }
        return fp_result;
    }

    public static final int distance(Vector2D p1, Vector2D p2) {
        int fp_tmp1 = p2.fp_x - p1.fp_x;
        int fp_tmp2 = p2.fp_y - p1.fp_y;
        return MathUtils.sqrt((fp_tmp1 * fp_tmp1 >> FP.SHIFT) + (fp_tmp2 * fp_tmp2 >> FP.SHIFT));
    }

    public static final int distanceApprox1(Vector2D p1, Vector2D p2) {
        int fp_xDiff = p2.fp_x - p1.fp_x;
        int fp_yDiff = p2.fp_y - p1.fp_y;
        fp_xDiff = fp_xDiff < 0 ? -fp_xDiff : fp_xDiff;
        int n = fp_yDiff = fp_yDiff < 0 ? -fp_yDiff : fp_yDiff;
        if (fp_xDiff < fp_yDiff) {
            int fp_t = fp_xDiff + (fp_xDiff >> 1);
            return fp_yDiff - (fp_yDiff >> 5) - (fp_yDiff >> 7) + (fp_t >> 2) + (fp_t >> 6);
        }
        int fp_t = fp_yDiff + (fp_yDiff >> 1);
        return fp_xDiff - (fp_xDiff >> 5) - (fp_xDiff >> 7) + (fp_t >> 2) + (fp_t >> 6);
    }

    public static final int distanceApprox2(Vector2D p1, Vector2D p2) {
        int fp_xDiff = p2.fp_x - p1.fp_x;
        int fp_yDiff = p2.fp_y - p1.fp_y;
        fp_xDiff = fp_xDiff < 0 ? -fp_xDiff : fp_xDiff;
        int n = fp_yDiff = fp_yDiff < 0 ? -fp_yDiff : fp_yDiff;
        if (fp_xDiff < fp_yDiff) {
            return (fp_DIST_APPROX_CONST1 * fp_xDiff >> FP.SHIFT) + (fp_DIST_APPROX_CONST2 * fp_yDiff >> FP.SHIFT);
        }
        return (fp_DIST_APPROX_CONST2 * fp_xDiff >> FP.SHIFT) + (fp_DIST_APPROX_CONST1 * fp_yDiff >> FP.SHIFT);
    }

    public static final float distanceFloat(float x1, float y1, float x2, float y2) {
        float xDiff = x2 - x1;
        float yDiff = y2 - y1;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public static final int sin(int angle) {
        if (angle <= 180) {
            return sin8[angle];
        }
        return -sin8[angle - 180];
    }

    public static final int cos(int angle) {
        if ((angle = (angle + 90) % 360) <= 180) {
            return sin8[angle];
        }
        return -sin8[angle - 180];
    }

    public static final int acos(int fp_x) {
        int left = 0;
        int right = 180;
        int middle = 0;
        int cosAngle = 0;
        while (left <= right) {
            middle = left + right >> 1;
            cosAngle = middle <= 90 ? sin8[middle + 90] : -sin8[middle - 90];
            if (fp_x > cosAngle) {
                right = middle - 1;
                continue;
            }
            if (fp_x == cosAngle) {
                return middle;
            }
            left = middle + 1;
        }
        return middle;
    }

    public static final int tan(int angle) {
        if (angle <= 90) {
            return tan8[angle];
        }
        if (angle <= 180) {
            return -tan8[180 - angle];
        }
        if (angle <= 270) {
            return tan8[angle - 180];
        }
        return -tan8[360 - angle];
    }

    public static final int atan(int fp_x) {
        int left = 0;
        int right = 90;
        int middle = 0;
        if (fp_x >= 0) {
            while (left <= right) {
                middle = left + right >> 1;
                if (fp_x > tan8[middle]) {
                    left = middle + 1;
                    continue;
                }
                if (fp_x == tan8[middle]) {
                    return middle;
                }
                right = middle - 1;
            }
            return middle;
        }
        while (left <= right) {
            middle = left + right >> 1;
            if (fp_x > -tan8[middle]) {
                right = middle - 1;
                continue;
            }
            if (fp_x == tan8[middle]) {
                return -middle;
            }
            left = middle + 1;
        }
        return -middle;
    }

    public static int atan2(int deltaY, int deltaX) {
        if (deltaX == 0 && deltaY == 0) {
            return 0;
        }
        if (deltaY <= 0) {
            if (deltaX > 0) {
                if (deltaX >= -deltaY) {
                    return atan2Table[(-deltaY << FP.SHIFT) / deltaX];
                }
                return 90 - atan2Table[(deltaX << FP.SHIFT) / -deltaY];
            }
            if (deltaX <= deltaY) {
                return 180 - atan2Table[(deltaY << FP.SHIFT) / deltaX];
            }
            return 90 + atan2Table[(deltaX << FP.SHIFT) / deltaY];
        }
        if (deltaX >= 0) {
            if (deltaX > deltaY) {
                return 360 - atan2Table[(deltaY << FP.SHIFT) / deltaX];
            }
            return 270 + atan2Table[(deltaX << FP.SHIFT) / deltaY];
        }
        if (-deltaX >= deltaY) {
            return 180 + atan2Table[(deltaY << FP.SHIFT) / -deltaX];
        }
        return 270 - atan2Table[(-deltaX << FP.SHIFT) / deltaY];
    }

    public static final void rotate(Vector2D point, Vector2D origin, int angle, Vector2D result) {
        int fp_cos = MathUtils.cos(angle);
        int fp_sin = MathUtils.sin(angle);
        result.fp_x = origin.fp_x + (fp_cos * (point.fp_x - origin.fp_x) >> FP.SHIFT) - (fp_sin * (-point.fp_y + origin.fp_y) >> FP.SHIFT);
        result.fp_y = -(-origin.fp_y + (fp_sin * (point.fp_x - origin.fp_x) >> FP.SHIFT) + (fp_cos * (-point.fp_y + origin.fp_y) >> FP.SHIFT));
    }

    public static final void rotate(Vector2D point, Vector2D origin, int angle) {
        int fp_cos = MathUtils.cos(angle);
        int fp_sin = MathUtils.sin(angle);
        int fp_tmpX = point.fp_x;
        point.fp_x = origin.fp_x + (fp_cos * (point.fp_x - origin.fp_x) >> FP.SHIFT) - (fp_sin * (-point.fp_y + origin.fp_y) >> FP.SHIFT);
        point.fp_y = -(-origin.fp_y + (fp_sin * (fp_tmpX - origin.fp_x) >> FP.SHIFT) + (fp_cos * (-point.fp_y + origin.fp_y) >> FP.SHIFT));
    }

    public static final void rotate(Vector2D point, int angle, Vector2D result) {
        int fp_cos = MathUtils.cos(angle);
        int fp_sin = MathUtils.sin(angle);
        result.fp_x = (fp_cos * point.fp_x >> FP.SHIFT) - (fp_sin * -point.fp_y >> FP.SHIFT);
        result.fp_y = -((fp_sin * point.fp_x >> FP.SHIFT) + (fp_cos * -point.fp_y >> FP.SHIFT));
    }

    public static final int calculateAngle(Vector2D v1, Vector2D v2) {
        int angle = 360 - MathUtils.atan2(v1.fp_y, v1.fp_x);
        MathUtils.rotate(v2, angle, tmp1);
        return MathUtils.atan2(MathUtils.tmp1.fp_y, MathUtils.tmp1.fp_x);
    }

    private static final short[] buildAtan2Table() {
        short[] result = new short[257];
        int angle = 0;
        int value = FP.ZERO;
        for (int i = 0; i <= 256; ++i) {
            if (value < i) {
                angle = (short)(angle + 1);
                value = MathUtils.tan(angle);
            }
            result[i] = angle;
        }
        return result;
    }

    public static final void forceDistanceApprox1(Vector2D point1, Vector2D point2, int fp_wantedDistance, int fp_weight) {
        int fp_distance = MathUtils.distanceApprox1(point1, point2);
        int fp_distanceDiff = fp_wantedDistance - fp_distance;
        internalTmp1.setTo(point2);
        internalTmp1.sub(point1);
        internalTmp1.normalizeApprox1();
        if (fp_distanceDiff > FP.ZERO || fp_distanceDiff < FP.ZERO) {
            internalTmp1.mul(fp_distanceDiff);
            internalTmp2.setTo(internalTmp1);
            internalTmp1.mul(fp_weight);
            point1.sub(internalTmp1);
            internalTmp1.setTo(internalTmp2);
            internalTmp1.mul(FP.ONE - fp_weight);
            point2.add(internalTmp1);
        }
    }

    public static final void forceDistance(Vector2D point1, Vector2D point2, int fp_wantedDistance, int fp_weight) {
        int fp_distance = MathUtils.distance(point1, point2);
        int fp_distanceDiff = fp_wantedDistance - fp_distance;
        internalTmp1.setTo(point2);
        internalTmp1.sub(point1);
        internalTmp1.normalize();
        if (fp_distanceDiff > FP.ZERO || fp_distanceDiff < FP.ZERO) {
            internalTmp1.mul(fp_distanceDiff);
            internalTmp2.setTo(internalTmp1);
            internalTmp1.mul(fp_weight);
            point1.sub(internalTmp1);
            internalTmp1.setTo(internalTmp2);
            internalTmp1.mul(FP.ONE - fp_weight);
            point2.add(internalTmp1);
        }
    }

    public static int whichSide(int u1, int u2, int v1, int v2) {
        int tmp = v1 * u2 - u1 * v2;
        return tmp == 0 ? 0 : (tmp < 0 ? -1 : 1);
    }
}

