/*
 * Decompiled with CFR 0.152.
 */
package framework.utils.resmgr;

import framework.graphics.RotatableSprite;
import framework.graphics.SimpleSprite;
import framework.sound.Music;
import framework.sound.SoundFX;
import framework.utils.FileReader;
import framework.utils.resmgr.IResourcesRequester;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public class ResourcesManager {
    public static final short DONT_NOTIFY = -1;
    private boolean[] isWorking = new boolean[5];
    private Vector freeIds;
    private static final short INITIAL_POOLS_COUNT = 5;
    private static ResourcesManager instance;
    private Hashtable[] pools = new Hashtable[5];
    private Hashtable resourcesInfos;

    private ResourcesManager() {
        this.freeIds = new Vector(5);
        short i = 0;
        while (true) {
            if (i >= 5) break;
            this.isWorking[i] = false;
            this.freeIds.addElement(new Short(i));
            i = (short)(i + 1);
        }
    }

    public void addResource(short poolId, String resourceName, Object obj) {
        if (poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null) {
            throw new RuntimeException("Attempt to add resource " + resourceName + " to empty pool with id: " + poolId + ".");
        }
        if (resourceName == null) {
            throw new RuntimeException("ResourceName can't be null.");
        }
        if (obj == null) {
            throw new RuntimeException("Can't add null object. Resource name: " + resourceName);
        }
        if (this.pools[poolId].put(resourceName, obj) != null) {
            throw new RuntimeException("Key " + resourceName + " alredy exists in pool.");
        }
    }

    public Thread createPool(IResourcesRequester resourcesRequester, String fileName, short notificationFrequency) {
        if (resourcesRequester == null) {
            throw new RuntimeException("You can't pass null as resourcesRequester! How would you know what's the id of created pool?");
        }
        try {
            short newPoolId = (Short)this.freeIds.elementAt(0);
            Thread thread = new Thread(new ResourcesLoader(resourcesRequester, fileName, newPoolId, notificationFrequency));
            this.freeIds.removeElementAt(0);
            this.pools[newPoolId] = new Hashtable();
            this.isWorking[newPoolId] = true;
            thread.start();
            return thread;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            resourcesRequester.onResourcesLoadingProgress((short)-1, (short)-1, "Maximum number of resources pools exceeded.");
            return null;
        }
    }

    public void createPoolSync(IResourcesRequester resourcesRequester, String fileName, short notificationFrequency) {
        Thread thread = this.createPool(resourcesRequester, fileName, notificationFrequency);
        try {
            thread.join();
        }
        catch (InterruptedException exc) {
            throw new RuntimeException("Resources loading thread has been interrupted!");
        }
    }

    public Thread createPool(IResourcesRequester resourcesRequester, String fileName) {
        return this.createPool(resourcesRequester, fileName, (short)5);
    }

    public void createPoolSync(IResourcesRequester resourcesRequester, String fileName) {
        this.createPoolSync(resourcesRequester, fileName, (short)5);
    }

    public static ResourcesManager getInstance() {
        if (instance == null) {
            instance = new ResourcesManager();
        }
        return instance;
    }

    public Object getResource(String resourceName, short poolId) {
        if (poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null) {
            throw new RuntimeException("Attempt to get resource '" + resourceName + "' from non-existing pool (" + poolId + ").");
        }
        try {
            return this.pools[poolId].get(resourceName);
        }
        catch (NullPointerException exc) {
            throw new RuntimeException("Specified key can't be null.");
        }
    }

    public final Enumeration getPoolKeys(short poolId) {
        if (this.poolEmpty(poolId)) {
            throw new RuntimeException("Attempt to access an empty pool with id: " + poolId + ".");
        }
        return this.pools[poolId].keys();
    }

    public final boolean poolEmpty(short poolId) {
        return poolId < 0 || poolId >= this.pools.length || this.pools[poolId] == null;
    }

    public void removePool(short poolId) {
        if (this.isWorking[poolId]) {
            throw new RuntimeException("Couldn't remove the pool: it hasn't loaded yet!");
        }
        this.pools[poolId].clear();
        this.pools[poolId] = null;
        this.freeIds.addElement(new Short(poolId));
        System.gc();
    }

    public void removeResource(short poolId, String resourceName, boolean definitely) {
        if (!this.isWorking[poolId]) {
            this.pools[poolId].remove(resourceName);
            if (definitely && this.resourcesInfos != null) {
                Vector<String> keysToBeRemoved = new Vector<String>();
                Enumeration e = this.resourcesInfos.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    short tmpPoolId = Short.parseShort(key.substring(0, key.indexOf("|")));
                    if (tmpPoolId != poolId) continue;
                    keysToBeRemoved.addElement(key);
                }
                int collectionSize = keysToBeRemoved.size();
                for (int i = 0; i < collectionSize; ++i) {
                    this.resourcesInfos.remove(keysToBeRemoved.elementAt(i));
                }
                if (this.resourcesInfos.size() == 0) {
                    this.resourcesInfos = null;
                }
                keysToBeRemoved = null;
                System.gc();
            }
        } else {
            throw new RuntimeException("Couldn't remove the pool: it hasn't loaded yet!");
        }
    }

    public void removeResource(short poolId, String resourceName) {
        this.removeResource(poolId, resourceName, false);
    }

    public void reloadResource(short poolId, String resourceName) {
        if (this.resourcesInfos == null) {
            throw new RuntimeException("Resource " + resourceName + " was not marked as reloadable!");
        }
        ResourceInfo resourceInfo = (ResourceInfo)this.resourcesInfos.get(poolId + "|" + resourceName);
        Object obj = ResourcesManager.loadResource(poolId, resourceName, resourceInfo.resourceType, resourceInfo.resourceType, resourceInfo.paramsString, null);
        this.addResource(poolId, resourceName, obj);
    }

    public void setPoolsCount(short poolsCount) {
        Hashtable[] temp;
        short highDataIndex;
        boolean dataCounter = false;
        for (highDataIndex = (short)(this.pools.length - 1); highDataIndex >= 0 && this.pools[highDataIndex] == null; highDataIndex = (short)(highDataIndex - 1)) {
        }
        if (poolsCount > highDataIndex) {
            short i;
            boolean[] tmp = new boolean[poolsCount];
            temp = new Hashtable[poolsCount];
            for (i = 0; i <= highDataIndex; i = (short)(i + 1)) {
                tmp[i] = this.isWorking[i];
                temp[i] = this.pools[i];
            }
            for (i = (short)this.pools.length; i < poolsCount; i = (short)(i + 1)) {
                this.freeIds.addElement(new Short(i));
            }
        } else {
            throw new RuntimeException("Shrinking pools table to " + poolsCount + " is impossible.");
        }
        this.pools = temp;
        System.gc();
    }

    private void onResourcesLoadingFinished(short poolId) {
        this.isWorking[poolId] = false;
    }

    public static Object loadResource(short poolId, String resourceName, String resourceType, String resourceFileName, String paramsString, IResourcesRequester resourcesRequester) {
        if (resourceType.equals("IMG")) {
            try {
                return Image.createImage((String)resourceFileName);
            }
            catch (IOException exc) {
                return null;
            }
        }
        if (resourceType.equals("SIMPLE_SPRITE")) {
            try {
                int framesCount = Integer.parseInt(paramsString);
                Image image = Image.createImage((String)resourceFileName);
                return new SimpleSprite(image, framesCount);
            }
            catch (IOException exc) {
                return null;
            }
        }
        if (resourceType.equals("ROT_SIMPLE_SPRITE")) {
            try {
                int framesCount = Integer.parseInt(paramsString.substring(0, paramsString.indexOf(" ")));
                short angle = Short.parseShort(paramsString.substring(paramsString.indexOf(" ") + 1));
                Image image = Image.createImage((String)resourceFileName);
                return RotatableSprite.createRotatedSimpleSprite(image, framesCount, angle);
            }
            catch (IOException exc) {
                return null;
            }
        }
        if (resourceType.equals("ROTATEABLE_SPRITE")) {
            try {
                int framesCount = paramsString == null || paramsString.equals("") ? 1 : Integer.parseInt(paramsString);
                return new RotatableSprite(resourceFileName, framesCount);
            }
            catch (IOException exc) {
                return null;
            }
        }
        if (resourceType.equals("FONT")) {
            try {
                int charactersCount = Integer.parseInt(paramsString);
                Image image = Image.createImage((String)resourceFileName);
                return new SimpleSprite(image, charactersCount);
            }
            catch (IOException exc) {
                return null;
            }
        }
        if (resourceType.equals("WAV") || resourceType.equals("AMR") || resourceType.equals("MIDI") || resourceType.equals("SP_MIDI")) {
            try {
                if (resourceType.equals("WAV")) {
                    return SoundFX.getInstance().addSoundFX(resourceFileName, Integer.parseInt(paramsString));
                }
                if (resourceType.equals("AMR")) {
                    String contentType = "audio/amr";
                } else if (resourceType.equals("MIDI")) {
                    return Music.addMusicTrack(resourceFileName);
                }
                return null;
            }
            catch (IOException exc) {
                throw new RuntimeException("IO Exception: " + exc.getMessage());
            }
            catch (MediaException exc) {
                throw new RuntimeException("Media Exception: " + exc.getMessage());
            }
        }
        if (resourcesRequester != null) {
            return resourcesRequester.loadUnknownResource(poolId, resourceName, resourceType, resourceFileName, paramsString);
        }
        return null;
    }

    private class ResourceInfo {
        public String resourceType;
        public String resourceFileName;
        public String paramsString;

        public ResourceInfo(String resourceType, String resourceFileName, String paramsString) {
            this.resourceType = resourceType;
            this.resourceFileName = resourceFileName;
            this.paramsString = paramsString;
        }
    }

    private class ResourcesLoader
    implements Runnable {
        private IResourcesRequester resourcesRequester;
        private String filename;
        private short poolId;
        private short notificationFrequency = (short)5;

        public ResourcesLoader(IResourcesRequester resourcesRequester, String fileName, short poolId, short notificationFrequency) {
            this.poolId = poolId;
            this.filename = fileName;
            this.resourcesRequester = resourcesRequester;
            this.notificationFrequency = notificationFrequency;
        }

        private Object loadResource(String resourceName, String resourceType, String resourceFileName, String paramsString) {
            return ResourcesManager.loadResource(this.poolId, resourceName, resourceType, resourceFileName, paramsString, this.resourcesRequester);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileReader resDescriptionFile = null;
            try {
                int resCounter;
                String resCounterStr;
                resDescriptionFile = new FileReader(this.filename);
                while ((resCounterStr = resDescriptionFile.readNextLine()).equals("") || resCounterStr.charAt(0) == '#') {
                }
                try {
                    resCounter = Short.parseShort(resCounterStr);
                }
                catch (NumberFormatException exc) {
                    throw new RuntimeException("Wrong file format: " + resCounterStr + " is not a number.");
                }
                for (int i = 0; i < resCounter; ++i) {
                    String resFile;
                    String resType;
                    String resName;
                    while ((resName = resDescriptionFile.readNextLine()).equals("") || resName.charAt(0) == '#') {
                    }
                    while ((resType = resDescriptionFile.readNextLine()).equals("") || resType.charAt(0) == '#') {
                    }
                    String paramsString = "";
                    int index = resType.indexOf(" ");
                    if (index != -1 && index + 1 < resType.length()) {
                        paramsString = resType.substring(index + 1);
                        resType = resType.substring(0, index);
                    }
                    while ((resFile = resDescriptionFile.readNextLine()).equals("") || resFile.charAt(0) == '#') {
                    }
                    int resTypeLength = resType.length();
                    if (resTypeLength > 0 && resType.charAt(resTypeLength - 1) == '@') {
                        resType = resType.substring(0, resTypeLength);
                        if (ResourcesManager.this.resourcesInfos == null) {
                            ResourcesManager.this.resourcesInfos = new Hashtable();
                        }
                        if (ResourcesManager.this.resourcesInfos.put(this.poolId + "@" + resName, new ResourceInfo(resType, resFile, paramsString)) != null) {
                            throw new RuntimeException("Key " + this.poolId + "@" + resName + " alredy exists in resourcesInfo.");
                        }
                    }
                    ResourcesManager.getInstance().addResource(this.poolId, resName, this.loadResource(resName, resType, resFile, paramsString));
                    if (this.notificationFrequency == -1 || i % this.notificationFrequency != 0) continue;
                    this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)(100 * i / resCounter), null);
                }
                ResourcesManager.this.onResourcesLoadingFinished(this.poolId);
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)100, null);
            }
            catch (IOException exc) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, "IOException has been thrown while reading from " + this.filename + ": " + exc.getMessage());
            }
            catch (Error err) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, err != null ? err.toString() + ": " + (err.getMessage() != null ? err.getMessage() : "no message") : "err == null");
            }
            catch (Exception exc) {
                this.resourcesRequester.onResourcesLoadingProgress(this.poolId, (short)-1, exc != null ? exc.toString() + ": " + (exc.getMessage() != null ? exc.getMessage() : "no message") : "exc == null");
            }
            finally {
                if (resDescriptionFile != null) {
                    resDescriptionFile.close();
                }
            }
        }
    }
}

