/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IInfoBoardMessageInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class InfoBoardMessageDataPacket
implements IDataStringConvertible,
IInfoBoardMessageInfo {
    private static final int NUMPACKETFILEDS = 2;
    private IGSId id;
    private String message;

    public InfoBoardMessageDataPacket() {
        this.id = null;
        this.message = "";
    }

    public InfoBoardMessageDataPacket(IGSId messageId, String messageText) {
        this.id = messageId;
        this.message = messageText;
    }

    public String toDataString() throws PacketConversionException {
        if (this.id == null || this.message == null || new String("").equals(this.message)) {
            throw new PacketConversionException("InfoBoardMessageDataPacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.id);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.message);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainsplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        String elem0 = (String)mainsplit.elementAt(0);
        try {
            if (!PacketType.InfoBoardMessage.equals(ObjectUtil.shortFromString(elem0)) || mainsplit.size() != 3) {
                throw new PacketConversionException("parsing InfoBoardMessageDataPacket: invalid packet type");
            }
            this.id = GSIdUtil.parseFromString((String)mainsplit.elementAt(1));
            this.message = (String)mainsplit.elementAt(2);
        }
        catch (Exception ex) {
            throw new PacketConversionException("error while parsing InfoBoardMessageDataPacket" + ex.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.InfoBoardMessage;
    }

    public IGSId getMessageId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }
}

