/*
 * Decompiled with CFR 0.152.
 */
package framework;

import com.nokia.mid.ui.DeviceControl;
import framework.AppState;
import framework.math.FP;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class MainGameCanvas
extends GameCanvas
implements Runnable {
    public static final int SOFTKEY_LEFT = -6;
    public static final int SOFTKEY_RIGHT = -7;
    public static final int CLR = -8;
    public static final int KEY_FIRE = -5;
    public static final int KEY_UP_ARROW = -1;
    public static final int KEY_DOWN_ARROW = -2;
    public static final int KEY_RIGHT_ARROW = -4;
    public static final int KEY_LEFT_ARROW = -3;
    public static final int KEY_STATE_UP = 2;
    public static final int KEY_STATE_DOWN = 64;
    public static final int KEY_STATE_RIGHT = 32;
    public static final int KEY_STATE_LEFT = 4;
    public static final int KEY_STATE_FIRE = 256;
    public long totalTime;
    public long framesCount;
    private Thread gameThread;
    private boolean finishApp;
    private boolean finished;
    private boolean paused;
    private long lastTime;
    private int deltaTime;
    private Hashtable statesMap;
    private AppState currentAppState;
    private AppState requestedAppState;
    private Object requestedAppStateParam;
    private Graphics g;
    private Thread appThread;
    public boolean isTerrainLoading = false;
    private long lastLightTime = 0L;
    private static final int FADE_RGB_SQUARE_SIZE = 40;
    private int[] fadeRgbData = null;
    Runtime rtime;

    public MainGameCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.rtime = Runtime.getRuntime();
        this.statesMap = new Hashtable();
    }

    public void beginMainLoop() {
        if (this.finished || this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
        this.finishApp = false;
        this.paused = false;
    }

    public void endMainLoop() {
        this.finishApp = true;
        if (!Thread.currentThread().equals(this.appThread)) {
            while (!this.finished) {
                this.sleep(50);
            }
        }
    }

    public void registerAppState(AppState state) {
        if (this.statesMap.containsKey(state.getName())) {
            throw new RuntimeException(":: State with name " + state.getName() + " has already been registered.");
        }
        this.statesMap.put(state.getName(), state);
    }

    public void requestAppStateChange(String stateName, Object param) {
        if (!this.statesMap.containsKey(stateName)) {
            this.requestAppStateChange("ErrorAppState", "Error: There's no such\nstate as " + stateName + ".");
            System.out.println("error no state: " + stateName);
            return;
        }
        this.requestedAppState = (AppState)this.statesMap.get(stateName);
        this.requestedAppStateParam = param;
        if (this.currentAppState == null) {
            this.changeAppState(this.requestedAppState, param);
        }
    }

    public void requestAppStateChange(String stateName) {
        this.requestAppStateChange(stateName, null);
    }

    public void run() {
        int fadeTimer = -1;
        this.appThread = Thread.currentThread();
        this.finished = false;
        this.g = this.getGraphics();
        try {
            while (!this.finishApp) {
                if (this.requestedAppState != null) {
                    if ((this.currentAppState.fadeStyle & 2) != 0) {
                        this.fadeOut(this.currentAppState.fadeColor);
                    }
                    do {
                        this.changeAppState(this.requestedAppState, this.requestedAppStateParam);
                    } while (this.requestedAppState != null);
                    if ((this.currentAppState.fadeStyle & 1) != 0) {
                        fadeTimer = AppState.FADE_DURATION;
                        this.prepareFadeRgbData(this.currentAppState.fadeColor);
                    }
                }
                if (!this.paused) {
                    long currentTime = System.currentTimeMillis();
                    if (this.lastTime == -1L) {
                        this.lastTime = currentTime;
                        continue;
                    }
                    this.deltaTime = (int)(currentTime - this.lastTime);
                    this.totalTime += (long)this.deltaTime;
                    this.lastTime = currentTime;
                    this.currentAppState.handleInput();
                    this.currentAppState.update(this.deltaTime);
                    this.currentAppState.render(this.g);
                    if (System.currentTimeMillis() - this.lastLightTime > 1000L) {
                        DeviceControl.setLights((int)0, (int)100);
                        this.lastLightTime = System.currentTimeMillis();
                    }
                    if (fadeTimer >= 0 && (this.currentAppState.fadeStyle & 1) != 0) {
                        this.recomputeFadeRgbData(this.currentAppState.fadeColor, fadeTimer);
                        this.renderFadeRgbData();
                        fadeTimer -= this.deltaTime;
                    }
                    ++this.framesCount;
                    try {
                        this.flushGraphics();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Thread.yield();
                    this.sleep(5);
                    continue;
                }
                this.sleep(50);
            }
        }
        catch (Error err) {
            err.printStackTrace();
            while (true) {
                this.drawDebugMessage("FRM ERR: " + (err != null ? err.toString() + ": " + (err.getMessage() != null ? err.getMessage() : "no message") : "err == null"), this.getWidth() / 7);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            while (true) {
                this.drawDebugMessage("FRM EXC: " + (exc != null ? exc.toString() + ": " + (exc.getMessage() != null ? exc.getMessage() : "no message") : "exc == null"), this.getWidth() / 7);
            }
        }
        this.finished = true;
    }

    public void drawDebugMessage(String text, int lettersPerRow) {
        int y = 0;
        this.g.setColor(0xFFFF00);
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.g.setColor(0xFF0000);
        for (int i = 0; i < text.length(); i += lettersPerRow) {
            this.g.drawString(text.substring(i, Math.min(i + lettersPerRow, text.length())), 0, y, 0);
            y += 15;
        }
        this.flushGraphics();
    }

    void setPaused(boolean value) {
        this.paused = value;
        if (value) {
            this.lastTime = -1L;
        }
    }

    private void changeAppState(AppState gameState, Object param) {
        if (this.currentAppState != null) {
            this.currentAppState.deinitialize();
        }
        this.requestedAppState = null;
        this.requestedAppStateParam = null;
        this.currentAppState = gameState;
        if (!this.currentAppState.initialize(param) && this.requestedAppState == null) {
            this.requestAppStateChange("ErrorAppState", "Unknown error.\nHave you forgotten\nto request error state\nafter failed initialization?");
        }
        this.lastTime = -1L;
    }

    protected void keyRepeated(int keyCode) {
        if (this.hasRepeatEvents()) {
            this.currentAppState.keyRepeated(keyCode);
        }
    }

    protected void keyPressed(int keyCode) {
        this.currentAppState.keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.currentAppState.keyReleased(keyCode);
    }

    protected void showNotify() {
        if (this.paused) {
            this.currentAppState.pauseStateChanged(false);
        }
        this.g = this.getGraphics();
    }

    protected void hideNotify() {
        this.currentAppState.pauseStateChanged(true);
    }

    public String getCurrentAppStateName() {
        if (this.currentAppState != null) {
            return this.currentAppState.name;
        }
        return null;
    }

    public void applicationDestroyed() {
        if (this.currentAppState != null) {
            this.currentAppState.applicationDestroyed();
        }
    }

    private void sleep(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void prepareFadeRgbData(int color) {
        if (this.fadeRgbData == null) {
            this.fadeRgbData = new int[1600];
        }
        for (int i = 0; i < this.fadeRgbData.length; ++i) {
            this.fadeRgbData[i] = color;
        }
    }

    private void recomputeFadeRgbData(int color, int fadeTimer) {
        if (this.fadeRgbData == null) {
            return;
        }
        int opacity = (fadeTimer << FP.SHIFT << FP.SHIFT) / (AppState.FADE_DURATION << FP.SHIFT) * (255 << FP.SHIFT) >> FP.SHIFT >> FP.SHIFT;
        if (opacity > 255) {
            opacity = 255;
        } else if (opacity < 0) {
            opacity = 0;
        }
        for (int i = 0; i < this.fadeRgbData.length; ++i) {
            this.fadeRgbData[i] = opacity << 24 | color;
        }
    }

    private void renderFadeRgbData() {
        if (this.fadeRgbData == null) {
            return;
        }
        int colsCount = 7;
        int rowsCount = 9;
        for (int col = 0; col < colsCount; ++col) {
            for (int row = 0; row < rowsCount; ++row) {
                this.g.drawRGB(this.fadeRgbData, 0, 40, col * 40, row * 40, 40, 40, true);
            }
        }
    }

    private void fadeOut(int color) {
        long time;
        int fadeTimer = 0;
        this.prepareFadeRgbData(color);
        do {
            time = System.currentTimeMillis();
            this.recomputeFadeRgbData(color, fadeTimer);
            this.renderFadeRgbData();
            this.flushGraphics();
        } while ((fadeTimer = (int)((long)fadeTimer + (System.currentTimeMillis() - time))) <= AppState.FADE_DURATION);
    }
}

