/*
 * Decompiled with CFR 0.152.
 */
package framework.utils.rms;

import framework.utils.rms.IRMSRecord;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public final class RMSUtils {
    public static int getRecordsCount(String recordStoreName) {
        RecordStore recordStore = null;
        int numRecords = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            numRecords = recordStore.getNumRecords();
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full.");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name.");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open.");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error.");
        }
        return numRecords;
    }

    public static Vector loadRecords(String recordStoreName, Class recordType) {
        RecordStore recordStore = null;
        RecordEnumeration recordEnum = null;
        Vector<IRMSRecord> recordVector = new Vector<IRMSRecord>();
        IRMSRecord record = null;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            recordEnum = recordStore.enumerateRecords(null, null, false);
            while (recordEnum.hasNextElement()) {
                record = (IRMSRecord)recordType.newInstance();
                record.setId(recordEnum.nextRecordId());
                record.initializeFromByteArray(recordStore.getRecord(record.getId()));
                recordVector.addElement(record);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("No more records are available");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
        catch (InstantiationException exc) {
            throw new RuntimeException(exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Illegal Access Exception. Your RMS record class must have default constructor without parameters");
        }
        return recordVector;
    }

    public static void storeRecord(String recordStoreName, IRMSRecord record) {
        RecordStore recordStore = null;
        RecordEnumeration recordEnum = null;
        Vector recordVector = new Vector();
        byte[] byteArr = null;
        int recordId = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            recordEnum = recordStore.enumerateRecords(null, null, false);
            byteArr = record.toByteArray();
            recordId = recordStore.addRecord(byteArr, 0, byteArr.length);
            record.setId(recordId);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("No more records are available");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
    }

    public static void storeRecords(String recordStoreName, Vector records) {
        for (int i = 0; i < records.size(); ++i) {
            RMSUtils.storeRecord(recordStoreName, (IRMSRecord)records.elementAt(i));
        }
    }

    public static void createRecordStore(String recordStoreName) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid RecordStore name");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("No more records are available");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
    }

    public static void deleteRecordStore(String recordStoreName) {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)recordStoreName);
            }
            catch (RecordStoreNotFoundException exc) {
                throw new RuntimeException("RecordStore not found");
            }
            catch (RecordStoreException exc) {
                throw new RuntimeException(exc.toString());
            }
        }
    }

    public static void updateRecord(String recordStoreName, IRMSRecord record) {
        RecordStore recordStore = null;
        byte[] byteArr = null;
        int recordId = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byteArr = record.toByteArray();
            recordId = record.getId();
            try {
                recordStore.setRecord(recordId, byteArr, 0, byteArr.length);
            }
            catch (InvalidRecordIDException exc) {
                recordId = recordStore.addRecord(byteArr, 0, byteArr.length);
                record.setId(recordId);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("Invalid record id");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
    }

    public static boolean storeExists(String recordStoreName) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            rs.closeRecordStore();
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    public static void deleteRecord(String recordStoreName, int recordId) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            recordStore.deleteRecord(recordId);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("No more records are available");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
    }

    public static void deleteRecord(String recordStoreName, IRMSRecord record) {
        RMSUtils.deleteRecord(recordStoreName, record.getId());
    }

    public static void deleteAllRecords(String recordStoreName) {
        RecordStore recordStore = null;
        RecordEnumeration recordEnum = null;
        try {
            recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            recordEnum = recordStore.enumerateRecords(null, null, false);
            while (recordEnum.hasNextElement()) {
                recordStore.deleteRecord(recordEnum.nextRecordId());
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException exc) {
            throw new RuntimeException("RecordStore not found. Did you create it?");
        }
        catch (RecordStoreFullException exc) {
            throw new RuntimeException("RecordStore is full");
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Invalid Record Store name");
        }
        catch (RecordStoreNotOpenException exc) {
            throw new RuntimeException("RecordStore is not open");
        }
        catch (InvalidRecordIDException exc) {
            throw new RuntimeException("No more records are available");
        }
        catch (RecordStoreException exc) {
            throw new RuntimeException("RecordStore error");
        }
    }
}

