/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketQueueFullHandling;
import gs.common.utils.CollectionUtil;
import gs.exceptions.GSException;
import java.util.Vector;

public class PacketQueue {
    private Vector queue;
    private Short queueFullHandling = PacketQueueFullHandling.ForcePacket;
    private Boolean overflowed;
    private int maxCapacity = 1024;

    public PacketQueue() {
        this.queue = new Vector();
        this.overflowed = Boolean.FALSE;
    }

    public void enqueue(IDataStringConvertible p) throws GSException {
        if (this.maxCapacity == this.queue.size()) {
            this.overflowed = Boolean.TRUE;
            if (this.queueFullHandling.equals(PacketQueueFullHandling.ForcePacket)) {
                this.dequeue();
                this.queue.addElement(p);
            } else if (!this.queueFullHandling.equals(PacketQueueFullHandling.DiscardPacket) && this.queueFullHandling.equals(PacketQueueFullHandling.Exception)) {
                throw new GSException("Packet queue is full");
            }
            return;
        }
        this.queue.addElement(p);
    }

    public IDataStringConvertible dequeue() {
        IDataStringConvertible result = null;
        if (this.queue.size() != 0) {
            if (this.queue.size() == this.maxCapacity) {
                this.overflowed = Boolean.FALSE;
            }
            result = (IDataStringConvertible)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
        }
        return result;
    }

    public void clear() {
        this.queue.removeAllElements();
        this.overflowed = Boolean.FALSE;
    }

    public int size() {
        return this.queue.size();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int val) throws GSException {
        if (val < 0) {
            throw new GSException("PacketQueue.setMaxCapacity: invalid max capacity");
        }
        this.maxCapacity = val == 0 ? 1024 : val;
    }

    public Boolean hasOverflowed() {
        return this.overflowed;
    }

    public Short getQueueFullHandling() {
        return this.queueFullHandling;
    }

    public void setQueueFullHandling(Short val) throws GSException {
        if (!(PacketQueueFullHandling.DiscardPacket.equals(val) || PacketQueueFullHandling.ForcePacket.equals(val) || PacketQueueFullHandling.Exception.equals(val))) {
            throw new GSException("PacketQueue.setQueueFullHandling: invalid argument");
        }
        this.queueFullHandling = val;
    }

    public String toString() {
        return "PacketQueue: packets=" + CollectionUtil.vectorToString(this.queue) + "; " + "queueFullHandling=" + PacketQueueFullHandling.packetQueueFullHandlingToString(this.queueFullHandling);
    }
}

