/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.enumerations.PlayerStatus;
import gs.common.gsid.GSLongId;
import gs.common.gsid.IGSId;
import gs.common.info.IPlayerStateInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class PlayerStateInfo
implements IPlayerStateInfo,
IDataStringConvertible {
    private static final int NUMPACKETFILEDS = 4;
    Integer roomNumber;
    IGSId gameId;
    Boolean isOwner;
    Short playerStatus;

    public PlayerStateInfo() {
        this.roomNumber = new Integer(-1);
        this.gameId = new GSLongId(-1L);
        this.isOwner = Boolean.FALSE;
        this.playerStatus = PlayerStatus.Online;
    }

    public PlayerStateInfo(Integer roomNumber, IGSId gameId, boolean isOwner, Short playerStatus) {
        this.gameId = gameId;
        this.isOwner = new Boolean(isOwner);
        this.roomNumber = roomNumber;
        this.playerStatus = playerStatus;
    }

    public PlayerStateInfo(IPlayerStateInfo info) {
        this.gameId = info.getGameId();
        this.isOwner = info.isOwner();
        this.roomNumber = info.getRoomNumber();
        this.playerStatus = info.getStatus();
    }

    public Integer getRoomNumber() {
        return this.roomNumber;
    }

    public IGSId getGameId() {
        return this.gameId;
    }

    public Boolean isOwner() {
        return this.isOwner;
    }

    public Short getStatus() {
        return this.playerStatus;
    }

    public String toDataString() throws PacketConversionException {
        if (this.roomNumber == null || this.gameId == null || this.isOwner == null || PlayerStatus.Invalid.equals(this.playerStatus)) {
            throw new PacketConversionException("PlayerStateInfo to data string: invalid packet type");
        }
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.roomNumber);
        result = result + DataPacketUtil.playerStateInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameId);
        result = result + DataPacketUtil.playerStateInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.isOwner);
        result = result + DataPacketUtil.playerStateInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.playerStatus);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector splitDataStr = CollectionUtil.splitString(dataStr, DataPacketUtil.playerStateInfoSeperator());
        if (splitDataStr.size() != 4) {
            throw new PacketConversionException("parsing PlayerStateInfo: invalid packet type");
        }
        try {
            this.roomNumber = new Integer(Integer.parseInt((String)splitDataStr.elementAt(0)));
            this.gameId = GSIdUtil.parseFromString((String)splitDataStr.elementAt(1));
            this.isOwner = ObjectUtil.booleanFromString((String)splitDataStr.elementAt(2));
            this.playerStatus = ObjectUtil.shortFromString((String)splitDataStr.elementAt(3));
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing PlayerStateInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public String toString() {
        return "PlayerStateInfo: roomNumber=" + this.roomNumber.toString() + "; " + "gameId=" + ((Object)this.gameId).toString() + "; " + "isOwner=" + this.isOwner.toString() + "; " + "playerStatus=" + PlayerStatus.playerStatusToString(this.playerStatus);
    }
}

