/*
 * Decompiled with CFR 0.152.
 */
package menu;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuBackground {
    private static MenuBackground instance = null;
    private Image menuImg;
    private Image menuYesImg;
    private Image menuNoImg;
    private Image menuBackImg;
    private Image menuClrImg;
    public static final int MENU_NORMAL = 1;
    public static final int MENU_BACK = 2;
    public static final int MENU_YES_NO = 3;
    public static final int MENU_OK_BACK = 4;
    public static final int MENU_OK = 5;
    public static final int MENU_OK_CLR = 6;
    int menuButtonsOffsetX;
    int menuButtonsOffsetY;
    public boolean switchMenuBackgroundBackButton;

    public MenuBackground() {
        instance = this;
        this.initialize();
    }

    public static MenuBackground GetInstance() {
        if (instance == null) {
            new MenuBackground();
        }
        return instance;
    }

    public void Draw(Graphics g) {
        this.Draw(g, 1);
    }

    public void Draw(Graphics g, int menuType) {
        if (this.menuImg == null) {
            return;
        }
        g.drawImage(this.menuImg, 120, 160, 3);
        if (menuType == 2 || menuType == 4) {
            if (this.switchMenuBackgroundBackButton) {
                g.drawImage(this.menuClrImg, this.menuButtonsOffsetX, this.menuButtonsOffsetY, 0);
            } else {
                g.drawImage(this.menuBackImg, this.menuButtonsOffsetX, this.menuButtonsOffsetY, 0);
            }
        } else if (menuType == 3) {
            g.drawImage(this.menuNoImg, this.menuButtonsOffsetX, this.menuButtonsOffsetY, 0);
            g.drawImage(this.menuYesImg, 0, this.menuButtonsOffsetY, 0);
        }
        if (menuType == 4 || menuType == 5) {
            g.drawImage(this.menuYesImg, 0, this.menuButtonsOffsetY, 0);
        }
    }

    public void initialize() {
        try {
            this.menuImg = Image.createImage((String)"/menu_tlo.png");
            this.menuYesImg = Image.createImage((String)"/ikona_yes.png");
            this.menuNoImg = Image.createImage((String)"/ikona_no.png");
            this.menuBackImg = Image.createImage((String)"/ikona_back.png");
            this.menuClrImg = Image.createImage((String)"/ikona_del.png");
            this.switchMenuBackgroundBackButton = false;
            this.menuButtonsOffsetX = 240 - this.menuYesImg.getHeight();
            this.menuButtonsOffsetY = 320 - this.menuYesImg.getHeight();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public int getMenuImgWidth() {
        return this.menuImg.getWidth();
    }

    public int getMenuImgHeight() {
        return this.menuImg.getHeight();
    }

    public void deinitialize() {
        this.menuImg = null;
        this.menuYesImg = null;
        this.menuNoImg = null;
        this.menuBackImg = null;
        this.menuClrImg = null;
        System.gc();
    }

    public void setSwitchBackroundBackButton(boolean b) {
        this.switchMenuBackgroundBackButton = b;
    }
}

