/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.inGame;

import com.jarbull.basket.inGame.Ball;
import com.jarbull.basket.tools.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Nail
extends Sprite {
    public static final int SPRITE_WIDTH = 1;
    public static final int SPRITE_HEIGHT = 1;

    public Nail(int x, int y) throws IOException {
        super(Image.createImage((int)1, (int)1));
        int[] rgb = new int[]{0xFFFFFF};
        Image img = Image.createRGBImage((int[])rgb, (int)1, (int)1, (boolean)false);
        this.setImage(img, 1, 1);
        this.setPosition(x, y);
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, true);
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        if (!isMovedBack) {
            ball.moveBack();
            isMovedBack = true;
        }
        int ballCenterX = ball.getX() + ball.getWidth() / 2;
        int ballCenterY = ball.getY() + ball.getHeight() / 2;
        int nailCenterX = this.getX() + this.getWidth() / 2;
        int nailCenterY = this.getY() + this.getHeight() / 2;
        ball.reflect(new Vector2D(ballCenterX - nailCenterX, ballCenterY - nailCenterY).normalize());
        return isMovedBack;
    }
}

