/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.BasketProcessor;
import com.jarbull.basket.game.MainMidlet;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class BasketCanvas
extends JBGameCanvas
implements Runnable {
    public MainMidlet m;
    BasketProcessor processor;
    private int canvasWidth;
    private int canvasHeight;

    public BasketCanvas(MainMidlet m) throws IOException {
        this.m = m;
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
        this.setFullScreenMode(true);
        this.canvasWidth = this.getWidth();
        this.canvasHeight = this.getHeight();
        this.processor = new BasketProcessor(this);
    }

    public void run() {
        this.processor.placeOk = false;
        this.processor.start();
        while (this.isRunning) {
            if (!this.isPaused) {
                this.repaint();
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.processor.kill();
        KeyCodeAdapter.getInstance().setCanvas(null);
    }

    public void paint(Graphics g) {
        if (this.processor == null || !this.processor.prepareObjectsFinished) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
            g.setColor(255, 255, 255);
            g.drawString("Loading...", 0, 0, 0);
            return;
        }
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        this.processor.layerManager.paint(g, this.canvasWidth / 2 - 120, this.canvasHeight / 2 - 160);
        this.processor.dirAssistant.paint(g, this.canvasWidth / 2 - 120, this.canvasHeight / 2 - 160);
        this.processor.gauge.paint(g);
        this.processor.scoreAndTime.paint(g);
    }

    public void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        if (keyCode == -202 || keyCode == 209) {
            this.processor.scoreAndTime.stopTime();
            this.processor.pause();
            ImageHandler.getInstance().clearImageBuffer();
            JBManager.getInstance().clearFonts();
            JBManager.getInstance().addAction(new JBAction(this, "clearti"));
            this.m.openPauseMenu();
        }
    }
}

