/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMSGameScores
implements RecordFilter,
RecordComparator {
    private RecordStore recordStore = null;
    public static String playerNameFilter = null;

    public boolean matches(byte[] candidate) throws IllegalArgumentException {
        if (playerNameFilter == null) {
            return false;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(candidate);
        DataInputStream inputStream = new DataInputStream(bais);
        String name = null;
        try {
            int score = inputStream.readInt();
            name = inputStream.readUTF();
        }
        catch (EOFException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        catch (IOException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        return playerNameFilter.equals(name);
    }

    public int compare(byte[] rec1, byte[] rec2) {
        ByteArrayInputStream bais1 = new ByteArrayInputStream(rec1);
        DataInputStream inputStream1 = new DataInputStream(bais1);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(rec2);
        DataInputStream inputStream2 = new DataInputStream(bais2);
        int score1 = 0;
        int score2 = 0;
        try {
            score1 = inputStream1.readInt();
            score2 = inputStream2.readInt();
        }
        catch (EOFException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        catch (IOException eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        if (score1 > score2) {
            return -1;
        }
        if (score1 < score2) {
            return 1;
        }
        return 0;
    }

    public RMSGameScores(String rsName) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)rsName, (boolean)true);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    public static void closeRecordStore(RecordStore rs) {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteRecordStore(String rsName) {
        try {
            RecordStore.deleteRecordStore((String)rsName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delete(String entity, RecordStore rs) {
        try {
            boolean found = false;
            RecordEnumeration re = rs.enumerateRecords(null, null, true);
            re.reset();
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                String val = new String(rs.getRecord(id));
                if (!val.startsWith(entity)) continue;
                found = true;
                if (entity == null) {
                    rs.deleteRecord(id);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addScore(int score, String playerName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeInt(score);
            outputStream.writeUTF(playerName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        byte[] b = baos.toByteArray();
        try {
            int recId = this.recordStore.addRecord(b, 0, b.length);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    private void printScoresHelper(RecordEnumeration re, Graphics g, int sWidth, int sHeight) {
        try {
            int cnt = 0;
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            g.setColor(255, 255, 255);
            g.drawString("HIGH SCORES", sWidth / 2, Font.getDefaultFont().getHeight(), 0x10 | 1);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(id));
                DataInputStream inputStream = new DataInputStream(bais);
                try {
                    int score = inputStream.readInt();
                    String playerName = String.valueOf(cnt + 1);
                    g.drawString(playerName + "-) " + score + " p.", sWidth / 2, Font.getDefaultFont().getHeight() * 2 + cnt * 20, 0x10 | 1);
                    if (++cnt <= 9) continue;
                    this.recordStore.deleteRecord(id);
                }
                catch (EOFException eofe) {
                    System.out.println(eofe);
                    eofe.printStackTrace();
                }
            }
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public void printScores(Graphics g, int sWidth, int sHeight) {
        try {
            RecordEnumeration re = this.recordStore.enumerateRecords(null, (RecordComparator)this, true);
            this.printScoresHelper(re, g, sWidth, sHeight);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }

    public void printScores(String playerName, Graphics g, int sWidth, int sHeight) {
        try {
            RecordEnumeration re = this.recordStore.enumerateRecords((RecordFilter)this, (RecordComparator)this, true);
            this.printScoresHelper(re, g, sWidth, sHeight);
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
    }
}

