/*
 * Decompiled with CFR 0.152.
 */
package demopak;

import demopak.AbstractScreen;
import demopak.GameMidlet;
import demopak.Inventory;
import demopak.MapObject;
import demopak.Time;
import demopak.Weather;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class MainGameCanvas
extends AbstractScreen
implements Runnable {
    private GameMidlet midlet = null;
    Timer timer;
    Time time;
    Image panel;
    private volatile Thread animationThread = null;
    private int fps = 30;
    int x = 0;
    int y = 0;
    int df;
    int level = 1;
    boolean invent;
    private LayerManager gameManager = null;
    MapObject mapobject;
    Inventory inventory;
    Weather rain;

    MainGameCanvas(GameMidlet midlet) throws Exception {
        this.midlet = midlet;
        this.panel = Image.createImage((String)"/panel.png");
        this.gameManager = new LayerManager();
        this.mapobject = new MapObject();
        this.inventory = new Inventory();
        this.timer = new Timer();
        this.time = new Time();
        this.rain = new Weather();
        this.mapobject.createGame();
        this.mapobject.createLevel(this.level);
        this.upend();
    }

    void start() {
        this.timer.schedule((TimerTask)this.time, 0L, 200L);
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (currentThread == this.animationThread) {
                long endTime;
                long startTime = System.currentTimeMillis();
                if (this.isShown()) {
                    this.updateGame();
                    this.draw();
                    this.flushGraphics();
                }
                if ((endTime = System.currentTimeMillis() - startTime) < (long)this.fps) {
                    MainGameCanvas mainGameCanvas = this;
                    synchronized (mainGameCanvas) {
                        this.wait((long)this.fps - endTime);
                        continue;
                    }
                }
                currentThread.yield();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void stop() {
        this.animationThread = null;
    }

    private void draw() {
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, GameMidlet.SCREEN_WIDTH, GameMidlet.SCREEN_HEIGHT);
        this.x = this.origin(MapObject.hero.getX() + 10, this.mapobject.background.getWidth(), GameMidlet.SCREEN_WIDTH);
        this.y = this.origin(MapObject.hero.getY() + 21, this.mapobject.background.getHeight(), GameMidlet.SCREEN_HEIGHT);
        this.g.setClip(this.x, this.y, this.mapobject.background.getWidth(), this.mapobject.background.getHeight());
        this.g.translate(this.x, this.y);
        this.gameManager.paint(this.g, 0, 0);
        this.g.translate(-this.x, -this.y);
        this.g.setClip(0, 0, GameMidlet.SCREEN_WIDTH, GameMidlet.SCREEN_HEIGHT);
        this.g.setColor(180, 5, 5);
        this.g.drawString(Time.timeOfDay, 0, 0, 0);
        this.mapobject.drawObject(this.g, this.x, this.y);
        this.rain.drawAtmosphere(this.g);
        if (this.invent) {
            this.inventory.drawInvent(this.g);
        }
        this.g.drawImage(this.panel, 0, GameMidlet.SCREEN_HEIGHT - 95, 0);
        this.g.fillRect(15, GameMidlet.SCREEN_HEIGHT - 9, MapObject.hero.life, 4);
        this.g.setColor(5, 5, 150);
        this.g.fillRect(15, GameMidlet.SCREEN_HEIGHT - 20, MapObject.hero.stamina, 4);
    }

    void updateGame() {
        this.keys();
        if (this.mapobject.firekostr.fire) {
            this.mapobject.firekostr.Think();
        }
        this.mapobject.heroverh.Dvig();
        for (int i = 0; i < this.mapobject.zombi.length; ++i) {
            this.mapobject.zombi[i].TimeZombi();
            if (!this.mapobject.zombi[i].zomb) continue;
            this.mapobject.zombi[i].vidLogic();
        }
        if (MapObject.hero.getX() == 1260 || MapObject.hero.getX() == 1259) {
            this.createMap(2);
        }
        if (MapObject.hero.getX() == 0 || MapObject.hero.getX() == -1) {
            this.createMap(4);
        }
        if (MapObject.hero.getY() == 0) {
            this.createMap(1);
        }
        if (MapObject.hero.getY() == 1238) {
            this.createMap(3);
        }
    }

    private int origin(int focus, int fieldLength, int screenLength) {
        int origin = screenLength >= fieldLength ? (screenLength - fieldLength) / 2 : (focus <= screenLength / 2 ? 0 : (focus >= fieldLength - screenLength / 2 ? screenLength - fieldLength : screenLength / 2 - focus));
        return origin;
    }

    void keys() {
        if (this.leftsoft) {
            this.stop();
            this.midlet.exitGame();
        }
        if (this.rightsoft) {
            this.rightsoft = false;
            this.invent = !this.invent;
        }
        if (!this.invent) {
            if (this.down) {
                MapObject.hero.moveHero(1, this.mapobject.background);
            }
            if (this.up) {
                MapObject.hero.moveHero(2, this.mapobject.background);
            }
            if (!(this.left || this.right || this.down || this.up || !this.fire)) {
                MapObject.hero.ataka(this.mapobject.zombi);
            }
            if (this.left) {
                MapObject.hero.moveHero(3, this.mapobject.background);
            }
            if (this.right) {
                MapObject.hero.moveHero(4, this.mapobject.background);
            }
            if (!(this.left || this.right || this.down || this.up || this.fire)) {
                MapObject.hero.stay();
            }
        } else {
            MapObject.hero.stay();
            if (this.key7) {
                this.inventory.delItem();
            }
            if (this.down) {
                this.inventory.removeItem(this.inventory.invent.i5);
            }
            if (this.up) {
                this.inventory.removeItem(this.inventory.invent.i4);
            }
            if (this.fire) {
                this.inventory.useItem(this.mapobject.firekostr);
            }
            if (this.left) {
                --this.inventory.sel;
                this.inventory.Selector();
                this.left = false;
            }
            if (this.right) {
                ++this.inventory.sel;
                this.inventory.Selector();
                this.right = false;
            }
        }
    }

    final void upend() {
        this.gameManager.append((Layer)this.mapobject.heroverh);
        for (int i = 0; i < this.mapobject.zombi.length; ++i) {
            this.gameManager.append((Layer)this.mapobject.zombi[i]);
        }
        this.gameManager.append((Layer)MapObject.hero);
        this.gameManager.append((Layer)this.mapobject.firekostr);
        this.gameManager.append((Layer)this.mapobject.dopfon);
        this.gameManager.append((Layer)this.mapobject.background);
    }

    void createMap(int naprav) {
        switch (naprav) {
            case 1: {
                break;
            }
            case 2: {
                if (this.level >= 4) break;
                ++this.level;
                this.mapobject.createLevel(this.level);
                MapObject.hero.setPosition(10, MapObject.hero.getY());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.level <= 1) break;
                --this.level;
                this.mapobject.createLevel(this.level);
                MapObject.hero.setPosition(1250, MapObject.hero.getY());
            }
        }
    }
}

