/*
 * Decompiled with CFR 0.152.
 */
package game.smarts;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSSmartSprite;
import game.xGame;
import javax.microedition.lcdui.Graphics;

public class Enemy
extends BBSSmartSprite {
    private final int fsOrangePig;
    private final int fsBluePing;
    private final int fsChameleon;
    private final int fsGreenSoldier;
    private final int fsBlueSoldier;
    private final int fsGrayBat;
    private final int fsPurpleBat;
    private final int fsJumpingPlatform45;
    private final int fsJumpingPlatform90;
    private int[][] enemyPos;
    long i = 0L;
    private int interactionRatioX = 0;
    private int interactionRatioY = 0;
    private int[] row = new int[]{0};
    private int[] xDirection = new int[1];
    private static final int ACTIVITY = 0;
    private static final int ENEMY_TYPE = 1;
    private static final int DIRECTION = 2;
    private static final int FRAME = 3;
    private static final int X = 4;
    private static final int Y = 5;
    private static final int RIGHT = 1;
    private static final int LEFT = -1;
    private int[] ropeRates = new int[]{40, 40, 20, 40, 40, 40, 40, 30, 15};

    public Enemy(BBSGame game, BBSSprite[] sprite, int x, int y, int sType, int objId, int[][] enemies) {
        super(sprite, sType, objId);
        this.enemyPos = enemies;
        this.zorder = -1;
        this.fsOrangePig = this.rSprite[0].addFrameSet(new int[]{0, 0, 0, 1, 1, 1, 21, 2}, 120, false);
        this.fsBluePing = this.rSprite[0].addFrameSet(new int[]{3, 3, 3, 4, 4, 4, 22, 5}, 120, false);
        this.fsChameleon = this.rSprite[0].addFrameSet(new int[]{6, 6, 6, 7, 7, 7, 8, 8, 8}, 120, false);
        this.fsGreenSoldier = this.rSprite[0].addFrameSet(new int[]{9, 9, 9, 10, 10, 10, 23, 11}, 120, false);
        this.fsBlueSoldier = this.rSprite[0].addFrameSet(new int[]{12, 12, 12, 13, 13, 13, 24, 14}, 120, false);
        this.fsGrayBat = this.rSprite[0].addFrameSet(new int[]{15, 15, 15, 16, 16, 16, 17, 17, 17}, 120, false);
        this.fsPurpleBat = this.rSprite[0].addFrameSet(new int[]{18, 18, 18, 19, 19, 19, 20, 20, 20}, 120, false);
        this.fsJumpingPlatform45 = this.rSprite[0].addFrameSet(new int[]{26, 26, 25, 27}, 30, false);
        this.fsJumpingPlatform90 = this.rSprite[0].addFrameSet(new int[]{29, 29, 28, 30}, 30, true);
    }

    public static BBSSmartSprite create(BBSGame game, int sType, int objId, int[][] enemies) {
        return new Enemy(game, new BBSSprite[]{new BBSSprite(game, "sprites/Enemy.sif", 0, 100, 0, 0, 0, 0)}, 0, 0, sType, objId, enemies);
    }

    public void doAnimation(BBSSmartGame game, int time) {
        int cnt;
        if (this.onceInMs(time, 120)) {
            for (cnt = 0; cnt < this.enemyPos.length; ++cnt) {
                if (this.enemyPos[cnt][1] == this.fsChameleon || this.enemyPos[cnt][1] == this.fsGrayBat || this.enemyPos[cnt][1] == this.fsPurpleBat) {
                    this.enemyPos[cnt][3] = (this.enemyPos[cnt][3] + 1) % 9;
                    continue;
                }
                if (this.enemyPos[cnt][1] == this.fsJumpingPlatform45 || this.enemyPos[cnt][1] == this.fsJumpingPlatform90) {
                    if (this.enemyPos[cnt][0] != 2) continue;
                    continue;
                }
                this.enemyPos[cnt][3] = (this.enemyPos[cnt][3] + 1) % 8;
            }
        }
        if (this.onceInMs(time, 30)) {
            for (cnt = 0; cnt < this.enemyPos.length; ++cnt) {
                if (this.enemyPos[cnt][1] != this.fsJumpingPlatform45 && this.enemyPos[cnt][1] != this.fsJumpingPlatform90 || this.enemyPos[cnt][0] != 2) continue;
                if (this.enemyPos[cnt][3] == 3) {
                    this.enemyPos[cnt][0] = 3;
                    continue;
                }
                this.enemyPos[cnt][3] = (this.enemyPos[cnt][3] + 1) % 4;
            }
        }
    }

    public void trigger(String command, int[] pars) {
    }

    public int interract(BBSSmartGame game, BBSSmartSprite sprite, int action) {
        for (int cnt = 0; cnt < this.enemyPos.length; ++cnt) {
            if (((xGame)game).IMMORTAL && (!((xGame)game).IMMORTAL || this.enemyPos[cnt][1] != this.fsJumpingPlatform45 && this.enemyPos[cnt][1] != this.fsJumpingPlatform90) || this.enemyPos[cnt][0] != 1) continue;
            this.rSprite[0].setFrameSet(this.enemyPos[cnt][1], this.enemyPos[cnt][2]);
            this.rSprite[0].setFrame(this.enemyPos[cnt][3]);
            this.rSprite[0].x = this.enemyPos[cnt][4];
            this.rSprite[0].y = this.enemyPos[cnt][5] * game.tileSet.tileHeight;
            this.interactionRatioX = this.rSprite[0].getFrameWidth() * 50 / 100;
            this.interactionRatioY = this.rSprite[0].getFrameHeight() * 60 / 100;
            switch (this.enemyPos[cnt][1]) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    switch (this.enemyPos[cnt][3]) {
                        case 0: 
                        case 2: {
                            break;
                        }
                        case 1: {
                            if (sprite.rSprite[0].y >= this.rSprite[0].y) break;
                            this.interactionRatioY = this.rSprite[0].getFrameHeight() * 90 / 100;
                        }
                    }
                    break;
                }
                case 3: {
                    this.interactionRatioX = this.rSprite[0].getFrameWidth() * 65 / 100;
                    if (sprite.rSprite[0].y < this.rSprite[0].y) {
                        this.interactionRatioY = this.rSprite[0].getFrameHeight();
                        break;
                    }
                    this.interactionRatioY = this.rSprite[0].getFrameHeight() * 85 / 100;
                    break;
                }
                case 6: 
                case 7: {
                    this.interactionRatioX = this.rSprite[0].getFrameWidth() * 50 / 100;
                    if (sprite.rSprite[0].y < this.rSprite[0].y) {
                        this.interactionRatioY = this.rSprite[0].getFrameHeight() * 120 / 100;
                        break;
                    }
                    this.interactionRatioY = this.rSprite[0].getFrameHeight() * 80 / 100;
                    break;
                }
                case 8: 
                case 9: {
                    this.interactionRatioX = this.rSprite[0].getFrameWidth() * 100 / 100;
                    this.interactionRatioY = this.rSprite[0].getFrameHeight() * 100 / 100;
                }
            }
            if (Math.abs(sprite.rSprite[0].x - this.rSprite[0].x) >= this.interactionRatioX || Math.abs(sprite.rSprite[0].y - this.rSprite[0].y) >= this.interactionRatioY) continue;
            if (this.enemyPos[cnt][0] != 2 && this.enemyPos[cnt][1] == this.fsJumpingPlatform45) {
                this.enemyPos[cnt][0] = 2;
                this.xDirection[0] = this.enemyPos[cnt][2];
                if (game.w == 128) {
                    sprite.trigger("jump45_128", this.xDirection);
                    continue;
                }
                sprite.trigger("jump45", this.xDirection);
                continue;
            }
            if (this.enemyPos[cnt][0] != 2 && this.enemyPos[cnt][1] == this.fsJumpingPlatform90) {
                this.enemyPos[cnt][0] = 2;
                this.xDirection[0] = this.enemyPos[cnt][2];
                sprite.trigger("jump90", this.xDirection);
                continue;
            }
            this.row[0] = cnt;
            sprite.trigger("liveDown", this.row);
            this.enemyPos[cnt][0] = 0;
            game.vibrate(400);
        }
        return 0;
    }

    public boolean draw(BBSGame game, Graphics g, int spriteNo) {
        for (int cnt = 0; cnt < this.enemyPos.length; ++cnt) {
            this.rSprite[0].setFrameSet(this.enemyPos[cnt][1], this.enemyPos[cnt][2]);
            this.rSprite[0].setFrame(this.enemyPos[cnt][3]);
            if (this.enemyPos[cnt][1] == this.fsJumpingPlatform45 || this.enemyPos[cnt][1] == this.fsJumpingPlatform90) {
                this.rSprite[0].setDirection(-this.enemyPos[cnt][2]);
            }
            if (this.enemyPos[cnt][4] == 0) {
                this.rSprite[0].x = this.enemyPos[cnt][2] == -1 ? this.leftLimit(game, cnt) : this.rightLimit(game, cnt);
            } else {
                this.rSprite[0].x = this.enemyPos[cnt][4];
                if (game.gameState == 5 && (this.enemyPos[cnt][1] == this.fsGrayBat || this.enemyPos[cnt][1] == this.fsPurpleBat)) {
                    this.rSprite[0].x -= this.enemyPos[cnt][2];
                    if (this.enemyPos[cnt][2] == 1 && this.rSprite[0].x == this.leftLimit(game, cnt) || this.enemyPos[cnt][2] == -1 && this.rSprite[0].x == this.rightLimit(game, cnt)) {
                        int[] nArray = this.enemyPos[cnt];
                        nArray[2] = nArray[2] * -1;
                    }
                }
            }
            this.enemyPos[cnt][4] = this.rSprite[0].x;
            this.rSprite[0].y = this.enemyPos[cnt][5] * game.tileSet.tileHeight;
            this.rSprite[0].paint(game, g);
        }
        return true;
    }

    private int leftLimit(BBSGame game, int row) {
        return game.tileSet.tileWidth * 5 / 2 + this.rSprite[0].sData.width * this.ropeRates[this.enemyPos[row][1] - 1] / 100;
    }

    private int rightLimit(BBSGame game, int row) {
        if (game.w == 128) {
            return game.tileSet.fullW - game.tileSet.tileWidth * 7 / 2 - this.rSprite[0].sData.width * this.ropeRates[this.enemyPos[row][1] - 1] / 100;
        }
        return game.tileSet.fullW - game.tileSet.tileWidth * 5 / 2 - this.rSprite[0].sData.width * this.ropeRates[this.enemyPos[row][1] - 1] / 100;
    }
}

