/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.input;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.input.IController;
import com.jarbull.efw.input.Point;
import com.jarbull.efw.util.MathEx;
import java.util.Vector;

public class TouchPad
implements IController {
    private Vector a = new Vector();
    private boolean b;

    public Point adaptXY(Point point) {
        int n2 = ResolutionHandler.getInstance().adaptX(point.getX(), point.getY());
        int n3 = ResolutionHandler.getInstance().adaptY(point.getX(), point.getY());
        return new Point(n2, n3);
    }

    public Point adaptXY(Point point, boolean bl) {
        if (bl) {
            this.a.addElement(point);
        }
        return this.adaptXY(point);
    }

    public int getDirectionAngle() {
        int n2 = 0;
        Point point = (Point)this.a.elementAt(0);
        for (int i2 = 1; i2 < this.a.size(); ++i2) {
            n2 += MathEx.getLineAngle(point, (Point)this.a.elementAt(i2));
        }
        return n2 / (this.a.size() - 1);
    }

    public void clearPath() {
        this.a.removeAllElements();
    }

    public boolean checkCollisionWithPath(int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            Point point = (Point)this.a.elementAt(i2);
            if (point.getX() < n2 || point.getX() > n2 + n4 || point.getY() < n3 || point.getY() > n3 + n5) continue;
            return true;
        }
        return false;
    }

    public Point[] getPath() {
        Point[] pointArray = new Point[this.a.size()];
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            pointArray[i2] = (Point)this.a.elementAt(i2);
        }
        return pointArray;
    }

    public boolean isEnabled() {
        return this.b;
    }

    public void setEnabled(boolean bl) {
        this.b = bl;
    }

    public boolean isSupported() {
        return false;
    }
}

