/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game;

import com.apr.game.Game;
import com.apr.game.font.Font;
import com.apr.game.sound.SoundClass;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Utils {
    protected static int W;
    protected static int H;
    protected static int HALF_W;
    protected static int HALF_H;
    private static Random RAND;
    public static Font font;
    public static Font fontSmall;
    public static Font fontTransparent;
    public static boolean soundOn;
    public static boolean vibrate;
    protected static SoundClass currentPlayed;

    public static Image loadImage(String path) throws IOException {
        return Image.createImage((String)path);
    }

    public static boolean inBounds(int x, int y, int pX, int pY, int w, int h) {
        return x >= pX && y >= pY && x <= pX + w && y <= pY + h;
    }

    public static void gradientBox(Graphics g, int color1, int color2, int left, int top, int width, int height, boolean orientation) {
        int max = orientation ? height : width;
        for (int i = 0; i < max; ++i) {
            int color = Utils.midColor(color1, color2, max * (max - 1 - i) / (max - 1), max);
            g.setColor(color);
            if (orientation) {
                g.drawLine(left, top + i, left + width - 1, top + i);
                continue;
            }
            g.drawLine(left + i, top, left + i, top + height - 1);
        }
    }

    private static int midColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 >> 0 & 0xFF) * prop + (color2 >> 0 & 0xFF) * (max - prop)) / max;
        int color = red << 16 | green << 8 | blue;
        return color;
    }

    public static void setSize(int w, int h) {
        W = w;
        H = h;
        HALF_H = H / 2;
        HALF_W = W / 2;
    }

    public static int nextInt(int i) {
        return RAND.nextInt(i);
    }

    public static void playSound(SoundClass sound) {
        if (!soundOn) {
            return;
        }
        if (currentPlayed != null) {
            currentPlayed.deactivate();
        }
        currentPlayed = sound;
        sound.play();
    }

    public static void changeSound(boolean enabled) {
        soundOn = enabled;
    }

    protected static void vibrate(MIDlet midlet) {
        if (vibrate) {
            Display.getDisplay((MIDlet)midlet).vibrate(Game.frameRate);
        }
    }

    public static Image scaleImage(Image sourceImage, int newWidth, int newHeight) {
        int oldWidth = sourceImage.getWidth();
        int oldHeight = sourceImage.getHeight();
        int[] inputData = new int[oldWidth * oldHeight];
        sourceImage.getRGB(inputData, 0, oldWidth, 0, 0, oldWidth, oldHeight);
        int[] outputData = new int[newWidth * newHeight];
        int YD = (oldHeight / newHeight - 1) * oldWidth;
        int YR = oldHeight % newHeight;
        int XD = oldWidth / newWidth;
        int XR = oldWidth % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                outputData[outOffset++] = inputData[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += oldWidth;
        }
        return Image.createRGBImage((int[])outputData, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public static Image rotateImage(Image src, float angle) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int[] srcData = new int[sw * sh];
        src.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        int[] dstData = new int[sw * sh];
        double rads = (double)angle * Math.PI / 180.0;
        float sa = (float)Math.sin(rads);
        float ca = (float)Math.cos(rads);
        int isa = (int)(256.0f * sa);
        int ica = (int)(256.0f * ca);
        int my = -(sh >> 1);
        for (int i = 0; i < sh; ++i) {
            int wpos = i * sw;
            int xacc = my * isa - (sw >> 1) * ica + (sw >> 1 << 8);
            int yacc = my * ica + (sw >> 1) * isa + (sh >> 1 << 8);
            for (int j = 0; j < sw; ++j) {
                int srcx = xacc >> 8;
                int srcy = yacc >> 8;
                if (srcx < 0) {
                    srcx = 0;
                }
                if (srcy < 0) {
                    srcy = 0;
                }
                if (srcx > sw - 1) {
                    srcx = sw - 1;
                }
                if (srcy > sh - 1) {
                    srcy = sh - 1;
                }
                dstData[wpos++] = srcData[srcx + srcy * sw];
                xacc += ica;
                yacc -= isa;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)sw, (int)sh, (boolean)true);
    }

    static {
        RAND = new Random();
        vibrate = true;
    }
}

