/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.animations;

import com.apr.game.animations.Animation;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageEffects59
extends Animation {
    int[] imageData;
    int width;
    int height;
    int alpha;
    int steps;
    int currentStep = 0;
    int x;
    int y;
    int var1;
    byte type = (byte)-1;
    Random r = new Random();
    public static final byte ANIMATION_DISOLVE_OUT = 0;
    public static final byte ANIMATION_FADE_OUT = 1;
    public static final byte ANIMATION_FADE_IN = 2;
    public static final byte ANIMATION_WIPE_TOP_TO_BOTTOM = 3;
    public static final byte STATIC_ALPHA_CHANGE = 4;

    public ImageEffects59(Image img, int x, int y) {
        this.x = x;
        this.y = y;
        this.getRGB(img);
        for (int i = 0; i < this.imageData.length; ++i) {
            int a = this.imageData[i] >> 24 & 0xFF;
            int r = this.imageData[i] >> 16 & 0xFF;
            int g = this.imageData[i] >> 8 & 0xFF;
            int b = this.imageData[i] & 0xFF;
            r = 255 - r;
            g = 255 - g;
            b = 255 - b;
            this.imageData[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    public ImageEffects59(Image img, int variable, byte type, int x, int y) {
        this.x = x;
        this.y = y;
        this.steps = variable;
        this.type = type;
        this.getRGB(img);
        switch (type) {
            case 0: {
                this.var1 = this.imageData.length / variable;
                break;
            }
            case 1: {
                this.var1 = 255 / variable + 1;
                break;
            }
            case 2: {
                for (int i = 0; i < this.imageData.length; ++i) {
                    int a = this.imageData[i] >> 24 & 0xFF;
                    if (a == 0) continue;
                    int color = this.imageData[i] & 0xFFFFFF;
                    a = 1;
                    this.imageData[i] = color += (a <<= 24);
                }
                this.var1 = 255 / variable + 1;
                break;
            }
            case 3: {
                this.var1 = this.height / variable;
                if (this.var1 * variable >= this.height) break;
                ++this.var1;
                break;
            }
            case 4: {
                for (int i = 0; i < this.imageData.length; ++i) {
                    int a = this.imageData[i] >> 24 & 0xFF;
                    if (a == 0) continue;
                    int color = this.imageData[i] & 0xFFFFFF;
                    a = variable;
                    this.imageData[i] = color += (a <<= 24);
                }
                break;
            }
        }
    }

    public void enter() {
    }

    public void getRGB(Image img) {
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.imageData = new int[this.width * this.height];
        img.getRGB(this.imageData, 0, this.width, 0, 0, this.width, this.height);
    }

    public void update(int time) {
        if (this.done) {
            return;
        }
        switch (this.type) {
            case 0: {
                int maxCount = 0;
                for (int i = 0; i < this.var1; ++i) {
                    if (++maxCount == this.var1 * 5) {
                        return;
                    }
                    int rand = Math.abs(this.r.nextInt() % this.imageData.length);
                    if (this.imageData[rand] != 0) {
                        this.imageData[rand] = 0;
                        continue;
                    }
                    --i;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.imageData.length; ++i) {
                    int a = this.imageData[i] >> 24 & 0xFF;
                    int color = this.imageData[i] & 0xFFFFFF;
                    if ((a -= this.var1) < 0) {
                        a = 0;
                    }
                    this.imageData[i] = color += (a <<= 24);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.imageData.length; ++i) {
                    int a = this.imageData[i] >> 24 & 0xFF;
                    if (a == 0) continue;
                    int color = this.imageData[i] & 0xFFFFFF;
                    if ((a += this.var1) > 255) {
                        a = 255;
                    }
                    this.imageData[i] = color += (a <<= 24);
                }
                break;
            }
            case 3: {
                int start;
                for (int i = start = this.currentStep * this.width * this.var1; i < start + this.width * this.var1 && i < this.imageData.length; ++i) {
                    this.imageData[i] = 0;
                }
                break;
            }
        }
        ++this.currentStep;
        if (this.currentStep == this.steps) {
            this.done = true;
        }
    }

    public void render(Graphics g) {
        g.drawRGB(this.imageData, 0, this.width, this.x, this.y, this.width, this.height, true);
    }
}

