/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.buttons.Buttons;
import com.apr.game.displayable.Background;
import com.apr.game.displayable.Title;
import com.apr.game.states.StateMoving;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public class StateMainMenu
extends StateMoving {
    protected Background background;
    protected Title title;
    protected Buttons buttons;
    public static byte NEXT_STATE;

    public StateMainMenu(byte type, Buttons buttons, Background background, int increase) throws IOException {
        super(type, increase);
        this.background = background;
        this.buttons = buttons;
    }

    public StateMainMenu(byte type, Background background, int increase) throws IOException {
        super(type, increase);
        this.background = background;
    }

    public void setButtons(Buttons b) {
        this.buttons = b;
    }

    public void enter() throws IOException, MediaException {
        super.enter();
        this.done = false;
        this.background.enter();
        this.title.enter();
        this.buttons.enter(-W, this.title.getH() * 2);
    }

    public void exit() throws MediaException {
        this.title.exit();
        this.buttons.exit();
    }

    public void update(int time) throws IOException, MediaException {
        if (this.state != 0) {
            this.buttons.updatePosition(this.increase, 0);
        }
        super.update(time);
    }

    public void render(Graphics g) {
        this.background.render(g);
        this.title.render(g);
        this.buttons.render(g);
    }

    public byte nextState() {
        return NEXT_STATE;
    }

    protected void moveUp() {
        this.buttons.moveUp();
    }

    protected void moveDown() {
        this.buttons.moveDown();
    }

    protected void fire() {
        this.buttons.fire();
        this.startEnding();
    }

    protected void checkClick(int x, int y) {
        if (this.buttons.checkButton(x, y)) {
            this.fire();
        }
    }
}

