/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.apr.game.Game;
import com.apr.game.Utils;
import com.apr.game.buttons.ButtonYesNoShadow;
import com.apr.game.displayable.Background;
import com.apr.game.font.J2MEFont;
import com.apr.game.sound.SoundClass;
import com.apr.game.states.State;
import com.apr.game.states.StateAbout;
import com.apr.game.states.StateIntro;
import com.apr.game.states.StateMachine;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;
import logic.GameState;
import logic.TTTConstants;
import states.StateContinueYesNo;
import states.StateInstructions;
import states.StateMainMenuTTT;
import states.StateOptions;
import states.StatePlay;

public class TTTGame
extends Game {
    public static Locale locale;
    public static final byte STATE_MACHINE = 0;
    public static final byte STATE_INTRO = 1;
    public static final byte STATE_CONTINUE = 2;
    public static final byte STATE_CONTINUE2 = 3;
    public static final byte STATE_MENU = 4;
    public static final byte STATE_PLAY = 5;
    public static final byte STATE_INSTRUCTIONS = 6;
    public static final byte STATE_OPTIONS = 7;
    public static final byte STATE_ABOUT = 8;
    public static final byte STATE_FINISH = -1;
    public static Image imgButton;

    public TTTGame(MIDlet mIDlet) {
        super(mIDlet);
    }

    protected void initSettings() throws IOException, MediaException {
        State.game = this;
        Utils.font = new J2MEFont(0, 1);
        Utils.fontSmall = new J2MEFont(8, 0);
        locale = new Locale();
        ButtonYesNoShadow.YES = Locale.getString("Yes");
        ButtonYesNoShadow.NO = Locale.getString("No");
        TTTConstants.loadValues();
        imgButton = Image.createImage((String)"/images/button.png");
        Image image = Image.createImage((String)"/images/button_shadow.png");
        Background background = new Background();
        background.enter();
        GameState.setBackground(background);
        SoundClass.EXTENSION = ".amr";
        SoundClass.TYPE = "audio/amr";
        this.machine = new StateMachine(0, -1);
        State[] stateArray = new State[]{new StateIntro(1, 3000, 2, true), new StateContinueYesNo(2, 5, 4, background), new StateMainMenuTTT(4, background, 30, imgButton), new StateContinueYesNo(3, 5, 5, background), new StatePlay(5, 4, background, 30), new StateInstructions(6, 4, background, 30), new StateOptions(7, 4, 1, image), new StateAbout(8, 4, background)};
        this.machine.addStates(stateArray);
        this.machine.setDefaultState(stateArray[0]);
        State.setSize(this.getWidth(), 320);
        GameState.NUM_ANIMS = 5;
    }

    public void start() {
        this.done = false;
        new Thread(this).start();
    }
}

