/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.apr.game.Utils;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TTTConstants
extends Utils {
    public static final Boolean FALSE = new Boolean(false);
    public static final Boolean TRUE = new Boolean(true);
    public static final String[] COLORS_STRING = new String[]{"yellow", "orange", "green", "blue"};
    public static final boolean TURN_X = true;
    public static final boolean TURN_O = false;
    public static final byte NO_WIN = -1;
    public static final int YELLOW = 0xFFFF00;
    public static String SOUND_STRING = "sound";
    public static String VIBRATION_STRING = "vibration";
    public static String CURRENT_SIZE_STRING = "board_size";
    public static String FINISH_ROW_STRING = "finish";
    public static String GAME_POINTS_STRING = "game_points";
    public static String TIMED_GAME_STRING = "timed_gamed";
    public static String TURN_TIME_STRING = "turn_time";
    public static String COMPUTER_OPONENT_STRING = "computer_oponent";
    public static String COMPUTER_LEVEL_STRING = "level";
    public static String WHO_STARTS_STRING = "who_starts";
    public static String X_NAME_STRING = "x_name";
    public static String O_NAME_STRING = "o_name";
    public static String X_COLOR_STRING = "x_color";
    public static String O_COLOR_STRING = "o_color";
    public static String PLAYER_PIECE_STRING = "player_piece";
    public static final byte EMPTY = 0;
    public static final byte X = 1;
    public static final byte O = 2;
    public static final byte SWITCH = 3;
    public static final byte RANDOM = 4;
    public static final byte[] BOARD_SIZES = new byte[]{3, 4, 5};
    public static final byte[] TIMES = new byte[]{20, 30, 40};
    public static final byte[] FINISH_OPTIONS = new byte[]{3, 4, 5};
    public static boolean TOURNAMENT = true;
    public static byte BOARD_SIZE = 0;
    public static byte FINISH_CRITERIA = 0;
    public static byte GAME_POINTS = (byte)10;
    public static boolean TIMED_GAME = false;
    public static byte TURN_TIME = 0;
    public static boolean COMPUTER_OPONENT = true;
    public static byte COMPUTER_LEVEL = 1;
    public static byte WHO_STARTS = 0;
    public static String X_NAME;
    public static String O_NAME;
    public static byte X_COLOR;
    public static byte O_COLOR;
    public static byte PLAYER_PIECE;

    public static void loadValues() {
        TTTConstants.loadSound();
        TTTConstants.loadVibration();
        TTTConstants.loadSize();
        TTTConstants.loadFinish();
        TTTConstants.loadGamePoints();
        TTTConstants.loadTimedGame();
        TTTConstants.loadTurnTime();
        TTTConstants.loadComputerOponent();
        TTTConstants.loadComputerLevel();
        TTTConstants.loadWhoStarts();
        TTTConstants.loadXName();
        TTTConstants.loadOName();
        TTTConstants.loadXColor();
        TTTConstants.loadOColor();
    }

    public static void loadSound() {
        Boolean bl = TTTConstants.checkBoolean(SOUND_STRING);
        if (bl != null) {
            Utils.soundOn = bl;
        }
    }

    public static void loadVibration() {
        Boolean bl = TTTConstants.checkBoolean(VIBRATION_STRING);
        if (bl != null) {
            Utils.vibrate = bl;
        }
    }

    public static void loadSize() {
        Byte by = TTTConstants.checkByte(CURRENT_SIZE_STRING);
        if (by != null) {
            BOARD_SIZE = by;
        }
    }

    public static void loadFinish() {
        Byte by = TTTConstants.checkByte(FINISH_ROW_STRING);
        if (by != null) {
            FINISH_CRITERIA = by;
        }
    }

    public static void loadGamePoints() {
        Byte by = TTTConstants.checkByte(GAME_POINTS_STRING);
        if (by != null) {
            GAME_POINTS = by;
        }
    }

    public static void loadTimedGame() {
        Boolean bl = TTTConstants.checkBoolean(TIMED_GAME_STRING);
        if (bl != null) {
            TIMED_GAME = bl;
        }
    }

    public static void loadTurnTime() {
        Byte by = TTTConstants.checkByte(TURN_TIME_STRING);
        if (by != null) {
            TURN_TIME = by;
        }
    }

    public static void loadComputerOponent() {
        Boolean bl = TTTConstants.checkBoolean(COMPUTER_OPONENT_STRING);
        if (bl != null) {
            COMPUTER_OPONENT = bl;
        }
    }

    public static void loadComputerLevel() {
        Byte by = TTTConstants.checkByte(COMPUTER_LEVEL_STRING);
        if (by != null) {
            COMPUTER_LEVEL = by;
        }
    }

    public static void loadWhoStarts() {
        Byte by = TTTConstants.checkByte(WHO_STARTS_STRING);
        if (by != null) {
            WHO_STARTS = by;
        }
    }

    public static void loadXName() {
        String string = TTTConstants.checkString(X_NAME_STRING);
        if (string != null) {
            X_NAME = string;
        }
    }

    public static void loadOName() {
        String string = TTTConstants.checkString(O_NAME_STRING);
        if (string != null) {
            O_NAME = string;
        }
    }

    public static void loadXColor() {
        Byte by = TTTConstants.checkByte(X_COLOR_STRING);
        if (by != null) {
            X_COLOR = by;
        }
    }

    public static void loadOColor() {
        Byte by = TTTConstants.checkByte(O_COLOR_STRING);
        if (by != null) {
            O_COLOR = by;
        }
    }

    public static void loadPlayerPiece() {
        Byte by = TTTConstants.checkByte(PLAYER_PIECE_STRING);
        if (by != null) {
            PLAYER_PIECE = by;
        }
    }

    public static void save(String string, boolean bl) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            String string2 = String.valueOf(bl);
            int n = 1;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.numRecords() == 0) {
                recordStore.addRecord(string2.getBytes(), 0, string2.length());
            } else {
                while (recordEnumeration.hasNextElement()) {
                    n = recordEnumeration.nextRecordId();
                }
                recordStore.setRecord(n, string2.getBytes(), 0, string2.length());
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public static void save(String string, byte by) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            String string2 = String.valueOf(by);
            int n = 1;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.numRecords() == 0) {
                recordStore.addRecord(string2.getBytes(), 0, string2.length());
            } else {
                while (recordEnumeration.hasNextElement()) {
                    n = recordEnumeration.nextRecordId();
                }
                recordStore.setRecord(n, string2.getBytes(), 0, string2.length());
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    private static Boolean checkBoolean(String string) {
        try {
            String string2 = "";
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                string2 = new String(recordStore.getRecord(recordEnumeration.nextRecordId()));
            }
            if (string2.equals("false")) {
                return FALSE;
            }
            if (string2.equals("true")) {
                return TRUE;
            }
            return null;
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
    }

    private static Byte checkByte(String string) {
        try {
            String string2 = "";
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                string2 = new String(recordStore.getRecord(recordEnumeration.nextRecordId()));
            }
            return new Byte((byte)Integer.valueOf(string2).intValue());
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String checkString(String string) {
        try {
            String string2 = "";
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                string2 = new String(recordStore.getRecord(recordEnumeration.nextRecordId()));
            }
            return string2;
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        X_COLOR = 0;
        O_COLOR = 0;
        PLAYER_PIECE = 0;
    }
}

