/*
 * Decompiled with CFR 0.152.
 */
package net.jscience.math.waba;

import waba.sys.Convert;

public abstract class MathFP {
    private static int _fbits = 12;
    private static int _digits = 4;
    private static int _one = 4096;
    private static int _fmask = 4095;
    private static int _dmul = 10000;
    private static int _flt = 0;
    private static int _pi = 12868;
    private static int[] e = new int[]{_one, 11134, 30266, 82270, 223636};
    public static int PI = _pi;
    public static int E = e[1];
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;
    private static int err_no = 0;

    public static int setPrecision(int n) {
        if (n > 12 || n < 0) {
            return _digits;
        }
        _fbits = n;
        _one = 1 << n;
        _flt = 12 - n;
        _digits = 0;
        _dmul = 1;
        _fmask = _one - 1;
        PI = _pi >> _flt;
        E = e[1] >> _flt;
        int n2 = _one;
        while (n2 != 0) {
            n2 /= 10;
            ++_digits;
            _dmul *= 10;
        }
        return _digits;
    }

    public static int getPrecision() {
        return _fbits;
    }

    public static int toInt(int n) {
        if (n < 0) {
            return -(MathFP.round(-n, 0) >> _fbits);
        }
        return MathFP.round(n, 0) >> _fbits;
    }

    public static int toFP(int n) {
        return n << _fbits;
    }

    public static int convert(int n, int n2) {
        int n3;
        int n4 = n3 = n < 0 ? -1 : 1;
        if (MathFP.abs(n2) < 13) {
            n = _fbits < n2 ? n + n3 * (1 << (n2 - _fbits >> 1)) >> n2 - _fbits : (n <<= _fbits - n2);
        }
        return n;
    }

    public static int toFP(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        String string2 = "-1";
        int n2 = MathFP.pointIndex(string);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
            while (string2.length() < _digits) {
                string2 = string2 + "0";
            }
            if (string2.length() > _digits) {
                string2 = string2.substring(0, _digits);
            }
        } else {
            n2 = string.length();
        }
        int n3 = 0;
        if (n != n2) {
            n3 = Convert.toInt((String)string.substring(n, n2));
        }
        int n4 = Convert.toInt((String)string2) + 1;
        int n5 = (n3 << _fbits) + (n4 << _fbits) / _dmul;
        if (n == 1) {
            n5 = -n5;
        }
        return n5;
    }

    public static String toString(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = n >> _fbits;
        int n3 = _dmul * (n & _fmask) >> _fbits;
        String string = Convert.toString((int)n3);
        while (string.length() < _digits) {
            string = "0" + string;
        }
        return (bl ? "-" : "") + Convert.toString((int)n2) + "." + string;
    }

    public static String toString(int n, int n2) {
        if (n2 > _digits) {
            n2 = _digits;
        }
        String string = MathFP.toString(MathFP.round(n, n2));
        return string.substring(0, string.length() - _digits + n2);
    }

    public static int max(int n, int n2) {
        return n < n2 ? n2 : n;
    }

    public static int min(int n, int n2) {
        return n2 < n ? n2 : n;
    }

    public static int round(int n, int n2) {
        int n3 = 10;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= 10;
            ++n4;
        }
        n3 = MathFP.div(MathFP.toFP(5), MathFP.toFP(n3));
        if (n < 0) {
            n3 = -n3;
        }
        return n + n3;
    }

    public static int mul(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        int n4 = _fmask;
        if ((n & n4) == 0) {
            return (n >> n3) * n2;
        }
        if ((n2 & n4) == 0) {
            return n * (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (MathFP.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            n4 >>= 1;
            --n3;
        }
        int n5 = (n >> n3) * (n2 >> n3) << n3;
        int n6 = (n & n4) * (n2 & n4) >> n3;
        if ((n5 = n5 + (n6 += (n & ~n4) * (n2 & n4) >> n3) + ((n & n4) * (n2 & ~n4) >> n3) << _fbits - n3) < 0) {
            err_no = 2;
            return Integer.MAX_VALUE;
        }
        return bl ? -n5 : n5;
    }

    public static int div(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        if (n2 == _one) {
            return n;
        }
        if ((n2 & _fmask) == 0) {
            return n / (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (MathFP.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            --n3;
        }
        int n4 = (n << n3) / n2 << _fbits - n3;
        return bl ? -n4 : n4;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static int sub(int n, int n2) {
        return n - n2;
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static int sqrt(int n, int n2) {
        if (n < 0) {
            err_no = 1;
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        int n3 = n + _one >> 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 + MathFP.div(n, n3) >> 1;
            ++n4;
        }
        if (n3 < 0) {
            err_no = 2;
            return Integer.MAX_VALUE;
        }
        return n3;
    }

    public static int sqrt(int n) {
        return MathFP.sqrt(n, 16);
    }

    public static int sin(int n) {
        int n2 = MathFP.mul(n, MathFP.div(MathFP.toFP(180), PI));
        if ((n2 %= MathFP.toFP(360)) < 0) {
            n2 = MathFP.toFP(360) + n2;
        }
        int n3 = n2;
        if (n2 >= MathFP.toFP(90) && n2 < MathFP.toFP(270)) {
            n3 = MathFP.toFP(180) - n2;
        } else if (n2 >= MathFP.toFP(270) && n2 < MathFP.toFP(360)) {
            n3 = -(MathFP.toFP(360) - n2);
        }
        int n4 = n3 / 90;
        int n5 = MathFP.mul(n4, n4);
        int n6 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-18 >> _flt, n5) + (326 >> _flt), n5) - (2646 >> _flt), n5) + (6434 >> _flt), n4);
        return n6;
    }

    public static int asin(int n) {
        boolean bl;
        if (MathFP.abs(n) > _one) {
            err_no = 1;
            return -1;
        }
        boolean bl2 = bl = n < 0;
        if (n < 0) {
            n = -n;
        }
        int n2 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(35 >> _flt, n) - (146 >> _flt), n) + (347 >> _flt), n) - (877 >> _flt), n) + (6434 >> _flt);
        int n3 = PI / 2 - MathFP.mul(MathFP.sqrt(_one - n), n2);
        return bl ? -n3 : n3;
    }

    public static int cos(int n) {
        return MathFP.sin(PI / 2 - n);
    }

    public static int acos(int n) {
        return PI / 2 - MathFP.asin(n);
    }

    public static int tan(int n) {
        return MathFP.div(MathFP.sin(n), MathFP.cos(n));
    }

    public static int cot(int n) {
        return MathFP.div(MathFP.cos(n), MathFP.sin(n));
    }

    public static int atan(int n) {
        return MathFP.asin(MathFP.div(n, MathFP.sqrt(_one + MathFP.mul(n, n))));
    }

    public static int exp(int n) {
        if (n == 0) {
            return _one;
        }
        boolean bl = n < 0;
        n = MathFP.abs(n);
        int n2 = n >> _fbits;
        int n3 = _one;
        int n4 = 0;
        while (n4 < n2 / 4) {
            n3 = MathFP.mul(n3, e[4] >> _flt);
            ++n4;
        }
        if (n2 % 4 > 0) {
            n3 = MathFP.mul(n3, e[n2 % 4] >> _flt);
        }
        if ((n &= _fmask) > 0) {
            int n5 = _one;
            int n6 = 0;
            int n7 = 1;
            int n8 = 0;
            while (n8 < 16) {
                n6 += n5 / n7;
                if ((n7 *= n8 + 1) > (n5 = MathFP.mul(n5, n)) || n5 <= 0 || n7 <= 0) break;
                ++n8;
            }
            n3 = MathFP.mul(n3, n6);
        }
        if (bl) {
            n3 = MathFP.div(_one, n3);
        }
        return n3;
    }

    public static int log(int n) {
        if (n <= 0) {
            err_no = 1;
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n >= _one << 1) {
            n >>= 1;
            ++n4;
        }
        int n5 = n4 * (2839 >> _flt);
        int n6 = 0;
        if (n < _one) {
            return -MathFP.log(MathFP.div(_one, n));
        }
        n -= _one;
        int n7 = 1;
        while (n7 < 20) {
            n3 = n2 == 0 ? n : MathFP.mul(n2, n);
            if (n3 == 0) break;
            n6 += (n7 % 2 == 0 ? -1 : 1) * n3 / n7;
            n2 = n3;
            ++n7;
        }
        return n5 + n6;
    }

    public static int pow(int n, int n2) {
        boolean bl = n2 < 0;
        int n3 = _one;
        n2 = MathFP.abs(n2);
        int n4 = n2 >> _fbits;
        while (n4-- > 0) {
            n3 = MathFP.mul(n3, n);
        }
        if (n3 < 0) {
            err_no = 2;
            return Integer.MAX_VALUE;
        }
        n3 = n != 0 ? MathFP.mul(n3, MathFP.exp(MathFP.mul(MathFP.log(n), n2 & _fmask))) : 0;
        if (bl) {
            return MathFP.div(_one, n3);
        }
        return n3;
    }

    public static int stat() {
        int n = err_no;
        err_no = 0;
        return n;
    }

    private static int pointIndex(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < string.length()) {
            if (cArray[n] == '.') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int atan2(int n, int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 = MathFP.atan(MathFP.div(n, n2));
        } else if (n2 < 0) {
            n3 = (n2 < 0 ? -PI : PI) - MathFP.atan(MathFP.abs(MathFP.div(n, n2)));
        } else {
            if (n2 == 0 && n == 0) {
                err_no = 1;
                return -1;
            }
            n3 = (n2 < 0 ? -PI : PI) / 2;
        }
        return n3;
    }
}

