/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class SoundPlayer {
    Player title_sound;
    Player ingame_sound;
    Player collect_sound;
    Player levelover_sound;
    Player accident_sound;

    public SoundPlayer(MIDlet midlet) {
        this.title_sound = SoundPlayer.sclip(midlet, "/sounds/intro.mid");
        this.ingame_sound = SoundPlayer.sclip(midlet, "/sounds/ingame.mid");
        this.collect_sound = SoundPlayer.sclip(midlet, "/sounds/collect.mid");
        this.accident_sound = SoundPlayer.sclip(midlet, "/sounds/crash_2.mid");
    }

    public static Player sclip(MIDlet midlet, String s) {
        Player player = null;
        try {
            InputStream is = midlet.getClass().getResourceAsStream(s);
            player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            player.prefetch();
            player.realize();
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player;
    }

    public void stopSounds() {
        try {
            this.title_sound.stop();
            this.ingame_sound.stop();
            this.collect_sound.stop();
        }
        catch (Exception e) {
            System.out.println("Error while stoping the sound." + e);
        }
    }

    public void playTitle() {
        this.title_sound.setLoopCount(5);
        this.play(this.title_sound);
    }

    public void playInGame() {
        this.ingame_sound.setLoopCount(5);
        this.play(this.ingame_sound);
    }

    public void playCollect() {
        this.play(this.collect_sound);
    }

    public void playAccident() {
        this.play(this.accident_sound);
    }

    public void playOver() {
        this.playTitle();
    }

    public void play(Player player) {
        try {
            if (player.getState() != 400) {
                player.setMediaTime(0L);
                player.start();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in playing the Sound" + e);
        }
    }
}

