/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Spell;
import com.eternity.castlelords.Warlord;
import com.impossible.util.XCanvas;
import java.util.Enumeration;
import java.util.Hashtable;

public class AIComputer {
    private GameObjects gameObjects;
    private CLGameCanvas canvas;
    public int shot = 0;
    public int actualBattle = 0;
    public int unitBatch = 1;
    public int[] availableSpells;
    public int[] spellsCountdown = new int[Spell.SPELL_NAME_KEYS.length];
    public Hashtable unitsPossibleStrategies = new Hashtable();
    public Hashtable magicPossibleStrategies = new Hashtable();
    public Hashtable buildPossibleStrategies = new Hashtable();
    public int actualUnitsStrategy = 0;
    public int actualMagicStrategy = 0;
    public int actualBuildStrategy = 0;
    public int actualMagicCycles = 0;
    public int actualUnitCycles = 0;
    public int actualBuildCycles = 0;
    public int unitsWeightOffset = 0;
    public int magicWeightOffset = 0;
    public int buildWeightOffset = 0;
    int redTotal = 0;
    int redTotalWalkers = 0;
    int blueTotal = 0;
    int blueTotalWalkers = 0;
    int unitDiff = 0;
    public static final int MINIMUM_UNITS = 3;
    public static final int MAXIMUM_UNITS = 10;
    public static final int MINIMUM_UNITS_QUICK = 4;
    public static final int MINIMUM_GOLD = 100;
    public static final int MINIMUM_CASTLE_POWER = 100;
    public static final int NORMAL_CYCLE = 60;
    public static final int QUICK_CYCLE = 5;

    public AIComputer() {
    }

    public AIComputer(CLGameCanvas canvas, GameObjects gameObjects) {
        this.gameObjects = gameObjects;
        this.canvas = canvas;
        int i = 0;
        while (i < this.spellsCountdown.length) {
            this.spellsCountdown[i] = 0;
            ++i;
        }
    }

    public void setBattleNumber(int actualBattle) {
        this.actualBattle = actualBattle;
    }

    public void resetStrategies() {
        this.buildPossibleStrategies.clear();
        this.unitsPossibleStrategies.clear();
        this.magicPossibleStrategies.clear();
        this.actualBuildStrategy = 0;
        this.actualMagicStrategy = 0;
        this.actualUnitsStrategy = 0;
        this.availableSpells = null;
        int i = 0;
        while (i < this.spellsCountdown.length) {
            this.spellsCountdown[i] = 0;
            ++i;
        }
    }

    public boolean isAvailableSpellType(int spellType) {
        int i = 0;
        while (i < this.availableSpells.length) {
            if (this.availableSpells[i] == spellType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void spellsCountdown() {
        int i = 0;
        while (i < this.spellsCountdown.length) {
            if (this.spellsCountdown[i] > 0) {
                int n = i;
                this.spellsCountdown[n] = this.spellsCountdown[n] - XCanvas.DT;
            } else {
                this.spellsCountdown[i] = 0;
            }
            ++i;
        }
    }

    public int getActualStrategy(Hashtable possibleStrategies) {
        Integer key;
        int maxShot = 0;
        Enumeration enumer = possibleStrategies.keys();
        while (enumer.hasMoreElements()) {
            key = (Integer)enumer.nextElement();
            if (maxShot > key) continue;
            maxShot = key;
        }
        int shot = CLGameCanvas.random(maxShot);
        int result = Integer.MAX_VALUE;
        enumer = possibleStrategies.keys();
        while (enumer.hasMoreElements()) {
            key = (Integer)enumer.nextElement();
            if (shot > key || result <= key) continue;
            result = (Integer)possibleStrategies.get(key);
        }
        return result;
    }

    public void doTurn() {
        this.blueTotal = 0;
        this.redTotal = 0;
        int i = 0;
        while (i < this.gameObjects.redWarlord.unitsCounts.length) {
            this.redTotal += this.gameObjects.redWarlord.unitsCounts[i];
            this.blueTotal += this.gameObjects.blueWarlord.unitsCounts[i];
            ++i;
        }
        this.redTotalWalkers = this.gameObjects.redWarlord.unitsCounts[0] + this.gameObjects.redWarlord.unitsCounts[1] + this.gameObjects.redWarlord.unitsCounts[3];
        this.blueTotalWalkers = this.gameObjects.blueWarlord.unitsCounts[0] + this.gameObjects.blueWarlord.unitsCounts[1] + this.gameObjects.blueWarlord.unitsCounts[3];
        this.unitDiff = this.redTotal > this.blueTotal ? this.redTotal - this.blueTotal : this.blueTotal - this.redTotal;
        this.spellsCountdown();
        switch (this.actualBuildStrategy) {
            case 31: {
                if (this.gameObjects.redWarlord.money < GameObjects.BUILDINGS_PRICES[0][0]) break;
                this.gameObjects.redWarlord.addProduct((byte)2, (byte)0, 1);
                this.actualBuildStrategy = 0;
                break;
            }
            case 32: {
                if (this.gameObjects.redWarlord.money < GameObjects.BUILDINGS_PRICES[0][1]) break;
                this.gameObjects.redWarlord.addProduct((byte)2, (byte)1, 1);
                this.actualBuildStrategy = 0;
                break;
            }
            case 35: {
                if (this.gameObjects.redWarlord.money < GameObjects.BUILDINGS_PRICES[0][3]) break;
                this.gameObjects.redWarlord.addProduct((byte)2, (byte)3, 1);
                this.actualBuildStrategy = 0;
                break;
            }
            case 34: {
                if (this.gameObjects.redWarlord.money < GameObjects.BUILDINGS_PRICES[0][5]) break;
                this.gameObjects.redWarlord.addProduct((byte)2, (byte)5, 1);
                this.actualBuildStrategy = 0;
                break;
            }
            case 36: {
                if (this.gameObjects.redWarlord.money < GameObjects.BUILDINGS_PRICES[0][4]) break;
                this.gameObjects.redWarlord.addProduct((byte)2, (byte)4, 1);
                this.canvas.addSpell(1, false);
                this.actualBuildStrategy = 0;
                break;
            }
            case 37: {
                this.canvas.razeWall(false);
                this.actualBuildStrategy = 0;
            }
        }
        if (this.actualBuildCycles < 1) {
            switch (this.actualUnitsStrategy) {
                case 11: {
                    if (this.gameObjects.redWarlord.money < this.unitBatch * this.gameObjects.redWarlord.getUnitPrice((byte)0, (byte)0)) break;
                    this.gameObjects.redWarlord.addProduct((byte)0, (byte)0, this.unitBatch);
                    this.unitBatch = 1;
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 12: {
                    if (this.gameObjects.redWarlord.money < this.unitBatch * this.gameObjects.redWarlord.getUnitPrice((byte)0, (byte)1)) break;
                    this.gameObjects.redWarlord.addProduct((byte)0, (byte)1, this.unitBatch);
                    this.unitBatch = 1;
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 13: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUnitPrice((byte)0, (byte)2)) break;
                    this.gameObjects.redWarlord.addProduct((byte)0, (byte)2, 1);
                    this.unitBatch = 1;
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 15: {
                    if (this.gameObjects.redWarlord.money < this.unitBatch * this.gameObjects.redWarlord.getUnitPrice((byte)0, (byte)3)) break;
                    this.gameObjects.redWarlord.addProduct((byte)0, (byte)3, this.unitBatch);
                    this.unitBatch = 1;
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 14: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUnitPrice((byte)0, (byte)4)) break;
                    this.gameObjects.redWarlord.addProduct((byte)0, (byte)4, 1);
                    this.unitBatch = 1;
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 41: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUpgradePrice(0, 0)) break;
                    this.gameObjects.redWarlord.addProduct((byte)1, (byte)0, 1);
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 42: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUpgradePrice(0, 1)) break;
                    this.gameObjects.redWarlord.addProduct((byte)1, (byte)1, 1);
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 43: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUpgradePrice(0, 2)) break;
                    this.gameObjects.redWarlord.addProduct((byte)1, (byte)2, 1);
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 45: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUpgradePrice(0, 3)) break;
                    this.gameObjects.redWarlord.addProduct((byte)1, (byte)3, 1);
                    this.actualUnitsStrategy = 0;
                    break;
                }
                case 44: {
                    if (this.gameObjects.redWarlord.money < this.gameObjects.redWarlord.getUpgradePrice(0, 4)) break;
                    this.gameObjects.redWarlord.addProduct((byte)1, (byte)4, 1);
                    this.actualUnitsStrategy = 0;
                }
            }
            this.actualBuildCycles = this.blueTotal >= 4 ? 5 : 60;
        } else {
            --this.actualBuildCycles;
        }
        if (this.gameObjects.redWarlord.mana >= this.gameObjects.redWarlord.getSpellPriceByType(this.actualMagicStrategy) && this.actualMagicStrategy != 0 && this.canvas.addSpell(this.actualMagicStrategy, false)) {
            this.spellsCountdown[this.actualMagicStrategy] = Spell.getCoolDownByType(this.actualMagicStrategy, this.gameObjects.redWarlord.intelligence);
            this.actualMagicStrategy = 0;
            this.actualMagicCycles = 60;
        }
        if (this.actualUnitsStrategy == 14 && this.gameObjects.redWarlord.underSiege) {
            this.actualUnitsStrategy = 0;
        }
        if (this.actualUnitsStrategy == 13 && this.gameObjects.redWarlord.underSiege) {
            this.actualUnitsStrategy = 0;
        }
        if (this.actualUnitsStrategy == 0 && (this.actualBuildStrategy != 31 || this.actualBuildStrategy != 32 || this.actualBuildStrategy != 35)) {
            this.chooseUnitsStrategy();
        }
        if (this.actualMagicCycles < 1) {
            if (this.actualMagicStrategy == 0) {
                this.chooseMagicStrategy();
            }
        } else {
            --this.actualMagicCycles;
        }
        if (this.actualBuildStrategy == 0) {
            this.chooseBuildStrategy();
        }
    }

    public int getStrongestWarlordUnit() {
        int unitType = 0;
        int hp = 0;
        int pp = 0;
        Warlord warlord = this.gameObjects.redWarlord;
        if (warlord.getUnitHP(0) > hp && warlord.getUnitPP(0) > pp) {
            hp = warlord.getUnitHP(0);
            pp = warlord.getUnitPP(0);
            unitType = 0;
        }
        if (warlord.getUnitHP(1) > hp && warlord.getUnitPP(1) > pp) {
            hp = warlord.getUnitHP(1);
            pp = warlord.getUnitPP(1);
            unitType = 1;
        }
        if (warlord.getUnitHP(3) > hp && warlord.getUnitPP(3) > pp) {
            hp = warlord.getUnitHP(3);
            pp = warlord.getUnitPP(3);
            unitType = 3;
        }
        return unitType;
    }

    public void setStandardWeightsForBPerson(int personPointer) {
        int weight = 0;
        if (this.redTotalWalkers < 10 || this.redTotalWalkers < this.blueTotalWalkers) {
            if (this.gameObjects.redWarlord.unitsLevel[0] > 0) {
                weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_PIKER_POINTER];
                this.addToPossibleUnitsStrategies((byte)0, weight, 0);
            }
            if (this.gameObjects.redWarlord.unitsLevel[1] > 0) {
                weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_KNIGHT_POINTER];
                this.addToPossibleUnitsStrategies((byte)0, weight, 1);
            }
            if (this.gameObjects.redWarlord.unitsLevel[3] > 0) {
                weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_RIDER_POINTER];
                this.addToPossibleUnitsStrategies((byte)0, weight, 3);
            }
        }
        if (this.gameObjects.redWarlord.unitsCounts[2] < 1 && this.gameObjects.redWarlord.unitsLevel[2] > 0 && this.gameObjects.redWarlord.castleLevel > 1 && !this.gameObjects.redWarlord.underSiege) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_ARCHER_POINTER];
            this.addToPossibleUnitsStrategies((byte)0, weight, 2);
        }
        if (this.gameObjects.redWarlord.unitsCounts[4] < 1 && this.gameObjects.redWarlord.unitsLevel[4] > 0 && this.gameObjects.redWarlord.canBuildWall && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)4) && !this.gameObjects.redWarlord.underSiege) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_CANNON_POINTER];
            this.addToPossibleUnitsStrategies((byte)0, weight, 4);
        }
        if (this.gameObjects.redWarlord.unitsLevel[0] < 5) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.UPG_PIKER_POINTER];
            this.addToPossibleUnitsStrategies((byte)1, weight, 0);
        }
        if (this.gameObjects.redWarlord.unitsLevel[1] < 5) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.UPG_KNIGHT_POINTER];
            this.addToPossibleUnitsStrategies((byte)1, weight, 1);
        }
        if (this.gameObjects.redWarlord.unitsLevel[3] < 5) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.UPG_RIDER_POINTER];
            this.addToPossibleUnitsStrategies((byte)1, weight, 3);
        }
        if (this.gameObjects.redWarlord.unitsLevel[2] < 5 && this.gameObjects.redWarlord.castleLevel > 1) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.UPG_ARCHER_POINTER];
            this.addToPossibleUnitsStrategies((byte)1, weight, 2);
        }
        if (this.gameObjects.redWarlord.unitsLevel[4] < 5) {
            weight = GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.UPG_CANNON_POINTER];
            this.addToPossibleUnitsStrategies((byte)1, weight, 4);
        }
    }

    public void setBatchProductionForBPerson() {
        int weight = 0;
        int commanders = 0;
        Warlord redWarlord = this.gameObjects.redWarlord;
        if (this.redTotal < this.blueTotal || this.gameObjects.redWarlord.underSiege) {
            if (redWarlord.hasBattlePerson(Warlord.SPAMMER1) || redWarlord.hasBattlePerson(Warlord.SPAMMER2) || redWarlord.hasBattlePerson(Warlord.SPAMMER3) || redWarlord.hasBattlePerson(Warlord.VALIANT1) || redWarlord.hasBattlePerson(Warlord.VALIANT2) || redWarlord.hasBattlePerson(Warlord.VALIANT3)) {
                weight += CLGameCanvas.random(3) + 1;
                ++commanders;
            }
            if (redWarlord.hasBattlePerson(Warlord.TITAN1) || redWarlord.hasBattlePerson(Warlord.TITAN2) || redWarlord.hasBattlePerson(Warlord.TITAN3) || redWarlord.hasBattlePerson(Warlord.DEFENDER)) {
                ++weight;
                ++commanders;
            }
            if (redWarlord.hasBattlePerson(Warlord.AVERAGEJOE) || redWarlord.hasBattlePerson(Warlord.SPAMMER4)) {
                weight += CLGameCanvas.random(2) + 1;
                ++commanders;
            }
        } else {
            if (redWarlord.hasBattlePerson(Warlord.SPAMMER1) || redWarlord.hasBattlePerson(Warlord.SPAMMER2) || redWarlord.hasBattlePerson(Warlord.SPAMMER3) || redWarlord.hasBattlePerson(Warlord.VALIANT1) || redWarlord.hasBattlePerson(Warlord.VALIANT2) || redWarlord.hasBattlePerson(Warlord.VALIANT3)) {
                weight += CLGameCanvas.random(2) + 2;
                ++commanders;
            }
            if (redWarlord.hasBattlePerson(Warlord.TITAN1) || redWarlord.hasBattlePerson(Warlord.TITAN2) || redWarlord.hasBattlePerson(Warlord.TITAN3) || redWarlord.hasBattlePerson(Warlord.DEFENDER)) {
                ++weight;
                ++commanders;
            }
            if (redWarlord.hasBattlePerson(Warlord.AVERAGEJOE) || redWarlord.hasBattlePerson(Warlord.SPAMMER4)) {
                weight += CLGameCanvas.random(2) + 1;
                ++commanders;
            }
        }
        this.unitBatch = commanders < 2 ? weight : weight / commanders;
        this.unitBatch = this.unitBatch < 1 ? 1 : this.unitBatch;
    }

    public void chooseUnitsStrategy() {
        this.unitsWeightOffset = 0;
        if (this.unitsPossibleStrategies.size() > 0 && this.actualUnitsStrategy == 0) {
            this.unitsPossibleStrategies.clear();
        }
        this.unitsPossibleStrategies.put(new Integer(0), new Integer(0));
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER1)) {
            this.setStandardWeightsForBPerson(GameObjects.SPAMMER1_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 0);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER2)) {
            this.setStandardWeightsForBPerson(GameObjects.SPAMMER2_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 1);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER3)) {
            this.setStandardWeightsForBPerson(GameObjects.SPAMMER3_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 3);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER4)) {
            this.setStandardWeightsForBPerson(GameObjects.SPAMMER4_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 1);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 3);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN1)) {
            this.setStandardWeightsForBPerson(GameObjects.TITAN1_POINTER);
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 0);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN2)) {
            this.setStandardWeightsForBPerson(GameObjects.TITAN2_POINTER);
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 1);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN3)) {
            this.setStandardWeightsForBPerson(GameObjects.TITAN3_POINTER);
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 3);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT1)) {
            this.setStandardWeightsForBPerson(GameObjects.VALIANT1_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 1);
            }
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 1);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT2)) {
            this.setStandardWeightsForBPerson(GameObjects.VALIANT2_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 3);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 1);
            }
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 3);
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 1);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT3)) {
            this.setStandardWeightsForBPerson(GameObjects.VALIANT3_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 3);
            }
            if (this.redTotal > this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 3);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.DEFENDER)) {
            boolean command = false;
            this.setStandardWeightsForBPerson(GameObjects.DEFENDER_POINTER);
            if (this.redTotal < this.blueTotal + 1) {
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 0);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 3);
            }
            if (this.redTotal > this.blueTotal + 1) {
                int unitType = this.getStrongestWarlordUnit();
                if (this.gameObjects.redWarlord.unitsCounts[5] < 1 && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)5)) {
                    this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, unitType);
                }
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, unitType);
                this.addToPossibleUnitsStrategies((byte)0, this.unitDiff, 4);
                this.addToPossibleUnitsStrategies((byte)1, this.unitDiff, 4);
            }
        }
        if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.AVERAGEJOE)) {
            this.setStandardWeightsForBPerson(GameObjects.AVERAGEJOE_POINTER);
        }
        if (this.actualUnitsStrategy == 0 && this.unitsPossibleStrategies.size() > 0) {
            this.actualUnitsStrategy = this.getActualStrategy(this.unitsPossibleStrategies);
            if (this.actualUnitsStrategy == 11 || this.actualUnitsStrategy == 12 || this.actualUnitsStrategy == 15) {
                this.setBatchProductionForBPerson();
            }
        }
    }

    public void addToPossibleUnitsStrategies(byte type, int weight, int unitType) {
        block0 : switch (type) {
            case 0: {
                if (this.gameObjects.redWarlord.unitsLevel[unitType] <= 0 || this.gameObjects.redWarlord.tt_unit_max_levels[unitType] <= 0 || this.gameObjects.redWarlord.isInProduction((byte)0, (byte)unitType)) break;
                this.unitsWeightOffset += weight;
                switch (unitType) {
                    case 0: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(11));
                        break;
                    }
                    case 1: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(12));
                        break;
                    }
                    case 2: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(13));
                        break;
                    }
                    case 3: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(15));
                        break;
                    }
                    case 4: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(14));
                    }
                }
                break;
            }
            case 1: {
                if (this.gameObjects.redWarlord.unitsLevel[unitType] >= this.gameObjects.redWarlord.tt_unit_max_levels[unitType] || this.gameObjects.redWarlord.isInProduction((byte)1, (byte)unitType)) break;
                this.unitsWeightOffset += weight;
                switch (unitType) {
                    case 0: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(41));
                        break block0;
                    }
                    case 1: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(42));
                        break block0;
                    }
                    case 2: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(43));
                        break block0;
                    }
                    case 3: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(45));
                        break block0;
                    }
                    case 4: {
                        this.unitsPossibleStrategies.put(new Integer(this.unitsWeightOffset), new Integer(44));
                    }
                }
            }
        }
    }

    public void setStandardWeightsForMPerson(int personPointer) {
        int activeOwnEnchants = this.gameObjects.redWarlord.getNumberOfActiveEnchantments();
        int activeEnemyEnchants = this.gameObjects.blueWarlord.getNumberOfActiveEnchantments();
        int warlordLevel = this.gameObjects.redWarlord.intelligence;
        int weight = 0;
        if (this.isAvailableSpellType(2) && (this.gameObjects.blueWarlord.unitsCounts[4] > 0 || this.gameObjects.blueWarlord.unitsCounts[5] > 0)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[0][personPointer];
            this.addToPossibleMagicStrategies(weight, 2);
        }
        if (this.isAvailableSpellType(3) && activeEnemyEnchants > 0) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[1][personPointer];
            this.addToPossibleMagicStrategies(weight, 3);
        }
        if (this.isAvailableSpellType(4) && (this.gameObjects.blueWarlord.unitsCounts[5] > 0 || this.gameObjects.blueWarlord.unitsCounts[2] > 0)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[2][personPointer];
            this.addToPossibleMagicStrategies(weight, 4);
        }
        if (this.isAvailableSpellType(5) && this.gameObjects.redWarlord.mana > this.gameObjects.redWarlord.getSpellPriceByType(5) * 2 && !this.gameObjects.redWarlord.hasEnchantmentType(5)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[3][personPointer];
            this.addToPossibleMagicStrategies(weight, 5);
        }
        if (this.isAvailableSpellType(6) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(6)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[4][personPointer];
            this.addToPossibleMagicStrategies(weight, 6);
        }
        if (this.isAvailableSpellType(7) && this.blueTotalWalkers > 0) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[5][personPointer];
            this.addToPossibleMagicStrategies(weight, 7);
        }
        if (this.isAvailableSpellType(8) && this.blueTotalWalkers > 0) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[6][personPointer];
            this.addToPossibleMagicStrategies(weight, 8);
        }
        if (this.isAvailableSpellType(9) && this.redTotal + 2 < this.blueTotal && !this.gameObjects.redWarlord.hasEnchantmentType(9)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[7][personPointer];
            this.addToPossibleMagicStrategies(weight, 9);
        }
        if (this.isAvailableSpellType(10) && this.gameObjects.redWarlord.mana * 2 < this.gameObjects.blueWarlord.mana && !this.gameObjects.redWarlord.hasEnchantmentType(10)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[8][personPointer];
            this.addToPossibleMagicStrategies(weight, 10);
        }
        if (this.isAvailableSpellType(11) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.personOnSpike.hasAbility(8192)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[9][personPointer];
            this.addToPossibleMagicStrategies(weight, 11);
        }
        if (this.isAvailableSpellType(12) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(12)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[10][personPointer];
            this.addToPossibleMagicStrategies(weight, 12);
        }
        if (this.isAvailableSpellType(13) && this.blueTotal > 3 && !this.gameObjects.redWarlord.hasEnchantmentType(13)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[11][personPointer];
            this.addToPossibleMagicStrategies(weight, 13);
        }
        if (this.isAvailableSpellType(14) && this.redTotal + 2 < this.blueTotal && !this.gameObjects.redWarlord.hasEnchantmentType(14)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[12][personPointer];
            this.addToPossibleMagicStrategies(weight, 14);
        }
        if (this.isAvailableSpellType(15) && this.redTotal + 2 < this.blueTotal && this.gameObjects.redWarlord.mana > this.gameObjects.redWarlord.getSpellPriceByType(15)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[13][personPointer];
            this.addToPossibleMagicStrategies(weight, 15);
        }
        if (this.isAvailableSpellType(16) && this.redTotal + 2 < this.blueTotal) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[14][personPointer];
            this.addToPossibleMagicStrategies(weight, 16);
        }
        if (this.isAvailableSpellType(17) && this.redTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(17) && (this.gameObjects.blueWarlord.unitsCounts[5] > 0 || this.gameObjects.blueWarlord.has_cannon || this.gameObjects.redWarlord.besiegers > 0)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[15][personPointer];
            this.addToPossibleMagicStrategies(weight, 17);
        }
        if (this.isAvailableSpellType(18) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(18)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[16][personPointer];
            this.addToPossibleMagicStrategies(weight, 18);
        }
        if (this.isAvailableSpellType(19) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(19)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[17][personPointer];
            this.addToPossibleMagicStrategies(weight, 19);
        }
        if (this.isAvailableSpellType(20) && this.gameObjects.redWarlord.unitsCounts[2] > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(20)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[18][personPointer];
            this.addToPossibleMagicStrategies(weight, 20);
        }
        if (this.isAvailableSpellType(21) && this.redTotal > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(21)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[19][personPointer];
            this.addToPossibleMagicStrategies(weight, 21);
        }
        if (this.isAvailableSpellType(22) && this.redTotal > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(22)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[20][personPointer];
            this.addToPossibleMagicStrategies(weight, 22);
        }
        if (this.isAvailableSpellType(23) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(23)) {
            weight = GameObjects.ALL_MAGIC_PERSON_WEIGHT[21][personPointer];
            this.addToPossibleMagicStrategies(weight, 23);
        }
    }

    public void addToPossibleMagicStrategies(int weight, int spellType) {
        if (this.spellsCountdown[spellType] < 1) {
            this.magicWeightOffset += weight;
            this.magicPossibleStrategies.put(new Integer(this.magicWeightOffset), new Integer(spellType));
        }
    }

    public void chooseMagicStrategy() {
        int value = 0;
        this.availableSpells = this.gameObjects.redWarlord.getAvailableSpellTypes();
        this.magicWeightOffset = 0;
        int activeOwnEnchants = this.gameObjects.redWarlord.getNumberOfActiveEnchantments();
        int activeEnemyEnchants = this.gameObjects.blueWarlord.getNumberOfActiveEnchantments();
        int warlordLevel = this.gameObjects.redWarlord.intelligence;
        if (this.magicPossibleStrategies.size() > 0 && this.actualMagicStrategy == 0) {
            this.magicPossibleStrategies.clear();
        }
        this.magicPossibleStrategies.put(new Integer(0), new Integer(0));
        this.setStandardWeightsForMPerson(GameObjects.MIXED1_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.MIXED2_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.MIXED3_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.ARMORER_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.BALANCED_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.CHIEFTAIN_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.ENCHANTER_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.ENCHANTER2_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.ENGINEER_POINTER);
        this.setStandardWeightsForMPerson(GameObjects.MSPAMMERDD1_POINTER);
        if (this.isAvailableSpellType(2) && warlordLevel > 8 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED1)) {
            value = this.gameObjects.blueWarlord.unitsCounts[4] + this.gameObjects.blueWarlord.unitsCounts[5];
            this.addToPossibleMagicStrategies(value, 2);
        }
        if (this.isAvailableSpellType(3) && activeEnemyEnchants > 0 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.BALANCED) && warlordLevel > 4) {
            value = activeEnemyEnchants * (warlordLevel - 3);
            this.addToPossibleMagicStrategies(value, 3);
        }
        if (this.isAvailableSpellType(5) && this.gameObjects.redWarlord.mana > this.gameObjects.redWarlord.getSpellPriceByType(5) * 2 && !this.gameObjects.redWarlord.hasEnchantmentType(5) && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENCHANTER) && warlordLevel > 4 || this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED3) && warlordLevel > 9)) {
            this.addToPossibleMagicStrategies(value *= warlordLevel - 3, 5);
        }
        if (this.isAvailableSpellType(7) && this.blueTotal > 3 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.MSPAMMERDD2)) {
            value = this.blueTotal * 2;
            this.addToPossibleMagicStrategies(value, 7);
        }
        if (this.isAvailableSpellType(8) && this.blueTotal > 0 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.MSPAMMERDD1) && warlordLevel > 4) {
            value = this.blueTotal;
            this.addToPossibleMagicStrategies(value, 8);
        } else if (this.isAvailableSpellType(8) && this.blueTotal > 3 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.MSPAMMERDD2) && warlordLevel > 4) {
            value = this.blueTotal * 2;
            this.addToPossibleMagicStrategies(value, 8);
        }
        if (this.isAvailableSpellType(9) && !this.gameObjects.redWarlord.hasEnchantmentType(9) && warlordLevel > 4 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENGINEER)) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 4) + 1;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 9);
        }
        if (this.isAvailableSpellType(10) && this.gameObjects.redWarlord.mana * 2 < this.gameObjects.blueWarlord.mana && !this.gameObjects.redWarlord.hasEnchantmentType(10) && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENGINEER) && warlordLevel > 4) {
            value = this.gameObjects.redWarlord.mana > 10 ? this.gameObjects.blueWarlord.mana / this.gameObjects.redWarlord.mana * (warlordLevel - 4) : this.gameObjects.blueWarlord.mana / 10 * (warlordLevel - 4);
            this.addToPossibleMagicStrategies(value, 10);
        }
        if (this.isAvailableSpellType(11) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.personOnSpike.hasAbility(8192) && warlordLevel > 4 && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENCHANTER)) {
            value = (this.blueTotal - this.redTotal + 2) * (warlordLevel - 4);
            this.addToPossibleMagicStrategies(value, 11);
        }
        if (this.isAvailableSpellType(12) && this.redTotalWalkers > 0 && this.blueTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(12) && warlordLevel > 4 && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED1) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED2))) {
            value = this.redTotal * 2;
            this.addToPossibleMagicStrategies(value, 12);
        }
        if (this.isAvailableSpellType(13) && this.blueTotal > 3 && !this.gameObjects.redWarlord.hasEnchantmentType(13) && warlordLevel > 9 && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED2) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENCHANTER) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.ENCHANTER2))) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9) + this.gameObjects.blueWarlord.besiegers;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 13);
        }
        if (this.isAvailableSpellType(14) && this.redTotal + 2 < this.blueTotal && !this.gameObjects.redWarlord.hasEnchantmentType(14) && warlordLevel > 9 && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.CHIEFTAIN) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.BERSERK))) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9) + this.gameObjects.blueWarlord.besiegers;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 14);
        }
        if (this.isAvailableSpellType(15) && this.redTotal + 2 < this.blueTotal && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ARMORER) && warlordLevel > 9) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9) + this.gameObjects.blueWarlord.besiegers;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 15);
        }
        if (this.isAvailableSpellType(16) && this.redTotal + 2 < this.blueTotal && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ARMORER) && warlordLevel > 4) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 4) + this.gameObjects.blueWarlord.besiegers;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 16);
        }
        if (this.isAvailableSpellType(17) && this.redTotalWalkers > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(17) && (this.gameObjects.blueWarlord.unitsCounts[5] > 0 || this.gameObjects.redWarlord.besiegers > 0) && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED1) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED2) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.MIXED3) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.CHIEFTAIN) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.BALANCED))) {
            value = this.gameObjects.redWarlord.besiegers;
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 17);
        }
        if (this.isAvailableSpellType(18) && this.redTotalWalkers + 2 <= this.blueTotalWalkers && !this.gameObjects.redWarlord.hasEnchantmentType(18) && this.gameObjects.redWarlord.hasMagicPerson(Warlord.BALANCED) && warlordLevel > 9) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 18);
        }
        if (this.isAvailableSpellType(19) && this.redTotalWalkers + 2 <= this.blueTotalWalkers && !this.gameObjects.redWarlord.hasEnchantmentType(19) && this.gameObjects.redWarlord.hasMagicPerson(Warlord.ARMORER) && warlordLevel > 4) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 4);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 19);
        }
        if (this.isAvailableSpellType(20) && this.gameObjects.redWarlord.unitsCounts[2] > 0 && !this.gameObjects.redWarlord.hasEnchantmentType(20) && warlordLevel > 4 && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.CHIEFTAIN) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.BERSERK))) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 4);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 20);
        }
        if (this.isAvailableSpellType(21) && this.redTotalWalkers + 2 <= this.blueTotalWalkers && !this.gameObjects.redWarlord.hasEnchantmentType(21) && this.gameObjects.redWarlord.hasMagicPerson(Warlord.CHIEFTAIN) && warlordLevel > 4) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 4);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 21);
        }
        if (this.isAvailableSpellType(22) && this.redTotal + 2 <= this.blueTotal && !this.gameObjects.redWarlord.hasEnchantmentType(22) && this.gameObjects.redWarlord.hasMagicPerson(Warlord.BALANCED) && warlordLevel > 9) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 22);
        }
        if (this.isAvailableSpellType(23) && this.redTotalWalkers + 2 <= this.blueTotalWalkers && !this.gameObjects.redWarlord.hasEnchantmentType(23) && warlordLevel > 9 && (this.gameObjects.redWarlord.hasMagicPerson(Warlord.BALANCED) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.CHIEFTAIN) || this.gameObjects.redWarlord.hasMagicPerson(Warlord.ARMORER))) {
            value = (this.blueTotal - this.redTotal) * (warlordLevel - 9);
            value = value < 1 ? 1 : value;
            this.addToPossibleMagicStrategies(value, 23);
        }
        if (this.actualMagicStrategy == 0 && this.magicPossibleStrategies.size() > 0) {
            this.actualMagicStrategy = this.getActualStrategy(this.magicPossibleStrategies);
        }
    }

    public int setStandardWeightsForEconomy(int personPointer, int lastWeightOffset) {
        if (this.gameObjects.redWarlord.canBuildWall && this.redTotal + 1 < this.blueTotal && this.gameObjects.redWarlord.unitsCounts[5] < 1 && this.gameObjects.redWarlord.tt_buildings[5] && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)5)) {
            this.buildPossibleStrategies.put(new Integer(lastWeightOffset += GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.ADD_WALL_POINTER]), new Integer(34));
        }
        if (this.gameObjects.redWarlord.underSiege && this.gameObjects.redWarlord.tt_buildings[4] && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)4) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)0) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)1) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)3)) {
            this.buildPossibleStrategies.put(new Integer(lastWeightOffset += GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.CASTLE_DEFENCE_POINTER]), new Integer(36));
        }
        if (this.gameObjects.redWarlord.tt_buildings[0]) {
            this.buildPossibleStrategies.put(new Integer(++lastWeightOffset), new Integer(31));
        }
        if (this.gameObjects.redWarlord.tt_buildings[1]) {
            this.buildPossibleStrategies.put(new Integer(++lastWeightOffset), new Integer(32));
        }
        if (this.gameObjects.redWarlord.castlePower < 100 && !this.gameObjects.redWarlord.underSiege && this.gameObjects.redWarlord.tt_buildings[3] && this.redTotal > this.blueTotal + 1) {
            this.buildPossibleStrategies.put(new Integer(lastWeightOffset += GameObjects.ALL_BATTLE_PERSON_WEIGHT[personPointer][GameObjects.CASTLE_REPAIR_POINTER]), new Integer(35));
        }
        return lastWeightOffset;
    }

    public void chooseBuildStrategy() {
        int weightOffset = 0;
        if (this.buildPossibleStrategies.size() > 0 && this.actualBuildStrategy == 0) {
            this.buildPossibleStrategies.clear();
        }
        if (this.redTotalWalkers > this.blueTotalWalkers + 1 && this.gameObjects.redWarlord.unitsCounts[5] + this.gameObjects.blueWarlord.unitsCounts[5] > 1) {
            this.actualBuildStrategy = 37;
        } else if (this.redTotal <= this.blueTotal) {
            if (this.gameObjects.redWarlord.mines < this.gameObjects.blueWarlord.mines && this.gameObjects.redWarlord.tt_buildings[1]) {
                this.actualBuildStrategy = 32;
            }
            if (this.gameObjects.redWarlord.villages < this.gameObjects.blueWarlord.villages && this.gameObjects.redWarlord.tt_buildings[0]) {
                this.actualBuildStrategy = 31;
            }
        } else {
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER1)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.SPAMMER1_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER2)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.SPAMMER2_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER3)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.SPAMMER3_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.SPAMMER4)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.SPAMMER4_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN1)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.TITAN1_POINTER, weightOffset);
                if (this.gameObjects.redWarlord.underSiege && this.gameObjects.redWarlord.tt_buildings[4] && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)4) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)0) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)1) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)3)) {
                    this.buildPossibleStrategies.put(new Integer(weightOffset += this.gameObjects.blueWarlord.besiegers), new Integer(36));
                }
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN2)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.TITAN2_POINTER, weightOffset);
                if (this.gameObjects.redWarlord.underSiege && this.gameObjects.redWarlord.tt_buildings[4] && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)4) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)0) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)1) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)3)) {
                    this.buildPossibleStrategies.put(new Integer(weightOffset += this.gameObjects.blueWarlord.besiegers), new Integer(36));
                }
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.TITAN3)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.TITAN3_POINTER, weightOffset);
                if (this.gameObjects.redWarlord.underSiege && this.gameObjects.redWarlord.tt_buildings[4] && !this.gameObjects.redWarlord.isInProduction((byte)2, (byte)4) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)0) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)1) && !this.gameObjects.redWarlord.isInProduction((byte)0, (byte)3)) {
                    this.buildPossibleStrategies.put(new Integer(weightOffset += this.gameObjects.blueWarlord.besiegers), new Integer(36));
                }
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT1)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.VALIANT1_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT2)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.VALIANT2_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.VALIANT3)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.VALIANT3_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.DEFENDER)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.DEFENDER_POINTER, weightOffset);
            }
            if (this.gameObjects.redWarlord.hasBattlePerson(Warlord.AVERAGEJOE)) {
                weightOffset = this.setStandardWeightsForEconomy(GameObjects.AVERAGEJOE_POINTER, weightOffset);
            }
        }
        if (this.actualBuildStrategy == 0 && this.buildPossibleStrategies.size() > 0) {
            this.actualBuildStrategy = this.getActualStrategy(this.buildPossibleStrategies);
        }
    }

    public void toString(Hashtable table) {
        Enumeration enumer = table.keys();
        System.out.println("KEY : VALUE");
        System.out.println("===========");
        while (enumer.hasMoreElements()) {
            Integer key = (Integer)enumer.nextElement();
            Integer value = (Integer)table.get(key);
            System.out.println(String.valueOf(key) + " : " + value);
            System.out.println("-----------");
        }
        System.out.println("-----------");
    }
}

