/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.Im;
import com.impossible.util.ImLoader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public abstract class GameObject
extends Sprite {
    protected int positionX;
    protected int positionY;
    protected int oldPositionX;
    protected int oldPositionY;
    protected int turnDelay;
    protected boolean ownedByBlue;
    protected boolean attackOver = false;
    protected boolean moved = true;
    public int level = 1;
    public int magicLevel = 0;
    protected CLImageTracker tracker;
    protected GameObjects gameObjects;
    public String lastAbility = "";
    public int race;
    public int type = 0;
    public int actualSequence = Person.NORMAL;
    public int[][] sequence = new int[][]{new int[1], new int[1]};
    protected ImLoader frames = null;
    protected Im image = null;
    protected int xOffs = 0;
    protected int yOffs = 0;
    int frame_idx = 0;
    int width;
    int height;

    public GameObject(int x, int y, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(WarlordsCastles.DUMMY_IMAGE);
        this.positionX = x;
        this.positionY = y;
        this.oldPositionX = x;
        this.oldPositionY = y;
        this.ownedByBlue = ownedByBlue;
        this.gameObjects = gameObjects;
        this.tracker = tracker;
        this.attackOver = false;
        this.turnDelay = 0;
        this.setRefPixelPosition(this.positionX, this.positionY);
    }

    public void setPositionX(int x) {
        this.positionX = x;
    }

    public void setPositionY(int y) {
        this.positionY = y;
    }

    public void setPositionXY(int x, int y) {
        this.positionX = x;
        this.positionY = y;
    }

    public void setTurnDelay(int turnDelay) {
        this.turnDelay = turnDelay;
    }

    public void setOwnedByPlayer(boolean ownedByPlayer) {
        this.ownedByBlue = ownedByPlayer;
    }

    public void setAttackOver(boolean attack) {
        this.attackOver = attack;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getStartPositionX() {
        return this.positionX - (this.width() >> 1);
    }

    public int getEndPositionX() {
        return this.positionX + (this.width() >> 1);
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getTurnDelay() {
        return this.turnDelay;
    }

    public boolean isOwnedByBlue() {
        return this.ownedByBlue;
    }

    public boolean isAttackOver() {
        return this.attackOver;
    }

    public void saveOldPositionXY() {
        this.oldPositionX = this.positionX;
        this.oldPositionY = this.positionY;
    }

    public void restorePositionXY() {
        this.positionX = this.oldPositionX;
        this.positionY = this.oldPositionY;
    }

    public boolean wasMoved() {
        return this.moved;
    }

    public abstract Image getImage();

    public abstract void doStep();

    public static boolean getChance(int percentage) {
        return percentage > CLGameCanvas.random(100);
    }

    public int getLevel() {
        return this.level;
    }

    public int getActualLevel() {
        int level = this.level + this.magicLevel > 5 ? 5 : this.level + this.magicLevel;
        return level < 1 ? 1 : level;
    }

    public void setLevel(int level) {
        this.level = level > 5 ? 5 : level;
    }

    public void addLevel(int level) {
        this.level += level;
        if (this.level > 5) {
            this.level = 5;
        }
    }

    public void setMagicLevel(int level) {
        this.magicLevel = level;
    }

    public void addMagicLevel(int level) {
        this.magicLevel += level;
    }

    public final boolean collideWith(GameObject gobject) {
        int x1 = this.getPositionX() - this.width() / 2;
        int y1 = this.getPositionY();
        int w1 = this.width();
        int h1 = this.height();
        int x2 = gobject.getPositionX() - gobject.width() / 2;
        int y2 = gobject.getPositionY();
        int w2 = gobject.width();
        int h2 = gobject.height();
        return x1 <= x2 + w2 && x1 + w1 >= x2 && y1 <= y2 + h2 && y1 + h1 >= y2;
    }

    public int width() {
        if (this.frames == null && this.image != null) {
            return this.image.getWidth();
        }
        return this.width;
    }

    public int height() {
        if (this.frames == null) {
            return this.image.getHeight();
        }
        return this.height;
    }

    public void nextFrame() {
        if (this.frames == null) {
            super.nextFrame();
        } else if (++this.frame_idx >= this.sequence[this.actualSequence].length) {
            this.frame_idx = 0;
        }
    }

    public void prevFrame() {
        if (this.frames == null) {
            super.prevFrame();
        } else if (--this.frame_idx < 0) {
            this.frame_idx = this.sequence[this.actualSequence].length - 1;
        }
    }

    public int getFrameIdx() {
        if (this.frames == null) {
            return this.getFrame();
        }
        return this.frame_idx;
    }

    public void setFrameSequence(int[] sequence) {
        if (this.frames == null) {
            super.setFrameSequence(sequence);
        } else {
            this.frame_idx = 0;
        }
    }

    public void paintSprite(Graphics g, boolean nextFrame) {
        if (nextFrame && this.moved) {
            this.nextFrame();
        }
        if (this.frames == null) {
            int transform = this.isOwnedByBlue() ? 0 : 2;
            this.image.drawRegion(g, 0, 0, this.image.getWidth(), this.image.getHeight(), transform, this.positionX - CLGameCanvas.viewport + this.xOffs, this.positionY, 20);
        } else {
            int col = this.sequence[this.actualSequence][this.frame_idx];
            this.frames.transform = this.ownedByBlue ? 0 : 2;
            int x = this.frames.transform == 0 ? this.positionX - CLGameCanvas.viewport - (this.width >> 1) + CLImageTracker.units_diff[this.race][this.type][col] : this.positionX - CLGameCanvas.viewport - (this.width >> 1) + (this.width - CLImageTracker.units_diff[this.race][this.type][col] - this.frames.getWidth(0, col));
            int y = this.positionY + this.height - this.frames.getHeight(0, col);
            this.frames.drawSubImage(g, x, y, 0, col);
        }
    }
}

