/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Walker;
import javax.microedition.lcdui.Image;

public class Piker
extends Walker {
    public static final int[] PIKER_TURN_DELAY = new int[]{2, 2, 2, 2};
    public static final int[] PIKER_BATTLE_DELAY = new int[]{12, 12, 16, 12};
    public static final byte PIKER_START_HIT = 4;
    public static final int[] WIDTH = new int[]{90, 70, 85, 85};
    public static final int[] HEIGHT = new int[]{70, 70, 80, 70};

    public Piker(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByBlue, gameObjects, tracker);
        this.setAttackOver(false);
        this.actualTurnDelay = PIKER_TURN_DELAY[this.race];
        this.actualBattleDelay = PIKER_BATTLE_DELAY[this.race];
        this.type = 0;
        this.setTurnDelay(this.actualTurnDelay);
        if (ownedByBlue) {
            this.sequence = CLImageTracker.PIKER_ANIM_SEQ[gameObjects.blueWarlord.race];
            this.pixelDiff = CLImageTracker.PIKER_PX_DIFF[gameObjects.blueWarlord.race];
            this.frames = CLImageTracker.pkr_blue[0];
            this.width = WIDTH[gameObjects.blueWarlord.race];
            this.height = HEIGHT[gameObjects.blueWarlord.race];
            CLGameCanvas.playerGameEvent = 16;
            this.start_hit_anim_idx = (byte)CLImageTracker.PIKER_ANIM_SEQ[gameObjects.blueWarlord.race][2][0];
        } else {
            this.sequence = CLImageTracker.PIKER_ANIM_SEQ[gameObjects.redWarlord.race];
            this.pixelDiff = CLImageTracker.PIKER_PX_DIFF[gameObjects.redWarlord.race];
            this.frames = CLImageTracker.pkr_red[0];
            this.width = WIDTH[gameObjects.redWarlord.race];
            this.height = HEIGHT[gameObjects.redWarlord.race];
            this.start_hit_anim_idx = (byte)CLImageTracker.PIKER_ANIM_SEQ[gameObjects.redWarlord.race][2][0];
        }
        this.setFrameSequence(this.sequence[Person.NORMAL]);
        this.actualSequence = Person.NORMAL;
        this.setRelatedAbilities();
        this.setRelatedBonuses();
        this.defineReferencePixel(this.getWidth() / 2, 0);
        this.level = ownedByBlue ? gameObjects.blueWarlord.unitsLevel[0] : gameObjects.redWarlord.unitsLevel[0];
    }

    public Image getImage() {
        return null;
    }

    public void setRelatedAbilities() {
        switch (this.race) {
            case 0: {
                break;
            }
            case 3: {
                this.addAbility(2048);
                this.addAbility(1024);
                break;
            }
            case 1: {
                this.addAbility(512);
                break;
            }
            case 2: {
                this.addAbility(4096);
            }
        }
    }

    public void setRelatedBonuses() {
        switch (this.race) {
            case 0: {
                this.addStackBonus(1);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                break;
            }
        }
    }
}

