/*
 * Decompiled with CFR 0.152.
 */
package com.impossible.util;

public class ByteStringBuffer {
    private byte[] string;
    private int length;
    private int increment;
    public static byte NUM_OFFS = (byte)52;

    public ByteStringBuffer() {
        this(64);
    }

    public ByteStringBuffer(int size) {
        this.string = new byte[size];
        this.increment = size;
        this.length = 0;
    }

    public ByteStringBuffer(byte[] text) {
        this(64);
        this.append(text);
    }

    public byte byteAt(int i) {
        return this.string[i];
    }

    public int length() {
        return this.length;
    }

    private void checkSize(int plus) {
        int new_lenght;
        byte[] new_string;
        while (this.string.length < this.length + plus) {
            new_string = new byte[this.string.length + this.increment];
            System.arraycopy(this.string, 0, new_string, 0, this.length);
            this.string = new_string;
        }
        while ((new_lenght = this.string.length - this.increment) > 0 && new_lenght > this.length + plus) {
            new_string = new byte[new_lenght];
            System.arraycopy(this.string, 0, new_string, 0, this.length + plus);
            this.string = new_string;
        }
    }

    public ByteStringBuffer append(byte[] text) {
        this.checkSize(text.length);
        System.arraycopy(text, 0, this.string, this.length, text.length);
        this.length += text.length;
        return this;
    }

    public ByteStringBuffer append(byte character) {
        this.checkSize(1);
        this.string[this.length] = character;
        ++this.length;
        return this;
    }

    public ByteStringBuffer appendNum(int number) {
        int size = 1;
        int tmp = 10;
        while (tmp <= Math.abs(number)) {
            ++size;
            tmp *= 10;
        }
        this.checkSize(size);
        int i = this.length + size - 1;
        while (i >= this.length) {
            this.string[i] = (byte)(number % 10 + NUM_OFFS);
            --i;
            number /= 10;
        }
        this.length += size;
        return this;
    }

    public ByteStringBuffer insert(int offset, byte[] text) {
        this.checkSize(text.length);
        System.arraycopy(this.string, offset, this.string, offset + text.length, this.length - offset);
        System.arraycopy(text, 0, this.string, offset, text.length);
        this.length += text.length;
        return this;
    }

    public ByteStringBuffer delete(int offset, int size) {
        if (offset + size < this.length) {
            System.arraycopy(this.string, offset + size, this.string, offset, this.length - offset - size);
        }
        this.checkSize(-size);
        this.length -= size;
        return this;
    }

    public byte[] toByteString() {
        byte[] bstring = new byte[this.length];
        System.arraycopy(this.string, 0, bstring, 0, this.length);
        return bstring;
    }
}

