/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.game.BasketMidlet;
import com.jarbull.jbf.JBManager;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class LoadingScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private static final int CENTER = 3;
    private BasketMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private Vector textLines;
    private Vector textLinesState;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = true;

    public LoadingScreen(BasketMidlet midlet) {
        this.initialize(midlet);
    }

    private void initialize(BasketMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void addText(String text, String fontKey) {
        this.addText(text, 0, fontKey);
    }

    public void addText(String text) {
        this.addText(text, 0, "10x10-beyaz");
    }

    public void addText(String text, int state, String fontKey) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, fontKey));
    }

    public void removeTextFromEnd(int count) {
        for (int i = 0; i < count; ++i) {
            this.textLines.removeElementAt(this.textLines.size() - 1);
            this.textLinesState.removeElementAt(this.textLines.size() - 1);
        }
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 27, 62);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                }
            }
        }
        this.flicker = !this.flicker;
    }

    protected void keyPressed(int keyCode) {
        if (this.state == 0) {
            this.state = 2;
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousDisplay);
        this.textLines = null;
        this.textLinesState = null;
        System.gc();
    }
}

