/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class GPlayer
extends Slot {
    String _nickName = "";
    static int msgWidth;
    int _betState;
    String _message;
    PokerCard[] _cards = new PokerCard[7];
    int _cardsNum;
    PokerCard[] _madeCards = new PokerCard[5];
    int _madeCardsNum;
    long _realStageBetMoney;
    long _stageBetMoney;
    long _sideMoney;
    long _startMoney;
    int[] _backstraight = new int[]{1, 2, 3, 4, 5};
    int[] _mountain = new int[]{10, 11, 12, 13, 1};
    int _tree;
    int _point;
    int _nopairPoint;
    PokerCard _top = new PokerCard();
    int _msgHeight;
    int _rank;
    int _betCnt;

    boolean isAllIn() {
        return this._money <= 0L;
    }

    boolean isAvailable() {
        return this._money > 0L;
    }

    GPlayer() {
        int i;
        for (i = 0; i < this._cards.length; ++i) {
            this._cards[i] = new PokerCard();
        }
        for (i = 0; i < this._madeCards.length; ++i) {
            this._madeCards[i] = new PokerCard();
        }
        this.initPlayer();
    }

    void updateMessage(int x, int y, int delay) {
        Graphics g = ScreenGame.ref._buffG2;
        g.setClip(x, y, msgWidth + 4, 20);
        ScreenGame.ref.drawBackBuffer(g, ScreenGame.ref._focusX, ScreenGame.ref._focusY);
        this.drawMessage(g, x, y, true);
        WPTCanvas.ref.serviceRepaintRectInTime(delay, x, y, msgWidth + 4, 20);
        WPTCanvas.ref.processKeyQueue();
    }

    void showMessage(String message, int x, int y) {
        this._msgHeight = 20;
        while (this._msgHeight > 0) {
            this.updateMessage(x, y, 35);
            this._msgHeight -= 5;
        }
        while (this._msgHeight < 20) {
            this.updateMessage(x, y, 35);
            this._msgHeight += 5;
        }
        this._msgHeight = 20;
        this._message = message;
        this.updateMessage(x, y, 800);
        this._message = null;
        this._msgHeight -= 2;
        while (this._msgHeight > 0) {
            this.updateMessage(x, y, 35);
            this._msgHeight -= 5;
        }
        while (this._msgHeight < 20) {
            this.updateMessage(x, y, 35);
            this._msgHeight += 5;
        }
        this._msgHeight = 20;
        this._message = null;
        this.updateMessage(x, y, 0);
        ScreenGame.ref._gameState = 1;
    }

    void startGame() {
        this._state = (char)103;
        this._startMoney = this._money;
    }

    void initPlayer() {
        this.clearCards();
        this._stageBetMoney = 0L;
        this._realStageBetMoney = 0L;
        this._tree = 13;
        this._nopairPoint = 0;
        this._point = 0;
        this._msgHeight = 20;
        this._rank = -1;
        this._betCnt = 0;
        this._betState = -1;
        this._sideMoney = 0L;
        if (this._state == 'g') {
            this._state = (char)115;
        }
    }

    void drawMessage(Graphics g, int x, int y, boolean isTurn) {
        y = y + 10 - (this._msgHeight >> 1);
        g.setClip(x, y, msgWidth + 4, this._msgHeight);
        g.drawImage(ScreenGame.ref._i049, x, y, 20);
        if (!this.isGamer()) {
            g.setColor(0);
        } else if (isTurn) {
            g.setColor(0xFFFF00);
        } else {
            g.setColor(0xAAAAAA);
        }
        g.drawRect(x, y, msgWidth - 1 + 4, this._msgHeight - 1);
        if (this._msgHeight == 20) {
            if (this._message != null) {
                WPTCanvas.ref._bigFontY.drawString(g, this._message, x + msgWidth / 2, y + 7, 1, 0, 1, 0);
            } else {
                WPTCanvas.ref._smallFontW.drawString(g, this._nickName, x + msgWidth / 2 + 2, y + 3, 1, 0, 1, 0);
                WPTCanvas.ref._smallFontW.drawString(g, this.makeMoneyString(), x + msgWidth / 2, y + 12, 1, 0, 1, 0);
            }
        }
    }

    String makeMoneyString() {
        String ret = String.valueOf(this._money);
        int len = ret.length();
        char[] buff = new char[40];
        int bi = buff.length;
        int removeLen = 0;
        if (len > 12) {
            buff[--bi] = 66;
            removeLen = 9;
        } else if (len > 9) {
            buff[--bi] = 77;
            removeLen = 6;
        } else if (len > 6) {
            buff[--bi] = 75;
            removeLen = 3;
        }
        len -= removeLen;
        for (int i = 0; i < len; ++i) {
            if (i != 0 && i % 3 == 0) {
                buff[--bi] = 44;
            }
            buff[--bi] = ret.charAt(len - 1 - i);
        }
        return new String(buff, bi, buff.length - bi);
    }

    void drawCards(Graphics g, int x, int y, int color) {
        int size = this._cardsNum < 2 ? this._cardsNum : 2;
        for (int i = 0; i < size; ++i) {
            this._cards[i].paint(g, x, y, color);
            x += 16;
        }
    }

    void drawHandCards(Graphics g, int x, int y, int color) {
        int size = this._cardsNum < 2 ? this._cardsNum : 2;
        for (int i = 0; i < size; ++i) {
            this._cards[i].paint(g, x, y, color);
            x += 16;
        }
    }

    void drawMadeCards(Graphics g, int x, int y, int color) {
        for (int i = 0; i < this._madeCardsNum; ++i) {
            this._madeCards[i].paint(g, x, y, color);
            x += 16;
        }
    }

    boolean isGamer() {
        return this._state == 'g' && this._betState != 2;
    }

    int getPoint() {
        return this._point;
    }

    int getTree() {
        return this._tree;
    }

    void clearCards() {
        int i;
        for (i = 0; i < this._cards.length; ++i) {
            this._cards[i].init();
        }
        for (i = 0; i < this._madeCards.length; ++i) {
            this._madeCards[i].init();
        }
        this._cardsNum = 0;
        this._madeCardsNum = 0;
    }

    void addCard(int card) {
        this._cards[this._cardsNum++].setCard(card);
    }

    void sort(int[] buf, int num) {
        if (num > 1) {
            for (int i = 0; i < num - 1; ++i) {
                for (int j = i + 1; j < num; ++j) {
                    if (buf[i] <= buf[j]) continue;
                    int temp = buf[i];
                    buf[i] = buf[j];
                    buf[j] = temp;
                }
            }
        }
    }

    void sort(PokerCard[] card, int num) {
        if (num > 1) {
            for (int i = 0; i < num - 1; ++i) {
                for (int j = i + 1; j < num; ++j) {
                    int num2;
                    int num1 = card[i]._num == 1 ? 14 : card[i]._num;
                    int n = num2 = card[j]._num == 1 ? 14 : card[j]._num;
                    if (num1 <= num2) continue;
                    PokerCard temp = card[i];
                    card[i] = card[j];
                    card[j] = temp;
                }
            }
        }
    }

    boolean matchAll(int[] buf, int num, int[] card) {
        boolean k = true;
        for (int i = 0; i < 5; ++i) {
            boolean count = false;
            for (int j = 0; j < num; ++j) {
                if (card[i] != buf[j]) continue;
                count = true;
                break;
            }
            if (count) continue;
            k = false;
            break;
        }
        return k;
    }

    int checkStraightType(int[] buf, int num) {
        int j;
        int count;
        int i;
        if (num < 5) {
            return 0;
        }
        int[] temp = new int[num];
        this.sort(buf, num);
        int k = 0;
        for (i = 0; i < num - 1; ++i) {
            count = 0;
            for (j = i + 1; j < num; ++j) {
                if (buf[i] != buf[j]) continue;
                ++count;
            }
            if (count != 0) continue;
            buf[k] = buf[i];
            ++k;
        }
        buf[k] = buf[num - 1];
        num = k + 1;
        if (this.matchAll(buf, num, this._mountain)) {
            System.arraycopy(this._mountain, 0, buf, 0, 5);
            return 1;
        }
        if (this.matchAll(buf, num, this._backstraight)) {
            System.arraycopy(this._backstraight, 0, buf, 0, 5);
            return 2;
        }
        count = 0;
        k = 0;
        for (i = 0; i < num; ++i) {
            if (buf[i] < 2 || buf[i] > 9) continue;
            for (j = 0; j < 5; ++j) {
                temp[j] = buf[i] + j;
            }
            if (!this.matchAll(buf, num, temp)) continue;
            ++count;
            k = buf[i];
        }
        if (count != 0) {
            for (i = 0; i < 5; ++i) {
                buf[i] = k + i;
            }
            return 3;
        }
        return 0;
    }

    void copyToMadeCard(int[] cards, int size) {
        for (int i = 0; i < size; ++i) {
            this._madeCards[i].setCard(cards[i] - 1);
        }
        this._madeCardsNum = size;
    }

    void findMadeCardByNum(int start, int end, int num) {
        for (int a = start; a < end && this._cards[a]._card != -1; ++a) {
            if (this._cards[a]._num != num) continue;
            this._madeCards[this._madeCardsNum++].setCard(this._cards[a]._card);
            break;
        }
    }

    void findMadeCardByNumType(int start, int end, int num, int type) {
        for (int a = start; a < end && this._cards[a]._card != -1; ++a) {
            if (this._cards[a]._num != num || this._cards[a]._type != type) continue;
            this._madeCards[this._madeCardsNum++].setCard(this._cards[a]._card);
            break;
        }
    }

    void findMadeCardsByNum(int start, int end, int num) {
        for (int a = start; a < end && this._cards[a]._card != -1; ++a) {
            if (this._cards[a]._num == num) {
                this._madeCards[this._madeCardsNum++].setCard(this._cards[a]._card);
            }
            if (this._madeCardsNum >= 5) break;
        }
    }

    void findMadeCardsByType(int start, int end, int type) {
        for (int a = start; a < end && this._cards[a]._card != -1; ++a) {
            if (this._cards[a]._type == type) {
                this._madeCards[this._madeCardsNum++].setCard(this._cards[a]._card);
            }
            if (this._madeCardsNum >= 5) break;
        }
    }

    boolean checkSTRAIGHTFLUSH(int calcStart, int calcEnd) {
        int i;
        int size = calcEnd - calcStart;
        if (size < 5) {
            return false;
        }
        int[] buf = new int[7];
        int flushType = 0;
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            int n = this._cards[i]._type - 1;
            buf[n] = buf[n] + 1;
        }
        for (i = 0; i < 4; ++i) {
            if (buf[i] < 5) continue;
            flushType = i + 1;
            break;
        }
        if (flushType == 0) {
            return false;
        }
        int j = 0;
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            if (this._cards[i]._type != flushType) continue;
            buf[j] = this._cards[i]._num;
            ++j;
        }
        int straightType = this.checkStraightType(buf, j);
        if (straightType == 1) {
            this._tree = 1;
        } else if (straightType == 2) {
            this._tree = 3;
        } else if (straightType == 3) {
            this._tree = 2;
        }
        if (straightType != 0) {
            this._top._num = buf[4];
            if (straightType == 3) {
                this._point += this._top._num * 10;
            }
            if (ScreenGame.ref._bSetMadeCard) {
                this._madeCardsNum = 0;
                this.findMadeCardByNumType(calcStart, calcEnd, buf[0], flushType);
                this.findMadeCardByNumType(calcStart, calcEnd, buf[1], flushType);
                this.findMadeCardByNumType(calcStart, calcEnd, buf[2], flushType);
                this.findMadeCardByNumType(calcStart, calcEnd, buf[3], flushType);
                this.findMadeCardByNumType(calcStart, calcEnd, buf[4], flushType);
            }
        }
        return straightType != 0;
    }

    boolean checkFOROFKIND(int calcStart, int calcEnd) {
        int i;
        int size = calcEnd - calcStart;
        if (size < 4) {
            return false;
        }
        int[] buf = new int[14];
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            int n = this._cards[i]._num;
            buf[n] = buf[n] + 1;
        }
        for (i = 1; i <= 13; ++i) {
            if (buf[i] < 4) continue;
            this._tree = 4;
            this._point = i == 1 ? (this._point += 14) : (this._point += i);
            this._top._num = i;
            if (ScreenGame.ref._bSetMadeCard) {
                this._madeCardsNum = 0;
                this.findMadeCardsByNum(calcStart, calcEnd, i);
            }
            return true;
        }
        return false;
    }

    boolean checkFULLHOUSE(int calcStart, int calcEnd) {
        int i;
        int size = calcEnd - calcStart;
        if (size < 5) {
            return false;
        }
        int[] buf = new int[14];
        int threepair = 0;
        int twopair = 0;
        int num = 0;
        int num2 = 0;
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            int n = this._cards[i]._num;
            buf[n] = buf[n] + 1;
        }
        for (i = 1; i <= 13; ++i) {
            if (buf[i] >= 3) {
                ++threepair;
                if (num == true) continue;
                num = i;
                continue;
            }
            if (buf[i] < 2) continue;
            ++twopair;
            if (num2 == true) continue;
            num2 = i;
        }
        if (threepair != 0 && (threepair >= 2 || twopair != 0)) {
            this._tree = 5;
            if (num == 1) {
                this._point += 224;
                this._point += num2;
            } else {
                this._point += num << 4;
                this._point = num2 == 1 ? (this._point += 14) : (this._point += num2);
            }
            this._top._num = num;
            if (ScreenGame.ref._bSetMadeCard) {
                this._madeCardsNum = 0;
                this.findMadeCardsByNum(calcStart, calcEnd, num);
                this.findMadeCardsByNum(calcStart, calcEnd, num2);
            }
            return true;
        }
        return false;
    }

    boolean checkFLUSH(int calcStart, int calcEnd) {
        int i;
        int size = calcEnd - calcStart;
        if (size < 5) {
            return false;
        }
        int[] buf = new int[7];
        int flushType = 0;
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            int n = this._cards[i]._type - 1;
            buf[n] = buf[n] + 1;
        }
        for (i = 0; i < 4; ++i) {
            if (buf[i] < 5) continue;
            flushType = i + 1;
            break;
        }
        if (flushType == 0) {
            return false;
        }
        int j = 0;
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            if (this._cards[i]._type != flushType) continue;
            buf[j] = this._cards[i]._num;
            ++j;
        }
        this.sort(buf, j);
        this._tree = 6;
        int k = 0;
        for (i = j - 1; i >= 0; --i) {
            this._point += (1 << buf[i]) * 16;
            if (++k >= 4) break;
        }
        if (buf[0] == 1) {
            this._point += 262144;
            this._top._num = 1;
        } else {
            this._point += (1 << buf[j - 1]) * 16;
            this._top._num = buf[j - 1];
        }
        if (ScreenGame.ref._bSetMadeCard) {
            this._madeCardsNum = 0;
            this.findMadeCardsByType(calcStart, calcEnd, flushType);
            this.sort(this._madeCards, 5);
        }
        return true;
    }

    int findType(int cardnum, int calcStart, int calcEnd) {
        int s = -1;
        for (int i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            if (this._cards[i]._num != cardnum || s <= this._cards[i]._type) continue;
            s = this._cards[i]._type;
        }
        if (s == -1) {
            return 0;
        }
        return s;
    }

    boolean checkSTRAIGHT(int calcStart, int calcEnd) {
        boolean ret;
        int j;
        int size = calcEnd - calcStart;
        if (size < 5) {
            return false;
        }
        int[] buf = new int[size];
        for (int i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            buf[i - calcStart] = this._cards[i]._num;
        }
        int k = this.checkStraightType(buf, size);
        if (k == 1) {
            this._tree = 7;
        } else if (k == 2) {
            this._tree = 9;
        } else if (k == 3) {
            this._tree = 8;
        }
        if (k == 3) {
            this._point += buf[4] * 10;
            j = buf[4];
        } else {
            j = buf[0];
        }
        this._top._num = j;
        boolean bl = ret = k != 0;
        if (ret && ScreenGame.ref._bSetMadeCard) {
            this._madeCardsNum = 0;
            this.findMadeCardByNum(calcStart, calcEnd, buf[0]);
            this.findMadeCardByNum(calcStart, calcEnd, buf[1]);
            this.findMadeCardByNum(calcStart, calcEnd, buf[2]);
            this.findMadeCardByNum(calcStart, calcEnd, buf[3]);
            this.findMadeCardByNum(calcStart, calcEnd, buf[4]);
        }
        return ret;
    }

    boolean checkPAIR(int calcStart, int calcEnd) {
        int i;
        int[] buf = new int[14];
        int threepair = 0;
        int twopair = 0;
        int[] num = new int[4];
        for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
            int n = this._cards[i]._num;
            buf[n] = buf[n] + 1;
        }
        for (i = 1; i <= 13; ++i) {
            if (buf[i] >= 3) {
                num[0] = i;
                ++threepair;
                continue;
            }
            if (buf[i] < 2) continue;
            num[twopair] = i;
            ++twopair;
        }
        if (threepair != 0 || twopair != 0) {
            if (threepair != 0) {
                this._tree = 10;
                this._point = num[0] == 1 ? (this._point += 1400) : (this._point += num[0] * 100);
                this._top._num = num[0];
            } else if (twopair == 1) {
                this._tree = 12;
                this._point = num[0] == 1 ? (this._point += 1400) : (this._point += num[0] * 100);
                this._top._num = num[0];
            } else if (twopair >= 2) {
                this._tree = 11;
                if (num[0] == 1) {
                    this._point += 262144;
                    this._point += (1 << num[twopair - 1]) * 16;
                    this._top._num = num[0];
                } else {
                    this._point += (1 << num[twopair - 2]) * 16;
                    this._point += (1 << num[twopair - 1]) * 16;
                    this._top._num = num[twopair - 1];
                }
            }
            if (ScreenGame.ref._bSetMadeCard) {
                this._madeCardsNum = 0;
                if (twopair >= 2) {
                    if (num[0] == 1) {
                        this.findMadeCardsByNum(calcStart, calcEnd, num[0]);
                        this.findMadeCardsByNum(calcStart, calcEnd, num[twopair - 1]);
                    } else {
                        this.findMadeCardsByNum(calcStart, calcEnd, num[twopair - 1]);
                        this.findMadeCardsByNum(calcStart, calcEnd, num[twopair - 2]);
                    }
                } else {
                    this.findMadeCardsByNum(calcStart, calcEnd, num[0]);
                }
            }
        } else {
            this._tree = 13;
            num[0] = 0;
            for (i = calcStart; i < calcEnd && this._cards[i]._card != -1; ++i) {
                this._point = this._cards[i]._num == 1 ? (this._point += 262144) : (this._point += (1 << this._cards[i]._num) * 16);
                if (this._cards[i]._num == 1) {
                    num[0] = this._cards[i]._num;
                    continue;
                }
                if (num[0] == 1 || num[0] >= this._cards[i]._num) continue;
                num[0] = this._cards[i]._num;
            }
            this._top._num = num[0];
            if (ScreenGame.ref._bSetMadeCard) {
                this._madeCardsNum = 0;
                this.findMadeCardsByNum(calcStart, calcEnd, num[0]);
            }
        }
        return true;
    }

    void calcPoint(int calcStart, int calcEnd) {
        this._tree = 13;
        this._nopairPoint = 0;
        this._point = 0;
        if (!(this.checkSTRAIGHTFLUSH(calcStart, calcEnd) || this.checkFOROFKIND(calcStart, calcEnd) || this.checkFULLHOUSE(calcStart, calcEnd) || this.checkFLUSH(calcStart, calcEnd) || this.checkSTRAIGHT(calcStart, calcEnd))) {
            this.checkPAIR(calcStart, calcEnd);
        }
        if (ScreenGame.ref._bSetMadeCard && this._madeCardsNum < 5) {
            PokerCard[] buf = new PokerCard[this._cardsNum];
            System.arraycopy(this._cards, 0, buf, 0, this._cardsNum);
            this.sort(buf, this._cardsNum);
            for (int i = this._cardsNum - 1; i > 0; --i) {
                int addCard = buf[i]._card;
                for (int j = 0; j < this._madeCardsNum; ++j) {
                    if (addCard != this._madeCards[j]._card) continue;
                    addCard = -1;
                    break;
                }
                if (addCard == -1) continue;
                this._madeCards[this._madeCardsNum].setCard(addCard);
                if (this._tree != 13) {
                    this._nopairPoint = this._madeCards[this._madeCardsNum]._num == 1 ? (this._nopairPoint += 262144) : (this._nopairPoint += (1 << this._madeCards[this._madeCardsNum]._num) * 16);
                }
                this._madeCards[this._madeCardsNum]._color = 0xBBBBFF;
                if (++this._madeCardsNum >= 5) break;
            }
        }
    }

    int isBiggerThan(GPlayer b) {
        boolean ret = false;
        if (this._tree == b._tree) {
            if (this._point > b._point) {
                return 1;
            }
            if (this._point < b._point) {
                return -1;
            }
            if (this._nopairPoint > b._nopairPoint) {
                return 1;
            }
            if (this._nopairPoint < b._nopairPoint) {
                return -1;
            }
        } else {
            return this._tree < b._tree ? 1 : -1;
        }
        return 0;
    }
}

