/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public final class Engine {
    GCanvas canvas;
    public static Engine me;
    static Tower[] soldier;
    static Bullet[] bullet;
    static Deck[] deck;
    static short[][] buffData;
    static short[] soldierActivateStatus;
    static Button[] sysBn;
    static boolean[] layer;
    static final byte F_MAP = 0;
    static final byte F_SPRITE = 1;
    static final byte F_BOMB = 2;
    static final byte F_EFF = 3;
    static final byte F_FG = 4;
    static int gameMode;
    static final byte MODE_RISK = 0;
    static final byte MODE_CHALLENGE = 1;
    static int gameSeason;
    static final byte GS_SPRING = 0;
    static final byte GS_SUMMER = 1;
    static final byte GS_AUTUMN = 2;
    static final byte GS_WINTER = 3;
    static final byte GS_MAX = 4;
    public static Map map;
    public static Rank rank;
    static boolean[] seasonLock;
    static int gameRank;
    static int startRank;
    static short[] rankLen;
    public static boolean gameFinish;
    public static int money;
    public static short[] roleTeam;
    static boolean isChangMap;
    static byte screenFlashTime;
    static int screenFlashColor;
    static int shakeTime;
    static int shakeWave;
    static final byte SM_INITMENU = 0;
    static final byte SM_MENU_MORE = 1;
    static final byte SM_MORE_MENU = 2;
    static final byte SM_MENU_SEASON = 3;
    static final byte SM_MENU_HELP = 4;
    static final byte SM_MENU_ABOUT = 5;
    static final byte SM_HELP_MENU = 6;
    static final byte SM_ABOUT_MENU = 7;
    static final byte SM_SEASON_MENU = 10;
    static final byte SM_SEASON_CHOOSERANK = 11;
    static final byte SM_RANK_SEASON = 12;
    static final byte SM_SEASON_HELP = 13;
    static final byte SM_CHOOSERANK_RANK = 20;
    static final byte SM_RANK_CHOOSERANK = 21;
    static final byte SM_CHOOSERANK_SEASON = 22;
    static final byte SM_CHOOSERANK_HELP = 23;
    static final byte SM_MENU_CHOOSEBOSS = 30;
    static final byte SM_CHOOSEBOSS_RANK = 31;
    static final byte SM_RANK_CHOOSEBOSS = 32;
    static final byte SM_CHOOSEBOSS_MENU = 33;
    static final byte SM_RANK_RANK = 40;
    static final byte SM_RESTART = 41;
    static boolean loadCompleted;
    private static byte nextState;
    static Timer timer;
    public static boolean restart;

    static boolean isRiskMode() {
        return gameMode == 0;
    }

    static boolean isChallengeMode() {
        return gameMode == 1;
    }

    public Engine() {
        me = this;
        this.canvas = GCanvas.me;
        map = new Map(240, 320);
        rank = new Rank(this);
    }

    static void initGame(short[] dat) {
        gameFinish = false;
        money = 0;
        Script.initScriptVar();
        startRank = (byte)Variable.getInt(dat[0], Script.gExp, Script.gBInt);
        GMIDlet.sleepTime = (short)Variable.getInt(dat[1], Script.gExp, Script.gBInt);
        rankLen = Variable.getArray(dat[2], Script.gArray);
        Rank.selectUnitIndex = (byte)-1;
        Tools.initOverallAlpha();
        Engine.initSeason();
        Rank.initRankData(startRank, rankLen);
    }

    static void initSoldierActivateStatus() {
        short[] temp = gameRank >= Data.unlockTower.length ? new short[]{0} : Data.unlockTower[gameRank];
        soldierActivateStatus = new short[soldier.length];
        if (temp == null) {
            return;
        }
        int i = 0;
        while (i < temp.length) {
            Engine.soldierActivateStatus[temp[i]] = 1;
            ++i;
        }
    }

    static void initSeason() {
        seasonLock = new boolean[rankLen.length];
        int i = 0;
        while (i < seasonLock.length) {
            Engine.seasonLock[i] = i == 0;
            ++i;
        }
    }

    static int rankLenght() {
        if (rankLen == null) {
            return 0;
        }
        return rankLen[gameSeason];
    }

    static int getRankIndex() {
        int i;
        int index = gameRank - startRank;
        if (Engine.isRiskMode()) {
            i = 0;
            while (i < gameSeason) {
                index -= rankLen[i];
                ++i;
            }
        }
        if (Engine.isChallengeMode()) {
            i = 0;
            while (i < rankLen.length - 1) {
                index -= rankLen[i];
                ++i;
            }
        }
        return index;
    }

    static int getSeasonIndex(int rank) {
        rank -= startRank;
        int i = 0;
        while (i < rankLen.length) {
            if ((rank -= rankLen[i]) < 0) break;
            ++i;
        }
        return i;
    }

    static int getGameRank(int season, int gameIndex) {
        int len = 0;
        int i = 0;
        while (i < season) {
            len += rankLen[i];
            ++i;
        }
        return gameIndex + startRank + len;
    }

    static void loadMiniMap(int season) throws IOException {
        String[] temp = new String[rankLen[season]];
        int i = 0;
        while (i < rankLen[season]) {
            temp[i] = Engine.getGameRank(season, i) + "";
            ++i;
        }
        Tools.loadImages(13, temp);
    }

    static void removeMiniMap() {
        Tools.removeImageGroup(13);
    }

    public static void setRankEnd(int id) {
        GCanvas.setST((byte)14, 1);
        isChangMap = true;
        gameRank = (byte)id;
        Event.isChangeMap = false;
    }

    static void drawScreenFlash() {
        if (screenFlashTime == 0) {
            return;
        }
        if (screenFlashTime > 0) {
            screenFlashTime = (byte)(screenFlashTime - 1);
        }
        if (screenFlashTime % 2 != 0) {
            Tools.addRect(Map.setOffX, Map.setOffY, Map.screenWidth, Map.screenHeight, true, (byte)0, screenFlashColor, 4000);
        }
    }

    static void setScreenFlash(int time, int color) {
        int[] colorType = new int[]{-1, -65536, -16776961, -256, -16711936, -16777216};
        screenFlashTime = (byte)(time * 2);
        screenFlashColor = colorType[color];
    }

    static void screenShake() {
        if (shakeTime == 0) {
            return;
        }
        if (shakeTime > 0) {
            --shakeTime;
        }
        Map.setOffY += Engine.getShakeY();
        Map.setOffY = (short)Math.max(Map.setOffY, -shakeWave);
        Map.setOffY = (short)Math.min(Map.setOffY, Map.mapSize_hight * Map.tileHight - Map.screenHeight + shakeWave);
        if (shakeTime == 0) {
            Rank.initRankButton();
            Rank.resetRankButton();
        }
    }

    public static int getShakeY() {
        return GMIDlet.gameIndex % 2 == 0 ? shakeWave : -shakeWave;
    }

    static void free() {
        map.free();
        Rank.free();
        Script.free();
        Effect.EffectV.removeAllElements();
        Tools.removeImageGroup(3);
        Tools.removeImageGroup(8);
        Tools.removeImageGroup(28);
        Tools.removeImageGroup(2);
        Tools.removeImageGroup(29);
        Tools.removeImageGroup(0);
        Tools.removeImageGroup(15);
        Tools.removeImageGroup(11);
    }

    static void freeToNextRank() {
        map.free();
        Rank.free();
        Script.free();
        Effect.EffectV.removeAllElements();
        Tools.removeImageGroup(8);
        Tools.removeImageGroup(28);
        Tools.removeImageGroup(2);
    }

    static void drawShandow(int x, int y, int w, int h, int color, int drawLevel) {
        Tools.addARC(x - w / 2, y - h / 2, w, h, 0, 360, true, (byte)0, color, drawLevel);
    }

    static void drawColorScreenBG(int color, int drawLevel) {
        Tools.addRect(Map.setOffX, Map.setOffY - 20, Map.screenWidth, Map.screenHeight + 40, true, (byte)0, color, drawLevel);
    }

    public static void setGameFinish() {
        GCanvas.setST((byte)14, 1);
        gameFinish = true;
    }

    public static void sourceManager(byte type, byte state) {
        GCanvas.setST((byte)1, 1);
        nextState = state;
        Engine.sourceManager(type);
    }

    public static void tonextST(byte type) {
        GCanvas.setST((byte)61, 0);
        GCanvas.SM_TYPE = type;
    }

    public static void sourceManager(final byte type) {
        loadCompleted = false;
        timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                switch (type) {
                    case 2: {
                        try {
                            Engine.SM_INMENU();
                            Engine.SM_OUT_MORE();
                        }
                        catch (IOException e7) {
                            e7.printStackTrace();
                        }
                        GCanvas.setST((byte)2, 1);
                        break;
                    }
                    case 1: {
                        Engine.SM_OUTMENU();
                        Engine.SM_INMENU_MORE();
                        GCanvas.setST((byte)100, 1);
                        break;
                    }
                    case 5: {
                        Engine.SM_OUTMENU();
                        Engine.SM_INABOUT();
                        GCanvas.setST((byte)6, 1);
                        break;
                    }
                    case 7: {
                        try {
                            Engine.SM_OUTABOUT();
                            Engine.SM_INMENU();
                        }
                        catch (IOException e7) {
                            e7.printStackTrace();
                        }
                        GCanvas.setST((byte)2, 1);
                        break;
                    }
                    case 4: {
                        try {
                            Engine.SM_OUTMENU();
                            Engine.SM_INHELP();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        GCanvas.setST((byte)5, 1);
                        break;
                    }
                    case 6: {
                        try {
                            Engine.SM_OUTHELP();
                            Engine.SM_INMENU();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        GCanvas.setST((byte)2, 1);
                        break;
                    }
                    case 13: {
                        try {
                            Engine.SM_OUTSEASON();
                            Engine.SM_INHELP();
                        }
                        catch (IOException e5) {
                            e5.printStackTrace();
                        }
                        GCanvas.setST((byte)5, 1);
                        break;
                    }
                    case 3: {
                        try {
                            Engine.SM_OUTMENU();
                            Engine.SM_INSEASON();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        GCanvas.setST((byte)37, 1);
                        break;
                    }
                    case 12: {
                        try {
                            Engine.SM_OUTRANK();
                            Engine.SM_INSEASON();
                        }
                        catch (IOException e6) {
                            e6.printStackTrace();
                        }
                        GCanvas.setST((byte)37, 1);
                        break;
                    }
                    case 22: {
                        try {
                            Engine.SM_OUTCHOOSERANK();
                            Engine.SM_INSEASON();
                        }
                        catch (IOException e6) {
                            e6.printStackTrace();
                        }
                        GCanvas.setST((byte)37, 1);
                        break;
                    }
                    case 23: {
                        try {
                            Engine.SM_OUTCHOOSERANK();
                            Engine.SM_INHELP();
                        }
                        catch (IOException e6) {
                            e6.printStackTrace();
                        }
                        GCanvas.setST((byte)5, 1);
                        break;
                    }
                    case 21: {
                        try {
                            Engine.SM_OUTRANK();
                            Engine.SM_INCHOOSERANK();
                            GCanvas.setST((byte)98, 1);
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        break;
                    }
                    case 10: {
                        try {
                            Engine.SM_OUTSEASON();
                            Engine.SM_INMENU();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        GCanvas.setST((byte)2, 1);
                        break;
                    }
                    case 0: {
                        try {
                            Engine.SM_initMainMenu();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break;
                    }
                    case 30: {
                        try {
                            Engine.SM_OUTMENU();
                            Engine.SM_INCHOOSEBOSS();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        GCanvas.setST((byte)97, 1);
                        break;
                    }
                    case 33: {
                        try {
                            Engine.SM_OUTCHOOSEBOSS();
                            Engine.SM_INMENU();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        GCanvas.setST((byte)2, 1);
                        break;
                    }
                    case 11: {
                        try {
                            Engine.SM_OUTSEASON();
                            Engine.SM_INCHOOSERANK();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                        GCanvas.setST((byte)98, 1);
                        break;
                    }
                    case 20: {
                        try {
                            Engine.SM_OUTCHOOSERANK();
                            Engine.SM_Rank();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        GCanvas.setST((byte)39, 1);
                        break;
                    }
                    case 31: {
                        try {
                            Engine.SM_OUTCHOOSEBOSS();
                            Engine.SM_Rank();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        GCanvas.setST((byte)39, 1);
                        break;
                    }
                    case 32: {
                        try {
                            Engine.SM_OUTRANK();
                            Engine.SM_INCHOOSEBOSS();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        GCanvas.setST((byte)97, 1);
                        break;
                    }
                    case 40: {
                        try {
                            Engine.SM_RankToRank();
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                        GCanvas.setST((byte)39, 1);
                        break;
                    }
                    case 41: {
                        try {
                            Engine.SM_Rank_Restart();
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                        restart = false;
                        GCanvas.setST((byte)39, 1);
                    }
                }
                loadCompleted = true;
            }
        }, GMIDlet.sleepTime);
        timer = null;
    }

    private static void SM_INMENU() throws IOException {
        GCanvas.menuWhether = false;
        GCanvas.menuIndex = 0;
        Tools.loadImages(6);
        UI.initMenuButton();
    }

    private static void SM_OUTMENU() {
        Tools.removeImageGroup(6);
    }

    private static void SM_INHELP() throws IOException {
        System.out.println("Tools.loadImages(Tools.D_HELP);");
        Tools.loadImages(21);
        UI.initDragWindow(3, 0, 3, 0, 0, 0, 0, 240, 320, 80);
        UI.initHelpButton();
    }

    private static void SM_OUTHELP() {
        Tools.removeImageGroup(21);
        UI.removeDragWindow();
    }

    private static void SM_INSEASON() throws IOException {
        Tools.loadImages(10);
        UI.initDragWindow(0, 0, 4, 0, 0, 0, 0, 90, 320, 20, 3);
        UI.initSeasonButton();
        gameMode = 0;
        gameRank = Engine.getGameRank(gameSeason, 0);
        System.out.println("Engine SM_INSEASON gameRank:" + gameRank);
    }

    private static void SM_OUTSEASON() {
        Tools.removeImageGroup(10);
        UI.removeDragWindow();
    }

    private static void SM_INABOUT() {
        try {
            Tools.loadImages(16);
            UI.initAboutButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void SM_INMENU_MORE() {
        try {
            Tools.loadImages(5);
            UI.initMoreButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void SM_OUTABOUT() {
        Tools.removeImageGroup(16);
    }

    private static void SM_OUT_MORE() {
        Tools.removeImageGroup(5);
    }

    private static void SM_OUTRANK() throws IOException {
        Engine.free();
        Record.writeDB();
        Tools.loadImages(7);
    }

    private static void SM_INRANK() throws Exception {
        Tools.removeImageGroup(7);
        gameFinish = false;
        GCanvas.gameTime = 0;
        int i = 0;
        while (i < layer.length) {
            Engine.layer[i] = true;
            ++i;
        }
        try {
            Script.loadScript(gameRank);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Tools.loadImages(0);
        Tools.loadImages(4);
        Tools.loadImages(29);
        Tools.loadImages(15);
        rank.init();
        isChangMap = false;
        while (!Script.runInitEvent()) {
        }
        Rank.adjustScreen();
        Rank.playRankMusic();
    }

    private static void SM_INCHOOSERANK() throws IOException {
        Engine.loadMiniMap(gameSeason);
        Tools.loadImages(1);
        UI.initDragWindow(1, Math.max(0, Engine.getRankIndex()), rankLen[gameSeason], 0, 0, 0, 0, 360 / rankLen[gameSeason], 320, 10, 2);
        Map.setOffX = 0;
        Map.setOffY = 0;
        UI.initChooseRankButton();
        Sound.playmusic(0, -1);
    }

    private static void SM_OUTCHOOSERANK() {
        Tools.removeImageGroup(1);
        Engine.removeMiniMap();
        Sound.playmusic(0, -1);
    }

    private static void SM_INCHOOSEBOSS() throws IOException {
        Tools.loadImages(12);
        Tools.loadImages(1);
        Tools.loadImages(8);
        Map.setOffX = 0;
        Map.setOffY = 0;
        UI.initChooseBossButton();
        gameMode = 1;
        gameSeason = 4;
        gameRank = Engine.getGameRank(4, 0);
        UI.initDragWindow(2, 0, Engine.rankLenght(), 0, 0, 0, 0, 80, 106, 30);
        Sound.playmusic(0, -1);
    }

    private static void SM_OUTCHOOSEBOSS() {
        Tools.removeImageGroup(1);
        Tools.removeImageGroup(12);
        Tools.removeImageGroup(8);
        UI.removeDragWindow();
    }

    public static void SM_Rank() throws Exception {
        UI.removeDragWindow();
        Engine.removeMiniMap();
        Tools.removeImageGroup(21);
        Tools.removeImageGroup(7);
        gameFinish = false;
        Map.setOff(0, 0);
        GCanvas.gameTime = 0;
        int i = 0;
        while (i < layer.length) {
            Engine.layer[i] = true;
            ++i;
        }
        try {
            Script.loadScript(gameRank);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Tools.loadImages(0);
        if (gameRank == 1 && !Engine.isChallengeMode() || Engine.isChallengeMode() && Window.windowIndex == 0) {
            Tools.loadImages(15);
        }
        if (Engine.isChallengeMode()) {
            Tools.loadImages(12, new String[]{"7", "8"});
        }
        rank.init();
        isChangMap = false;
        while (!Script.runInitEvent()) {
        }
        Rank.adjustScreen();
        Rank.playRankMusic();
    }

    public static void SM_RankToRank() throws Exception {
        Engine.freeToNextRank();
        gameFinish = false;
        GCanvas.gameTime = 0;
        int i = 0;
        while (i < layer.length) {
            Engine.layer[i] = true;
            ++i;
        }
        try {
            Script.loadScript(gameRank);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        rank.init();
        isChangMap = false;
        while (!Script.runInitEvent()) {
        }
        Rank.adjustScreen();
        Record.writeDB();
        Rank.playRankMusic();
    }

    public static void SM_initMainMenu() throws IOException {
        Tools.loadImages(6);
        UI.init();
        Tools.loadImages(7);
        Tools.loadImages(14);
        Map.objData = Data.readArray("/data/Def_Obj.dat");
        Data.loadDB();
        Data.loadEffData();
        sysBn = new Button[6];
        int i = 0;
        while (i < sysBn.length) {
            Engine.sysBn[i] = new Button();
            ++i;
        }
        try {
            Script.loadGlobalScript();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("\u52a0\u8f7d\u5168\u5c40\u8d44\u6e90100000000");
        Record.readDB();
        Data.loadSpriteData();
        Record.readSmsDB();
    }

    public static void SM_Rank_Restart() throws Exception {
        restart = true;
        Rank.free();
        gameFinish = false;
        Map.setOff(0, 0);
        GCanvas.gameTime = 0;
        int i = 0;
        while (i < layer.length) {
            Engine.layer[i] = true;
            ++i;
        }
        try {
            Script.loadScript(gameRank);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        rank.init();
        isChangMap = false;
        while (!Script.runInitEvent()) {
        }
        Rank.adjustScreen();
        Rank.initRankButton();
    }

    static void initTestData() {
        int len = soldier.length;
        soldierActivateStatus = new short[len];
        int i = 0;
        while (i < soldierActivateStatus.length) {
            Engine.soldierActivateStatus[i] = 1;
            i += 3;
        }
    }

    public static byte getMotinVaule(short motionIndex, byte st, byte quality, int index) {
        if (Data.spriteMotionData[motionIndex] != null) {
            if (Data.spriteMotionData[motionIndex][st] != null) {
                return (byte)Tools.getMotionValue(Data.spriteMotionData[motionIndex][st][index], quality);
            }
            return Engine.getMotinVaule(motionIndex, (byte)0, quality, index);
        }
        return 0;
    }

    public static int getMotionLength(short motionIndex, byte st) {
        if (Data.spriteMotionData[motionIndex] != null) {
            if (Data.spriteMotionData[motionIndex][st] != null) {
                return Data.spriteMotionData[motionIndex][st].length;
            }
            return Data.spriteMotionData[motionIndex][0].length;
        }
        return 0;
    }

    public static int getExpMax(int level) {
        int e = 100;
        int lev = level;
        while (lev - 1 != 0) {
            e *= 19;
            e /= 10;
            --lev;
        }
        return level == 1 ? 100 : e;
    }

    static void loadTeachRes() throws IOException {
    }

    static void setButtonLock(short[] button, boolean isLock) {
        int i = 0;
        while (i < UI.getButtonSize()) {
            int j = 0;
            while (j < button.length) {
                if (UI.getButton((int)i).id == button[j]) {
                    UI.getButton((int)i).isHold = isLock;
                }
                ++j;
            }
            ++i;
        }
    }

    static {
        layer = new boolean[10];
        gameMode = 0;
        gameSeason = 0;
        gameRank = 0;
        startRank = 0;
        gameFinish = false;
        money = 9999;
        screenFlashTime = 0;
        screenFlashColor = -16777216;
        shakeWave = 2;
        restart = false;
    }
}

