/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public final class EnemyTD {
    int id;
    int index;
    int wave;
    Sprite s;
    String name;
    short defense;
    short speed;
    int hpMax;
    int hp;
    short damage;
    short getMoney;
    short scale;
    boolean isGeneral;
    boolean isFly;
    boolean isUnique;
    boolean isHiding;
    boolean isShow;
    byte path;
    byte curPoint;
    short curRing;
    short step;
    short nextStep;
    short stepNum;
    int alfTime;
    boolean refresh;
    boolean ready;
    int[][] buff = new int[8][2];
    int base;
    static short STEPSCALE = (short)(450 * Rank.gameSpeed / 10);
    static byte GAP = (byte)52;
    static byte OFFRANGE = (byte)20;
    static final byte T_LAND = 0;
    static final byte T_FLY = 1;
    static short[][][] vauleSoldier = new short[][][]{new short[][]{{100, 100}, {140, 120}, {200, 150}, {300, 200}}, new short[][]{{140, 120}, {200, 150}, {300, 200}, {400, 250}}, new short[][]{{170, 135}, {250, 175}, {350, 225}, {450, 275}}, new short[][]{{200, 150}, {300, 200}, {400, 250}, {500, 300}}, new short[][]{{250, 200}, {400, 250}, {500, 300}, {600, 400}}};
    static short[][][] vauleGeneral = new short[][][]{new short[][]{{100, 100}, {130, 120}, {160, 140}, {190, 160}}, new short[][]{{130, 120}, {160, 140}, {190, 160}, {220, 180}}, new short[][]{{145, 130}, {175, 150}, {205, 170}, {235, 190}}, new short[][]{{160, 140}, {190, 160}, {220, 180}, {250, 200}}, new short[][]{{190, 160}, {220, 180}, {250, 200}, {280, 220}}};
    int showHpTime;
    private int hurtValue = 0;
    private int deadIndex = -1;
    private int deadMottion = 3;
    private int deadIndexMax = 8;
    private boolean isGetMoney;
    int movePos;
    int tempMovePos;
    int showWait;
    int tempFrame = 0;
    int buffImageId = 0;
    int lastBuffImageId = 0;

    void init(short enemyID, short mode, byte pathID, String enemyNames, int index, int wave) {
        this.index = index;
        this.wave = wave;
        this.refresh = false;
        this.ready = false;
        this.id = enemyID;
        this.name = enemyNames;
        this.path = pathID;
        this.getEnemyData();
        this.buff = new int[8][3];
        this.hp = this.hpMax;
        this.step = this.nextStep = (short)(this.getSpeed() * STEPSCALE);
        this.stepNum = 0;
        this.curPoint = 0;
        this.curRing = 0;
        this.s = new Sprite(mode);
        this.s.visible = false;
        this.isShow = true;
        this.s.nextStatus = (byte)-2;
        this.s.curStatus = (byte)-2;
        this.s.x = Rank.path[this.path][this.curPoint][0];
        this.s.y = Rank.path[this.path][this.curPoint][1];
        Image img = Tools.getImage(8, mode);
        System.out.println("mode:" + mode);
        System.out.println("img == null:" + (img == null));
        if (img != null) {
            this.s.w = img.getWidth() / 3;
            this.s.h = img.getHeight();
        }
        System.out.println("s.w:" + this.s.w);
        this.s.isGeneral = this.isGeneral;
        this.s.flashMode = 0;
        this.s.scale = this.scale / 100 * 10000 / 10000;
        this.initShadowType();
        this.showWait = -1;
        this.getNextDir();
    }

    void initShadowType() {
        this.s.shadowImg = this.isGeneral ? (short)70 : (this.isFly ? (short)71 : (this.isUnique ? (short)72 : (short)73));
    }

    void getEnemyData() {
        this.hpMax = Data.enenmyTDData[this.id][0];
        this.defense = (short)Data.enenmyTDData[this.id][1];
        this.speed = (short)Data.enenmyTDData[this.id][2];
        this.damage = (short)Data.enenmyTDData[this.id][3];
        this.getMoney = (short)Data.enenmyTDData[this.id][4];
        this.scale = (short)Data.enenmyTDData[this.id][5];
        this.isGeneral = this.damage == 3;
        this.isFly = this.speed > 60;
        this.isUnique = this.damage == 2;
        this.isHiding = Data.enenmyTDData[this.id][8] == 1;
    }

    void editEnemyVaule(int per) {
        byte lev = EnemyTD.getVauleLevel();
        short hpRatio = vauleSoldier[lev][per][0];
        short defRatio = vauleSoldier[lev][per][1];
        if (this.isGeneral) {
            hpRatio = vauleGeneral[lev][per][0];
            defRatio = vauleGeneral[lev][per][1];
        }
    }

    static byte getVauleLevel() {
        if (Engine.gameRank >= 22) {
            return 0;
        }
        if (Engine.gameRank >= 19) {
            return 4;
        }
        if (Engine.gameRank >= 15) {
            return 3;
        }
        if (Engine.gameRank >= 10) {
            return 2;
        }
        if (Engine.gameRank >= 5) {
            return 1;
        }
        return 0;
    }

    void run() {
        if (!this.refresh && this.ready) {
            return;
        }
        STEPSCALE = (short)(450 * Rank.gameSpeed / 10);
        this.nextStep = (short)(this.getSpeed() * STEPSCALE);
        this.runARGB();
        if (this.s.curStatus == -2) {
            this.move();
        }
        this.checkIsHiding();
        this.s.run();
        this.runBuff();
        this.checkDead();
        this.runShow();
    }

    private void runARGB() {
        if (Rank.isPause() || this.isDead()) {
            return;
        }
        if (this.alfTime > 0) {
            this.alfTime -= Rank.gameSpeed;
        } else if (this.s.alf != 0) {
            this.s.alf = 0;
        }
    }

    void setARGB(int buffType) {
        switch (buffType) {
            case 2: {
                this.s.alf = -16711936;
                this.alfTime = this.buff[buffType][1];
                break;
            }
            case 1: {
                this.s.alf = -16776961;
                this.alfTime = this.buff[buffType][1];
            }
        }
    }

    private void checkIsHiding() {
        if (!this.isHiding) {
            return;
        }
        this.isShow = true;
    }

    void drawHpLine(int lev) {
        if (--this.showHpTime <= 0) {
            return;
        }
        if (this.s.visible && this.hp > 0 && this.hp < this.hpMax) {
            Tools.addRect(this.s.x - 20, this.s.y - 48, 40, 8, true, (byte)0, -16777216, lev);
            Tools.addRect(this.s.x - 18, this.s.y - 46, 38 * this.hp / this.hpMax, 4, true, (byte)0, -16711936, lev);
        }
    }

    boolean isFocus() {
        return Rank.focusType == 1 && Rank.focus == this.index;
    }

    void drawSelected(int lev) {
        if (this.s.visible && this.isFocus()) {
            int y = Math.max(this.s.y - 67, Map.setOffY);
            Tools.addGridImage(0, 23, this.s.x, y, 4, 1, GCanvas.gameTime / 3 % 4, 0, (byte)3, (byte)0, lev);
        }
    }

    void hurt(int value, int eftType, int hitSound, int buffId) {
        if (eftType > -1) {
            Effect.addEffect(this.s.x, this.s.y - 18, eftType, 0, 2000);
        }
        if (!this.s.visible) {
            return;
        }
        this.hurtValue = value;
        this.hp -= value;
        this.showHpTime = 96;
        if (hitSound != -1) {
            GCanvas.sound.playMusicFromSoundPool(hitSound);
        }
        if (this.hp > 0) {
            if (buffId > 0) {
                this.addBuff(Engine.buffData[buffId][3], Engine.buffData[buffId][0], Engine.buffData[buffId][1], Engine.buffData[buffId][2]);
            }
        } else if (this.s.curStatus != 13) {
            Rank.money += this.getMoney;
            if (this.isGeneral || this.isFly) {
                // empty if block
            }
            this.initDeadFlash(true);
            this.setDead();
        }
    }

    void initDeadFlash(boolean isGetMoney) {
        this.deadIndex = 0;
        this.isGetMoney = isGetMoney;
    }

    void drawDeadFlash(int lev) {
        if (this.deadIndex == -1) {
            return;
        }
        if (this.deadIndex > this.deadIndexMax) {
            this.deadIndex = -1;
            return;
        }
        int alf = 0;
        if (this.deadIndex >= 5) {
            alf = Tools.ALPHA[(this.deadIndexMax - this.deadIndex) * 20 / (this.deadIndexMax - 5)];
        }
        int index = Math.min(this.deadMottion, this.deadIndex);
        Tools.addImage(0, 50, this.s.x, this.s.y, index * 84, 0, 84, 84, alf, (byte)4, (byte)0, lev);
        if (this.isGetMoney) {
            this.drawGetMoney(this.getMoney, this.s.x, this.s.y - index * 5 - 15, alf, lev);
        }
        ++this.deadIndex;
    }

    void drawGetMoney(int money, int x, int y, int alf, int lev) {
        y = Math.max(0, y - 20);
        Tools.addImage(0, 51, x, y, alf, (byte)3, (byte)0, lev);
        Tools.addNum(money, 0, 2, x + 9, y + 7, 10, -1, alf, (byte)3, lev);
    }

    void getNextDir() {
        if (this.curPoint >= Rank.path[this.path].length - 1) {
            return;
        }
        this.s.dir = -1;
        this.s.faceDir = -1;
        short ox = Rank.path[this.path][this.curPoint][0];
        short oy = Rank.path[this.path][this.curPoint][1];
        short ox1 = Rank.path[this.path][this.curPoint + 1][0];
        short oy1 = Rank.path[this.path][this.curPoint + 1][1];
        short ox2 = Rank.path[this.path][this.curPoint + 2 >= Rank.path[this.path].length - 1 ? this.curPoint + 1 : this.curPoint + 2][0];
        if (ox == ox1) {
            this.s.dir = oy1 > oy ? 2 : 0;
        } else if (oy == oy1) {
            int n = this.s.dir = ox1 > ox ? 1 : 3;
        }
        if (oy == oy1) {
            this.s.faceDir = ox1 > ox ? 1 : 2;
        } else if (ox == ox1) {
            this.s.faceDir = oy1 > oy ? (ox2 > ox1 ? 1 : 2) : (ox2 > ox1 ? 0 : 3);
        }
    }

    void move() {
        if (Rank.isPause() || !Rank.running || this.hasBuff(3) || Message.sendpp) {
            return;
        }
        if (this.curPoint >= Rank.path[this.path].length - 1 && !this.isDead()) {
            if (Engine.isChallengeMode()) {
                this.setStart();
            } else {
                this.hurtHome();
                return;
            }
        }
        if (this.step != this.nextStep) {
            this.tempMovePos = this.movePos;
            this.stepNum = 0;
            this.step = this.nextStep;
        }
        this.stepNum = (short)(this.stepNum + 1);
        this.movePos = this.tempMovePos + this.stepNum * this.step / 1000;
        if (this.s.dir == 0) {
            if (!this.s.visible && this.showWait < 0) {
                if (this.base - this.movePos <= Rank.path[this.path][this.curPoint][1]) {
                    this.s.y = Rank.path[this.path][this.curPoint][1];
                    this.setShow();
                    return;
                }
                this.s.y = this.base - this.movePos;
            } else {
                if (Rank.path[this.path][this.curPoint][1] - this.movePos <= Rank.path[this.path][this.curPoint + 1][1]) {
                    this.s.y = Rank.path[this.path][this.curPoint + 1][1];
                    this.setWheel();
                    return;
                }
                this.s.y = Rank.path[this.path][this.curPoint][1] - this.movePos;
            }
        }
        if (this.s.dir == 2) {
            if (!this.s.visible && this.showWait < 0) {
                if (this.base + this.movePos >= Rank.path[this.path][this.curPoint][1]) {
                    this.s.y = Rank.path[this.path][this.curPoint][1];
                    this.setShow();
                    return;
                }
                this.s.y = this.base + this.movePos;
            } else {
                if (Rank.path[this.path][this.curPoint][1] + this.movePos >= Rank.path[this.path][this.curPoint + 1][1]) {
                    this.s.y = Rank.path[this.path][this.curPoint + 1][1];
                    this.setWheel();
                    return;
                }
                this.s.y = Rank.path[this.path][this.curPoint][1] + this.movePos;
            }
        }
        if (this.s.dir == 3) {
            if (!this.s.visible && this.showWait < 0) {
                if (this.base - this.movePos <= Rank.path[this.path][this.curPoint][0]) {
                    this.s.x = Rank.path[this.path][this.curPoint][0];
                    this.setShow();
                    return;
                }
                this.s.x = this.base - this.movePos;
            } else {
                if (Rank.path[this.path][this.curPoint][0] - this.movePos <= Rank.path[this.path][this.curPoint + 1][0]) {
                    this.s.x = Rank.path[this.path][this.curPoint + 1][0];
                    this.setWheel();
                    return;
                }
                this.s.x = Rank.path[this.path][this.curPoint][0] - this.movePos;
            }
        }
        if (this.s.dir == 1) {
            if (!this.s.visible && this.showWait < 0) {
                if (this.base + this.movePos >= Rank.path[this.path][this.curPoint][0]) {
                    this.s.x = Rank.path[this.path][this.curPoint][0];
                    this.setShow();
                    return;
                }
                this.s.x = this.base + this.movePos;
            } else {
                if (Rank.path[this.path][this.curPoint][0] + this.movePos >= Rank.path[this.path][this.curPoint + 1][0]) {
                    this.s.x = Rank.path[this.path][this.curPoint + 1][0];
                    this.setWheel();
                    return;
                }
                this.s.x = Rank.path[this.path][this.curPoint][0] + this.movePos;
            }
        }
    }

    void hurtHome() {
        Rank.curHomeHp -= this.damage;
        Rank.initTouchMe();
        if (Sound.openSound) {
            // empty if block
        }
        Engine.shakeTime = 4;
        if (Rank.curHomeHp <= 0) {
            Rank.curHomeHp = 0;
            Rank.initFailPass();
        }
        this.initDeadFlash(false);
        this.setDead();
    }

    static int getendlessMoney(int wave) {
        int baseMoney = 1;
        int tot = 0;
        int i = 1;
        while (i < wave) {
            baseMoney = 1 * i;
            tot += baseMoney;
            ++i;
        }
        return tot;
    }

    void setShow() {
        if (!this.refresh && !this.ready) {
            Rank.setAtStart(this.wave);
            return;
        }
        this.showWait = 5;
        this.stepNum = 0;
        this.tempMovePos = 0;
        this.movePos = 0;
        this.drawShowEffect();
    }

    void setRunningShow() {
        this.showWait = 5;
        this.stepNum = 0;
        this.tempMovePos = 0;
        this.movePos = 0;
        this.drawShowEffect();
    }

    void runShow() {
        if (this.showWait > 0) {
            --this.showWait;
            return;
        }
        if (this.showWait == 0 && !this.s.visible) {
            this.s.visible = true;
            this.showWait = -1;
        }
    }

    void drawShowEffect() {
        Effect.addEffect(this.s.x, this.s.y, 18, 0, 2000);
        Effect.addEffect(this.s.x, this.s.y, 19, 0, 2000);
    }

    void setStart() {
        this.curRing = (short)(this.curRing + 1);
        this.curPoint = 0;
        this.stepNum = 0;
        this.tempMovePos = 0;
        this.movePos = 0;
        this.getNextDir();
    }

    void setWheel() {
        this.curPoint = (byte)(this.curPoint + 1);
        this.stepNum = 0;
        this.tempMovePos = 0;
        this.movePos = 0;
        this.getNextDir();
    }

    void startRun() {
        this.s.setStatus((byte)-2);
        this.s.visible = true;
    }

    void paint() {
        this.s.paint(this.s.y + 1000);
        this.drawBuff();
        this.drawHpLine(this.s.y + 1000);
        this.drawSelected(this.s.y + 1000);
        this.drawDeadFlash(this.s.y + 2000);
    }

    void drawNum(int num, int offY, int layer) {
        Tools.addString(num + "", this.s.x, this.s.y + offY, (byte)5, 0xFFFFFF, layer, 16);
    }

    void drawHurtNum(int layer) {
        Tools.addString(this.hurtValue + "", this.s.x, this.s.y - 40, (byte)5, 0xFFFFFF, layer, 16);
    }

    void setDead() {
        this.s.nextStatus = (byte)13;
        this.s.curStatus = (byte)13;
        this.s.frameTimes = 0;
        this.s.index = 0;
        this.hp = 0;
        this.s.visible = false;
        this.buff = null;
        this.clearSelectedEnemy(this.index);
        --Rank.enemyNum;
    }

    void clearSelectedEnemy(int index) {
        if (this.isFocus()) {
            Rank.focus = (short)-1;
            Rank.focusType = 0;
        }
    }

    void checkDead() {
        if (this.hp <= 0 && this.s.curStatus != 13) {
            Rank.money += this.getMoney;
            if (this.isGeneral || this.isFly) {
                // empty if block
            }
            this.initDeadFlash(true);
            this.setDead();
        }
    }

    boolean isDead() {
        return this.s.curStatus == 13 || this.hp <= 0;
    }

    short getExtraSoul() {
        return 0;
    }

    short getSpeed() {
        if (this.s == null || !this.s.visible) {
            return (short)(40 * (100 - this.getBuffVaule((byte)1)) / 100);
        }
        return (short)(this.speed * (100 - this.getBuffVaule((byte)1)) / 100);
    }

    short getDefense() {
        return this.defense;
    }

    int getBuffVaule(byte buffType) {
        if (this.buff == null || this.buff[buffType][0] == 0 || this.buff[buffType][1] == 0) {
            return 0;
        }
        return this.buff[buffType][0];
    }

    void addBuff(short buffType, short buffVaule, short buffTime, short interval) {
        if (!this.canAddBuff(buffType, buffVaule)) {
            return;
        }
        this.buff[buffType][0] = buffVaule;
        this.buff[buffType][1] = (short)(buffTime * 24 + this.getCoverBuffTime(buffType));
        this.buff[buffType][2] = interval;
        this.setARGB(buffType);
    }

    int getCoverBuffTime(int buffType) {
        if (this.buff[buffType][1] > 0 && this.buff[buffType][2] > 0) {
            return this.buff[buffType][1] % this.buff[buffType][2];
        }
        return 0;
    }

    boolean canAddBuff(int buffType, int buffVaule) {
        return this.s.visible && this.buff != null && (this.buff[buffType][1] <= 0 || this.buff[buffType][0] <= buffVaule);
    }

    boolean hasBuff(int buffType) {
        return this.buff != null && this.buff[buffType][1] > 0;
    }

    void runBuff() {
        if (Rank.isPause() || this.isDead() || this.buff == null) {
            return;
        }
        int i = 0;
        while (i < this.buff.length) {
            if (this.buff[i][1] > 0) {
                int[] nArray = this.buff[i];
                nArray[1] = nArray[1] - Rank.gameSpeed;
                int interval = this.buff[i][2];
                switch (i) {
                    case 2: {
                        if (this.buff[i][1] % interval >= Rank.gameSpeed) break;
                        this.hp -= this.buff[i][0];
                    }
                }
            }
            ++i;
        }
    }

    void drawBuff() {
        if (this.isDead() || this.buff == null) {
            return;
        }
        int i = 0;
        while (i < this.buff.length) {
            if (this.buff[i][1] > 0) {
                switch (i) {
                    case 3: {
                        Tools.addImage(0, 14, this.s.x, this.s.y + 5, (byte)5, (byte)0, this.s.y + 1000);
                        break;
                    }
                    case 4: {
                        Tools.addGridImage(0, 15, this.s.x, this.s.y - 10, 6, 1, GCanvas.gameTime % 6, 0, (byte)4, (byte)0, this.s.y + 1000);
                        break;
                    }
                    case 1: {
                        Tools.addGridImage(0, 16, this.s.x, this.s.y + 10, 1, 2, 0, GCanvas.gameTime / 3 % 2, (byte)5, (byte)0, this.s.y + 1000);
                        break;
                    }
                    case 2: {
                        Tools.addGridImage(0, 17, this.s.x, this.s.y - 10, 1, 2, 0, GCanvas.gameTime / 3 % 2, (byte)4, (byte)0, this.s.y + 1000);
                    }
                }
            }
            ++i;
        }
    }

    public boolean canAttack() {
        return this.s.visible && !this.isDead() && (!this.isHiding || this.isShow);
    }
}

