/*
 * Decompiled with CFR 0.152.
 */
public class GMath {
    static final short RATIO = 4096;
    static short[] sinTable = new short[]{0, 71, 142, 214, 285, 356, 428, 499, 570, 640, 711, 781, 851, 921, 990, 1060, 1129, 1197, 1265, 1333, 1400, 1467, 1534, 1600, 1665, 1731, 1795, 1859, 1922, 1985, 2047, 2109, 2170, 2230, 2290, 2349, 2407, 2465, 2521, 2577, 2632, 2687, 2740, 2793, 2845, 2896, 2946, 2995, 3043, 3091, 3137, 3183, 3227, 3271, 3313, 3355, 3395, 3435, 3473, 3510, 3547, 3582, 3616, 3649, 3681, 3712, 3741, 3770, 3797, 3823, 3848, 3872, 3895, 3917, 3937, 3956, 3974, 3991, 4006, 4020, 4033, 4045, 4056, 4065, 4073, 4080, 4086, 4090, 4093, 4095, 4096, 4095, 4093, 4090, 4086, 4080, 4073, 4065, 4056, 4045, 4033, 4020, 4006, 3991, 3974, 3956, 3937, 3917, 3895, 3872, 3848, 3823, 3797, 3770, 3741, 3712, 3681, 3649, 3616, 3582, 3547, 3510, 3473, 3435, 3395, 3355, 3313, 3271, 3227, 3183, 3137, 3091, 3043, 2995, 2946, 2896, 2845, 2793, 2740, 2687, 2632, 2577, 2521, 2465, 2407, 2349, 2290, 2230, 2170, 2109, 2048, 1985, 1922, 1859, 1795, 1731, 1665, 1600, 1534, 1467, 1400, 1333, 1265, 1197, 1129, 1060, 990, 921, 851, 781, 711, 640, 570, 499, 428, 356, 285, 214, 142, 71, 0, -71, -142, -214, -285, -356, -428, -499, -570, -640, -711, -781, -851, -921, -990, -1060, -1129, -1197, -1265, -1333, -1400, -1467, -1534, -1600, -1665, -1731, -1795, -1859, -1922, -1985, -2047, -2109, -2170, -2230, -2290, -2349, -2407, -2465, -2521, -2577, -2632, -2687, -2740, -2793, -2845, -2896, -2946, -2995, -3043, -3091, -3137, -3183, -3227, -3271, -3313, -3355, -3395, -3435, -3473, -3510, -3547, -3582, -3616, -3649, -3681, -3712, -3741, -3770, -3797, -3823, -3848, -3872, -3895, -3917, -3937, -3956, -3974, -3991, -4006, -4020, -4033, -4045, -4056, -4065, -4073, -4080, -4086, -4090, -4093, -4095, -4096, -4095, -4093, -4090, -4086, -4080, -4073, -4065, -4056, -4045, -4033, -4020, -4006, -3991, -3974, -3956, -3937, -3917, -3895, -3872, -3848, -3823, -3797, -3770, -3741, -3712, -3681, -3649, -3616, -3582, -3547, -3510, -3473, -3435, -3395, -3355, -3313, -3271, -3227, -3183, -3137, -3091, -3043, -2995, -2946, -2896, -2845, -2793, -2740, -2687, -2632, -2577, -2521, -2465, -2407, -2349, -2290, -2230, -2170, -2109, -2048, -1985, -1922, -1859, -1795, -1731, -1665, -1600, -1534, -1467, -1400, -1333, -1265, -1197, -1129, -1060, -990, -921, -851, -781, -711, -640, -570, -499, -428, -356, -285, -214, -142, -71};

    public static short sin(int degree) {
        while (degree < 0) {
            degree += 360;
        }
        return sinTable[degree % 360];
    }

    public static short cos(int degree) {
        return GMath.sin(90 + degree);
    }

    public static int angle(int x1, int y1, int x2, int y2) {
        int a2 = x2 - x1;
        int b2 = y1 - y2;
        byte qd = GMath.getExactQD(x1, y1, x2, y2);
        int start = GMath.getAngleArea(qd);
        int sin = a2 * 4096 * 100 / GMath.sqrt(a2 * a2 + b2 * b2);
        int angle = 0;
        int i = start;
        while (i < start + 90) {
            if (sin == sinTable[i]) {
                angle = i;
                break;
            }
            if (i + 1 < sinTable.length) {
                if (sin > sinTable[i] && sin < sinTable[i + 1]) {
                    angle = i;
                    break;
                }
                if (sin < sinTable[i] && sin > sinTable[i + 1]) {
                    angle = i;
                    break;
                }
            }
            ++i;
        }
        return angle;
    }

    private static int getAngleArea(int qd) {
        switch (qd) {
            case 1: {
                return 0;
            }
            case 2: {
                return 270;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 90;
            }
        }
        return (qd - 1) % 4 * 90;
    }

    static byte getExactQD(int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            if (x2 > x1) {
                return (byte)(y2 > y1 ? 4 : 1);
            }
            return (byte)(y2 > y1 ? 3 : 2);
        }
        if (x1 == x2) {
            if (y2 > y1) {
                return 7;
            }
            if (y2 < y1) {
                return 5;
            }
        }
        if (y2 == y1) {
            if (x2 > x1) {
                return 6;
            }
            if (x2 < x1) {
                return 8;
            }
        }
        return 0;
    }

    private static short getAngleArea(int a2, int b2) {
        if (a2 >= 0 && b2 >= 0) {
            return 0;
        }
        if (a2 >= 0 && b2 < 0) {
            return 90;
        }
        if (a2 < 0 && b2 < 0) {
            return 180;
        }
        if (a2 < 0 && b2 > 0) {
            return 270;
        }
        return 0;
    }

    public static final int sqrt(long v) {
        if (v > 0L) {
            long c;
            v *= 10000L;
            long r = 10000L;
            while ((r = (v / r + r) / 2L) < (c = r)) {
            }
            return (int)c;
        }
        return 0;
    }
}

