/*
 * Decompiled with CFR 0.152.
 */
package main;

import bj.ScreenGameBJ;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import main.Common;
import main.Defines;
import main.Fonts;
import main.IScreen;
import main.Keys;
import main.MainCanvas;
import main.Resources;
import main.Settings;
import main.X;
import main.stateBJ;
import main.statePok;
import main.stateSol;
import pok.ScreenGamePok;
import sol.ScreenGameSol;

public class ScreenMenu
implements IScreen {
    final int MODE_LOADING_RES;
    final int MODE_MENU;
    final int MODE_INSTRUCTIONS;
    final int MODE_ABOUT;
    final int MODE_QUIT;
    final int MODE_NEW_GAME;
    final int MODE_LISTING_LEFT;
    final int MODE_LISTING_RIGHT;
    int MENUITEM_NEWGAME = 0;
    int MENUITEM_LOAD_GAME = 1;
    int MENUITEM_INSTRUCTIONS = 2;
    int MENUITEM_SCORES = 3;
    int MENUITEM_ABOUT = 4;
    int listingPos;
    Canvas canvas;
    int mode;
    int iSelectedItem = -1;
    int iSelectedGame = 0;
    final int GAME_POK;
    final int GAME_BJ;
    final int GAME_SOL;
    int iNeonFrame = 0;
    private static String[] menuStrings = new String[4];
    private static String sName;
    private static String sVersion;
    private static String sQuit;

    public ScreenMenu(Canvas canvas) {
        this.MODE_LOADING_RES = 0;
        this.MODE_MENU = 1;
        this.MODE_INSTRUCTIONS = 2;
        this.MODE_ABOUT = 3;
        this.MODE_QUIT = 4;
        this.MODE_NEW_GAME = 5;
        this.MODE_LISTING_LEFT = 6;
        this.MODE_LISTING_RIGHT = 7;
        this.GAME_POK = 0;
        this.GAME_BJ = 1;
        this.GAME_SOL = 2;
        System.out.println("screenMENU");
        this.listingPos = 0;
        this.canvas = canvas;
        this.iSelectedGame = 0;
        this.loadMenuStrings();
        this.mode = 0;
        this.iSelectedItem = 0;
    }

    public ScreenMenu(Canvas canvas, int game) {
        this.MODE_LOADING_RES = 0;
        this.MODE_MENU = 1;
        this.MODE_INSTRUCTIONS = 2;
        this.MODE_ABOUT = 3;
        this.MODE_QUIT = 4;
        this.MODE_NEW_GAME = 5;
        this.MODE_LISTING_LEFT = 6;
        this.MODE_LISTING_RIGHT = 7;
        this.GAME_POK = 0;
        this.GAME_BJ = 1;
        this.GAME_SOL = 2;
        System.out.println("screenMENU");
        this.listingPos = 0;
        this.canvas = canvas;
        this.iSelectedGame = 0;
        this.loadMenuStrings();
        this.mode = 0;
        this.iSelectedItem = 0;
        this.iSelectedGame = game;
    }

    private void loadMenuStrings() {
        ScreenMenu.menuStrings[0] = X.texts.getHashedString("NEW_GAME").toUpperCase();
        ScreenMenu.menuStrings[1] = X.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenMenu.menuStrings[2] = X.texts.getHashedString("INSTRUCTIONS").toUpperCase();
        ScreenMenu.menuStrings[3] = X.texts.getHashedString("ABOUT").toUpperCase();
        sName = X.texts.getHashedString("NAME").toUpperCase();
        sVersion = X.texts.getHashedString("VERSION").toUpperCase();
        sQuit = X.texts.getHashedString("REALY_QUIT").toUpperCase();
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen menu";
    }

    public void update(long tick) {
        switch (this.mode) {
            case 0: {
                Resources.loadMenuResources();
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                } else {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(false);
                }
                this.mode = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 6: {
                if (this.listingPos < 0) {
                    this.listingPos += Defines.WIDTH / 10;
                    if (this.listingPos > 0) {
                        this.listingPos = 0;
                        this.mode = 1;
                    }
                } else {
                    this.listingPos = 0;
                    this.mode = 1;
                }
                this.iSelectedItem = -1;
                this.iSelectedItem = 0;
                break;
            }
            case 7: {
                if (this.listingPos > 0) {
                    this.listingPos -= Defines.WIDTH / 10;
                    if (this.listingPos < 0) {
                        this.listingPos = 0;
                        this.mode = 1;
                    }
                } else {
                    this.listingPos = 0;
                    this.mode = 1;
                }
                this.iSelectedItem = -1;
                this.iSelectedItem = 0;
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 0: {
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        switch (this.mode) {
            case 6: 
            case 7: {
                this.listingPos = 0;
                this.mode = 1;
                this.iSelectedItem = -1;
                this.iSelectedItem = 0;
                break;
            }
            case 2: 
            case 3: {
                if (Keys.key_fn1) {
                    this.mode = 1;
                }
                if ((Keys.key_right || Keys.key_down || Keys.key_fn2 || Keys.key_num6 || Keys.key_num8) && ++Resources.iTextStartLine > Resources.iEndLine) {
                    Resources.iTextStartLine = Resources.iEndLine;
                }
                if (!Keys.key_left && !Keys.key_up && !Keys.key_fn1 && !Keys.key_num4 && !Keys.key_num2 || --Resources.iTextStartLine >= 0) break;
                Resources.iTextStartLine = 0;
                break;
            }
            case 4: {
                if (Keys.key_fn2) {
                    Resources.releaseMenuResources();
                    X.quitApp();
                    return;
                }
                if (!Keys.key_fn1) break;
                this.mode = 1;
                return;
            }
            case 1: {
                int ikeysCount = 4;
                if (Keys.key_fn2) {
                    this.mode = 4;
                    return;
                }
                if (Keys.key_fn1) {
                    Settings.bMusic = !Settings.bMusic;
                    Settings.saveSettings();
                    if (Settings.bMusic) {
                        X.soundManager.Stop();
                        X.soundManager.SetSoundOn(true);
                        X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    } else {
                        X.soundManager.Stop();
                        X.soundManager.SetSoundOn(false);
                    }
                    return;
                }
                if (Keys.key_left || Keys.key_num4) {
                    --this.iSelectedGame;
                    if (this.iSelectedGame == -1) {
                        this.iSelectedGame = 2;
                    }
                    this.mode = 6;
                    this.listingPos = -Defines.WIDTH;
                    this.iSelectedItem = this.MENUITEM_NEWGAME;
                    return;
                }
                if (Keys.key_right || Keys.key_num6) {
                    ++this.iSelectedGame;
                    if (this.iSelectedGame == 3) {
                        this.iSelectedGame = 0;
                    }
                    this.listingPos = Defines.WIDTH;
                    this.mode = 7;
                    this.iSelectedItem = this.MENUITEM_NEWGAME;
                    return;
                }
                boolean possLoad = false;
                switch (this.iSelectedGame) {
                    case 1: {
                        if (!stateBJ.canLoad()) break;
                        possLoad = true;
                        break;
                    }
                    case 0: {
                        if (!statePok.canLoad()) break;
                        possLoad = true;
                        break;
                    }
                    case 2: {
                        if (!stateSol.canLoad()) break;
                        possLoad = true;
                    }
                }
                if (Keys.key_up || Keys.key_num2) {
                    --this.iSelectedItem;
                    if (this.iSelectedItem < 0) {
                        this.iSelectedItem = ikeysCount;
                    }
                    if (!possLoad && this.iSelectedItem == 1) {
                        this.iSelectedItem = 0;
                    }
                    if (this.iSelectedItem == 3) {
                        this.iSelectedItem = 2;
                    }
                }
                if (Keys.key_down || Keys.key_num8) {
                    ++this.iSelectedItem;
                    if (this.iSelectedItem > ikeysCount) {
                        this.iSelectedItem = 0;
                    }
                    if (!possLoad && this.iSelectedItem == 1) {
                        this.iSelectedItem = 2;
                    }
                    if (this.iSelectedItem == 3) {
                        this.iSelectedItem = 4;
                    }
                }
                if (!Keys.key_fire) break;
                if (this.iSelectedItem == this.MENUITEM_INSTRUCTIONS) {
                    if (this.iSelectedGame == 0) {
                        Resources.prepareText(X.texts.getHashedString("INSTRUCTION_POK").toUpperCase());
                    }
                    if (this.iSelectedGame == 2) {
                        Resources.prepareText(X.texts.getHashedString("INSTRUCTION_SOL").toUpperCase());
                    }
                    if (this.iSelectedGame == 1) {
                        Resources.prepareText(X.texts.getHashedString("INSTRUCTION_BJ").toUpperCase());
                    }
                    this.mode = 2;
                    return;
                }
                if (this.iSelectedItem == this.MENUITEM_ABOUT) {
                    this.mode = 3;
                    return;
                }
                if (this.iSelectedItem == this.MENUITEM_LOAD_GAME) {
                    if (this.iSelectedGame == 1) {
                        Resources.releaseMenuResources();
                        MainCanvas.scrGameBJ = new ScreenGameBJ(this.canvas, false);
                        MainCanvas.activeScreen = MainCanvas.scrGameBJ;
                        MainCanvas.scrMenu = null;
                    }
                    if (this.iSelectedGame == 0) {
                        Resources.releaseMenuResources();
                        MainCanvas.scrGamePok = new ScreenGamePok(this.canvas, false);
                        MainCanvas.activeScreen = MainCanvas.scrGamePok;
                        MainCanvas.scrMenu = null;
                    }
                    if (this.iSelectedGame == 2) {
                        Resources.releaseMenuResources();
                        MainCanvas.scrGameSol = new ScreenGameSol(this.canvas, false);
                        MainCanvas.activeScreen = MainCanvas.scrGameSol;
                        MainCanvas.scrMenu = null;
                    }
                }
                if (this.iSelectedItem != this.MENUITEM_NEWGAME) break;
                Resources.prepareText(X.texts.getHashedString("NEW_GAME_WARN").toUpperCase());
                if (stateBJ.canLoad() && this.iSelectedGame == 1) {
                    this.mode = 5;
                    return;
                }
                if (statePok.canLoad() && this.iSelectedGame == 0) {
                    this.mode = 5;
                    return;
                }
                if (stateSol.canLoad() && this.iSelectedGame == 2) {
                    this.mode = 5;
                    return;
                }
                this.startNewGame();
                return;
            }
            case 5: {
                if (Keys.key_fn2) {
                    Resources.releaseMenuResources();
                    this.startNewGame();
                    return;
                }
                if (!Keys.key_fn1) break;
                this.mode = 1;
                return;
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void startNewGame() {
        if (this.iSelectedGame == 1) {
            Resources.releaseMenuResources();
            MainCanvas.scrGameBJ = new ScreenGameBJ(this.canvas, true);
            MainCanvas.activeScreen = MainCanvas.scrGameBJ;
            MainCanvas.scrMenu = null;
        }
        if (this.iSelectedGame == 0) {
            Resources.releaseMenuResources();
            MainCanvas.scrGamePok = new ScreenGamePok(this.canvas, true);
            MainCanvas.activeScreen = MainCanvas.scrGamePok;
            MainCanvas.scrMenu = null;
        }
        if (this.iSelectedGame == 2) {
            Resources.releaseMenuResources();
            MainCanvas.scrGameSol = new ScreenGameSol(this.canvas, true);
            MainCanvas.activeScreen = MainCanvas.scrGameSol;
            MainCanvas.scrMenu = null;
        }
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                Resources.paintBackground(g);
                break;
            }
            case 1: {
                this.paintMenu(g);
                if (Settings.bMusic) {
                    Resources.paintControls(g, 6);
                    break;
                }
                Resources.paintControls(g, 1);
                break;
            }
            case 2: {
                this.paintInstructions(g);
                break;
            }
            case 3: {
                this.paintAbout(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
                Resources.paintControls(g, 10);
                break;
            }
            case 5: {
                this.paintNewGame(g);
                Resources.paintControls(g, 10);
                break;
            }
            case 6: 
            case 7: {
                this.paintMenu(g);
                if (Settings.bMusic) {
                    Resources.paintControls(g, 6);
                    break;
                }
                Resources.paintControls(g, 1);
            }
        }
    }

    public void paintRaster(Graphics g) {
        int x = 0;
        for (int y = 0; y <= Defines.HEIGHT; y += Resources.iRasterH) {
            while (x <= Defines.WIDTH) {
                g.drawImage(Resources.imgRaster, x, y, 0);
                x += Resources.iRasterW;
            }
            x = 0;
        }
    }

    public void paintQuit(Graphics g) {
        this.paintRaster(g);
        Resources.paintMenuBG(10, 3, sQuit, g);
    }

    public void paintNewGame(Graphics g) {
        this.paintRaster(g);
        Resources.paintMenuBG(15, 8, menuStrings[0], g);
        Resources.paintTextIntoTable(15, 10, g);
    }

    public void paintInstructions(Graphics g) {
        this.paintRaster(g);
        Resources.paintMenuBG(16, 13, menuStrings[2], g);
        Resources.paintTextIntoTable(15, 13, g);
        Resources.paintControls(g, 8);
        g.setColor(0xFFFFFF);
        int iPosX = Defines.WIDTH / 2;
        int iPosYTop = (Defines.HEIGHT - Resources.iInfoBarH * 13) / 2 + Resources.TEXT_DIFF_Y - 10;
        int iPosY = iPosYTop + Resources.TEXT_DIFF_Y + 15;
        g.fillTriangle(iPosX, iPosYTop - 7, iPosX + 7, iPosYTop, iPosX - 7, iPosYTop);
        g.fillTriangle(iPosX, iPosY, iPosX - 6, iPosY - 6, iPosX + 6, iPosY - 6);
    }

    public void paintAbout(Graphics g) {
        this.paintRaster(g);
        Resources.paintControls(g, 8);
        Resources.paintMenuBG(16, 15, menuStrings[3], g);
        int iHeight = Resources.iInfoBarH * 15;
        g.drawImage(Resources.imgInlLogo, (Defines.WIDTH - Resources.iInlLogoW) / 2, (Defines.HEIGHT - Resources.iInlLogoH) / 2, 0);
        String name = (sName + ": " + X.singleton.getAppProperty("MIDlet-Name")).toUpperCase();
        String version = (sVersion + ": " + X.singleton.getAppProperty("MIDlet-Version")).toUpperCase();
        Fonts.drawStr(name, (Defines.WIDTH - Fonts.strWidth(name)) / 2, iHeight + (Defines.HEIGHT - iHeight) / 2 - Resources.iFont1H * 2 - Resources.iFont1H, g);
        Fonts.drawStr(version, (Defines.WIDTH - Fonts.strWidth(version)) / 2, iHeight + (Defines.HEIGHT - iHeight) / 2 - Resources.iFont1H - Resources.iFont1H, g);
    }

    public void paintMenu(Graphics g) {
        switch (this.iSelectedGame) {
            case 1: {
                this.paintBJ(g);
                break;
            }
            case 0: {
                this.paintPok(g);
                break;
            }
            case 2: {
                this.paintSol(g);
            }
        }
        int iPosX = this.listingPos + (Defines.WIDTH - Resources.iIconsMenuW) / 2;
        int iPosY = Resources.MENU_POS_Y;
        int x = this.listingPos + (Defines.WIDTH - Resources.iIconsMenuW) / 2;
        if (this.mode == 7 || this.mode == 6) {
            return;
        }
        if (0 == this.iSelectedItem) {
            Resources.sprIconsMENU.setFrame(1);
        } else {
            Resources.sprIconsMENU.setFrame(0);
        }
        Resources.sprIconsMENU.setPosition(iPosX, iPosY);
        Resources.sprIconsMENU.paint(g);
        Resources.sprMenuArrows.setFrame(0);
        Resources.sprMenuArrows.setPosition(iPosX - Resources.MENU_BUTTONS_OFFSET - Resources.iMenuArrowsW, iPosY + Resources.iIconsMenuH / 2);
        Resources.sprMenuArrows.paint(g);
        Resources.sprMenuArrows.setFrame(1);
        Resources.sprMenuArrows.setPosition(iPosX + Resources.MENU_BUTTONS_OFFSET + Resources.iIconsMenuW, iPosY + Resources.iIconsMenuH / 2);
        Resources.sprMenuArrows.paint(g);
        boolean possLoad = false;
        switch (this.iSelectedGame) {
            case 1: {
                if (!stateBJ.canLoad()) break;
                possLoad = true;
                break;
            }
            case 0: {
                if (!statePok.canLoad()) break;
                possLoad = true;
                break;
            }
            case 2: {
                if (!stateSol.canLoad()) break;
                possLoad = true;
            }
        }
        if (possLoad) {
            if (1 == this.iSelectedItem) {
                Resources.sprIconsMENU.setFrame(3);
            } else {
                Resources.sprIconsMENU.setFrame(2);
            }
            Resources.sprIconsMENU.setPosition(iPosX, Resources.MENU_BUTTONS_OFFSET + Resources.iIconsMenuH + iPosY);
            Resources.sprIconsMENU.paint(g);
        }
        iPosY = possLoad ? Resources.MENU_POS_Y + (2 * Resources.iIconsMenuH + Resources.MENU_BUTTONS_OFFSET) : Resources.MENU_POS_Y + (Resources.iIconsMenuH + Resources.MENU_BUTTONS_OFFSET);
        iPosX = this.listingPos + Resources.iIconsW - Resources.iIconsW / 2 + (Defines.WIDTH - Resources.iIconsMenuW) / 2;
        for (int i = 2; i < 5; ++i) {
            Sprite tmpSpr = i != this.iSelectedItem ? Resources.sprIconsOFF : Resources.sprIconsON;
            tmpSpr.setFrame(10);
            if (i == 3) continue;
            if (i == 4) {
                iPosX = this.listingPos + Defines.WIDTH - Resources.iIconsW - Resources.iIconsW / 2 - (Defines.WIDTH - Resources.iIconsMenuW) / 2;
                tmpSpr.setFrame(11);
            }
            tmpSpr.setPosition(iPosX, iPosY + Resources.MENU_BUTTONS_OFFSET);
            tmpSpr.paint(g);
        }
    }

    public void paintBJ(Graphics g) {
        Resources.imgBackground = Common.createImage("/bg_bj.png");
        Resources.paintBackground(g, 0);
        g.drawImage(Resources.imgBJLogo, this.listingPos + (Defines.WIDTH - Resources.iBJLogoW) / 2, Resources.LOGO_Y, 0);
    }

    public void paintPok(Graphics g) {
        Resources.imgBackground = Common.createImage("/bg_pok.png");
        Resources.paintBackground(g, 0);
        g.drawImage(Resources.imgPokerLogo, this.listingPos + (Defines.WIDTH - Resources.iPokerLogoW) / 2, Resources.LOGO_Y, 0);
    }

    public void paintSol(Graphics g) {
        Resources.imgBackground = Common.createImage("/bg_sol.png");
        Resources.paintBackground(g, 0);
        g.drawImage(Resources.imgSolLogo, this.listingPos + (Defines.WIDTH - Resources.iSolLogoW) / 2, Resources.LOGO_Y, 0);
    }

    public void invokeGameMenu() {
        X.soundManager.Stop();
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.pointerPressedMenu(x, y);
                break;
            }
            case 2: 
            case 3: {
                this.pointerPressedAbout(x, y);
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void pointerPressedAbout(int x, int y) {
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        int tableTop = (Defines.HEIGHT - Resources.iInfoBarH * 13) / 2;
        int tableHeight = Resources.iInfoBarH * 13;
        int tableLeft = (Defines.HEIGHT - Resources.iInfoBarW * 15) / 2;
        int tablewidth = Resources.iInfoBarW * 15;
        if (x > tableLeft && x < tableLeft + tablewidth) {
            if (y > tableTop && y < tableTop + tableHeight / 2) {
                Keys.key_up = true;
                this.keyPressed(0);
                Keys.key_up = false;
            }
            if (y > tableTop + tableHeight / 2 && y < tableTop + tableHeight) {
                Keys.key_down = true;
                this.keyPressed(0);
                Keys.key_down = false;
            }
        }
        Keys.key_fire = true;
        this.keyPressed(Keys.iEnterKey);
        Keys.key_fire = false;
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void pointerPressedMenu(int x, int y) {
        int buttonPressed = 0;
        if (this.iSelectedGame == 1) {
            buttonPressed = stateBJ.canLoad() ? Resources.whichMenuButton(x, y) : Resources.whichMenuButtonCantLoad(x, y);
        }
        if (this.iSelectedGame == 2) {
            buttonPressed = stateSol.canLoad() ? Resources.whichMenuButton(x, y) : Resources.whichMenuButtonCantLoad(x, y);
        }
        if (this.iSelectedGame == 0) {
            buttonPressed = statePok.canLoad() ? Resources.whichMenuButton(x, y) : Resources.whichMenuButtonCantLoad(x, y);
        }
        System.out.println(buttonPressed);
        switch (buttonPressed) {
            case 1: {
                this.iSelectedItem = this.MENUITEM_NEWGAME;
                break;
            }
            case 2: {
                this.iSelectedItem = this.MENUITEM_LOAD_GAME;
                break;
            }
            case 3: {
                this.iSelectedItem = this.MENUITEM_INSTRUCTIONS;
                break;
            }
            case 4: {
                this.iSelectedItem = this.MENUITEM_ABOUT;
                break;
            }
            case 5: {
                Keys.key_left = true;
                this.keyPressed(Keys.iLeftKey);
                Keys.key_left = false;
                return;
            }
            case 6: {
                Keys.key_right = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_right = false;
                return;
            }
            default: {
                this.iSelectedItem = -1;
            }
        }
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x, y)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void pointerReleased(int x, int y) {
        if (this.mode == 1) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            this.iSelectedItem = -1;
        }
    }
}

